; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -verify-machineinstrs | FileCheck %s
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_30 -verify-machineinstrs | FileCheck %s
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 -mcpu=sm_20 -verify-machineinstrs | %ptxas-verify %}
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 -mcpu=sm_30 -verify-machineinstrs | %ptxas-verify %}

target triple = "nvptx-unknown-cuda"

@tex0 = internal addrspace(1) global i64 0, align 8
@surf0 = internal addrspace(1) global i64 0, align 8

declare i32 @llvm.nvvm.txq.width(i64)
declare i32 @llvm.nvvm.txq.height(i64)
declare i32 @llvm.nvvm.suq.width(i64)
declare i32 @llvm.nvvm.suq.height(i64)
declare i64 @llvm.nvvm.texsurf.handle.internal.p1(ptr addrspace(1))


define i32 @t0(i64 %texHandle) {
; CHECK-LABEL: t0(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.u64 %rd1, [t0_param_0];
; CHECK-NEXT:    txq.width.b32 %r1, [%rd1];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %width = tail call i32 @llvm.nvvm.txq.width(i64 %texHandle)
  ret i32 %width
}

define i32 @t1() {
; CHECK-LABEL: t1(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    txq.width.b32 %r1, [tex0];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %texHandle = tail call i64 @llvm.nvvm.texsurf.handle.internal.p1(ptr addrspace(1) @tex0)
  %width = tail call i32 @llvm.nvvm.txq.width(i64 %texHandle)
  ret i32 %width
}


define i32 @t2(i64 %texHandle) {
; CHECK-LABEL: t2(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.u64 %rd1, [t2_param_0];
; CHECK-NEXT:    txq.height.b32 %r1, [%rd1];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %height = tail call i32 @llvm.nvvm.txq.height(i64 %texHandle)
  ret i32 %height
}

define i32 @t3() {
; CHECK-LABEL: t3(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    txq.height.b32 %r1, [tex0];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %texHandle = tail call i64 @llvm.nvvm.texsurf.handle.internal.p1(ptr addrspace(1) @tex0)
  %height = tail call i32 @llvm.nvvm.txq.height(i64 %texHandle)
  ret i32 %height
}


define i32 @s0(i64 %surfHandle) {
; CHECK-LABEL: s0(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.u64 %rd1, [s0_param_0];
; CHECK-NEXT:    suq.width.b32 %r1, [%rd1];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %width = tail call i32 @llvm.nvvm.suq.width(i64 %surfHandle)
  ret i32 %width
}

define i32 @s1() {
; CHECK-LABEL: s1(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    suq.width.b32 %r1, [surf0];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %surfHandle = tail call i64 @llvm.nvvm.texsurf.handle.internal.p1(ptr addrspace(1) @surf0)
  %width = tail call i32 @llvm.nvvm.suq.width(i64 %surfHandle)
  ret i32 %width
}


define i32 @s2(i64 %surfHandle) {
; CHECK-LABEL: s2(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.u64 %rd1, [s2_param_0];
; CHECK-NEXT:    suq.height.b32 %r1, [%rd1];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %height = tail call i32 @llvm.nvvm.suq.height(i64 %surfHandle)
  ret i32 %height
}

define i32 @s3() {
; CHECK-LABEL: s3(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    suq.height.b32 %r1, [surf0];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %surfHandle = tail call i64 @llvm.nvvm.texsurf.handle.internal.p1(ptr addrspace(1) @surf0)
  %height = tail call i32 @llvm.nvvm.suq.height(i64 %surfHandle)
  ret i32 %height
}



!nvvm.annotations = !{!1, !2}
!1 = !{ptr addrspace(1) @tex0, !"texture", i32 1}
!2 = !{ptr addrspace(1) @surf0, !"surface", i32 1}
