; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC
; PR2498

; This test tries to convince CHECK about promoting the load from %A + 2,
; because there is a load of %A in the entry block
define internal i32 @callee(i1 %C, ptr %A) {
;
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: read)
; CHECK-LABEL: define {{[^@]+}}@callee
; CHECK-SAME: (ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_0:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    unreachable
; CHECK:       F:
; CHECK-NEXT:    [[A_2:%.*]] = getelementptr i32, ptr [[A]], i32 2
; CHECK-NEXT:    [[R:%.*]] = load i32, ptr [[A_2]], align 4
; CHECK-NEXT:    ret i32 [[R]]
;
entry:
  ; Unconditonally load the element at %A
  %A.0 = load i32, ptr %A
  br i1 %C, label %T, label %F

T:
  ret i32 %A.0

F:
  ; Load the element at offset two from %A. This should not be promoted!
  %A.2 = getelementptr i32, ptr %A, i32 2
  %R = load i32, ptr %A.2
  ret i32 %R
}

define i32 @foo(ptr %A) {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: read)
; TUNIT-LABEL: define {{[^@]+}}@foo
; TUNIT-SAME: (ptr nofree readonly captures(none) [[A:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:    [[X:%.*]] = call i32 @callee(ptr nofree noundef readonly align 4 captures(none) [[A]]) #[[ATTR1:[0-9]+]]
; TUNIT-NEXT:    ret i32 [[X]]
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(argmem: read)
; CGSCC-LABEL: define {{[^@]+}}@foo
; CGSCC-SAME: (ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[A:%.*]]) #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:    [[X:%.*]] = call i32 @callee(ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[A]]) #[[ATTR2:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[X]]
;
  %X = call i32 @callee(i1 false, ptr %A)             ; <i32> [#uses=1]
  ret i32 %X
}

;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: read) }
; TUNIT: attributes #[[ATTR1]] = { nofree nosync nounwind willreturn memory(read) }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: read) }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree nosync nounwind willreturn memory(argmem: read) }
; CGSCC: attributes #[[ATTR2]] = { nofree willreturn memory(read) }
;.
