; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test that the strstr library call simplifier works correctly.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"

@.str = private constant [1 x i8] zeroinitializer
@.str1 = private constant [2 x i8] c"a\00"
@.str2 = private constant [6 x i8] c"abcde\00"
@.str3 = private constant [4 x i8] c"bcd\00"

declare ptr @strstr(ptr, ptr)

; Check strstr(str, "") -> str.

define ptr @test_simplify1(ptr %str) {
; CHECK-LABEL: @test_simplify1(
; CHECK-NEXT:    ret ptr [[STR:%.*]]
;
  %ret = call ptr @strstr(ptr %str, ptr @.str)
  ret ptr %ret
}

; Check strstr(str, "a") -> strchr(str, 'a').

define ptr @test_simplify2(ptr %str) {
; CHECK-LABEL: @test_simplify2(
; CHECK-NEXT:    [[STRCHR:%.*]] = call ptr @strchr(ptr noundef nonnull dereferenceable(1) [[STR:%.*]], i32 97)
; CHECK-NEXT:    ret ptr [[STRCHR]]
;
  %ret = call ptr @strstr(ptr %str, ptr @.str1)
  ret ptr %ret
}

; Check strstr("abcde", "bcd") -> "abcde" + 1.

define ptr @test_simplify3() {
; CHECK-LABEL: @test_simplify3(
; CHECK-NEXT:    ret ptr getelementptr inbounds nuw (i8, ptr @.str2, i64 1)
;
  %ret = call ptr @strstr(ptr @.str2, ptr @.str3)
  ret ptr %ret
}

; Check strstr(str, str) -> str.

define ptr @test_simplify4(ptr %str) {
; CHECK-LABEL: @test_simplify4(
; CHECK-NEXT:    ret ptr [[STR:%.*]]
;
  %ret = call ptr @strstr(ptr %str, ptr %str)
  ret ptr %ret
}

; Check strstr(str, pat) == str -> strncmp(str, pat, strlen(str)) == 0.

define i1 @test_simplify5(ptr %str, ptr %pat) {
; CHECK-LABEL: @test_simplify5(
; CHECK-NEXT:    [[STRLEN:%.*]] = call i64 @strlen(ptr noundef nonnull dereferenceable(1) [[PAT:%.*]])
; CHECK-NEXT:    [[STRNCMP:%.*]] = call i32 @strncmp(ptr [[STR:%.*]], ptr nonnull [[PAT]], i64 [[STRLEN]])
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[STRNCMP]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %ret = call ptr @strstr(ptr %str, ptr %pat)
  %cmp = icmp eq ptr %ret, %str
  ret i1 %cmp
}

define ptr @test1(ptr %str1, ptr %str2) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[RET:%.*]] = call ptr @strstr(ptr noundef nonnull dereferenceable(1) [[STR1:%.*]], ptr noundef nonnull dereferenceable(1) [[STR2:%.*]])
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = call ptr @strstr(ptr %str1, ptr %str2)
  ret ptr %ret
}

define ptr @test2(ptr %str1, ptr %str2) null_pointer_is_valid {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[RET:%.*]] = call ptr @strstr(ptr noundef [[STR1:%.*]], ptr noundef [[STR2:%.*]])
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = call ptr @strstr(ptr %str1, ptr %str2)
  ret ptr %ret
}
