; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=riscv64 | FileCheck %s

; The sub nuw produces poison if the input is not 0 or 1. We must insert a
; freeze before converting the sub to AND so that we don't propagate poison.
define i64 @foo(i64 %1) {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li a1, 1
; CHECK-NEXT:    sub a1, a1, a0
; CHECK-NEXT:    sltiu a0, a0, 2
; CHECK-NEXT:    xori a1, a1, 1
; CHECK-NEXT:    neg a0, a0
; CHECK-NEXT:    and a0, a0, a1
; CHECK-NEXT:    ret
entry:
  %.urem.i = sub nuw i64 1, %1
  %.cmp.i = icmp ugt i64 %1, 1
  %2 = xor i64 %.urem.i, 1
  %3 = select i1 %.cmp.i, i64 0, i64 %2
  ret i64 %3
}
