; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=r600-- -passes=amdgpu-printf-runtime-binding -mcpu=r600 -S < %s | FileCheck --check-prefix=R600 %s
; RUN: opt -mtriple=amdgcn-- -passes=amdgpu-printf-runtime-binding -mcpu=fiji -S < %s | FileCheck --check-prefix=GCN %s
; RUN: opt -mtriple=amdgcn--amdhsa -passes=amdgpu-printf-runtime-binding -mcpu=fiji -S < %s | FileCheck --check-prefix=GCN %s

@.str = private unnamed_addr addrspace(4) constant [6 x i8] c"%s:%d\00", align 1

@format.str.no.null.terminator = private unnamed_addr addrspace(4) constant [10 x i8] c"abcdefg %d", align 1
@indexed.format.str = private unnamed_addr addrspace(4) constant [11 x i8] c"abcdefg %d\00", align 1


@printed.str.size0 = private addrspace(4) constant [0 x i8] zeroinitializer, align 1
@printed.str.1ai8.zero = private addrspace(4) constant [1 x i8] zeroinitializer, align 1
@printed.str.1ai8.undef = private addrspace(4) constant [1 x i8] undef, align 1
@printed.str.i8.zero = private addrspace(4) constant i8 0, align 1
@printed.str.size2 = private addrspace(4) constant [2 x i8] [i8 27, i8 0], align 1
@printed.str.size3 = private addrspace(4) constant [3 x i8] [i8 27, i8 28, i8 0], align 1
@printed.str.size3.zero = private addrspace(4) constant [3 x i8] zeroinitializer, align 1
@printed.str.size4 = private addrspace(4) constant [4 x i8] c"abc\00", align 1
@printed.str.size4.nonull.term = private addrspace(4) constant [4 x i8] c"abcd", align 1
@printed.str.size5 = private addrspace(4) constant [5 x i8] c"abcd\00", align 1
@printed.str.size6 = private addrspace(4) constant [6 x i8] c"abcde\00", align 1
@printed.str.size7 = private addrspace(4) constant [7 x i8] c"abcdefg", align 1
@printed.str.size8 = private addrspace(4) constant [8 x i8] c"arstars\00", align 1
@printed.str.size9 = private addrspace(4) constant [9 x i8] c"deadbeef\00", align 1
@printed.str.size16 = private addrspace(4) constant [16 x i8] c"161616161616161\00", align 1
@printed.str.size17 = private addrspace(4) constant [17 x i8] c"1717171717171717\00", align 1
@printed.str.size20 = private addrspace(4) constant [20 x i8] c"abcdefghijklmnopqrs\00", align 1
@printed.str.size32 = private addrspace(4) constant [32 x i8] c"arstarstarstarstarstarstarstars\00", align 1
@printed.str.not.constant.size4 = private addrspace(4) global [4 x i8] c"abc\00", align 1
@printed.str.interposable.size4 = weak addrspace(4) constant [4 x i8] c"qrs\00", align 1

@printed.str.v4i8 = private addrspace(4) constant <4 x i8> <i8 1, i8 2, i8 3, i8 4>, align 4
@printed.str.v4i32 = private addrspace(4) constant <4 x i32> <i32 1, i32 2, i32 3, i32 4>, align 4
@printed.str.struct = private addrspace(4) constant { i32, i32, i32 } {i32 66, i32 77, i32 88 }, align 4
@printed.str.float.neg0 = private addrspace(4) constant float -0.0, align 4
@printed.str.float.0 = private addrspace(4) constant float 0.0, align 4
@printed.str.ptr.null = private addrspace(4) constant ptr null, align 4
@printed.str.ptr.undef = private addrspace(4) constant ptr poison, align 4
@format.str.f = private unnamed_addr addrspace(4) constant [33 x i8] c"%f %f %f %f %f %f %f %f %f %f %f\00", align 1
@format.str.F = private unnamed_addr addrspace(4) constant [33 x i8] c"%F %F %F %F %F %F %F %F %F %F %F\00", align 1
@format.str.a = private unnamed_addr addrspace(4) constant [33 x i8] c"%a %a %a %a %a %a %a %a %a %a %a\00", align 1
@format.str.A = private unnamed_addr addrspace(4) constant [33 x i8] c"%A %A %A %A %A %A %A %A %A %A %A\00", align 1
@format.str.p = private unnamed_addr addrspace(4) constant [15 x i8] c"%p %p %p %p %p\00", align 1
@format.str.d = private unnamed_addr addrspace(4) constant [30 x i8] c"%d %d %d %d %d %d %d %d %d %d\00", align 1

@format.str.v1 = private unnamed_addr addrspace(4) constant [35 x i8] c"%v1f %v1f %v1d %v1d %v1p %v1p %v1f\00", align 1
@format.str.v2 = private unnamed_addr addrspace(4) constant [35 x i8] c"%v2f %v2f %v2d %v2d %v2p %v2p %v2f\00", align 1
@format.str.v3 = private unnamed_addr addrspace(4) constant [35 x i8] c"%v3f %v3f %v3d %v3d %v3p %v3p %v3f\00", align 1
@format.str.v4 = private unnamed_addr addrspace(4) constant [35 x i8] c"%v4f %v4f %v4d %v4d %v4p %v4p %v4f\00", align 1
@format.str.v8 = private unnamed_addr addrspace(4) constant [35 x i8] c"%v8f %v8f %v8d %v8d %v8p %v8p %v8f\00", align 1
@format.str.v16 = private unnamed_addr addrspace(4) constant [42 x i8] c"%v16f %v16f %v16d %v16d %v16p %v16p %v16f\00", align 1
@format.str.u = private unnamed_addr addrspace(4) constant [30 x i8] c"%u %u %u %u %u %u %u %u %u %u\00", align 1
@format.str.one.ptr = private unnamed_addr addrspace(4) constant [8 x i8] c"arst %p\00", align 1


define amdgpu_kernel void @format_str_f(float %f32.0, double %f64, float %f32.1, i16 %i16, i32 %i32, i64 %i64, half %f16) {
; R600-LABEL: @format_str_f(
; R600-NEXT:    [[FPEXT_F32_TO_F64:%.*]] = fpext float [[F32_1:%.*]] to double
; R600-NEXT:    [[CALL1:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.f, float [[F32_0:%.*]], double [[F64:%.*]], double [[FPEXT_F32_TO_F64]], float 1.000000e+00, double 2.000000e+00, i16 [[I16:%.*]], i32 [[I32:%.*]], i64 [[I64:%.*]], <2 x float> <float 1.000000e+00, float 2.000000e+00>, <2 x i32> <i32 8, i32 234>, half [[F16:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_f(
; GCN-NEXT:    [[FPEXT_F32_TO_F64:%.*]] = fpext float [[F32_1:%.*]] to double
; GCN-NEXT:    [[TMP1:%.*]] = sext i16 [[I16:%.*]] to i32
; GCN-NEXT:    [[TMP2:%.*]] = bitcast half [[F16:%.*]] to i16
; GCN-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 64)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP4:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP4]], label [[TMP5:%.*]], label [[TMP6:%.*]]
; GCN:       5:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 1, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store float [[F32_0:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store double [[F64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 8
; GCN-NEXT:    store float [[F32_1]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 4
; GCN-NEXT:    store float 1.000000e+00, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store float 2.000000e+00, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 4
; GCN-NEXT:    store i32 [[TMP1]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 4
; GCN-NEXT:    store i32 [[I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 4
; GCN-NEXT:    store i64 [[I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR7:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], i32 8
; GCN-NEXT:    store <2 x float> <float 1.000000e+00, float 2.000000e+00>, ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR8:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], i32 8
; GCN-NEXT:    store <2 x i32> <i32 8, i32 234>, ptr addrspace(1) [[PRINTBUFFNEXTPTR8]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR9:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR8]], i32 8
; GCN-NEXT:    store i32 [[TMP3]], ptr addrspace(1) [[PRINTBUFFNEXTPTR9]], align 4
; GCN-NEXT:    br label [[TMP6]]
; GCN:       6:
; GCN-NEXT:    ret void
;
  %fpext.f32.to.f64 = fpext float %f32.1 to double
  %call1 = call i32 @printf(ptr addrspace(4) @format.str.f, float %f32.0, double %f64, double %fpext.f32.to.f64, float 1.0, double 2.0, i16 %i16, i32 %i32, i64 %i64, <2 x float> <float 1.0, float 2.0>, <2 x i32> <i32 8, i32 234>, half %f16)
  ret void
}

define amdgpu_kernel void @format_str_F(float %f32.0, double %f64, float %f32.1, i16 %i16, i32 %i32, i64 %i64, half %f16) {
; R600-LABEL: @format_str_F(
; R600-NEXT:    [[FPEXT_F32_TO_F64:%.*]] = fpext float [[F32_1:%.*]] to double
; R600-NEXT:    [[CALL1:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.F, float [[F32_0:%.*]], double [[F64:%.*]], double [[FPEXT_F32_TO_F64]], float 1.000000e+00, double 2.000000e+00, i16 [[I16:%.*]], i32 [[I32:%.*]], i64 [[I64:%.*]], <2 x float> <float 1.000000e+00, float 2.000000e+00>, <2 x i32> <i32 8, i32 234>, half [[F16:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_F(
; GCN-NEXT:    [[FPEXT_F32_TO_F64:%.*]] = fpext float [[F32_1:%.*]] to double
; GCN-NEXT:    [[TMP4:%.*]] = sext i16 [[I16:%.*]] to i32
; GCN-NEXT:    [[TMP5:%.*]] = bitcast half [[F16:%.*]] to i16
; GCN-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 72)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       5:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 2, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store float [[F32_0:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store double [[F64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 8
; GCN-NEXT:    store double [[FPEXT_F32_TO_F64]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 8
; GCN-NEXT:    store float 1.000000e+00, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store double 2.000000e+00, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 8
; GCN-NEXT:    store i32 [[TMP4]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 4
; GCN-NEXT:    store i32 [[I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 4
; GCN-NEXT:    store i64 [[I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR7:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], i32 8
; GCN-NEXT:    store <2 x float> <float 1.000000e+00, float 2.000000e+00>, ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR8:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], i32 8
; GCN-NEXT:    store <2 x i32> <i32 8, i32 234>, ptr addrspace(1) [[PRINTBUFFNEXTPTR8]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR9:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR8]], i32 8
; GCN-NEXT:    store i32 [[TMP6]], ptr addrspace(1) [[PRINTBUFFNEXTPTR9]], align 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       6:
; GCN-NEXT:    ret void
;
  %fpext.f32.to.f64 = fpext float %f32.1 to double
  %call1 = call i32 @printf(ptr addrspace(4) @format.str.F, float %f32.0, double %f64, double %fpext.f32.to.f64, float 1.0, double 2.0, i16 %i16, i32 %i32, i64 %i64, <2 x float> <float 1.0, float 2.0>, <2 x i32> <i32 8, i32 234>, half %f16)
  ret void
}

define amdgpu_kernel void @format_str_a(float %f32.0, double %f64, float %f32.1, i16 %i16, i32 %i32, i64 %i64, half %f16) {
; R600-LABEL: @format_str_a(
; R600-NEXT:    [[FPEXT_F32_TO_F64:%.*]] = fpext float [[F32_1:%.*]] to double
; R600-NEXT:    [[CALL1:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.a, float [[F32_0:%.*]], double [[F64:%.*]], double [[FPEXT_F32_TO_F64]], float 1.000000e+00, double 2.000000e+00, i16 [[I16:%.*]], i32 [[I32:%.*]], i64 [[I64:%.*]], <2 x float> <float 1.000000e+00, float 2.000000e+00>, <2 x i32> <i32 8, i32 234>, half [[F16:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_a(
; GCN-NEXT:    [[FPEXT_F32_TO_F64:%.*]] = fpext float [[F32_1:%.*]] to double
; GCN-NEXT:    [[TMP1:%.*]] = sext i16 [[I16:%.*]] to i32
; GCN-NEXT:    [[TMP2:%.*]] = bitcast half [[F16:%.*]] to i16
; GCN-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 72)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP4:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP4]], label [[TMP5:%.*]], label [[TMP6:%.*]]
; GCN:       5:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 3, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store float [[F32_0:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store double [[F64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 8
; GCN-NEXT:    store double [[FPEXT_F32_TO_F64]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 8
; GCN-NEXT:    store float 1.000000e+00, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store double 2.000000e+00, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 8
; GCN-NEXT:    store i32 [[TMP1]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 4
; GCN-NEXT:    store i32 [[I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 4
; GCN-NEXT:    store i64 [[I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR7:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], i32 8
; GCN-NEXT:    store <2 x float> <float 1.000000e+00, float 2.000000e+00>, ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR8:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], i32 8
; GCN-NEXT:    store <2 x i32> <i32 8, i32 234>, ptr addrspace(1) [[PRINTBUFFNEXTPTR8]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR9:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR8]], i32 8
; GCN-NEXT:    store i32 [[TMP3]], ptr addrspace(1) [[PRINTBUFFNEXTPTR9]], align 4
; GCN-NEXT:    br label [[TMP6]]
; GCN:       6:
; GCN-NEXT:    ret void
;
  %fpext.f32.to.f64 = fpext float %f32.1 to double
  %call1 = call i32 @printf(ptr addrspace(4) @format.str.a, float %f32.0, double %f64, double %fpext.f32.to.f64, float 1.0, double 2.0, i16 %i16, i32 %i32, i64 %i64, <2 x float> <float 1.0, float 2.0>, <2 x i32> <i32 8, i32 234>, half %f16)
  ret void
}

define amdgpu_kernel void @format_str_A(float %f32.0, double %f64, float %f32.1, i16 %i16, i32 %i32, i64 %i64, half %f16) {
; R600-LABEL: @format_str_A(
; R600-NEXT:    [[FPEXT_F32_TO_F64:%.*]] = fpext float [[F32_1:%.*]] to double
; R600-NEXT:    [[CALL1:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.A, float [[F32_0:%.*]], double [[F64:%.*]], double [[FPEXT_F32_TO_F64]], float 1.000000e+00, double 2.000000e+00, i16 [[I16:%.*]], i32 [[I32:%.*]], i64 [[I64:%.*]], <2 x float> <float 1.000000e+00, float 2.000000e+00>, <2 x i32> <i32 8, i32 234>, half [[F16:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_A(
; GCN-NEXT:    [[FPEXT_F32_TO_F64:%.*]] = fpext float [[F32_1:%.*]] to double
; GCN-NEXT:    [[TMP4:%.*]] = sext i16 [[I16:%.*]] to i32
; GCN-NEXT:    [[TMP5:%.*]] = bitcast half [[F16:%.*]] to i16
; GCN-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 72)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       5:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 4, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store float [[F32_0:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store double [[F64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 8
; GCN-NEXT:    store double [[FPEXT_F32_TO_F64]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 8
; GCN-NEXT:    store float 1.000000e+00, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store double 2.000000e+00, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 8
; GCN-NEXT:    store i32 [[TMP4]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 4
; GCN-NEXT:    store i32 [[I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 4
; GCN-NEXT:    store i64 [[I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR7:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], i32 8
; GCN-NEXT:    store <2 x float> <float 1.000000e+00, float 2.000000e+00>, ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR8:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], i32 8
; GCN-NEXT:    store <2 x i32> <i32 8, i32 234>, ptr addrspace(1) [[PRINTBUFFNEXTPTR8]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR9:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR8]], i32 8
; GCN-NEXT:    store i32 [[TMP6]], ptr addrspace(1) [[PRINTBUFFNEXTPTR9]], align 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       6:
; GCN-NEXT:    ret void
;
  %fpext.f32.to.f64 = fpext float %f32.1 to double
  %call1 = call i32 @printf(ptr addrspace(4) @format.str.A, float %f32.0, double %f64, double %fpext.f32.to.f64, float 1.0, double 2.0, i16 %i16, i32 %i32, i64 %i64, <2 x float> <float 1.0, float 2.0>, <2 x i32> <i32 8, i32 234>, half %f16)
  ret void
}

define void @format_str_ptr(ptr %ptr.flat, ptr addrspace(3) %ptr.lds, ptr addrspace(1) %ptr.global, ptr addrspace(5) %ptr.stack, ptr addrspace(4) %ptr.const) {
; R600-LABEL: @format_str_ptr(
; R600-NEXT:    [[CALL:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.p, ptr [[PTR_FLAT:%.*]], ptr addrspace(3) [[PTR_LDS:%.*]], ptr addrspace(1) [[PTR_GLOBAL:%.*]], ptr addrspace(5) [[PTR_STACK:%.*]], ptr addrspace(4) [[PTR_CONST:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_ptr(
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 36)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 5, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store ptr [[PTR_FLAT:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 8
; GCN-NEXT:    store ptr addrspace(3) [[PTR_LDS:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store ptr addrspace(1) [[PTR_GLOBAL:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 8
; GCN-NEXT:    store ptr addrspace(5) [[PTR_STACK:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store ptr addrspace(4) [[PTR_CONST:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 8
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %call = call i32 @printf(ptr addrspace(4) @format.str.p, ptr %ptr.flat, ptr addrspace(3) %ptr.lds, ptr addrspace(1) %ptr.global, ptr addrspace(5) %ptr.stack, ptr addrspace(4) %ptr.const)
  ret void
}

define amdgpu_kernel void @format_str_d(i1 %i1, i4 %i4, i8 %i8, i24 %i24, i16 %i16, i32 %i32, i64 %i64, i96 %i96, i128 %i128) {
; R600-LABEL: @format_str_d(
; R600-NEXT:    [[CALL:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.d, i1 [[I1:%.*]], i4 [[I4:%.*]], i8 [[I8:%.*]], i24 [[I24:%.*]], i16 [[I16:%.*]], i32 [[I32:%.*]], i64 [[I64:%.*]], i96 [[I96:%.*]], i128 [[I128:%.*]], i32 1234)
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_d(
; GCN-NEXT:    [[TMP1:%.*]] = sext i1 [[I1:%.*]] to i32
; GCN-NEXT:    [[TMP2:%.*]] = sext i4 [[I4:%.*]] to i32
; GCN-NEXT:    [[TMP3:%.*]] = sext i8 [[I8:%.*]] to i32
; GCN-NEXT:    [[TMP4:%.*]] = sext i16 [[I16:%.*]] to i32
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 72)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP5:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP5]], label [[TMP6:%.*]], label [[TMP7:%.*]]
; GCN:       6:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 6, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 [[TMP1]], ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[TMP2]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 [[TMP3]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 4
; GCN-NEXT:    store i24 [[I24:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store i32 [[TMP4]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 4
; GCN-NEXT:    store i32 [[I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 4
; GCN-NEXT:    store i64 [[I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 8
; GCN-NEXT:    store i96 [[I96:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR7:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], i32 16
; GCN-NEXT:    store i128 [[I128:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR8:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], i32 16
; GCN-NEXT:    store i32 1234, ptr addrspace(1) [[PRINTBUFFNEXTPTR8]], align 4
; GCN-NEXT:    br label [[TMP7]]
; GCN:       7:
; GCN-NEXT:    ret void
;
  %call = call i32 @printf(ptr addrspace(4) @format.str.d, i1 %i1, i4 %i4, i8 %i8, i24 %i24, i16 %i16, i32 %i32, i64 %i64, i96 %i96, i128 %i128, i32 1234)
  ret void
}

define amdgpu_kernel void @format_str_u(i1 %i1, i4 %i4, i8 %i8, i24 %i24, i16 %i16, i32 %i32, i64 %i64, i96 %i96, i128 %i128) {
; R600-LABEL: @format_str_u(
; R600-NEXT:    [[CALL:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.u, i1 [[I1:%.*]], i4 [[I4:%.*]], i8 [[I8:%.*]], i24 [[I24:%.*]], i16 [[I16:%.*]], i32 [[I32:%.*]], i64 [[I64:%.*]], i96 [[I96:%.*]], i128 [[I128:%.*]], i32 1234)
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_u(
; GCN-NEXT:    [[TMP1:%.*]] = zext i1 [[I1:%.*]] to i32
; GCN-NEXT:    [[TMP2:%.*]] = zext i4 [[I4:%.*]] to i32
; GCN-NEXT:    [[TMP3:%.*]] = zext i8 [[I8:%.*]] to i32
; GCN-NEXT:    [[TMP4:%.*]] = zext i16 [[I16:%.*]] to i32
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 72)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP5:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP5]], label [[TMP6:%.*]], label [[TMP7:%.*]]
; GCN:       6:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 7, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 [[TMP1]], ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[TMP2]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 [[TMP3]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 4
; GCN-NEXT:    store i24 [[I24:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store i32 [[TMP4]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 4
; GCN-NEXT:    store i32 [[I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 4
; GCN-NEXT:    store i64 [[I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 8
; GCN-NEXT:    store i96 [[I96:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR7:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], i32 16
; GCN-NEXT:    store i128 [[I128:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR8:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], i32 16
; GCN-NEXT:    store i32 1234, ptr addrspace(1) [[PRINTBUFFNEXTPTR8]], align 4
; GCN-NEXT:    br label [[TMP7]]
; GCN:       7:
; GCN-NEXT:    ret void
;
  %call = call i32 @printf(ptr addrspace(4) @format.str.u, i1 %i1, i4 %i4, i8 %i8, i24 %i24, i16 %i16, i32 %i32, i64 %i64, i96 %i96, i128 %i128, i32 1234)
  ret void
}

define void @format_str_v1(<1 x float> %v1f32.0, <1 x float> %v1f32.1, <1 x double> %v1f64, <1 x i8> %v1i8, <1 x i16> %v1i16, <1 x i32> %v1i32, <1 x i64> %v1i64,
; R600-LABEL: @format_str_v1(
; R600-NEXT:    [[V1F32_1_FPEXT:%.*]] = fpext <1 x float> [[V1F32_1:%.*]] to <1 x double>
; R600-NEXT:    [[CALL1:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.v1, <1 x float> [[V1F32_0:%.*]], <1 x double> [[V1F32_1_FPEXT]], <1 x double> [[V1F64:%.*]], <1 x i8> [[V1I8:%.*]], <1 x i16> [[V1I16:%.*]], <1 x i32> [[V1I32:%.*]], <1 x i64> [[V1I64:%.*]], <1 x ptr addrspace(1)> [[V1P1:%.*]], <1 x ptr addrspace(3)> [[V1P3:%.*]], <1 x half> [[V1F16:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_v1(
; GCN-NEXT:    [[V1F32_1_FPEXT:%.*]] = fpext <1 x float> [[V1F32_1:%.*]] to <1 x double>
; GCN-NEXT:    [[TMP1:%.*]] = sext <1 x i8> [[V1I8:%.*]] to <1 x i32>
; GCN-NEXT:    [[TMP2:%.*]] = sext <1 x i16> [[V1I16:%.*]] to <1 x i32>
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 44)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP3:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP5:%.*]]
; GCN:       4:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 8, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store <1 x float> [[V1F32_0:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store <1 x double> [[V1F32_1_FPEXT]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 8
; GCN-NEXT:    store <1 x double> [[V1F64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 8
; GCN-NEXT:    store <1 x i32> [[TMP1]], ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store <1 x i32> [[TMP2]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 4
; GCN-NEXT:    store <1 x i32> [[V1I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 4
; GCN-NEXT:    store <1 x i64> [[V1I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 8
; GCN-NEXT:    br label [[TMP5]]
; GCN:       5:
; GCN-NEXT:    ret void
;
  <1 x ptr addrspace(1)> %v1p1, <1 x ptr addrspace(3)> %v1p3, <1 x half> %v1f16) {
  %v1f32.1.fpext = fpext <1 x float> %v1f32.1 to <1 x double>
  %call1 = call i32 @printf(ptr addrspace(4) @format.str.v1, <1 x float> %v1f32.0, <1 x double> %v1f32.1.fpext, <1 x double> %v1f64, <1 x i8> %v1i8, <1 x i16> %v1i16, <1 x i32> %v1i32, <1 x i64> %v1i64,
  <1 x ptr addrspace(1)> %v1p1, <1 x ptr addrspace(3)> %v1p3, <1 x half> %v1f16)
  ret void
}

define void @format_str_v2(<2 x float> %v2f32.0, <2 x float> %v2f32.1, <2 x double> %v2f64, <2 x i8> %v2i8, <2 x i16> %v2i16, <2 x i32> %v2i32, <2 x i64> %v2i64,
; R600-LABEL: @format_str_v2(
; R600-NEXT:    [[V2F32_1_FPEXT:%.*]] = fpext <2 x float> [[V2F32_1:%.*]] to <2 x double>
; R600-NEXT:    [[CALL1:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.v2, <2 x float> [[V2F32_0:%.*]], <2 x double> [[V2F32_1_FPEXT]], <2 x double> [[V2F64:%.*]], <2 x i8> [[V2I8:%.*]], <2 x i16> [[V2I16:%.*]], <2 x i32> [[V2I32:%.*]], <2 x i64> [[V2I64:%.*]], <2 x ptr addrspace(1)> [[V2P1:%.*]], <2 x ptr addrspace(3)> [[V2P3:%.*]], <2 x half> [[V2F16:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_v2(
; GCN-NEXT:    [[V2F32_1_FPEXT:%.*]] = fpext <2 x float> [[V2F32_1:%.*]] to <2 x double>
; GCN-NEXT:    [[TMP1:%.*]] = sext <2 x i8> [[V2I8:%.*]] to <2 x i32>
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 80)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP2:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP2]], label [[TMP3:%.*]], label [[TMP4:%.*]]
; GCN:       3:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 9, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store <2 x float> [[V2F32_0:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 8
; GCN-NEXT:    store <2 x double> [[V2F32_1_FPEXT]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 16
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 16
; GCN-NEXT:    store <2 x double> [[V2F64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 16
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 16
; GCN-NEXT:    store <2 x i32> [[TMP1]], ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 8
; GCN-NEXT:    store <2 x i16> [[V2I16:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 4
; GCN-NEXT:    store <2 x i32> [[V2I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 8
; GCN-NEXT:    store <2 x i64> [[V2I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 16
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 16
; GCN-NEXT:    br label [[TMP4]]
; GCN:       4:
; GCN-NEXT:    ret void
;
  <2 x ptr addrspace(1)> %v2p1, <2 x ptr addrspace(3)> %v2p3, <2 x half> %v2f16) {
  %v2f32.1.fpext = fpext <2 x float> %v2f32.1 to <2 x double>
  %call1 = call i32 @printf(ptr addrspace(4) @format.str.v2, <2 x float> %v2f32.0, <2 x double> %v2f32.1.fpext, <2 x double> %v2f64, <2 x i8> %v2i8, <2 x i16> %v2i16, <2 x i32> %v2i32, <2 x i64> %v2i64,
  <2 x ptr addrspace(1)> %v2p1, <2 x ptr addrspace(3)> %v2p3, <2 x half> %v2f16)
  ret void
}

define void @format_str_v3(<3 x float> %v3f32.0, <3 x float> %v3f32.1, <3 x double> %v3f64, <3 x i8> %v3i8, <3 x i16> %v3i16, <3 x i32> %v3i32, <3 x i64> %v3i64,
; R600-LABEL: @format_str_v3(
; R600-NEXT:    [[V3F32_1_FPEXT:%.*]] = fpext <3 x float> [[V3F32_1:%.*]] to <3 x double>
; R600-NEXT:    [[CALL1:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.v3, <3 x float> [[V3F32_0:%.*]], <3 x double> [[V3F32_1_FPEXT]], <3 x double> [[V3F64:%.*]], <3 x i8> [[V3I8:%.*]], <3 x i16> [[V3I16:%.*]], <3 x i32> [[V3I32:%.*]], <3 x i64> [[V3I64:%.*]], <3 x ptr addrspace(1)> [[V3P1:%.*]], <3 x ptr addrspace(3)> [[V3P3:%.*]], <3 x half> [[V3F16:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_v3(
; GCN-NEXT:    [[V3F32_1_FPEXT:%.*]] = fpext <3 x float> [[V3F32_1:%.*]] to <3 x double>
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 144)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 10, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store <3 x float> [[V3F32_0:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 16
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 16
; GCN-NEXT:    store <3 x double> [[V3F32_1_FPEXT]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 32
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 32
; GCN-NEXT:    store <3 x double> [[V3F64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 32
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 32
; GCN-NEXT:    store <3 x i8> [[V3I8:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store <3 x i16> [[V3I16:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 8
; GCN-NEXT:    store <3 x i32> [[V3I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 16
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 16
; GCN-NEXT:    store <3 x i64> [[V3I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 32
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 32
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  <3 x ptr addrspace(1)> %v3p1, <3 x ptr addrspace(3)> %v3p3, <3 x half> %v3f16) {
  %v3f32.1.fpext = fpext <3 x float> %v3f32.1 to <3 x double>
  %call1 = call i32 @printf(ptr addrspace(4) @format.str.v3, <3 x float> %v3f32.0, <3 x double> %v3f32.1.fpext, <3 x double> %v3f64, <3 x i8> %v3i8, <3 x i16> %v3i16, <3 x i32> %v3i32, <3 x i64> %v3i64,
  <3 x ptr addrspace(1)> %v3p1, <3 x ptr addrspace(3)> %v3p3, <3 x half> %v3f16)
  ret void
}

define void @format_str_v4(<4 x float> %v4f32.0, <4 x float> %v4f32.1, <4 x double> %v4f64, <4 x i8> %v4i8, <4 x i16> %v4i16, <4 x i32> %v4i32, <4 x i64> %v4i64,
; R600-LABEL: @format_str_v4(
; R600-NEXT:    [[V4F32_1_FPEXT:%.*]] = fpext <4 x float> [[V4F32_1:%.*]] to <4 x double>
; R600-NEXT:    [[CALL1:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.v4, <4 x float> [[V4F32_0:%.*]], <4 x double> [[V4F32_1_FPEXT]], <4 x double> [[V4F64:%.*]], <4 x i8> [[V4I8:%.*]], <4 x i16> [[V4I16:%.*]], <4 x i32> [[V4I32:%.*]], <4 x i64> [[V4I64:%.*]], <4 x ptr addrspace(1)> [[V4P1:%.*]], <4 x ptr addrspace(3)> [[V4P3:%.*]], <4 x half> [[V4F16:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_v4(
; GCN-NEXT:    [[V4F32_1_FPEXT:%.*]] = fpext <4 x float> [[V4F32_1:%.*]] to <4 x double>
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 144)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 11, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store <4 x float> [[V4F32_0:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 16
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 16
; GCN-NEXT:    store <4 x double> [[V4F32_1_FPEXT]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 32
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 32
; GCN-NEXT:    store <4 x double> [[V4F64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 32
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 32
; GCN-NEXT:    store <4 x i8> [[V4I8:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store <4 x i16> [[V4I16:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 8
; GCN-NEXT:    store <4 x i32> [[V4I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 16
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 16
; GCN-NEXT:    store <4 x i64> [[V4I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 32
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 32
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  <4 x ptr addrspace(1)> %v4p1, <4 x ptr addrspace(3)> %v4p3, <4 x half> %v4f16) {
  %v4f32.1.fpext = fpext <4 x float> %v4f32.1 to <4 x double>
  %call1 = call i32 @printf(ptr addrspace(4) @format.str.v4, <4 x float> %v4f32.0, <4 x double> %v4f32.1.fpext, <4 x double> %v4f64, <4 x i8> %v4i8, <4 x i16> %v4i16, <4 x i32> %v4i32, <4 x i64> %v4i64,
  <4 x ptr addrspace(1)> %v4p1, <4 x ptr addrspace(3)> %v4p3, <4 x half> %v4f16)
  ret void
}

define void @format_str_v8(<8 x float> %v8f32.0, <8 x float> %v8f32.1, <8 x double> %v8f64, <8 x i8> %v8i8, <8 x i16> %v8i16, <8 x i32> %v8i32, <8 x i64> %v8i64,
; R600-LABEL: @format_str_v8(
; R600-NEXT:    [[V8F32_1_FPEXT:%.*]] = fpext <8 x float> [[V8F32_1:%.*]] to <8 x double>
; R600-NEXT:    [[CALL1:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.v8, <8 x float> [[V8F32_0:%.*]], <8 x double> [[V8F32_1_FPEXT]], <8 x double> [[V8F64:%.*]], <8 x i8> [[V8I8:%.*]], <8 x i16> [[V8I16:%.*]], <8 x i32> [[V8I32:%.*]], <8 x i64> [[V8I64:%.*]], <8 x ptr addrspace(1)> [[V8P1:%.*]], <8 x ptr addrspace(3)> [[V8P3:%.*]], <8 x half> [[V8F16:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_v8(
; GCN-NEXT:    [[V8F32_1_FPEXT:%.*]] = fpext <8 x float> [[V8F32_1:%.*]] to <8 x double>
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 284)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 12, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store <8 x float> [[V8F32_0:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 32
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 32
; GCN-NEXT:    store <8 x double> [[V8F32_1_FPEXT]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 64
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 64
; GCN-NEXT:    store <8 x double> [[V8F64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 64
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 64
; GCN-NEXT:    store <8 x i8> [[V8I8:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 8
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 8
; GCN-NEXT:    store <8 x i16> [[V8I16:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 16
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 16
; GCN-NEXT:    store <8 x i32> [[V8I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 32
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 32
; GCN-NEXT:    store <8 x i64> [[V8I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 64
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 64
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  <8 x ptr addrspace(1)> %v8p1, <8 x ptr addrspace(3)> %v8p3, <8 x half> %v8f16) {
  %v8f32.1.fpext = fpext <8 x float> %v8f32.1 to <8 x double>
  %call1 = call i32 @printf(ptr addrspace(4) @format.str.v8, <8 x float> %v8f32.0, <8 x double> %v8f32.1.fpext, <8 x double> %v8f64, <8 x i8> %v8i8, <8 x i16> %v8i16, <8 x i32> %v8i32, <8 x i64> %v8i64,
  <8 x ptr addrspace(1)> %v8p1, <8 x ptr addrspace(3)> %v8p3, <8 x half> %v8f16)
  ret void
}

define void @format_str_v16(<16 x float> %v16f32.0, <16 x float> %v16f32.1, <16 x double> %v16f64, <16 x i8> %v16i8, <16 x i16> %v16i16, <16 x i32> %v16i32, <16 x i64> %v16i64,
; R600-LABEL: @format_str_v16(
; R600-NEXT:    [[V16F32_1_FPEXT:%.*]] = fpext <16 x float> [[V16F32_1:%.*]] to <16 x double>
; R600-NEXT:    [[CALL1:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.v16, <16 x float> [[V16F32_0:%.*]], <16 x double> [[V16F32_1_FPEXT]], <16 x double> [[V16F64:%.*]], <16 x i8> [[V16I8:%.*]], <16 x i16> [[V16I16:%.*]], <16 x i32> [[V16I32:%.*]], <16 x i64> [[V16I64:%.*]], <16 x ptr addrspace(1)> [[V16P1:%.*]], <16 x ptr addrspace(3)> [[V16P3:%.*]], <16 x half> [[V16F16:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @format_str_v16(
; GCN-NEXT:    [[V16F32_1_FPEXT:%.*]] = fpext <16 x float> [[V16F32_1:%.*]] to <16 x double>
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 564)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 13, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store <16 x float> [[V16F32_0:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 64
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 64
; GCN-NEXT:    store <16 x double> [[V16F32_1_FPEXT]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 128
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 128
; GCN-NEXT:    store <16 x double> [[V16F64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 128
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 128
; GCN-NEXT:    store <16 x i8> [[V16I8:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 16
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 16
; GCN-NEXT:    store <16 x i16> [[V16I16:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 32
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 32
; GCN-NEXT:    store <16 x i32> [[V16I32:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 64
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 64
; GCN-NEXT:    store <16 x i64> [[V16I64:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 128
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 128
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  <16 x ptr addrspace(1)> %v16p1, <16 x ptr addrspace(3)> %v16p3, <16 x half> %v16f16) {
  %v16f32.1.fpext = fpext <16 x float> %v16f32.1 to <16 x double>
  %call1 = call i32 @printf(ptr addrspace(4) @format.str.v16, <16 x float> %v16f32.0, <16 x double> %v16f32.1.fpext, <16 x double> %v16f64, <16 x i8> %v16i8, <16 x i16> %v16i16, <16 x i32> %v16i32, <16 x i64> %v16i64,
  <16 x ptr addrspace(1)> %v16p1, <16 x ptr addrspace(3)> %v16p3, <16 x half> %v16f16)
  ret void
}

define amdgpu_kernel void @test_kernel(i32 %n) {
; R600-LABEL: @test_kernel(
; R600-NEXT:  entry:
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(5) [[STR]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_kernel(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 14, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %str = alloca [9 x i8], align 1, addrspace(5)
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(5) %str, i32 %n)
  ret void
}

define amdgpu_kernel void @test_format_str_no_null_terminator(i32 %n) {
; R600-LABEL: @test_format_str_no_null_terminator(
; R600-NEXT:  entry:
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @format.str.no.null.terminator, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_format_str_no_null_terminator(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 8)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 15, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @format.str.no.null.terminator, i32 %n)
  ret void
}


define amdgpu_kernel void @test_indexed_format_str(i32 %n) {
; R600-LABEL: @test_indexed_format_str(
; R600-NEXT:  entry:
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) getelementptr ([11 x i8], ptr addrspace(4) @indexed.format.str, i64 0, i32 7), i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_indexed_format_str(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 8)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 16, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) getelementptr ([11 x i8], ptr addrspace(4) @indexed.format.str, i64 0, i32 7), i32 %n)
  ret void
}

define amdgpu_kernel void @test_indexed_format_str_oob(i32 %n) {
; R600-LABEL: @test_indexed_format_str_oob(
; R600-NEXT:  entry:
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) getelementptr ([11 x i8], ptr addrspace(4) @indexed.format.str, i64 0, i64 11), i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_indexed_format_str_oob(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 4)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 17, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) getelementptr ([11 x i8], ptr addrspace(4) @indexed.format.str, i64 0, i64 11), i32 %n)
  ret void
}

define amdgpu_kernel void @string_pointee_type(i32 %n) {
; R600-LABEL: @string_pointee_type(
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(5) [[STR]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @string_pointee_type(
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 18, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %str = alloca [9 x i8], align 1, addrspace(5)
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(5) %str, i32 %n)
  ret void
}

define amdgpu_kernel void @string_address_space4(i32 %n, ptr addrspace(4) %str) {
; R600-LABEL: @string_address_space4(
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) [[STR:%.*]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @string_address_space4(
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 19, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) %str, i32 %n)
  ret void
}

define amdgpu_kernel void @string_address_space1(i32 %n, ptr addrspace(1) %str) {
; R600-LABEL: @string_address_space1(
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(1) [[STR:%.*]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @string_address_space1(
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 20, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(1) %str, i32 %n)
  ret void
}

define amdgpu_kernel void @string_format_passed_i32(i32 %n, i32 %str) {
; R600-LABEL: @string_format_passed_i32(
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, i32 [[STR:%.*]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @string_format_passed_i32(
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 21, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 [[STR:%.*]], ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, i32 %str, i32 %n)
  ret void
}


@str.as1 = private unnamed_addr addrspace(1) constant [6 x i8] c"%s:%d\00", align 1

define amdgpu_kernel void @test_kernel_addrspacecasted_format_str(i32 %n) {
; R600-LABEL: @test_kernel_addrspacecasted_format_str(
; R600-NEXT:  entry:
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [9 x i8], ptr addrspace(5) [[STR]], i32 0, i32 0
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) addrspacecast (ptr addrspace(1) @str.as1 to ptr addrspace(4)), ptr addrspace(5) [[ARRAYDECAY]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_kernel_addrspacecasted_format_str(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [9 x i8], ptr addrspace(5) [[STR]], i32 0, i32 0
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 22, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %str = alloca [9 x i8], align 1, addrspace(5)
  %arraydecay = getelementptr inbounds [9 x i8], ptr addrspace(5) %str, i32 0, i32 0
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) addrspacecast (ptr addrspace(1) @str.as1 to ptr addrspace(4)), ptr addrspace(5) %arraydecay, i32 %n)
  ret void
}

define amdgpu_kernel void @test_undef_argument(i32 %n) {
; R600-LABEL: @test_undef_argument(
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) poison, ptr addrspace(5) [[STR]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_undef_argument(
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    ret void
;
  %str = alloca [9 x i8], align 1, addrspace(5)
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) poison, ptr addrspace(5) %str, i32 %n)
  ret void
}

define amdgpu_kernel void @test_poison_argument(i32 %n) {
; R600-LABEL: @test_poison_argument(
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) poison, ptr addrspace(5) [[STR]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_poison_argument(
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    ret void
;
  %str = alloca [9 x i8], align 1, addrspace(5)
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) poison, ptr addrspace(5) %str, i32 %n)
  ret void
}

define amdgpu_kernel void @test_null_argument(i32 %n) {
; R600-LABEL: @test_null_argument(
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) null, ptr addrspace(5) [[STR]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_null_argument(
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    ret void
;
  %str = alloca [9 x i8], align 1, addrspace(5)
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) null, ptr addrspace(5) %str, i32 %n)
  ret void
}

@undef.initializer = private unnamed_addr addrspace(4) constant [6 x i8] undef

define amdgpu_kernel void @undef_initializer_gv(i32 %n) {
; R600-LABEL: @undef_initializer_gv(
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @poison.initializer, ptr addrspace(5) [[STR]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @undef_initializer_gv(
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 4)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 23, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %str = alloca [9 x i8], align 1, addrspace(5)
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @poison.initializer, ptr addrspace(5) %str, i32 %n)
  ret void
}

@poison.initializer = private unnamed_addr addrspace(4) constant [6 x i8] poison

define amdgpu_kernel void @poison_initializer_gv(i32 %n) {
; R600-LABEL: @poison_initializer_gv(
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @poison.initializer, ptr addrspace(5) [[STR]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @poison_initializer_gv(
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 4)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 24, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %str = alloca [9 x i8], align 1, addrspace(5)
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @poison.initializer, ptr addrspace(5) %str, i32 %n)
  ret void
}

@zero.initializer = private unnamed_addr addrspace(4) constant [6 x i8] zeroinitializer

define amdgpu_kernel void @zero_initializer_gv(i32 %n) {
; R600-LABEL: @zero_initializer_gv(
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @poison.initializer, ptr addrspace(5) [[STR]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @zero_initializer_gv(
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 4)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 25, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %str = alloca [9 x i8], align 1, addrspace(5)
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @poison.initializer, ptr addrspace(5) %str, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size0(i32 %n) {
; R600-LABEL: @test_print_string_literal_size0(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size0, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size0(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 26, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 -256, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size0, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_1ai8.zero(i32 %n) {
; R600-LABEL: @test_print_string_literal_1ai8.zero(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.1ai8.zero, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_1ai8.zero(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 27, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 -256, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.1ai8.zero, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_1ai8.undef(i32 %n) {
; R600-LABEL: @test_print_string_literal_1ai8.undef(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.1ai8.undef, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_1ai8.undef(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 28, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 -256, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.1ai8.undef, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_i8.zero(i32 %n) {
; R600-LABEL: @test_print_string_literal_i8.zero(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.i8.zero, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_i8.zero(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 29, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 -256, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.i8.zero, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size2(i32 %n) {
; R600-LABEL: @test_print_string_literal_size2(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size2, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size2(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 30, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 27, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size2, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size3(i32 %n) {
; R600-LABEL: @test_print_string_literal_size3(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size3, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size3(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 31, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 7195, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size3, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size3_zero(i32 %n) {
; R600-LABEL: @test_print_string_literal_size3_zero(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size3.zero, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size3_zero(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 32, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 -256, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size3.zero, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size4(i32 %n) {
; R600-LABEL: @test_print_string_literal_size4(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size4, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size4(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 33, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 6513249, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size4, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size4_nonull_term(i32 %n) {
; R600-LABEL: @test_print_string_literal_size4_nonull_term(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size4.nonull.term, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size4_nonull_term(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 16)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 34, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 1684234849, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size4.nonull.term, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size5(i32 %n) {
; R600-LABEL: @test_print_string_literal_size5(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size5, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size5(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 16)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 35, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 1684234849, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size5, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size6(i32 %n) {
; R600-LABEL: @test_print_string_literal_size6(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size6, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size6(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 16)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 36, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 1684234849, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 101, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size6, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size7(i32 %n) {
; R600-LABEL: @test_print_string_literal_size7(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size6, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size7(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 16)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 37, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 1684234849, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 101, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size6, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size8(i32 %n) {
; R600-LABEL: @test_print_string_literal_size8(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size8, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size8(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 16)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 38, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 1953722977, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 7565921, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size8, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size9(i32 %n) {
; R600-LABEL: @test_print_string_literal_size9(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size9, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size9(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 20)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 39, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 1684104548, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 1717921122, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size9, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size16(i32 %n) {
; R600-LABEL: @test_print_string_literal_size16(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size16, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size16(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 24)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 40, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 909194801, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 909194801, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 909194801, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 4
; GCN-NEXT:    store i32 3225137, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size16, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size17(i32 %n) {
; R600-LABEL: @test_print_string_literal_size17(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size17, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size17(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 28)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 41, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 925972273, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 925972273, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 925972273, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 4
; GCN-NEXT:    store i32 925972273, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size17, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size20(i32 %n) {
; R600-LABEL: @test_print_string_literal_size20(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size20, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size20(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 28)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 42, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 1684234849, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 1751606885, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 1818978921, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 4
; GCN-NEXT:    store i32 1886350957, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store i32 7565937, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size20, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_size32(i32 %n) {
; R600-LABEL: @test_print_string_literal_size32(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size32, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_size32(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 40)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 43, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 1953722977, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 1953722977, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 1953722977, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 4
; GCN-NEXT:    store i32 1953722977, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store i32 1953722977, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR4:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], i32 4
; GCN-NEXT:    store i32 1953722977, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR5:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR4]], i32 4
; GCN-NEXT:    store i32 1953722977, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR6:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR5]], i32 4
; GCN-NEXT:    store i32 7565921, ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR7:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR6]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR7]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.size32, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_not_constant_global(i32 %n) {
; R600-LABEL: @test_print_string_not_constant_global(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.not.constant.size4, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_not_constant_global(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 44, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.not.constant.size4, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_constant_interposable_global(i32 %n) {
; R600-LABEL: @test_print_string_constant_interposable_global(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.interposable.size4, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_constant_interposable_global(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 45, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.interposable.size4, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_v4i8(i32 %n) {
; R600-LABEL: @test_print_string_literal_v4i8(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.v4i8, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_v4i8(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 16)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 46, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 67305985, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.v4i8, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_v4i32(i32 %n) {
; R600-LABEL: @test_print_string_literal_v4i32(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.v4i32, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_v4i32(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 47, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 1, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.v4i32, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_literal_struct(i32 %n) {
; R600-LABEL: @test_print_string_literal_struct(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.struct, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_literal_struct(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 48, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 66, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.struct, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_undef(i32 %n) {
; R600-LABEL: @test_print_string_undef(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) poison, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_undef(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 49, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) poison, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_poison(i32 %n) {
; R600-LABEL: @test_print_string_poison(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) poison, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_poison(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 50, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) poison, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_null(i32 %n) {
; R600-LABEL: @test_print_string_null(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) null, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_null(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 51, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) null, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_inttoptr(i32 %n) {
; R600-LABEL: @test_print_string_inttoptr(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) inttoptr (i64 1234 to ptr addrspace(4)), i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_inttoptr(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 52, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 4144959, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) inttoptr (i64 1234 to ptr addrspace(4)), i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_float_neg0(i32 %n) {
; R600-LABEL: @test_print_string_float_neg0(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.float.0, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_float_neg0(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 53, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 -256, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.float.0, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_float_0(i32 %n) {
; R600-LABEL: @test_print_string_float_0(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.float.0, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_float_0(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 54, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 -256, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.float.0, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_ptr_null(i32 %n) {
; R600-LABEL: @test_print_string_ptr_null(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.ptr.null, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_ptr_null(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 55, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 -256, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.ptr.null, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_ptr_undef(i32 %n) {
; R600-LABEL: @test_print_string_ptr_undef(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.ptr.undef, i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_ptr_undef(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 56, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 -256, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) @printed.str.ptr.undef, i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_indexed(i32 %n) {
; R600-LABEL: @test_print_string_indexed(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) getelementptr ([32 x i8], ptr addrspace(4) @printed.str.size32, i64 0, i64 15), i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_indexed(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 28)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 57, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 1936875892, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 1936875892, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR1:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR]], i32 4
; GCN-NEXT:    store i32 1936875892, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR2:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR1]], i32 4
; GCN-NEXT:    store i32 1936875892, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR3:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFNEXTPTR2]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR3]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) getelementptr ([32 x i8], ptr addrspace(4) @printed.str.size32, i64 0, i64 15), i32 %n)
  ret void
}

define amdgpu_kernel void @test_print_string_indexed_oob(i32 %n) {
; R600-LABEL: @test_print_string_indexed_oob(
; R600-NEXT:  entry:
; R600-NEXT:    [[PRINTF:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) getelementptr ([32 x i8], ptr addrspace(4) @printed.str.size32, i64 0, i64 32), i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_print_string_indexed_oob(
; GCN-NEXT:  entry:
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[ENTRY_SPLIT:%.*]]
; GCN:       entry.split:
; GCN-NEXT:    [[TMP0:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP0]], label [[TMP1:%.*]], label [[TMP2:%.*]]
; GCN:       1:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 58, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store i32 -256, ptr addrspace(1) [[PRINTBUFFGEP]], align 4
; GCN-NEXT:    [[PRINTBUFFNEXTPTR:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTBUFFGEP]], i32 4
; GCN-NEXT:    store i32 [[N:%.*]], ptr addrspace(1) [[PRINTBUFFNEXTPTR]], align 4
; GCN-NEXT:    br label [[TMP2]]
; GCN:       2:
; GCN-NEXT:    ret void
;
entry:
  %printf = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @.str, ptr addrspace(4) getelementptr ([32 x i8], ptr addrspace(4) @printed.str.size32, i64 0, i64 32), i32 %n)
  ret void
}

@array.i16 = private unnamed_addr addrspace(4) constant [6 x i16] [i16 1, i16 2, i16 3, i16 4, i16 5, i16 6]

; CHECK: error: <unknown>:0:0: in function test_format_array_i16 void (i32): printf format string must be a trivially resolved constant string global variable
define amdgpu_kernel void @test_format_array_i16(i32 %n) {
; R600-LABEL: @test_format_array_i16(
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @array.i16, ptr addrspace(5) [[STR]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_format_array_i16(
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 4)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 59, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %str = alloca [9 x i8], align 1, addrspace(5)
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @array.i16, ptr addrspace(5) %str, i32 %n)
  ret void
}

@struct = private unnamed_addr addrspace(4) constant { [6 x i8] } { [6 x i8] [i8 1, i8 2, i8 3, i8 4, i8 5, i8 6] }

define amdgpu_kernel void @test_format_struct(i32 %n) {
; R600-LABEL: @test_format_struct(
; R600-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; R600-NEXT:    [[CALL1:%.*]] = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @struct, ptr addrspace(5) [[STR]], i32 [[N:%.*]])
; R600-NEXT:    ret void
;
; GCN-LABEL: @test_format_struct(
; GCN-NEXT:    [[STR:%.*]] = alloca [9 x i8], align 1, addrspace(5)
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 4)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 60, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %str = alloca [9 x i8], align 1, addrspace(5)
  %call1 = call i32 (ptr addrspace(4), ...) @printf(ptr addrspace(4) @struct, ptr addrspace(5) %str, i32 %n)
  ret void
}

declare void @func(ptr)

define void @not_call_operand_printf() {
; R600-LABEL: @not_call_operand_printf(
; R600-NEXT:    call void @func(ptr @printf)
; R600-NEXT:    ret void
;
; GCN-LABEL: @not_call_operand_printf(
; GCN-NEXT:    call void @func(ptr @printf)
; GCN-NEXT:    ret void
;
  call void @func(ptr @printf)
  ret void
}

define void @printf_printf(i32 %n) {
; R600-LABEL: @printf_printf(
; R600-NEXT:    [[CALL:%.*]] = call i32 @printf(ptr addrspace(4) @format.str.one.ptr, ptr @printf)
; R600-NEXT:    ret void
;
; GCN-LABEL: @printf_printf(
; GCN-NEXT:    [[PRINTF_ALLOC_FN:%.*]] = call ptr addrspace(1) @__printf_alloc(i32 12)
; GCN-NEXT:    br label [[DOTSPLIT:%.*]]
; GCN:       .split:
; GCN-NEXT:    [[TMP1:%.*]] = icmp ne ptr addrspace(1) [[PRINTF_ALLOC_FN]], null
; GCN-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; GCN:       2:
; GCN-NEXT:    [[PRINTBUFFID:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 0
; GCN-NEXT:    [[PRINTBUFFIDCAST:%.*]] = bitcast ptr addrspace(1) [[PRINTBUFFID]] to ptr addrspace(1)
; GCN-NEXT:    store i32 61, ptr addrspace(1) [[PRINTBUFFIDCAST]], align 4
; GCN-NEXT:    [[PRINTBUFFGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[PRINTF_ALLOC_FN]], i32 4
; GCN-NEXT:    store ptr @printf, ptr addrspace(1) [[PRINTBUFFGEP]], align 8
; GCN-NEXT:    br label [[TMP3]]
; GCN:       3:
; GCN-NEXT:    ret void
;
  %call = call i32 @printf(ptr addrspace(4) @format.str.one.ptr, ptr @printf)
  ret void
}

declare i32 @printf(ptr addrspace(4), ...)
