; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -global-isel -mattr=+m -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32I
; RUN: llc -mtriple=riscv32 -global-isel -mattr=+m,+zba -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32ZBA

define signext i16 @sh1add(i64 %0, ptr %1) {
; RV32I-LABEL: sh1add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 1
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    lh a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: sh1add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh1add a0, a0, a2
; RV32ZBA-NEXT:    lh a0, 0(a0)
; RV32ZBA-NEXT:    ret
  %3 = getelementptr inbounds i16, ptr %1, i64 %0
  %4 = load i16, ptr %3
  ret i16 %4
}

define i32 @sh2add(i64 %0, ptr %1) {
; RV32I-LABEL: sh2add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: sh2add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a0, a0, a2
; RV32ZBA-NEXT:    lw a0, 0(a0)
; RV32ZBA-NEXT:    ret
  %3 = getelementptr inbounds i32, ptr %1, i64 %0
  %4 = load i32, ptr %3
  ret i32 %4
}

define i64 @sh3add(i64 %0, ptr %1) {
; RV32I-LABEL: sh3add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 3
; RV32I-NEXT:    add a2, a2, a0
; RV32I-NEXT:    lw a0, 0(a2)
; RV32I-NEXT:    lw a1, 4(a2)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: sh3add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a1, a0, a2
; RV32ZBA-NEXT:    lw a0, 0(a1)
; RV32ZBA-NEXT:    lw a1, 4(a1)
; RV32ZBA-NEXT:    ret
  %3 = getelementptr inbounds i64, ptr %1, i64 %0
  %4 = load i64, ptr %3
  ret i64 %4
}

define i32 @srli_1_sh2add(ptr %0, i32 %1) {
; RV32I-LABEL: srli_1_sh2add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: srli_1_sh2add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    srli a1, a1, 1
; RV32ZBA-NEXT:    sh2add a0, a1, a0
; RV32ZBA-NEXT:    lw a0, 0(a0)
; RV32ZBA-NEXT:    ret
  %3 = lshr i32 %1, 1
  %4 = getelementptr inbounds i32, ptr %0, i32 %3
  %5 = load i32, ptr %4, align 4
  ret i32 %5
}

define i64 @srli_2_sh3add(ptr %0, i32 %1) {
; RV32I-LABEL: srli_2_sh3add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    slli a1, a1, 3
; RV32I-NEXT:    add a1, a0, a1
; RV32I-NEXT:    lw a0, 0(a1)
; RV32I-NEXT:    lw a1, 4(a1)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: srli_2_sh3add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    srli a1, a1, 2
; RV32ZBA-NEXT:    sh3add a1, a1, a0
; RV32ZBA-NEXT:    lw a0, 0(a1)
; RV32ZBA-NEXT:    lw a1, 4(a1)
; RV32ZBA-NEXT:    ret
  %3 = lshr i32 %1, 2
  %4 = getelementptr inbounds i64, ptr %0, i32 %3
  %5 = load i64, ptr %4, align 8
  ret i64 %5
}

define signext i16 @srli_2_sh1add(ptr %0, i32 %1) {
; RV32I-LABEL: srli_2_sh1add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lh a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: srli_2_sh1add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    srli a1, a1, 2
; RV32ZBA-NEXT:    sh1add a0, a1, a0
; RV32ZBA-NEXT:    lh a0, 0(a0)
; RV32ZBA-NEXT:    ret
  %3 = lshr i32 %1, 2
  %4 = getelementptr inbounds i16, ptr %0, i32 %3
  %5 = load i16, ptr %4, align 2
  ret i16 %5
}

define i32 @srli_3_sh2add(ptr %0, i32 %1) {
; RV32I-LABEL: srli_3_sh2add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a1, 3
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: srli_3_sh2add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    srli a1, a1, 3
; RV32ZBA-NEXT:    sh2add a0, a1, a0
; RV32ZBA-NEXT:    lw a0, 0(a0)
; RV32ZBA-NEXT:    ret
  %3 = lshr i32 %1, 3
  %4 = getelementptr inbounds i32, ptr %0, i32 %3
  %5 = load i32, ptr %4, align 4
  ret i32 %5
}

define i64 @srli_4_sh3add(ptr %0, i32 %1) {
; RV32I-LABEL: srli_4_sh3add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    slli a1, a1, 3
; RV32I-NEXT:    add a1, a0, a1
; RV32I-NEXT:    lw a0, 0(a1)
; RV32I-NEXT:    lw a1, 4(a1)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: srli_4_sh3add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    srli a1, a1, 4
; RV32ZBA-NEXT:    sh3add a1, a1, a0
; RV32ZBA-NEXT:    lw a0, 0(a1)
; RV32ZBA-NEXT:    lw a1, 4(a1)
; RV32ZBA-NEXT:    ret
  %3 = lshr i32 %1, 4
  %4 = getelementptr inbounds i64, ptr %0, i32 %3
  %5 = load i64, ptr %4, align 8
  ret i64 %5
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
