
# Copyright 2001-2007, BSI.
# http://www.fastcoder.net/
# Extra functions for configure script.

#
# AC_DIR_INIT - locate the /etc/rc.d directory, which contains
# the init.d directory.  Defines the directory
# as INIT_DIR, which is substituted in the output files.
#
AC_DEFUN([AC_DIR_INIT],
[
  AC_MSG_CHECKING(for location of init.d directory)

  AC_ARG_WITH(init-dir,
	[  --with-init-dir=PATH    absolute path of init.d directory])

  INIT_DIR=/etc/rc.d/init.d
  # list dirs in reverse order of preference
  for a in /sbin /etc /etc/rc.d ; do
	if (test -d $a/init.d); then
		INIT_DIR="$a/init.d";
	fi
  done
  test -z "$with_init_dir" || INIT_DIR=$with_init_dir
  
  AC_MSG_RESULT($INIT_DIR)
  AC_SUBST(INIT_DIR)dnl
])

#
# AC_DIR_RC - locate the /etc/rc.d directory, which contains
# the rc?.d directories.  Defines the directory as RC_DIR,
# which is substituted in the output files.
#
AC_DEFUN([AC_DIR_RC],
[
  AC_MSG_CHECKING(for location of rc.d directories)

  AC_ARG_WITH(rc-dir,
	[  --with-rc-dir=PATH      absolute path of rc.d directory])

  RC_DIR=/etc/rc.d
  # list dirs in reverse order of preference
  for a in /sbin/init.d /etc /etc/rc.d ; do
	if (test -d $a/rc3.d); then
		RC_DIR=$a;
	fi
  done
  test -z "$with_rc_dir" || RC_DIR=$with_rc_dir
  
  AC_MSG_RESULT($RC_DIR)
  AC_SUBST(RC_DIR)dnl
])


#
# AC_DIR_XINETD - locate the /etc/xinetd.d directory.
# Defines the directory as XINETD_DIR, which is substituted in the output files.
#
AC_DEFUN([AC_DIR_XINETD],
[
  AC_MSG_CHECKING(for location of xinetd.d directory)

  AC_ARG_WITH(xinetd-d,
	[  --with-xinetd-dir=PATH  absolute path of xinetd.d directory])

  XINETD_DIR="/etc/xinetd.d"
  # list dirs in reverse order of preference
  for a in /usr/local/etc /etc; do
	if (test -d "$a/xinetd.d"); then
		XINETD_DIR="$a/xinetd.d";
	fi
  done
  test -z "$with_xinetd_d" || XINETD_DIR=$with_xinetd_d
  
  AC_MSG_RESULT($XINETD_DIR)
  AC_SUBST(XINETD_DIR)dnl
])

#
# AC_DIR_ALT_LINKS - locate the /etc/alternatives directory, which contains
# the symlinks for programs.
#
AC_DEFUN([AC_DIR_ALT_LINKS],
[
  AC_MSG_CHECKING(for location of alternatives symlink directory)

  AC_ARG_WITH(alt-links-dir,
	[  --with-alt-links-dir=PATH    absolute path of alternatives directory])

  ALT_LINKS_DIR=/etc/alternatives
  # list dirs in reverse order of preference
  for a in /etc/alternatives ; do
	if (test -d $a); then
		ALT_LINKS_DIR="$a";
	fi
  done
  test -z "$with_alt_links_dir" || ALT_LINKS_DIR=$with_alt_links_dir
  
  AC_MSG_RESULT($ALT_LINKS_DIR)
  AC_SUBST(ALT_LINKS_DIR)dnl
])

#
# AC_DIR_ALT_ADMIN - locate the /var/lib/alternatives directory, which contains
# the info about alternatives.
#
AC_DEFUN([AC_DIR_ALT_ADMIN],
[
  AC_MSG_CHECKING(for location of alternatives admin directory)

  AC_ARG_WITH(alt-admin-dir,
	[  --with-alt-admin-dir=PATH    absolute path of alternatives admin dir])

  ALT_ADMIN_DIR=/var/lib/alternatives
  # list dirs in reverse order of preference
  for a in /var/lib/dpkg/alternatives /var/lib/alternatives ; do
	if (test -d $a); then
		ALT_ADMIN_DIR="$a";
	fi
  done
  test -z "$with_alt_admin_dir" || ALT_ADMIN_DIR=$with_alt_admin_dir
  
  AC_MSG_RESULT($ALT_ADMIN_DIR)
  AC_SUBST(ALT_ADMIN_DIR)dnl
])

#
# AC_NTSYSV - the conditional code for compiling the NTSYSV program
#
AC_DEFUN([AC_NTSYSV],
[
    AC_MSG_CHECKING([whether to compile ntsysv])
    COMP_NTSYSV=yes
    AC_ARG_ENABLE([ntsysv],
	[  --enable-ntsysv         activates compilation of ntsysv program],
	[COMP_NTSYSV=$enableval])
    if test "x$COMP_NTSYSV" = "xyes"; then
	NTSYSV="ntsysv\$(EXEEXT)"
	NTSYSVMAN="ntsysv.8"
    else
	COMP_NTSYSV=no
	NTSYSV=""
	NTSYSVMAN=""
    fi
    AC_MSG_RESULT($COMP_NTSYSV)
    AC_SUBST(NTSYSV)
    AC_SUBST(NTSYSVMAN)
])

#
# AC_ALTERNATIVES - the conditional code for compiling the ALTERNATIVES program
#
AC_DEFUN([AC_ALTERNATIVES],
[
    AC_MSG_CHECKING([whether to compile alternatives])
    COMP_ALTERNATIVES=yes
    AC_ARG_ENABLE(alternatives,
	[  --enable-alternatives  activates compilation of alternatives program],
	[COMP_ALTERNATIVES=$enableval])
    if test "$COMP_ALTERNATIVES" = "yes"; then
	ALTERNATIVES="alternatives\$(EXEEXT)"
	ALTERNATIVESMAN="alternatives.8"
    else
	COMP_ALTERNATIVES=no
	ALTERNATIVES=""
	ALTERNATIVESMAN=""
    fi
    AC_MSG_RESULT($COMP_ALTERNATIVES)
    AC_SUBST(ALTERNATIVES)
    AC_SUBST(ALTERNATIVESMAN)
])

#
# AC_MANDATORY_HEADERS - the conditional code for compiling the NTSYSV program
#
AC_DEFUN([AC_MANDATORY_HEADERS],
[
    AC_MSG_CHECKING([whether to require chkconfig headers])
    dnl Default is to require headers
    AC_ARG_ENABLE(mandatory-headers,
	[  --enable-mandatory-headers  require chkconfig headers on init scripts],
	COMP_REQHDRS=$enableval, COMP_REQHDRS=yes)
    AC_MSG_RESULT($COMP_REQHDRS)
    dnl If we want mandatory headers, then define it.
    if test "$COMP_REQHDRS" = "yes"; then
	AC_DEFINE([MANDATORY_HEADERS], [], [require chkconfig style headers])
    fi
], [the conditional code for compiling the NTSYSV program])


#
# AC_MAX_LEVEL - find the maximum level to allow
#
AC_DEFUN([AC_MAX_LEVEL],
[
  AC_MSG_CHECKING(for maximum init level)

  AC_ARG_WITH(max-level,
	[  --with-max-level=INT    maximum init level allowed])

  # for levels in RC_DIR
  MAX_LEVEL=0
  for a in 0 1 2 3 4 5 6 7 8 9; do
	if (test -d $RC_DIR/rc$a.d); then
		MAX_LEVEL=$a
	fi
  done
  test -z "$with_max_level" || MAX_LEVEL=$with_max_level
  
  AC_MSG_RESULT($MAX_LEVEL)
  AC_SUBST(MAX_LEVEL)dnl
])

