#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::GalleryTypeCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GalleryTypeCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::GalleryTypeCodeType

=head1 DESCRIPTION

Indicates whether listing images are
included in the search results (in both Picture Gallery and
List Views) and, if so, which image listing enhancements apply
to them. Items that have pictures but do not have image listing
enhancements display a generic photo image in search results.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 None

Listing image is not included in the search results
(in either Picture Gallery or List Views), and no other
image listing enhancements apply. Items that have pictures
but do not have image listing enhancements display a generic
photo image in search results.
<br><br>
Mainly useful for RelistItem use cases when you want to
remove an existing gallery setting. However, not all image
listing enhancements can be removed on revise or relist.
<br><br>
Note that specifying None is not necessarily the same as
omitting GalleryType from a request. For example, specifying
other item properties may cause the listing to be
included in the search results Gallery by default if
GalleryType is not specified.



=cut


use constant None => scalar('None');


=head2 Featured

Listing is highlighted and included at the top of
search results.
<br><br>
When "Featured" is included in an item listing, the listing
also automatically gets the Gallery and Gallery Plus
functionality. "Gallery" and "Plus" do not need to be
specified separately in the listing. Passing "Featured",
"Plus", and "Gallery" in the same request will return an
error.
<br><br>
For eBay Motors (SiteId 100), this may also feature certain items on the eBay Motors home page.
<br><br>
Not applicable to eBay Stores Inventory listings.
<br><br>
<span class="tablenote"><b>Note:</b>
Gallery Featured is known as Featured First on the Italy site.
</span>
<br><br>



=cut


use constant Featured => scalar('Featured');


=head2 Gallery

Listing image is included in the search results (in
both Picture Gallery and List Views). Items that have
pictures but do not have the Gallery feature will have a
generic photo image shown in search results.
<br><br>
Some listing enhancements (for example, "Featured" and
"Plus") automatically include the Gallery functionality, so
"Gallery" does not need to be specified separately in the
listing. Passing "Featured", "Plus", and "Gallery" in the
same request will return an error.



=cut


use constant Gallery => scalar('Gallery');


=head2 Plus

Listing image has Gallery Plus funtionality. That
is, listing includes a Gallery Plus icon that, when moused
over or clicked, displays a large (400 px x 400 px) preview
image of the item. Clicking the image
displays the View Item page for that listing.
<br><br>
Listing images that are originally smaller than 400 px x 400 px are centered in the preview frame. Images that are originally larger than 400 px x 400 px are scaled down to 400 px on their longest side (maintaining their original aspect ratio).
<br><br>
Note that you can use the Gallery Plus feature
whether or not the image
is hosted with eBay Picture Services (EPS). One EPS image
is included at no cost with the Gallery Plus feature.
<br><br>
When "Plus" is included in an item listing, the listing
also automatically gets the Gallery functionality at no extra cost. "Gallery"
does not need to be specified separately in the listing.
Passing "Featured", "Plus", and "Gallery" in the same
request will return an error.
<br><br>
<span class="tablenote"><b>Note:</b>
As of 02-20-2008, the following sites offer free Gallery:
US (site ID 0), Parts & Accessories Category on US Motors (site ID 100),
CA (site ID 2), CAFR (site ID 210), FR (site ID 71) and NL (site ID 146).
Additionally, ES (site ID 186) and IT (site ID 101) offer free Gallery as of 03-03-2008.
<br><br>
On these sites (starting on the same production date), whenever Plus is selected
in a request that specifies at least two eBay Picture Services (EPS) hosted
images (using ItemType.PictureDetailsType.PictureURL), the Gallery Plus feature
now automatically includes a Gallery Showcase of all the listing's
images at no extra cost. If Plus is selected and the request includes only one
EPS image or any self-hosted images, regular Gallery Plus applies.
<br><br>
The Gallery Showcase displays when mousing over or clicking on the listing's Gallery
Plus icon in the search results. The Showcase window displays a large
(400 px x 400 px) preview image which is usually the first specified
PictureURL, as well as up to four (64 px x 64 px) selectable
thumbnails for the remaining EPS images (the Showcase window contains
pagination controls for observing all EPS images in the request).
Clicking on the preview image displays the item's listing page.
<br><br>
When using RelistItem or ReviseItem (item has no bids and more than
12 hours before the listing's end), Plus can be unselected in
the request. However, the Plus fee will still apply if a previous
request selected Plus. There is at most one Plus fee per listing.
</span>
<br><br>
Not applicable to eBay Stores Inventory listings.



=cut


use constant Plus => scalar('Plus');


=head2 CustomCode

Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
