package App::EventStreamr::DVswitch::Ingest::DV;
use Method::Signatures;
use Moo;
use namespace::clean;

# ABSTRACT: A DVswitch DV Process

our $VERSION = '0.5'; # VERSION: Generated by DZP::OurPkg:Version


extends 'App::EventStreamr::Process';

has 'cmd'         => ( is => 'ro', lazy => 1, builder => 1 );
has 'cmd_regex'   => ( is => 'ro', lazy => 1, builder => 1 );
has 'id'          => ( is => 'ro', required => 1 );
has 'device'      => ( is => 'ro', required => 1 );
has 'type'        => ( is => 'ro', default => sub { 'ingest' } );

method _build_cmd() {
  my $command = $self->{config}{commands}{dv} ? $self->{config}{commands}{dv} : 'dvsource-firewire -h $host -p $port -c $id';
  
  my %cmd_vars =  (
    device  => $self->device,
    host    => $self->{config}{mixer}{host},
    port    => $self->{config}{mixer}{port},
    id      => $self->{id},
  );

  $command =~ s/\$(\w+)/$cmd_vars{$1}/g;
  return $command;
}

method _build_cmd_regex() {
  return qr:dvgrab.+$self->{id}.*:;
}

with('App::EventStreamr::DVswitch::Roles::MixerWait');

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::EventStreamr::DVswitch::Ingest::DV - A DVswitch DV Process

=head1 VERSION

version 0.5

=head1 SYNOPSIS

This Provides a DV ingest process.

=head1 DESCRIPTION

This largely extends L<App::EventStreamr::Process>, provides
default cmds that can be overridden in the configuration.

=head1 AUTHOR

Leon Wright < techman@cpan.org >

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2014 by Leon Wright.

This is free software, licensed under:

  The GNU Affero General Public License, Version 3, November 2007

=cut
