#!/usr/bin/perl

package eBay::API::XML::Call::GetLiveAuctionBidders;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetLiveAuctionBidders.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetLiveAuctionBidders

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetLiveAuctionBidders inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetLiveAuctionBidders::GetLiveAuctionBiddersRequestType;
use eBay::API::XML::Call::GetLiveAuctionBidders::GetLiveAuctionBiddersResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetLiveAuctionBidders';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetLiveAuctionBidders::GetLiveAuctionBiddersRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetLiveAuctionBidders::GetLiveAuctionBiddersResponseType';
}

#
# input properties
#

=head2 setBidderStatus()

The seller can ask to retrieve a subset of users in the bidder approval list
who are either "approved","denied", or "pending" or a combination of these.
If this field is not specified in the request, all records are returned.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:BidderStatusCodeType'

=cut
       
sub setBidderStatus {
   my $self   = shift;
   my $sBidderStatus = shift;
   $self->getRequestDataType()->setBidderStatus($sBidderStatus);
}

=head2 setPagination()

Child elements control pagination of the output.
Use its EntriesPerPage property to control the number of bidders to return per call
and its PageNumber property to specify the page of data to return.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut
       
sub setPagination {
   my $self   = shift;
   my $pPagination = shift;
   $self->getRequestDataType()->setPagination($pPagination);
}

=head2 setUserCatalogID()

Number that identifies the seller's eBay Live Auctions catalog for which they
want to retrieve bidder requests.

  RequiredInput: Yes
#    Argument: 'xs:int'

=cut
       
sub setUserCatalogID {
   my $self   = shift;
   my $sUserCatalogID = shift;
   $self->getRequestDataType()->setUserCatalogID($sUserCatalogID);
}



#
# output properties
#

=head2 getBidderDetails()

Contains the bidder details that match the bidder query
passed in the request.
Returned when bidder search results are found.

  Returned: Conditionally
#    Returns: 'ns:BidderDetailArrayType'

=cut
       
sub getBidderDetails {
   my $self = shift;
   return $self->getResponseDataType()->getBidderDetails();
}

=head2 getPageNumber()

The page number for the page of data returned.

  Returned: Conditionally
#    Returns: 'xs:int'

=cut
       
sub getPageNumber {
   my $self = shift;
   return $self->getResponseDataType()->getPageNumber();
}

=head2 getPaginationResult()

Shows the pagination of data returned by requests. Only returned
if Pagination was specified in the request.

  Returned: Conditionally
#    Returns: 'ns:PaginationResultType'

=cut
       
sub getPaginationResult {
   my $self = shift;
   return $self->getResponseDataType()->getPaginationResult();
}

=head2 getTotalApproved()

Total number of bidders in Approved state.

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getTotalApproved {
   my $self = shift;
   return $self->getResponseDataType()->getTotalApproved();
}

=head2 getTotalDenied()

Total number of bidders in Denied state.

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getTotalDenied {
   my $self = shift;
   return $self->getResponseDataType()->getTotalDenied();
}

=head2 getTotalPending()

Total number of bidders in Pending state.

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getTotalPending {
   my $self = shift;
   return $self->getResponseDataType()->getTotalPending();
}





1;   
