/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Position {
    private final double x;
    private final double y;
    private final Dimension2D dim;

    public Position(double d, double d2, Dimension2D dimension2D) {
        this.x = d;
        this.y = d2;
        this.dim = dimension2D;
    }

    public String toString() {
        return "x=" + this.x + " y=" + this.y + " dim=" + this.dim;
    }

    public Position align(double d) {
        double d2 = d - this.dim.getHeight();
        return this.translateY(d2);
    }

    public final double getMinY() {
        return this.y;
    }

    public final double getMaxY() {
        return this.y + this.getHeight();
    }

    public UGraphic translate(UGraphic uGraphic) {
        return uGraphic.apply(new UTranslate(this.x, this.y));
    }

    public Position translateY(double d) {
        return new Position(this.x, this.y + d, this.dim);
    }

    public Position translateX(double d) {
        return new Position(this.x + d, this.y, this.dim);
    }

    public MinMax update(MinMax minMax) {
        return minMax.addPoint(this.x + this.dim.getWidth(), this.y + this.dim.getHeight());
    }

    public void drawDebug(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(null));
        uGraphic = uGraphic.apply(new UTranslate(this.x, this.y));
        uGraphic.draw(new URectangle(this.dim));
    }

    public double getHeight() {
        return this.dim.getHeight();
    }

    public double getWidth() {
        return this.dim.getWidth();
    }

    public UTranslate getTranslate() {
        return new UTranslate(this.x, this.y);
    }
}

