package Mesos::Messages;

=head1 NAME

Mesos::Messages - load Mesos protobuf message classes

=head1 DESCRIPTION

This file is automatically generated from bin/generate_messages. Creates Mesos protobuf message classes using Google::ProtocolBuffers.

=cut

# Generated by the protocol buffer compiler (protoc-perl) DO NOT EDIT!
# source: /tmp/xMdXs3sy_I



use strict;
use warnings;

use Google::ProtocolBuffers;
{
    unless (Mesos::Value::Type->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::Value::Type',
            [
               ['SCALAR', 0],
               ['RANGES', 1],
               ['SET', 2],
               ['TEXT', 3],

            ]
        );
    }
    
    unless (Mesos::TaskState->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::TaskState',
            [
               ['TASK_STAGING', 6],
               ['TASK_STARTING', 0],
               ['TASK_RUNNING', 1],
               ['TASK_KILLING', 8],
               ['TASK_FINISHED', 2],
               ['TASK_FAILED', 3],
               ['TASK_KILLED', 4],
               ['TASK_LOST', 5],
               ['TASK_ERROR', 7],

            ]
        );
    }
    
    unless (Mesos::TaskStatus::Source->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::TaskStatus::Source',
            [
               ['SOURCE_MASTER', 0],
               ['SOURCE_SLAVE', 1],
               ['SOURCE_EXECUTOR', 2],

            ]
        );
    }
    
    unless (Mesos::Offer::Operation::Type->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::Offer::Operation::Type',
            [
               ['LAUNCH', 1],
               ['RESERVE', 2],
               ['UNRESERVE', 3],
               ['CREATE', 4],
               ['DESTROY', 5],

            ]
        );
    }
    
    unless (Mesos::Status->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::Status',
            [
               ['DRIVER_NOT_STARTED', 1],
               ['DRIVER_RUNNING', 2],
               ['DRIVER_ABORTED', 3],
               ['DRIVER_STOPPED', 4],

            ]
        );
    }
    
    unless (Mesos::MachineInfo::Mode->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::MachineInfo::Mode',
            [
               ['UP', 1],
               ['DRAINING', 2],
               ['DOWN', 3],

            ]
        );
    }
    
    unless (Mesos::ContainerInfo::DockerInfo::Network->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::ContainerInfo::DockerInfo::Network',
            [
               ['HOST', 1],
               ['BRIDGE', 2],
               ['NONE', 3],

            ]
        );
    }
    
    unless (Mesos::Volume::Mode->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::Volume::Mode',
            [
               ['RW', 1],
               ['RO', 2],

            ]
        );
    }
    
    unless (Mesos::NetworkInfo::Protocol->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::NetworkInfo::Protocol',
            [
               ['IPv4', 1],
               ['IPv6', 2],

            ]
        );
    }
    
    unless (Mesos::Resource::DiskInfo::Source::Type->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::Resource::DiskInfo::Source::Type',
            [
               ['PATH', 1],
               ['MOUNT', 2],

            ]
        );
    }
    
    unless (Mesos::ContainerInfo::Type->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::ContainerInfo::Type',
            [
               ['DOCKER', 1],
               ['MESOS', 2],

            ]
        );
    }
    
    unless (Mesos::Image::Type->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::Image::Type',
            [
               ['APPC', 1],
               ['DOCKER', 2],

            ]
        );
    }
    
    unless (Mesos::DiscoveryInfo::Visibility->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::DiscoveryInfo::Visibility',
            [
               ['FRAMEWORK', 0],
               ['CLUSTER', 1],
               ['EXTERNAL', 2],

            ]
        );
    }
    
    unless (Mesos::FrameworkInfo::Capability::Type->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::FrameworkInfo::Capability::Type',
            [
               ['UNKNOWN', 0],
               ['REVOCABLE_RESOURCES', 1],
               ['TASK_KILLING_STATE', 2],

            ]
        );
    }
    
    unless (Mesos::TaskStatus::Reason->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_enum(
            'Mesos::TaskStatus::Reason',
            [
               ['REASON_COMMAND_EXECUTOR_FAILED', 0],
               ['REASON_CONTAINER_LAUNCH_FAILED', 21],
               ['REASON_CONTAINER_LIMITATION', 19],
               ['REASON_CONTAINER_LIMITATION_DISK', 20],
               ['REASON_CONTAINER_LIMITATION_MEMORY', 8],
               ['REASON_CONTAINER_PREEMPTED', 17],
               ['REASON_CONTAINER_UPDATE_FAILED', 22],
               ['REASON_EXECUTOR_REGISTRATION_TIMEOUT', 23],
               ['REASON_EXECUTOR_REREGISTRATION_TIMEOUT', 24],
               ['REASON_EXECUTOR_TERMINATED', 1],
               ['REASON_EXECUTOR_UNREGISTERED', 2],
               ['REASON_FRAMEWORK_REMOVED', 3],
               ['REASON_GC_ERROR', 4],
               ['REASON_INVALID_FRAMEWORKID', 5],
               ['REASON_INVALID_OFFERS', 6],
               ['REASON_MASTER_DISCONNECTED', 7],
               ['REASON_RECONCILIATION', 9],
               ['REASON_RESOURCES_UNKNOWN', 18],
               ['REASON_SLAVE_DISCONNECTED', 10],
               ['REASON_SLAVE_REMOVED', 11],
               ['REASON_SLAVE_RESTARTED', 12],
               ['REASON_SLAVE_UNKNOWN', 13],
               ['REASON_TASK_INVALID', 14],
               ['REASON_TASK_UNAUTHORIZED', 15],
               ['REASON_TASK_UNKNOWN', 16],

            ]
        );
    }
    
    unless (Mesos::RateLimits->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::RateLimits',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::RateLimit', 
                    'limits', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'aggregate_default_qps', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'aggregate_default_capacity', 3, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::TimeInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::TimeInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'nanoseconds', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::DurationInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::DurationInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'nanoseconds', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ResourceUsage->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ResourceUsage',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::ResourceUsage::Executor', 
                    'executors', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'total', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::CommandInfo::URI->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::CommandInfo::URI',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BOOL(), 
                    'executable', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BOOL(), 
                    'extract', 3, 1
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BOOL(), 
                    'cache', 4, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Label->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Label',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'key', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ContainerInfo::DockerInfo::PortMapping->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ContainerInfo::DockerInfo::PortMapping',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'host_port', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'container_port', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'protocol', 3, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::RateLimit->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::RateLimit',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'qps', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'principal', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'capacity', 3, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Volume->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Volume',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'container_path', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'host_path', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::Volume::Mode', 
                    'mode', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Image', 
                    'image', 4, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ExecutorInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ExecutorInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::ExecutorID', 
                    'executor_id', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BYTES(), 
                    'data', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'resources', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::CommandInfo', 
                    'command', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::FrameworkID', 
                    'framework_id', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'name', 9, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'source', 10, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::ContainerInfo', 
                    'container', 11, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::DiscoveryInfo', 
                    'discovery', 12, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::FrameworkInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::FrameworkInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'user', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'name', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::FrameworkID', 
                    'id', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'failover_timeout', 4, 0.0
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BOOL(), 
                    'checkpoint', 5, 0
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'role', 6, "*"
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'hostname', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'principal', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'webui_url', 9, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::FrameworkInfo::Capability', 
                    'capabilities', 10, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Labels', 
                    'labels', 11, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Offer::Operation::Launch->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Offer::Operation::Launch',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::TaskInfo', 
                    'task_infos', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Port->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Port',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'number', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'name', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'protocol', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::DiscoveryInfo::Visibility', 
                    'visibility', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Labels', 
                    'labels', 5, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Attribute->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Attribute',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'name', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::Value::Type', 
                    'type', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Scalar', 
                    'scalar', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Ranges', 
                    'ranges', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Text', 
                    'text', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Set', 
                    'set', 6, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::TaskID->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::TaskID',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::HealthCheck::HTTP->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::HealthCheck::HTTP',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'port', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'path', 2, "/"
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'statuses', 4, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::MachineInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::MachineInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::MachineID', 
                    'id', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::MachineInfo::Mode', 
                    'mode', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Unavailability', 
                    'unavailability', 3, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Parameter->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Parameter',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'key', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::CgroupInfo::NetCls->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::CgroupInfo::NetCls',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'classid', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Address->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Address',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'hostname', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'ip', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT32(), 
                    'port', 3, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::FrameworkInfo::Capability->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::FrameworkInfo::Capability',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::FrameworkInfo::Capability::Type', 
                    'type', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Unavailability->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Unavailability',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::TimeInfo', 
                    'start', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::DurationInfo', 
                    'duration', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::MasterInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::MasterInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'id', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'ip', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'port', 3, 5050
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'pid', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'hostname', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'version', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Address', 
                    'address', 7, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::IpStatistics->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::IpStatistics',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'Forwarding', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'DefaultTTL', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InReceives', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InHdrErrors', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InAddrErrors', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'ForwDatagrams', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InUnknownProtos', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InDiscards', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InDelivers', 9, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutRequests', 10, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutDiscards', 11, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutNoRoutes', 12, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'ReasmTimeout', 13, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'ReasmReqds', 14, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'ReasmOKs', 15, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'ReasmFails', 16, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'FragOKs', 17, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'FragFails', 18, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'FragCreates', 19, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::TrafficControlStatistics->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::TrafficControlStatistics',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'id', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'backlog', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'bytes', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'drops', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'overlimits', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'packets', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'qlen', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'ratebps', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'ratepps', 9, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'requeues', 10, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Ports->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Ports',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Port', 
                    'ports', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Offer::Operation::Unreserve->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Offer::Operation::Unreserve',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'resources', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Resource::RevocableInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Resource::RevocableInfo',
            [

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Environment->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Environment',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Environment::Variable', 
                    'variables', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Credential->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Credential',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'principal', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'secret', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::URL->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::URL',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'scheme', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::Address', 
                    'address', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'path', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Parameter', 
                    'query', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'fragment', 5, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::FrameworkID->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::FrameworkID',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Resource::DiskInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Resource::DiskInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Resource::DiskInfo::Persistence', 
                    'persistence', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Volume', 
                    'volume', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Resource::DiskInfo::Source', 
                    'source', 3, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ResourceUsage::Executor->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ResourceUsage::Executor',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::ExecutorInfo', 
                    'executor_info', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'allocated', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::ResourceStatistics', 
                    'statistics', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::ContainerID', 
                    'container_id', 4, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Value::Set->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Value::Set',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'item', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Environment::Variable->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Environment::Variable',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'name', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Offer::Operation::Reserve->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Offer::Operation::Reserve',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'resources', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Image::Appc->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Image::Appc',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'name', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'id', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Labels', 
                    'labels', 3, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Resource::DiskInfo::Source->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Resource::DiskInfo::Source',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::Resource::DiskInfo::Source::Type', 
                    'type', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Resource::DiskInfo::Source::Path', 
                    'path', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Resource::DiskInfo::Source::Mount', 
                    'mount', 3, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Resource::DiskInfo::Source::Mount->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Resource::DiskInfo::Source::Mount',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'root', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Value::Text->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Value::Text',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::UdpStatistics->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::UdpStatistics',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InDatagrams', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'NoPorts', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InErrors', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutDatagrams', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'RcvbufErrors', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'SndbufErrors', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InCsumErrors', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'IgnoredMulti', 8, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Resource->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Resource',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'name', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::Value::Type', 
                    'type', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Scalar', 
                    'scalar', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Ranges', 
                    'ranges', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Set', 
                    'set', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'role', 6, "*"
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Resource::DiskInfo', 
                    'disk', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Resource::ReservationInfo', 
                    'reservation', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Resource::RevocableInfo', 
                    'revocable', 9, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ContainerInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ContainerInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::ContainerInfo::Type', 
                    'type', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Volume', 
                    'volumes', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::ContainerInfo::DockerInfo', 
                    'docker', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'hostname', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::ContainerInfo::MesosInfo', 
                    'mesos', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::NetworkInfo', 
                    'network_infos', 7, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Value::Ranges->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Value::Ranges',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Value::Range', 
                    'range', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ExecutorID->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ExecutorID',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::TaskInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::TaskInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'name', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::TaskID', 
                    'task_id', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::SlaveID', 
                    'slave_id', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'resources', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::ExecutorInfo', 
                    'executor', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BYTES(), 
                    'data', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::CommandInfo', 
                    'command', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::HealthCheck', 
                    'health_check', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::ContainerInfo', 
                    'container', 9, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Labels', 
                    'labels', 10, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::DiscoveryInfo', 
                    'discovery', 11, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Resource::DiskInfo::Source::Path->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Resource::DiskInfo::Source::Path',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'root', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Request->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Request',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::SlaveID', 
                    'slave_id', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'resources', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::SlaveInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::SlaveInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'hostname', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'resources', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Attribute', 
                    'attributes', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::SlaveID', 
                    'id', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BOOL(), 
                    'checkpoint', 7, 0
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT32(), 
                    'port', 8, 5051
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::HealthCheck->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::HealthCheck',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::HealthCheck::HTTP', 
                    'http', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'delay_seconds', 2, 15.0
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'interval_seconds', 3, 10.0
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'timeout_seconds', 4, 20.0
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'consecutive_failures', 5, 3
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'grace_period_seconds', 6, 10.0
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::CommandInfo', 
                    'command', 7, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Value->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Value',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::Value::Type', 
                    'type', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Scalar', 
                    'scalar', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Ranges', 
                    'ranges', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Set', 
                    'set', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Value::Text', 
                    'text', 5, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::NetworkInfo::IPAddress->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::NetworkInfo::IPAddress',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::NetworkInfo::Protocol', 
                    'protocol', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'ip_address', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::CgroupInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::CgroupInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::CgroupInfo::NetCls', 
                    'net_cls', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ContainerStatus->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ContainerStatus',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::NetworkInfo', 
                    'network_infos', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::CgroupInfo', 
                    'cgroup_info', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::InverseOffer->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::InverseOffer',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::OfferID', 
                    'id', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::URL', 
                    'url', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::FrameworkID', 
                    'framework_id', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::SlaveID', 
                    'slave_id', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::Unavailability', 
                    'unavailability', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'resources', 6, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ContainerInfo::MesosInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ContainerInfo::MesosInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Image', 
                    'image', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::DiscoveryInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::DiscoveryInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::DiscoveryInfo::Visibility', 
                    'visibility', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'name', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'environment', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'location', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'version', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Ports', 
                    'ports', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Labels', 
                    'labels', 7, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Image::Docker->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Image::Docker',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'name', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Credential', 
                    'credential', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Resource::DiskInfo::Persistence->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Resource::DiskInfo::Persistence',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'id', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'principal', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ContainerInfo::DockerInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ContainerInfo::DockerInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'image', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::ContainerInfo::DockerInfo::Network', 
                    'network', 2, 1
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::ContainerInfo::DockerInfo::PortMapping', 
                    'port_mappings', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BOOL(), 
                    'privileged', 4, 0
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Parameter', 
                    'parameters', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BOOL(), 
                    'force_pull_image', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'volume_driver', 7, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::TcpStatistics->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::TcpStatistics',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'RtoAlgorithm', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'RtoMin', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'RtoMax', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'MaxConn', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'ActiveOpens', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'PassiveOpens', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'AttemptFails', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'EstabResets', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'CurrEstab', 9, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InSegs', 10, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutSegs', 11, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'RetransSegs', 12, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InErrs', 13, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutRsts', 14, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InCsumErrors', 15, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Resource::ReservationInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Resource::ReservationInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'principal', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Labels', 
                    'labels', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::CommandInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::CommandInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::CommandInfo::URI', 
                    'uris', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Environment', 
                    'environment', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'user', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BOOL(), 
                    'shell', 6, 1
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'arguments', 7, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::MachineID->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::MachineID',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'hostname', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'ip', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Value::Range->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Value::Range',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'begin', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'end', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ResourceStatistics->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ResourceStatistics',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'timestamp', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'cpus_user_time_secs', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'cpus_system_time_secs', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'cpus_limit', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_rss_bytes', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_limit_bytes', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'cpus_nr_periods', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'cpus_nr_throttled', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'cpus_throttled_time_secs', 9, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_file_bytes', 10, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_anon_bytes', 11, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_mapped_file_bytes', 12, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::PerfStatistics', 
                    'perf', 13, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'net_rx_packets', 14, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'net_rx_bytes', 15, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'net_rx_errors', 16, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'net_rx_dropped', 17, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'net_tx_packets', 18, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'net_tx_bytes', 19, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'net_tx_errors', 20, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'net_tx_dropped', 21, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'net_tcp_rtt_microsecs_p50', 22, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'net_tcp_rtt_microsecs_p90', 23, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'net_tcp_rtt_microsecs_p95', 24, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'net_tcp_rtt_microsecs_p99', 25, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'disk_limit_bytes', 26, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'disk_used_bytes', 27, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'net_tcp_active_connections', 28, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'net_tcp_time_wait_connections', 29, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'processes', 30, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT32(), 
                    'threads', 31, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_low_pressure_counter', 32, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_medium_pressure_counter', 33, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_critical_pressure_counter', 34, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::TrafficControlStatistics', 
                    'net_traffic_control_statistics', 35, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_total_bytes', 36, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_total_memsw_bytes', 37, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_soft_limit_bytes', 38, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_cache_bytes', 39, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_swap_bytes', 40, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'mem_unevictable_bytes', 41, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::SNMPStatistics', 
                    'net_snmp_statistics', 42, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::TaskStatus->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::TaskStatus',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::TaskID', 
                    'task_id', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::TaskState', 
                    'state', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BYTES(), 
                    'data', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'message', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::SlaveID', 
                    'slave_id', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'timestamp', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::ExecutorID', 
                    'executor_id', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BOOL(), 
                    'healthy', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::TaskStatus::Source', 
                    'source', 9, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::TaskStatus::Reason', 
                    'reason', 10, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_BYTES(), 
                    'uuid', 11, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Labels', 
                    'labels', 12, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::ContainerStatus', 
                    'container_status', 13, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::SNMPStatistics->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::SNMPStatistics',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::IpStatistics', 
                    'ip_stats', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::IcmpStatistics', 
                    'icmp_stats', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::TcpStatistics', 
                    'tcp_stats', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::UdpStatistics', 
                    'udp_stats', 4, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Offer::Operation->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Offer::Operation',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::Offer::Operation::Type', 
                    'type', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Offer::Operation::Launch', 
                    'launch', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Offer::Operation::Reserve', 
                    'reserve', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Offer::Operation::Unreserve', 
                    'unreserve', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Offer::Operation::Create', 
                    'create', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Offer::Operation::Destroy', 
                    'destroy', 6, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Image->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Image',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::Image::Type', 
                    'type', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Image::Appc', 
                    'appc', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Image::Docker', 
                    'docker', 3, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::NetworkInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::NetworkInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::NetworkInfo::Protocol', 
                    'protocol', 1, ""
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'ip_address', 2, ""
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'groups', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Labels', 
                    'labels', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::NetworkInfo::IPAddress', 
                    'ip_addresses', 5, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::IcmpStatistics->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::IcmpStatistics',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InMsgs', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InErrors', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InCsumErrors', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InDestUnreachs', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InTimeExcds', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InParmProbs', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InSrcQuenchs', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InRedirects', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InEchos', 9, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InEchoReps', 10, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InTimestamps', 11, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InTimestampReps', 12, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InAddrMasks', 13, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'InAddrMaskReps', 14, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutMsgs', 15, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutErrors', 16, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutDestUnreachs', 17, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutTimeExcds', 18, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutParmProbs', 19, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutSrcQuenchs', 20, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutRedirects', 21, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutEchos', 22, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutEchoReps', 23, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutTimestamps', 24, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutTimestampReps', 25, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutAddrMasks', 26, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_INT64(), 
                    'OutAddrMaskReps', 27, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::OfferID->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::OfferID',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Offer->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Offer',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::OfferID', 
                    'id', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::FrameworkID', 
                    'framework_id', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    'Mesos::SlaveID', 
                    'slave_id', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'hostname', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'resources', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::ExecutorID', 
                    'executor_ids', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Attribute', 
                    'attributes', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::URL', 
                    'url', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    'Mesos::Unavailability', 
                    'unavailability', 9, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Offer::Operation::Create->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Offer::Operation::Create',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'volumes', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Credentials->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Credentials',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Credential', 
                    'credentials', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Parameters->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Parameters',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Parameter', 
                    'parameter', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Filters->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Filters',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'refuse_seconds', 1, 5.0
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::ContainerID->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::ContainerID',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::SlaveID->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::SlaveID',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'value', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Value::Scalar->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Value::Scalar',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'value', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Offer::Operation::Destroy->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Offer::Operation::Destroy',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Resource', 
                    'volumes', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::WeightInfo->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::WeightInfo',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'weight', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_STRING(), 
                    'role', 2, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::PerfStatistics->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::PerfStatistics',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'timestamp', 1, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_REQUIRED(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'duration', 2, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'cycles', 3, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'stalled_cycles_frontend', 4, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'stalled_cycles_backend', 5, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'instructions', 6, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'cache_references', 7, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'cache_misses', 8, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'branches', 9, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'branch_misses', 10, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'bus_cycles', 11, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'ref_cycles', 12, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'cpu_clock', 13, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_DOUBLE(), 
                    'task_clock', 14, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'page_faults', 15, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'minor_faults', 16, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'major_faults', 17, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'context_switches', 18, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'cpu_migrations', 19, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'alignment_faults', 20, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'emulation_faults', 21, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'l1_dcache_loads', 22, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'l1_dcache_load_misses', 23, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'l1_dcache_stores', 24, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'l1_dcache_store_misses', 25, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'l1_dcache_prefetches', 26, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'l1_dcache_prefetch_misses', 27, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'l1_icache_loads', 28, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'l1_icache_load_misses', 29, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'l1_icache_prefetches', 30, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'l1_icache_prefetch_misses', 31, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'llc_loads', 32, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'llc_load_misses', 33, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'llc_stores', 34, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'llc_store_misses', 35, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'llc_prefetches', 36, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'llc_prefetch_misses', 37, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'dtlb_loads', 38, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'dtlb_load_misses', 39, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'dtlb_stores', 40, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'dtlb_store_misses', 41, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'dtlb_prefetches', 42, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'dtlb_prefetch_misses', 43, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'itlb_loads', 44, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'itlb_load_misses', 45, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'branch_loads', 46, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'branch_load_misses', 47, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'node_loads', 48, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'node_load_misses', 49, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'node_stores', 50, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'node_store_misses', 51, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'node_prefetches', 52, undef
                ],
                [
                    Google::ProtocolBuffers::Constants::LABEL_OPTIONAL(), 
                    Google::ProtocolBuffers::Constants::TYPE_UINT64(), 
                    'node_prefetch_misses', 53, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

    unless (Mesos::Labels->can('_pb_fields_list')) {
        Google::ProtocolBuffers->create_message(
            'Mesos::Labels',
            [
                [
                    Google::ProtocolBuffers::Constants::LABEL_REPEATED(), 
                    'Mesos::Label', 
                    'labels', 1, undef
                ],

            ],
            { 'create_accessors' => 1,  }
        );
    }

}
1;
