# Generated by default/object.tt
package Paws::Kendra::SalesforceChatterFeedConfiguration;
  use Moose;
  has DocumentDataFieldName => (is => 'ro', isa => 'Str', required => 1);
  has DocumentTitleFieldName => (is => 'ro', isa => 'Str');
  has FieldMappings => (is => 'ro', isa => 'ArrayRef[Paws::Kendra::DataSourceToIndexFieldMapping]');
  has IncludeFilterTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::SalesforceChatterFeedConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::SalesforceChatterFeedConfiguration object:

  $service_obj->Method(Att1 => { DocumentDataFieldName => $value, ..., IncludeFilterTypes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::SalesforceChatterFeedConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DocumentDataFieldName

=head1 DESCRIPTION

Defines configuration for syncing a Salesforce chatter feed. The
contents of the object comes from the Salesforce FeedItem table.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DocumentDataFieldName => Str

The name of the column in the Salesforce FeedItem table that contains
the content to index. Typically this is the C<Body> column.


=head2 DocumentTitleFieldName => Str

The name of the column in the Salesforce FeedItem table that contains
the title of the document. This is typically the C<Title> column.


=head2 FieldMappings => ArrayRef[L<Paws::Kendra::DataSourceToIndexFieldMapping>]

Maps fields from a Salesforce chatter feed into Amazon Kendra index
fields.


=head2 IncludeFilterTypes => ArrayRef[Str|Undef]

Filters the documents in the feed based on status of the user. When you
specify C<ACTIVE_USERS> only documents from users who have an active
account are indexed. When you specify C<STANDARD_USER> only documents
for Salesforce standard users are documented. You can specify both.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

