# Generated by default/object.tt
package Paws::GameLift::TargetTrackingConfiguration;
  use Moose;
  has TargetValue => (is => 'ro', isa => 'Num', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::TargetTrackingConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::TargetTrackingConfiguration object:

  $service_obj->Method(Att1 => { TargetValue => $value, ..., TargetValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::TargetTrackingConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->TargetValue

=head1 DESCRIPTION

B<This data type is used with the GameLift FleetIQ and game server
groups.>

Settings for a target-based scaling policy as part of a
GameServerGroupAutoScalingPolicy. These settings are used to create a
target-based policy that tracks the GameLift FleetIQ metric
C<"PercentUtilizedGameServers"> and specifies a target value for the
metric. As player usage changes, the policy triggers to adjust the game
server group capacity so that the metric returns to the target value.

=head1 ATTRIBUTES


=head2 B<REQUIRED> TargetValue => Num

Desired value to use with a game server group target-based scaling
policy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

