package Net::CalDAVTalk::TimeZones;

=head1 NAME

Net::CalDAVTalk::TimeZone - autogenerated timezone data for Net::CalDAVTalk

=head1 SYNOPSIS

    *** WARNING: DO NOT EDIT ***

    This file is generated by utils/GenerateTimeZoneModule.pl

   ./utils/GenerateTimeZoneModule.pl htdocs/ajaxui/build/fastmail/timezones-raw.js > modules/Net/CalDAVTalk/TimeZones.pm

   Generated: Thu Aug 13 02:55:03 2015

=cut

use strict;
use warnings;

use Data::ICal::Entry::TimeZone;
use Data::ICal::Entry::TimeZone::Daylight;
use Data::ICal::Entry::TimeZone::Standard;
use Data::ICal::TimeZone;
use DateTime::Format::ISO8601;
use DateTime::TimeZone;
use Text::LevenshteinXS qw{distance};

our $RulesByZone = {
  'America/Bogota' => {
                        'StandardTzOffset' => '-0500'
                      },
  'America/Whitehorse' => {
                            'StandardTzOffset' => '-0800',
                            'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                            'DaylightTzOffset' => '-0700',
                            'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                          },
  'Africa/Kinshasa' => {
                         'StandardTzOffset' => '+0100'
                       },
  'Antarctica/Palmer' => {
                           'StandardTzOffset' => '-0400',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=4SU',
                           'DaylightTzOffset' => '-0300',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=1SU'
                         },
  'America/Mazatlan' => {
                          'StandardTzOffset' => '-0700',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                          'DaylightTzOffset' => '-0600',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU'
                        },
  'America/Indiana/Vincennes' => {
                                   'StandardTzOffset' => '-0500',
                                   'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                   'DaylightTzOffset' => '-0400',
                                   'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                                 },
  'Africa/Conakry' => {
                        'StandardTzOffset' => '+0000'
                      },
  'Asia/Manila' => {
                     'StandardTzOffset' => '+0800'
                   },
  'America/Nassau' => {
                        'StandardTzOffset' => '-0500',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                        'DaylightTzOffset' => '-0400',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                      },
  'Europe/Belgrade' => {
                         'StandardTzOffset' => '+0100',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0200',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'Asia/Dhaka' => {
                    'StandardTzOffset' => '+0600'
                  },
  'Etc/GMT+2' => {
                   'StandardTzOffset' => '+0200'
                 },
  'America/Los_Angeles' => {
                             'StandardTzOffset' => '-0800',
                             'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                             'DaylightTzOffset' => '-0700',
                             'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                           },
  'Asia/Aqtau' => {
                    'StandardTzOffset' => '+0500'
                  },
  'Asia/Dushanbe' => {
                       'StandardTzOffset' => '+0500'
                     },
  'Africa/Bujumbura' => {
                          'StandardTzOffset' => '+0200'
                        },
  'Asia/Baghdad' => {
                      'StandardTzOffset' => '+0300',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYMONTHDAY=1',
                      'DaylightTzOffset' => '+0400',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYMONTHDAY=1'
                    },
  'Asia/Beirut' => {
                     'StandardTzOffset' => '+0200',
                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                     'DaylightTzOffset' => '+0300',
                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                   },
  'America/Juneau' => {
                        'StandardTzOffset' => '-0900',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                        'DaylightTzOffset' => '-0800',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                      },
  'Etc/GMT+10' => {
                    'StandardTzOffset' => '+1000'
                  },
  'America/Inuvik' => {
                        'StandardTzOffset' => '-0700',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                        'DaylightTzOffset' => '-0600',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                      },
  'Asia/Pyongyang' => {
                        'StandardTzOffset' => '+0900'
                      },
  'Africa/Nairobi' => {
                        'StandardTzOffset' => '+0300'
                      },
  'Pacific/Norfolk' => {
                         'StandardTzOffset' => '+1130'
                       },
  'America/St_Johns' => {
                          'StandardTzOffset' => '-0330',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                          'DaylightTzOffset' => '-0230',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                        },
  'Pacific/Guam' => {
                      'StandardTzOffset' => '+1000'
                    },
  'Australia/Currie' => {
                          'StandardTzOffset' => '+1000',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                          'DaylightTzOffset' => '+1100',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=1SU'
                        },
  'America/Hermosillo' => {
                            'StandardTzOffset' => '-0700'
                          },
  'Asia/Muscat' => {
                     'StandardTzOffset' => '+0400'
                   },
  'America/Indiana/Knox' => {
                              'StandardTzOffset' => '-0600',
                              'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                              'DaylightTzOffset' => '-0500',
                              'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                            },
  'Asia/Bahrain' => {
                      'StandardTzOffset' => '+0300'
                    },
  'Asia/Samarkand' => {
                        'StandardTzOffset' => '+0500'
                      },
  'Africa/Addis_Ababa' => {
                            'StandardTzOffset' => '+0300'
                          },
  'America/Halifax' => {
                         'StandardTzOffset' => '-0400',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                         'DaylightTzOffset' => '-0300',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                       },
  'Asia/Ulaanbaatar' => {
                          'StandardTzOffset' => '+0800',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=-1SA',
                          'DaylightTzOffset' => '+0900',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SA'
                        },
  'Asia/Jerusalem' => {
                        'StandardTzOffset' => '+0200',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                        'DaylightTzOffset' => '+0300',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=8FR'
                      },
  'America/Indiana/Vevay' => {
                               'StandardTzOffset' => '-0500',
                               'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                               'DaylightTzOffset' => '-0400',
                               'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                             },
  'America/Cayman' => {
                        'StandardTzOffset' => '-0500'
                      },
  'America/Guyana' => {
                        'StandardTzOffset' => '-0400'
                      },
  'Europe/Chisinau' => {
                         'StandardTzOffset' => '+0200',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0300',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'Etc/GMT+14' => {
                    'StandardTzOffset' => '+1400'
                  },
  'Asia/Kuwait' => {
                     'StandardTzOffset' => '+0300'
                   },
  'Atlantic/Reykjavik' => {
                            'StandardTzOffset' => '+0000'
                          },
  'Europe/Bucharest' => {
                          'StandardTzOffset' => '+0200',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                          'DaylightTzOffset' => '+0300',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                        },
  'Asia/Krasnoyarsk' => {
                          'StandardTzOffset' => '+0800'
                        },
  'Pacific/Wake' => {
                      'StandardTzOffset' => '+1200'
                    },
  'Africa/Blantyre' => {
                         'StandardTzOffset' => '+0200'
                       },
  'Pacific/Tahiti' => {
                        'StandardTzOffset' => '-1000'
                      },
  'America/Dawson_Creek' => {
                              'StandardTzOffset' => '-0700'
                            },
  'America/North_Dakota/New_Salem' => {
                                        'StandardTzOffset' => '-0600',
                                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                        'DaylightTzOffset' => '-0500',
                                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                                      },
  'Europe/Istanbul' => {
                         'StandardTzOffset' => '+0200',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0300',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'Pacific/Fiji' => {
                      'StandardTzOffset' => '+1200',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=1;BYDAY=3SU',
                      'DaylightTzOffset' => '+1300',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=4SU'
                    },
  'America/Atikokan' => {
                          'StandardTzOffset' => '-0500'
                        },
  'Pacific/Marquesas' => {
                           'StandardTzOffset' => '-0930'
                         },
  'America/Bahia' => {
                       'StandardTzOffset' => '-0300'
                     },
  'America/Matamoros' => {
                           'StandardTzOffset' => '-0600',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                           'DaylightTzOffset' => '-0500',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                         },
  'Australia/Broken_Hill' => {
                               'StandardTzOffset' => '+0930',
                               'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                               'DaylightTzOffset' => '+1030',
                               'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=1SU'
                             },
  'America/Antigua' => {
                         'StandardTzOffset' => '-0400'
                       },
  'America/New_York' => {
                          'StandardTzOffset' => '-0500',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                          'DaylightTzOffset' => '-0400',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                        },
  'Pacific/Pohnpei' => {
                         'StandardTzOffset' => '+1100'
                       },
  'America/El_Salvador' => {
                             'StandardTzOffset' => '-0600',
                             'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=-1SU',
                             'DaylightTzOffset' => '-0500',
                             'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=5;BYDAY=1SU'
                           },
  'America/Blanc-Sablon' => {
                              'StandardTzOffset' => '-0400'
                            },
  'Africa/Harare' => {
                       'StandardTzOffset' => '+0200'
                     },
  'Asia/Shanghai' => {
                       'StandardTzOffset' => '+0800',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=3SU',
                       'DaylightTzOffset' => '+0900',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=3SU'
                     },
  'Indian/Comoro' => {
                       'StandardTzOffset' => '+0300'
                     },
  'Africa/Porto-Novo' => {
                           'StandardTzOffset' => '+0100'
                         },
  'Pacific/Nauru' => {
                       'StandardTzOffset' => '+1200'
                     },
  'Europe/Warsaw' => {
                       'StandardTzOffset' => '+0100',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0200',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'Etc/GMT+6' => {
                   'StandardTzOffset' => '+0600'
                 },
  'Europe/Brussels' => {
                         'StandardTzOffset' => '+0100',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0200',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'America/Havana' => {
                        'StandardTzOffset' => '-0500',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                        'DaylightTzOffset' => '-0400',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                      },
  'Antarctica/Casey' => {
                          'StandardTzOffset' => '+0800'
                        },
  'America/Barbados' => {
                          'StandardTzOffset' => '-0400',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=1SU',
                          'DaylightTzOffset' => '-0300',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=3SU'
                        },
  'Pacific/Kwajalein' => {
                           'StandardTzOffset' => '+1200'
                         },
  'Africa/Ouagadougou' => {
                            'StandardTzOffset' => '+0000'
                          },
  'Africa/Abidjan' => {
                        'StandardTzOffset' => '+0000'
                      },
  'Asia/Hebron' => {
                     'StandardTzOffset' => '+0200',
                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=4FR',
                     'DaylightTzOffset' => '+0300',
                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1TH'
                   },
  'Etc/GMT-11' => {
                    'StandardTzOffset' => '-1100'
                  },
  'America/Rainy_River' => {
                             'StandardTzOffset' => '-0600',
                             'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                             'DaylightTzOffset' => '-0500',
                             'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                           },
  'Asia/Makassar' => {
                       'StandardTzOffset' => '+0800'
                     },
  'Asia/Vladivostok' => {
                          'StandardTzOffset' => '+1100'
                        },
  'America/Santarem' => {
                          'StandardTzOffset' => '-0300'
                        },
  'Asia/Pontianak' => {
                        'StandardTzOffset' => '+0700'
                      },
  'Etc/GMT+11' => {
                    'StandardTzOffset' => '+1100'
                  },
  'Africa/Lusaka' => {
                       'StandardTzOffset' => '+0200'
                     },
  'Africa/Luanda' => {
                       'StandardTzOffset' => '+0100'
                     },
  'America/Argentina/Mendoza' => {
                                   'StandardTzOffset' => '-0300'
                                 },
  'Europe/Kaliningrad' => {
                            'StandardTzOffset' => '+0300'
                          },
  'Europe/Madrid' => {
                       'StandardTzOffset' => '+0100',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0200',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'Africa/Mogadishu' => {
                          'StandardTzOffset' => '+0300'
                        },
  'America/Yellowknife' => {
                             'StandardTzOffset' => '-0700',
                             'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                             'DaylightTzOffset' => '-0600',
                             'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                           },
  'Atlantic/Stanley' => {
                          'StandardTzOffset' => '-0300'
                        },
  'Pacific/Majuro' => {
                        'StandardTzOffset' => '+1200'
                      },
  'America/Jamaica' => {
                         'StandardTzOffset' => '-0500'
                       },
  'Asia/Kashgar' => {
                      'StandardTzOffset' => '+0800',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=3SU',
                      'DaylightTzOffset' => '+0900',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=3SU'
                    },
  'America/Argentina/Cordoba' => {
                                   'StandardTzOffset' => '-0300',
                                   'StandardRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=3SU',
                                   'DaylightTzOffset' => '-0200',
                                   'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=3SU'
                                 },
  'Indian/Antananarivo' => {
                             'StandardTzOffset' => '+0300'
                           },
  'Asia/Anadyr' => {
                     'StandardTzOffset' => '+1200'
                   },
  'Indian/Mauritius' => {
                          'StandardTzOffset' => '+0400'
                        },
  'Asia/Irkutsk' => {
                      'StandardTzOffset' => '+0900'
                    },
  'America/Cuiaba' => {
                        'StandardTzOffset' => '-0400',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=2;BYDAY=3SU',
                        'DaylightTzOffset' => '-0300',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=3SU'
                      },
  'Asia/Sakhalin' => {
                       'StandardTzOffset' => '+1100'
                     },
  'Africa/Sao_Tome' => {
                         'StandardTzOffset' => '+0000'
                       },
  'Pacific/Niue' => {
                      'StandardTzOffset' => '-1100'
                    },
  'America/Manaus' => {
                        'StandardTzOffset' => '-0400'
                      },
  'Etc/GMT+3' => {
                   'StandardTzOffset' => '+0300'
                 },
  'Africa/Monrovia' => {
                         'StandardTzOffset' => '+0000'
                       },
  'America/Tijuana' => {
                         'StandardTzOffset' => '-0800',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                         'DaylightTzOffset' => '-0700',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                       },
  'Asia/Ho_Chi_Minh' => {
                          'StandardTzOffset' => '+0700'
                        },
  'Etc/GMT-3' => {
                   'StandardTzOffset' => '-0300'
                 },
  'Africa/Algiers' => {
                        'StandardTzOffset' => '+0100'
                      },
  'Europe/Riga' => {
                     'StandardTzOffset' => '+0200',
                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                     'DaylightTzOffset' => '+0300',
                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                   },
  'Europe/Vilnius' => {
                        'StandardTzOffset' => '+0200',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                        'DaylightTzOffset' => '+0300',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                      },
  'Asia/Colombo' => {
                      'StandardTzOffset' => '+0530'
                    },
  'Antarctica/DumontDUrville' => {
                                   'StandardTzOffset' => '+1000'
                                 },
  'America/Boise' => {
                       'StandardTzOffset' => '-0700',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                       'DaylightTzOffset' => '-0600',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                     },
  'Pacific/Pago_Pago' => {
                           'StandardTzOffset' => '-1100'
                         },
  'Africa/Kampala' => {
                        'StandardTzOffset' => '+0300'
                      },
  'Indian/Christmas' => {
                          'StandardTzOffset' => '+0700'
                        },
  'Asia/Dubai' => {
                    'StandardTzOffset' => '+0400'
                  },
  'America/Dawson' => {
                        'StandardTzOffset' => '-0800',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                        'DaylightTzOffset' => '-0700',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                      },
  'Pacific/Kiritimati' => {
                            'StandardTzOffset' => '+1400'
                          },
  'America/Bahia_Banderas' => {
                                'StandardTzOffset' => '-0600',
                                'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                                'DaylightTzOffset' => '-0500',
                                'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU'
                              },
  'America/Yakutat' => {
                         'StandardTzOffset' => '-0900',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                         'DaylightTzOffset' => '-0800',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                       },
  'Asia/Kabul' => {
                    'StandardTzOffset' => '+0430'
                  },
  'America/Danmarkshavn' => {
                              'StandardTzOffset' => '+0000'
                            },
  'Etc/GMT-12' => {
                    'StandardTzOffset' => '-1200'
                  },
  'Europe/Uzhgorod' => {
                         'StandardTzOffset' => '+0200',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0300',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'America/Glace_Bay' => {
                           'StandardTzOffset' => '-0400',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                           'DaylightTzOffset' => '-0300',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                         },
  'Africa/Bissau' => {
                       'StandardTzOffset' => '+0000'
                     },
  'America/Kentucky/Louisville' => {
                                     'StandardTzOffset' => '-0500',
                                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                     'DaylightTzOffset' => '-0400',
                                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                                   },
  'Etc/GMT+5' => {
                   'StandardTzOffset' => '+0500'
                 },
  'Africa/Dar_es_Salaam' => {
                              'StandardTzOffset' => '+0300'
                            },
  'Africa/El_Aaiun' => {
                         'StandardTzOffset' => '+0000',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0100',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'Etc/GMT+7' => {
                   'StandardTzOffset' => '+0700'
                 },
  'Asia/Amman' => {
                    'StandardTzOffset' => '+0300'
                  },
  'America/La_Paz' => {
                        'StandardTzOffset' => '-0400'
                      },
  'America/Costa_Rica' => {
                            'StandardTzOffset' => '-0600',
                            'StandardRRule' => 'FREQ=YEARLY;BYMONTH=6;BYDAY=1SU',
                            'DaylightTzOffset' => '-0500',
                            'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=1;BYDAY=3SA'
                          },
  'Pacific/Tongatapu' => {
                           'StandardTzOffset' => '+1300',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=1;BYDAY=-1SU',
                           'DaylightTzOffset' => '+1400',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU'
                         },
  'Etc/UCT' => {
                 'StandardTzOffset' => '+0000'
               },
  'America/Nipigon' => {
                         'StandardTzOffset' => '-0500',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                         'DaylightTzOffset' => '-0400',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                       },
  'Africa/Tunis' => {
                      'StandardTzOffset' => '+0100',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                      'DaylightTzOffset' => '+0200',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                    },
  'Asia/Tbilisi' => {
                      'StandardTzOffset' => '+0400'
                    },
  'Europe/Simferopol' => {
                           'StandardTzOffset' => '+0200',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                           'DaylightTzOffset' => '+0300',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                         },
  'Pacific/Guadalcanal' => {
                             'StandardTzOffset' => '+1100'
                           },
  'America/Regina' => {
                        'StandardTzOffset' => '-0600'
                      },
  'Pacific/Enderbury' => {
                           'StandardTzOffset' => '+1300'
                         },
  'Indian/Cocos' => {
                      'StandardTzOffset' => '+0630'
                    },
  'Australia/Perth' => {
                         'StandardTzOffset' => '+0800',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0900',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU'
                       },
  'America/Creston' => {
                         'StandardTzOffset' => '-0700'
                       },
  'Etc/GMT-1' => {
                   'StandardTzOffset' => '-0100'
                 },
  'Asia/Kolkata' => {
                      'StandardTzOffset' => '+0530'
                    },
  'America/Argentina/Rio_Gallegos' => {
                                        'StandardTzOffset' => '-0300'
                                      },
  'America/Porto_Velho' => {
                             'StandardTzOffset' => '-0400'
                           },
  'Asia/Phnom_Penh' => {
                         'StandardTzOffset' => '+0700'
                       },
  'Asia/Magadan' => {
                      'StandardTzOffset' => '+1200'
                    },
  'Atlantic/Canary' => {
                         'StandardTzOffset' => '+0000',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0100',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'America/Kentucky/Monticello' => {
                                     'StandardTzOffset' => '-0500',
                                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                     'DaylightTzOffset' => '-0400',
                                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                                   },
  'Pacific/Chuuk' => {
                       'StandardTzOffset' => '+1000'
                     },
  'America/Swift_Current' => {
                               'StandardTzOffset' => '-0600'
                             },
  'Europe/Minsk' => {
                      'StandardTzOffset' => '+0300'
                    },
  'Pacific/Palau' => {
                       'StandardTzOffset' => '+0900'
                     },
  'Europe/Helsinki' => {
                         'StandardTzOffset' => '+0200',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0300',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'Australia/Melbourne' => {
                             'StandardTzOffset' => '+1000',
                             'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                             'DaylightTzOffset' => '+1100',
                             'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=1SU'
                           },
  'Etc/GMT+1' => {
                   'StandardTzOffset' => '+0100'
                 },
  'America/Monterrey' => {
                           'StandardTzOffset' => '-0600',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                           'DaylightTzOffset' => '-0500',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU'
                         },
  'America/Menominee' => {
                           'StandardTzOffset' => '-0600',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                           'DaylightTzOffset' => '-0500',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                         },
  'America/Cayenne' => {
                         'StandardTzOffset' => '-0300'
                       },
  'Etc/GMT-2' => {
                   'StandardTzOffset' => '-0200'
                 },
  'America/Miquelon' => {
                          'StandardTzOffset' => '-0300',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                          'DaylightTzOffset' => '-0200',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                        },
  'America/Iqaluit' => {
                         'StandardTzOffset' => '-0500',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                         'DaylightTzOffset' => '-0400',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                       },
  'Etc/GMT-6' => {
                   'StandardTzOffset' => '-0600'
                 },
  'Etc/GMT' => {
                 'StandardTzOffset' => '+0000'
               },
  'Asia/Novosibirsk' => {
                          'StandardTzOffset' => '+0700'
                        },
  'Australia/Adelaide' => {
                            'StandardTzOffset' => '+0930',
                            'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                            'DaylightTzOffset' => '+1030',
                            'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=1SU'
                          },
  'Europe/Amsterdam' => {
                          'StandardTzOffset' => '+0100',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                          'DaylightTzOffset' => '+0200',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                        },
  'Europe/Moscow' => {
                       'StandardTzOffset' => '+0400'
                     },
  'Pacific/Rarotonga' => {
                           'StandardTzOffset' => -1000,
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=1SU',
                           'DaylightTzOffset' => '-0930',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU'
                         },
  'Europe/Malta' => {
                      'StandardTzOffset' => '+0100',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                      'DaylightTzOffset' => '+0200',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                    },
  'Africa/Banjul' => {
                       'StandardTzOffset' => '+0000'
                     },
  'Africa/Tripoli' => {
                        'StandardTzOffset' => '+0200'
                      },
  'Indian/Kerguelen' => {
                          'StandardTzOffset' => '+0500'
                        },
  'Asia/Urumqi' => {
                     'StandardTzOffset' => '+0800',
                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=3SU',
                     'DaylightTzOffset' => '+0900',
                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=3SU'
                   },
  'Africa/Libreville' => {
                           'StandardTzOffset' => '+0100'
                         },
  'Africa/Khartoum' => {
                         'StandardTzOffset' => '+0300'
                       },
  'America/Recife' => {
                        'StandardTzOffset' => '-0300'
                      },
  'America/Argentina/La_Rioja' => {
                                    'StandardTzOffset' => '-0300'
                                  },
  'Europe/Paris' => {
                      'StandardTzOffset' => '+0100',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                      'DaylightTzOffset' => '+0200',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                    },
  'Indian/Mayotte' => {
                        'StandardTzOffset' => '+0300'
                      },
  'America/Argentina/Salta' => {
                                 'StandardTzOffset' => '-0300'
                               },
  'Pacific/Funafuti' => {
                          'StandardTzOffset' => '+1200'
                        },
  'Europe/Berlin' => {
                       'StandardTzOffset' => '+0100',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0200',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'Etc/GMT-9' => {
                   'StandardTzOffset' => '-0900'
                 },
  'Asia/Choibalsan' => {
                         'StandardTzOffset' => '+0800',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=-1SA',
                         'DaylightTzOffset' => '+0900',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SA'
                       },
  'America/Montevideo' => {
                            'StandardTzOffset' => '-0300',
                            'StandardRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU',
                            'DaylightTzOffset' => '-0200',
                            'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=1SU'
                          },
  'America/Belize' => {
                        'StandardTzOffset' => '-0600'
                      },
  'Africa/Djibouti' => {
                         'StandardTzOffset' => '+0300'
                       },
  'America/Argentina/San_Juan' => {
                                    'StandardTzOffset' => '-0300'
                                  },
  'America/Thunder_Bay' => {
                             'StandardTzOffset' => '-0500',
                             'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                             'DaylightTzOffset' => '-0400',
                             'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                           },
  'Asia/Hovd' => {
                   'StandardTzOffset' => '+0700',
                   'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=-1SA',
                   'DaylightTzOffset' => '+0800',
                   'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SA'
                 },
  'Asia/Novokuznetsk' => {
                           'StandardTzOffset' => '+0700'
                         },
  'Indian/Maldives' => {
                         'StandardTzOffset' => '+0500'
                       },
  'America/Toronto' => {
                         'StandardTzOffset' => '-0500',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                         'DaylightTzOffset' => '-0400',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                       },
  'Australia/Eucla' => {
                         'StandardTzOffset' => '+0845',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0945',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU'
                       },
  'Pacific/Galapagos' => {
                           'StandardTzOffset' => '-0600'
                         },
  'Asia/Tehran' => {
                     'StandardTzOffset' => '+0330',
                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYMONTHDAY=21',
                     'DaylightTzOffset' => '+0430',
                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYMONTHDAY=21'
                   },
  'Africa/Malabo' => {
                       'StandardTzOffset' => '+0100'
                     },
  'America/Martinique' => {
                            'StandardTzOffset' => '-0400'
                          },
  'Asia/Aden' => {
                   'StandardTzOffset' => '+0300'
                 },
  'America/Chihuahua' => {
                           'StandardTzOffset' => '-0700',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                           'DaylightTzOffset' => '-0600',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU'
                         },
  'Australia/Sydney' => {
                          'StandardTzOffset' => '+1000',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                          'DaylightTzOffset' => '+1100',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=1SU'
                        },
  'America/Moncton' => {
                         'StandardTzOffset' => '-0400',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                         'DaylightTzOffset' => '-0300',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                       },
  'America/Goose_Bay' => {
                           'StandardTzOffset' => '-0400',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                           'DaylightTzOffset' => '-0300',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                         },
  'America/Detroit' => {
                         'StandardTzOffset' => '-0500',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                         'DaylightTzOffset' => '-0400',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                       },
  'Australia/Lindeman' => {
                            'StandardTzOffset' => '+1000',
                            'StandardRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=1SU',
                            'DaylightTzOffset' => '+1100',
                            'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU'
                          },
  'Africa/Mbabane' => {
                        'StandardTzOffset' => '+0200'
                      },
  'Etc/GMT+4' => {
                   'StandardTzOffset' => '+0400'
                 },
  'Africa/Lubumbashi' => {
                           'StandardTzOffset' => '+0200'
                         },
  'America/Asuncion' => {
                          'StandardTzOffset' => '-0400',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=8SU',
                          'DaylightTzOffset' => '-0300',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=1SU'
                        },
  'Antarctica/Vostok' => {
                           'StandardTzOffset' => '+0600'
                         },
  'America/Indiana/Petersburg' => {
                                    'StandardTzOffset' => '-0500',
                                    'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                    'DaylightTzOffset' => '-0400',
                                    'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                                  },
  'Africa/Lome' => {
                     'StandardTzOffset' => '+0000'
                   },
  'Asia/Harbin' => {
                     'StandardTzOffset' => '+0800',
                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=3SU',
                     'DaylightTzOffset' => '+0900',
                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=3SU'
                   },
  'America/Montreal' => {
                          'StandardTzOffset' => '-0500',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                          'DaylightTzOffset' => '-0400',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                        },
  'Asia/Tashkent' => {
                       'StandardTzOffset' => '+0500'
                     },
  'Atlantic/St_Helena' => {
                            'StandardTzOffset' => '+0000'
                          },
  'Africa/Brazzaville' => {
                            'StandardTzOffset' => '+0100'
                          },
  'Pacific/Saipan' => {
                        'StandardTzOffset' => '+1000'
                      },
  'Asia/Ust-Nera' => {
                       'StandardTzOffset' => '+1100'
                     },
  'Antarctica/Macquarie' => {
                              'StandardTzOffset' => '+1100'
                            },
  'America/Edmonton' => {
                          'StandardTzOffset' => '-0700',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                          'DaylightTzOffset' => '-0600',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                        },
  'Asia/Yerevan' => {
                      'StandardTzOffset' => '+0400'
                    },
  'Africa/Dakar' => {
                      'StandardTzOffset' => '+0000'
                    },
  'Europe/London' => {
                       'StandardTzOffset' => '+0000',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0100',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'America/Indiana/Indianapolis' => {
                                      'StandardTzOffset' => '-0500',
                                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                      'DaylightTzOffset' => '-0400',
                                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                                    },
  'Asia/Aqtobe' => {
                     'StandardTzOffset' => '+0500'
                   },
  'Africa/Bamako' => {
                       'StandardTzOffset' => '+0000'
                     },
  'Australia/Lord_Howe' => {
                             'StandardTzOffset' => '+1030',
                             'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                             'DaylightTzOffset' => '+1100',
                             'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=1SU'
                           },
  'Europe/Budapest' => {
                         'StandardTzOffset' => '+0100',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0200',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'Europe/Rome' => {
                     'StandardTzOffset' => '+0100',
                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                     'DaylightTzOffset' => '+0200',
                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                   },
  'Etc/GMT+8' => {
                   'StandardTzOffset' => '+0800'
                 },
  'Pacific/Fakaofo' => {
                         'StandardTzOffset' => '+1300'
                       },
  'Africa/Maseru' => {
                       'StandardTzOffset' => '+0200'
                     },
  'Europe/Oslo' => {
                     'StandardTzOffset' => '+0100',
                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                     'DaylightTzOffset' => '+0200',
                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                   },
  'Africa/Asmara' => {
                       'StandardTzOffset' => '+0300'
                     },
  'Africa/Douala' => {
                       'StandardTzOffset' => '+0100'
                     },
  'America/Merida' => {
                        'StandardTzOffset' => '-0600',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                        'DaylightTzOffset' => '-0500',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU'
                      },
  'Asia/Brunei' => {
                     'StandardTzOffset' => '+0800'
                   },
  'Asia/Rangoon' => {
                      'StandardTzOffset' => '+0630'
                    },
  'America/Thule' => {
                       'StandardTzOffset' => '-0400',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                       'DaylightTzOffset' => '-0300',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                     },
  'Asia/Macau' => {
                    'StandardTzOffset' => '+0800',
                    'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=3SU',
                    'DaylightTzOffset' => '+0900',
                    'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=3SU'
                  },
  'Asia/Oral' => {
                   'StandardTzOffset' => '+0500'
                 },
  'America/Cancun' => {
                        'StandardTzOffset' => '-0600',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                        'DaylightTzOffset' => '-0500',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU'
                      },
  'Asia/Singapore' => {
                        'StandardTzOffset' => '+0800'
                      },
  'Asia/Chongqing' => {
                        'StandardTzOffset' => '+0800',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=3SU',
                        'DaylightTzOffset' => '+0900',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=3SU'
                      },
  'Etc/GMT-4' => {
                   'StandardTzOffset' => '-0400'
                 },
  'America/Maceio' => {
                        'StandardTzOffset' => '-0300'
                      },
  'America/North_Dakota/Center' => {
                                     'StandardTzOffset' => '-0600',
                                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                     'DaylightTzOffset' => '-0500',
                                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                                   },
  'Pacific/Easter' => {
                        'StandardTzOffset' => '-0600',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=4SU',
                        'DaylightTzOffset' => '-0500',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=1SU'
                      },
  'Africa/Johannesburg' => {
                             'StandardTzOffset' => '+0200'
                           },
  'Europe/Prague' => {
                       'StandardTzOffset' => '+0100',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0200',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'America/Resolute' => {
                          'StandardTzOffset' => '-0600',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                          'DaylightTzOffset' => '-0500',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                        },
  'America/Indiana/Winamac' => {
                                 'StandardTzOffset' => '-0500',
                                 'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                 'DaylightTzOffset' => '-0400',
                                 'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                               },
  'Pacific/Noumea' => {
                        'StandardTzOffset' => '+1100',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=2;BYMONTHDAY=27',
                        'DaylightTzOffset' => '+1200',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=12;BYDAY=1SU'
                      },
  'Asia/Bishkek' => {
                      'StandardTzOffset' => '+0600'
                    },
  'Pacific/Chatham' => {
                         'StandardTzOffset' => '+1245',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                         'DaylightTzOffset' => '+1345',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=-1SU'
                       },
  'America/Eirunepe' => {
                          'StandardTzOffset' => '-0500'
                        },
  'America/Rankin_Inlet' => {
                              'StandardTzOffset' => '-0600',
                              'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                              'DaylightTzOffset' => '-0500',
                              'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                            },
  'America/Cambridge_Bay' => {
                               'StandardTzOffset' => '-0700',
                               'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                               'DaylightTzOffset' => '-0600',
                               'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                             },
  'Atlantic/South_Georgia' => {
                                'StandardTzOffset' => '-0200'
                              },
  'Pacific/Tarawa' => {
                        'StandardTzOffset' => '+1200'
                      },
  'Etc/GMT+12' => {
                    'StandardTzOffset' => '+1200'
                  },
  'Asia/Yakutsk' => {
                      'StandardTzOffset' => '+1000'
                    },
  'Pacific/Efate' => {
                       'StandardTzOffset' => '+1100',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=1;BYDAY=4SU',
                       'DaylightTzOffset' => '+1200',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=4SU'
                     },
  'Pacific/Pitcairn' => {
                          'StandardTzOffset' => '-0800'
                        },
  'America/Araguaina' => {
                           'StandardTzOffset' => '-0300'
                         },
  'Atlantic/Cape_Verde' => {
                             'StandardTzOffset' => '-0100'
                           },
  'Africa/Gaborone' => {
                         'StandardTzOffset' => '+0200'
                       },
  'Etc/GMT-5' => {
                   'StandardTzOffset' => '-0500'
                 },
  'America/Argentina/Jujuy' => {
                                 'StandardTzOffset' => '-0300'
                               },
  'Africa/Cairo' => {
                      'StandardTzOffset' => '+0200',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=-1TH',
                      'DaylightTzOffset' => '+0300',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=-1FR'
                    },
  'America/Winnipeg' => {
                          'StandardTzOffset' => '-0600',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                          'DaylightTzOffset' => '-0500',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                        },
  'Africa/Windhoek' => {
                         'StandardTzOffset' => '+0100',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                         'DaylightTzOffset' => '+0200',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=1SU'
                       },
  'Etc/GMT-8' => {
                   'StandardTzOffset' => '-0800'
                 },
  'Africa/Casablanca' => {
                           'StandardTzOffset' => '+0000',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                           'DaylightTzOffset' => '+0100',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                         },
  'Africa/Kigali' => {
                       'StandardTzOffset' => '+0200'
                     },
  'Asia/Vientiane' => {
                        'StandardTzOffset' => '+0700'
                      },
  'Africa/Bangui' => {
                       'StandardTzOffset' => '+0100'
                     },
  'Asia/Ashgabat' => {
                       'StandardTzOffset' => '+0500'
                     },
  'Africa/Nouakchott' => {
                           'StandardTzOffset' => '+0000'
                         },
  'America/Argentina/Tucuman' => {
                                   'StandardTzOffset' => '-0300',
                                   'StandardRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=3SU',
                                   'DaylightTzOffset' => '-0200',
                                   'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=3SU'
                                 },
  'Europe/Gibraltar' => {
                          'StandardTzOffset' => '+0100',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                          'DaylightTzOffset' => '+0200',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                        },
  'Etc/GMT+9' => {
                   'StandardTzOffset' => '+0900'
                 },
  'America/Pangnirtung' => {
                             'StandardTzOffset' => '-0500',
                             'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                             'DaylightTzOffset' => '-0400',
                             'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                           },
  'America/Sao_Paulo' => {
                           'StandardTzOffset' => '-0300',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=2;BYDAY=3SU',
                           'DaylightTzOffset' => '-0200',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=3SU'
                         },
  'Asia/Nicosia' => {
                      'StandardTzOffset' => '+0200',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                      'DaylightTzOffset' => '+0300',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                    },
  'Pacific/Midway' => {
                        'StandardTzOffset' => '-1100'
                      },
  'Europe/Andorra' => {
                        'StandardTzOffset' => '+0100',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                        'DaylightTzOffset' => '+0200',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                      },
  'Asia/Riyadh' => {
                     'StandardTzOffset' => '+0300'
                   },
  'Europe/Athens' => {
                       'StandardTzOffset' => '+0200',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0300',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'Europe/Volgograd' => {
                          'StandardTzOffset' => '+0400'
                        },
  'Asia/Qyzylorda' => {
                        'StandardTzOffset' => '+0600'
                      },
  'Asia/Khandyga' => {
                       'StandardTzOffset' => '+1000'
                     },
  'Asia/Gaza' => {
                   'StandardTzOffset' => '+0200',
                   'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=4FR',
                   'DaylightTzOffset' => '+0300',
                   'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1TH'
                 },
  'Asia/Omsk' => {
                   'StandardTzOffset' => '+0700'
                 },
  'Asia/Tokyo' => {
                    'StandardTzOffset' => '+0900'
                  },
  'America/Sitka' => {
                       'StandardTzOffset' => '-0900',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                       'DaylightTzOffset' => '-0800',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                     },
  'Asia/Jayapura' => {
                       'StandardTzOffset' => '+0900'
                     },
  'Asia/Thimphu' => {
                      'StandardTzOffset' => '+0600'
                    },
  'Antarctica/Syowa' => {
                          'StandardTzOffset' => '+0300'
                        },
  'America/Port-au-Prince' => {
                                'StandardTzOffset' => '-0500',
                                'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                'DaylightTzOffset' => '-0400',
                                'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                              },
  'Asia/Damascus' => {
                       'StandardTzOffset' => '+0200',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1FR',
                       'DaylightTzOffset' => '+0300',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1FR'
                     },
  'America/Indiana/Marengo' => {
                                 'StandardTzOffset' => '-0500',
                                 'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                 'DaylightTzOffset' => '-0400',
                                 'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                               },
  'Asia/Qatar' => {
                    'StandardTzOffset' => '+0300'
                  },
  'Europe/Sofia' => {
                      'StandardTzOffset' => '+0200',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                      'DaylightTzOffset' => '+0300',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                    },
  'America/Fortaleza' => {
                           'StandardTzOffset' => '-0300'
                         },
  'America/Mexico_City' => {
                             'StandardTzOffset' => '-0600',
                             'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                             'DaylightTzOffset' => '-0500',
                             'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU'
                           },
  'Atlantic/Azores' => {
                         'StandardTzOffset' => '-0100',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '+0000',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'America/Belem' => {
                       'StandardTzOffset' => '-0300'
                     },
  'Asia/Hong_Kong' => {
                        'StandardTzOffset' => '+0800',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=4SU',
                        'DaylightTzOffset' => '+0900',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=3SU'
                      },
  'America/Nome' => {
                      'StandardTzOffset' => '-0900',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                      'DaylightTzOffset' => '-0800',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                    },
  'America/Godthab' => {
                         'StandardTzOffset' => '-0300',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                         'DaylightTzOffset' => '-0200',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                       },
  'Antarctica/Davis' => {
                          'StandardTzOffset' => '+0700'
                        },
  'America/Scoresbysund' => {
                              'StandardTzOffset' => '-0100',
                              'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                              'DaylightTzOffset' => '+0000',
                              'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                            },
  'Australia/Brisbane' => {
                            'StandardTzOffset' => '+1000',
                            'StandardRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=1SU',
                            'DaylightTzOffset' => '+1100',
                            'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU'
                          },
  'Asia/Baku' => {
                   'StandardTzOffset' => '+0400',
                   'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                   'DaylightTzOffset' => '+0500',
                   'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                 },
  'Asia/Kuala_Lumpur' => {
                           'StandardTzOffset' => '+0800'
                         },
  'Africa/Lagos' => {
                      'StandardTzOffset' => '+0100'
                    },
  'Indian/Chagos' => {
                       'StandardTzOffset' => '+0600'
                     },
  'America/Vancouver' => {
                           'StandardTzOffset' => '-0800',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                           'DaylightTzOffset' => '-0700',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                         },
  'Asia/Yekaterinburg' => {
                            'StandardTzOffset' => '+0600'
                          },
  'Pacific/Port_Moresby' => {
                              'StandardTzOffset' => '+1000'
                            },
  'America/Phoenix' => {
                         'StandardTzOffset' => '-0700'
                       },
  'Etc/GMT-7' => {
                   'StandardTzOffset' => '-0700'
                 },
  'Europe/Copenhagen' => {
                           'StandardTzOffset' => '+0100',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                           'DaylightTzOffset' => '+0200',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                         },
  'Asia/Almaty' => {
                     'StandardTzOffset' => '+0600'
                   },
  'Etc/UTC' => {
                 'StandardTzOffset' => '+0000'
               },
  'Asia/Kathmandu' => {
                        'StandardTzOffset' => '+0545'
                      },
  'Asia/Dili' => {
                   'StandardTzOffset' => '+0900'
                 },
  'America/Adak' => {
                      'StandardTzOffset' => -1000,
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                      'DaylightTzOffset' => '-0900',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                    },
  'America/Argentina/Catamarca' => {
                                     'StandardTzOffset' => '-0300'
                                   },
  'America/Caracas' => {
                         'StandardTzOffset' => '-0430'
                       },
  'Etc/GMT-10' => {
                    'StandardTzOffset' => '-1000'
                  },
  'America/Curacao' => {
                         'StandardTzOffset' => '-0400'
                       },
  'America/Tegucigalpa' => {
                             'StandardTzOffset' => '-0600',
                             'StandardRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=-1SU',
                             'DaylightTzOffset' => '-0500',
                             'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=5;BYDAY=1SU'
                           },
  'Pacific/Honolulu' => {
                          'StandardTzOffset' => '-1000'
                        },
  'Pacific/Wallis' => {
                        'StandardTzOffset' => '+1200'
                      },
  'Africa/Niamey' => {
                       'StandardTzOffset' => '+0100'
                     },
  'America/Ojinaga' => {
                         'StandardTzOffset' => '-0700',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                         'DaylightTzOffset' => '-0600',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                       },
  'Europe/Tirane' => {
                       'StandardTzOffset' => '+0100',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0200',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'America/Rio_Branco' => {
                            'StandardTzOffset' => '-0500'
                          },
  'America/Guatemala' => {
                           'StandardTzOffset' => '-0600'
                         },
  'Africa/Ceuta' => {
                      'StandardTzOffset' => '+0100',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                      'DaylightTzOffset' => '+0200',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                    },
  'America/Argentina/San_Luis' => {
                                    'StandardTzOffset' => '-0300'
                                  },
  'Africa/Maputo' => {
                       'StandardTzOffset' => '+0200'
                     },
  'America/Santa_Isabel' => {
                              'StandardTzOffset' => '-0800',
                              'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                              'DaylightTzOffset' => '-0700',
                              'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU'
                            },
  'America/Managua' => {
                         'StandardTzOffset' => '-0600',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=6;BYDAY=4MO',
                         'DaylightTzOffset' => '-0500',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=3SU'
                       },
  'America/Noronha' => {
                         'StandardTzOffset' => '-0200'
                       },
  'America/Santiago' => {
                          'StandardTzOffset' => '-0400',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=4SU',
                          'DaylightTzOffset' => '-0300',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=1SU'
                        },
  'Europe/Lisbon' => {
                       'StandardTzOffset' => '+0000',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0100',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'Asia/Kamchatka' => {
                        'StandardTzOffset' => '+1200'
                      },
  'America/Campo_Grande' => {
                              'StandardTzOffset' => '-0400',
                              'StandardRRule' => 'FREQ=YEARLY;BYMONTH=2;BYDAY=3SU',
                              'DaylightTzOffset' => '-0300',
                              'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=3SU'
                            },
  'America/Lima' => {
                      'StandardTzOffset' => '-0500',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYMONTHDAY=1',
                      'DaylightTzOffset' => '-0400',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=1;BYMONTHDAY=1'
                    },
  'Asia/Bangkok' => {
                      'StandardTzOffset' => '+0700'
                    },
  'Australia/Darwin' => {
                          'StandardTzOffset' => '+0930'
                        },
  'America/Metlakatla' => {
                            'StandardTzOffset' => '-0800'
                          },
  'Asia/Seoul' => {
                    'StandardTzOffset' => '+0900',
                    'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=2SU',
                    'DaylightTzOffset' => '+1000',
                    'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=5;BYDAY=2SU'
                  },
  'Europe/Luxembourg' => {
                           'StandardTzOffset' => '+0100',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                           'DaylightTzOffset' => '+0200',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                         },
  'Atlantic/Faroe' => {
                        'StandardTzOffset' => '+0000',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                        'DaylightTzOffset' => '+0100',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                      },
  'America/Boa_Vista' => {
                           'StandardTzOffset' => '-0400'
                         },
  'Pacific/Apia' => {
                      'StandardTzOffset' => '+1300',
                      'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                      'DaylightTzOffset' => '+1400',
                      'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=-1SU'
                    },
  'Antarctica/Mawson' => {
                           'StandardTzOffset' => '+0500'
                         },
  'Europe/Monaco' => {
                       'StandardTzOffset' => '+0100',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0200',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'Etc/GMT+13' => {
                    'StandardTzOffset' => '+1300'
                  },
  'America/Argentina/Buenos_Aires' => {
                                        'StandardTzOffset' => '-0300',
                                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=3SU',
                                        'DaylightTzOffset' => '-0200',
                                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=3SU'
                                      },
  'Europe/Kiev' => {
                     'StandardTzOffset' => '+0200',
                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                     'DaylightTzOffset' => '+0300',
                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                   },
  'America/Santo_Domingo' => {
                               'StandardTzOffset' => '-0400'
                             },
  'Asia/Jakarta' => {
                      'StandardTzOffset' => '+0700'
                    },
  'Africa/Ndjamena' => {
                         'StandardTzOffset' => '+0100'
                       },
  'America/Guayaquil' => {
                           'StandardTzOffset' => '-0500'
                         },
  'America/Chicago' => {
                         'StandardTzOffset' => '-0600',
                         'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                         'DaylightTzOffset' => '-0500',
                         'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                       },
  'Europe/Samara' => {
                       'StandardTzOffset' => '+0400'
                     },
  'America/Indiana/Tell_City' => {
                                   'StandardTzOffset' => '-0600',
                                   'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                   'DaylightTzOffset' => '-0500',
                                   'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                                 },
  'Europe/Zaporozhye' => {
                           'StandardTzOffset' => '+0200',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                           'DaylightTzOffset' => '+0300',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                         },
  'America/Denver' => {
                        'StandardTzOffset' => '-0700',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                        'DaylightTzOffset' => '-0600',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                      },
  'Pacific/Auckland' => {
                          'StandardTzOffset' => '+1200',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                          'DaylightTzOffset' => '+1300',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=9;BYDAY=-1SU'
                        },
  'Europe/Vienna' => {
                       'StandardTzOffset' => '+0100',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0200',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'America/Grand_Turk' => {
                            'StandardTzOffset' => '-0500',
                            'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                            'DaylightTzOffset' => '-0400',
                            'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                          },
  'America/Argentina/Ushuaia' => {
                                   'StandardTzOffset' => '-0300'
                                 },
  'Asia/Kuching' => {
                      'StandardTzOffset' => '+0800'
                    },
  'Asia/Karachi' => {
                      'StandardTzOffset' => '+0500'
                    },
  'Africa/Accra' => {
                      'StandardTzOffset' => '+0000'
                    },
  'America/Port_of_Spain' => {
                               'StandardTzOffset' => '-0400'
                             },
  'America/Anchorage' => {
                           'StandardTzOffset' => '-0900',
                           'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                           'DaylightTzOffset' => '-0800',
                           'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                         },
  'America/North_Dakota/Beulah' => {
                                     'StandardTzOffset' => '-0600',
                                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                                     'DaylightTzOffset' => '-0500',
                                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                                   },
  'America/Paramaribo' => {
                            'StandardTzOffset' => '-0300'
                          },
  'Asia/Taipei' => {
                     'StandardTzOffset' => '+0800',
                     'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYMONTHDAY=1',
                     'DaylightTzOffset' => '+0900',
                     'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=4;BYMONTHDAY=1'
                   },
  'Antarctica/Rothera' => {
                            'StandardTzOffset' => '-0300'
                          },
  'Europe/Dublin' => {
                       'StandardTzOffset' => '+0000',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0100',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'Africa/Freetown' => {
                         'StandardTzOffset' => '+0000'
                       },
  'Atlantic/Bermuda' => {
                          'StandardTzOffset' => '-0400',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=11;BYDAY=1SU',
                          'DaylightTzOffset' => '-0300',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=2SU'
                        },
  'Pacific/Kosrae' => {
                        'StandardTzOffset' => '+1100'
                      },
  'Europe/Tallinn' => {
                        'StandardTzOffset' => '+0200',
                        'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                        'DaylightTzOffset' => '+0300',
                        'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                      },
  'Pacific/Gambier' => {
                         'StandardTzOffset' => '-0900'
                       },
  'Australia/Hobart' => {
                          'StandardTzOffset' => '+1000',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=4;BYDAY=1SU',
                          'DaylightTzOffset' => '+1100',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=1SU'
                        },
  'America/Panama' => {
                        'StandardTzOffset' => '-0500'
                      },
  'Indian/Reunion' => {
                        'StandardTzOffset' => '+0400'
                      },
  'Europe/Zurich' => {
                       'StandardTzOffset' => '+0100',
                       'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                       'DaylightTzOffset' => '+0200',
                       'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                     },
  'Atlantic/Madeira' => {
                          'StandardTzOffset' => '+0000',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                          'DaylightTzOffset' => '+0100',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                        },
  'America/Puerto_Rico' => {
                             'StandardTzOffset' => '-0400'
                           },
  'Europe/Stockholm' => {
                          'StandardTzOffset' => '+0100',
                          'StandardRRule' => 'FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                          'DaylightTzOffset' => '+0200',
                          'DaylightRRule' => 'FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU'
                        },
  'Indian/Mahe' => {
                     'StandardTzOffset' => '+0400'
                   }
}
;
our $ZonesByOffset = {
  '-0600' => {
               'N' => [
                        [
                          '0',
                          [
                            'America/Managua',
                            'America/Monterrey',
                            'America/Chihuahua',
                            'America/Merida',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Ojinaga',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '73472400',
                          [
                            'America/Managua',
                            'America/Monterrey',
                            'America/Chihuahua',
                            'America/Merida',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Ojinaga',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '105084000',
                          [
                            'America/Monterrey',
                            'America/Chihuahua',
                            'America/Merida',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Ojinaga',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '126687600',
                          [
                            'America/Monterrey',
                            'America/Chihuahua',
                            'America/Merida',
                            'America/Kentucky/Louisville',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Ojinaga',
                            'America/Swift_Current',
                            'America/Indiana/Marengo',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '152092800',
                          [
                            'America/Monterrey',
                            'America/Chihuahua',
                            'America/Merida',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Ojinaga',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '377935200',
                          [
                            'America/Monterrey',
                            'America/Chihuahua',
                            'America/Matamoros',
                            'America/Ojinaga',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '504939600',
                          [
                            'America/Monterrey',
                            'America/Chihuahua',
                            'America/Matamoros',
                            'Pacific/Galapagos',
                            'America/Ojinaga',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '568015200',
                          [
                            'America/Chihuahua',
                            'Pacific/Galapagos',
                            'America/Ojinaga',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '717310800',
                          [
                            'America/Managua',
                            'America/Chihuahua',
                            'Pacific/Galapagos',
                            'America/Ojinaga',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '725868000',
                          [
                            'America/Chihuahua',
                            'Pacific/Galapagos',
                            'America/Ojinaga',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '820476000',
                          [
                            'Pacific/Galapagos',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '883634400',
                          [
                            'America/Chihuahua',
                            'Pacific/Galapagos',
                            'America/Ojinaga',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '891766800',
                          [
                            'Pacific/Galapagos',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '973400400',
                          [
                            'Pacific/Galapagos',
                            'America/Swift_Current',
                            'America/Cambridge_Bay',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '986115600',
                          [
                            'Pacific/Galapagos',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '1001836800',
                          [
                            'Pacific/Galapagos',
                            'America/Swift_Current',
                            'America/Mexico_City',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ],
                        [
                          '1014184800',
                          [
                            'Pacific/Galapagos',
                            'America/Swift_Current',
                            'America/Regina',
                            'Etc/GMT-6'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Tegucigalpa',
                            'America/Winnipeg',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Kentucky/Monticello',
                            'America/Indiana/Knox',
                            'America/Indiana/Petersburg',
                            'America/Rankin_Inlet',
                            'America/Resolute',
                            'America/Rainy_River'
                          ]
                        ],
                        [
                          '104914800',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Tegucigalpa',
                            'America/Winnipeg',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Indiana/Knox',
                            'America/Indiana/Petersburg',
                            'America/Rankin_Inlet',
                            'America/Resolute',
                            'America/Rainy_River'
                          ]
                        ],
                        [
                          '161758800',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Tegucigalpa',
                            'America/Winnipeg',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Indiana/Knox',
                            'America/Indiana/Petersburg',
                            'America/Rankin_Inlet',
                            'America/Resolute',
                            'America/Rainy_River'
                          ]
                        ],
                        [
                          '247046400',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Tegucigalpa',
                            'America/Winnipeg',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Indiana/Knox',
                            'America/Rankin_Inlet',
                            'America/Resolute',
                            'America/Rainy_River'
                          ]
                        ],
                        [
                          '384926400',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Tegucigalpa',
                            'America/Winnipeg',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Indiana/Knox',
                            'America/Rankin_Inlet',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '407653200',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Indiana/Knox',
                            'America/Rankin_Inlet',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '568015200',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Indiana/Knox',
                            'America/Rankin_Inlet',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '688550400',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Rankin_Inlet',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '694260000',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Rankin_Inlet',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '720003600',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '820476000',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Chihuahua',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Ojinaga',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '852094800',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Chihuahua',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Ojinaga',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '883634400',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '902041200',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '941353200',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Iqaluit',
                            'America/Rankin_Inlet',
                            'America/Pangnirtung',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '941360400',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Kentucky/Monticello',
                            'America/Iqaluit',
                            'America/Rankin_Inlet',
                            'America/Cambridge_Bay',
                            'America/Pangnirtung',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '972806400',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/North_Dakota/Center',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '986112000',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '1001836800',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Menominee',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '1014184800',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '1067158800',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '1143961200',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Indiana/Vincennes',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Indiana/Tell_City',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '1162108800',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Indiana/Vincennes',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Indiana/Tell_City',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '1173600000',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Indiana/Vincennes',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Indiana/Tell_City',
                            'America/Indiana/Knox',
                            'America/Indiana/Petersburg',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '1194163200',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Indiana/Tell_City',
                            'America/Indiana/Knox',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '1270371600',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Bahia_Banderas',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Indiana/Tell_City',
                            'America/Indiana/Knox',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '1289120400',
                          [
                            'America/Guatemala',
                            'America/El_Salvador',
                            'America/Costa_Rica',
                            'America/Chicago',
                            'America/Managua',
                            'America/Monterrey',
                            'America/Tegucigalpa',
                            'America/Merida',
                            'America/Winnipeg',
                            'America/Cancun',
                            'America/Matamoros',
                            'America/Belize',
                            'America/Bahia_Banderas',
                            'America/Mexico_City',
                            'America/Menominee',
                            'America/Indiana/Tell_City',
                            'America/Indiana/Knox',
                            'America/North_Dakota/Beulah',
                            'America/Rankin_Inlet',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'America/Resolute',
                            'America/Rainy_River',
                            'Pacific/Easter'
                          ]
                        ]
                      ]
             },
  '+0730' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Singapore',
                            'Asia/Kuala_Lumpur'
                          ]
                        ]
                      ]
             },
  '-0830' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Pitcairn'
                          ]
                        ]
                      ]
             },
  '+1200' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Tarawa',
                            'Pacific/Wake',
                            'Pacific/Majuro',
                            'Pacific/Wallis',
                            'Pacific/Kosrae',
                            'Pacific/Funafuti',
                            'Etc/GMT+12'
                          ]
                        ],
                        [
                          '294323400',
                          [
                            'Pacific/Tarawa',
                            'Pacific/Wake',
                            'Pacific/Majuro',
                            'Pacific/Wallis',
                            'Pacific/Nauru',
                            'Pacific/Kosrae',
                            'Pacific/Funafuti',
                            'Etc/GMT+12'
                          ]
                        ],
                        [
                          '745848000',
                          [
                            'Pacific/Tarawa',
                            'Pacific/Wake',
                            'Pacific/Majuro',
                            'Pacific/Kwajalein',
                            'Pacific/Wallis',
                            'Pacific/Nauru',
                            'Pacific/Kosrae',
                            'Pacific/Funafuti',
                            'Etc/GMT+12'
                          ]
                        ],
                        [
                          '915105600',
                          [
                            'Pacific/Tarawa',
                            'Pacific/Wake',
                            'Pacific/Majuro',
                            'Pacific/Kwajalein',
                            'Pacific/Wallis',
                            'Pacific/Nauru',
                            'Pacific/Funafuti',
                            'Etc/GMT+12'
                          ]
                        ],
                        [
                          '1301151600',
                          [
                            'Asia/Kamchatka',
                            'Asia/Magadan',
                            'Asia/Ust-Nera',
                            'Pacific/Tarawa',
                            'Pacific/Wake',
                            'Pacific/Majuro',
                            'Pacific/Kwajalein',
                            'Asia/Anadyr',
                            'Pacific/Wallis',
                            'Pacific/Nauru',
                            'Pacific/Funafuti',
                            'Etc/GMT+12'
                          ]
                        ],
                        [
                          '1315828800',
                          [
                            'Asia/Kamchatka',
                            'Asia/Magadan',
                            'Pacific/Tarawa',
                            'Pacific/Wake',
                            'Pacific/Majuro',
                            'Pacific/Kwajalein',
                            'Asia/Anadyr',
                            'Pacific/Wallis',
                            'Pacific/Nauru',
                            'Pacific/Funafuti',
                            'Etc/GMT+12'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Pacific/Fiji',
                            'Pacific/Auckland',
                            'Asia/Kamchatka'
                          ]
                        ],
                        [
                          '386420400',
                          [
                            'Pacific/Fiji',
                            'Pacific/Auckland',
                            'Asia/Kamchatka',
                            'Asia/Anadyr'
                          ]
                        ],
                        [
                          '670341600',
                          [
                            'Pacific/Fiji',
                            'Pacific/Auckland'
                          ]
                        ],
                        [
                          '695746800',
                          [
                            'Pacific/Fiji',
                            'Pacific/Auckland',
                            'Asia/Kamchatka',
                            'Asia/Anadyr'
                          ]
                        ],
                        [
                          '1269698400',
                          [
                            'Pacific/Fiji',
                            'Pacific/Auckland'
                          ]
                        ]
                      ]
             },
  '-0700' => {
               'N' => [
                        [
                          '0',
                          [
                            'America/Phoenix',
                            'America/Swift_Current',
                            'America/Creston',
                            'Etc/GMT-7'
                          ]
                        ],
                        [
                          '73472400',
                          [
                            'America/Phoenix',
                            'America/Creston',
                            'Etc/GMT-7'
                          ]
                        ],
                        [
                          '84016800',
                          [
                            'America/Phoenix',
                            'America/Dawson_Creek',
                            'America/Creston',
                            'Etc/GMT-7'
                          ]
                        ],
                        [
                          '126255600',
                          [
                            'America/Phoenix',
                            'America/Boise',
                            'America/Dawson_Creek',
                            'America/Creston',
                            'Etc/GMT-7'
                          ]
                        ],
                        [
                          '129114000',
                          [
                            'America/Phoenix',
                            'America/Dawson_Creek',
                            'America/Creston',
                            'Etc/GMT-7'
                          ]
                        ],
                        [
                          '915174000',
                          [
                            'America/Phoenix',
                            'America/Hermosillo',
                            'America/Dawson_Creek',
                            'America/Creston',
                            'Etc/GMT-7'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/Denver',
                            'America/Boise',
                            'America/Yellowknife',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '28800',
                          [
                            'America/Hermosillo',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Bahia_Banderas',
                            'America/Yellowknife',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '126255600',
                          [
                            'America/Hermosillo',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Bahia_Banderas',
                            'America/Yellowknife',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '129114000',
                          [
                            'America/Hermosillo',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Bahia_Banderas',
                            'America/Yellowknife',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '294228000',
                          [
                            'America/Hermosillo',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Bahia_Banderas',
                            'America/Yellowknife',
                            'America/Inuvik',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center',
                            'Pacific/Easter'
                          ]
                        ],
                        [
                          '384926400',
                          [
                            'America/Hermosillo',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Bahia_Banderas',
                            'America/Yellowknife',
                            'America/Inuvik',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem',
                            'America/North_Dakota/Center'
                          ]
                        ],
                        [
                          '720003600',
                          [
                            'America/Hermosillo',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Bahia_Banderas',
                            'America/Yellowknife',
                            'America/Inuvik',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem'
                          ]
                        ],
                        [
                          '891766800',
                          [
                            'America/Chihuahua',
                            'America/Hermosillo',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Bahia_Banderas',
                            'America/Ojinaga',
                            'America/Yellowknife',
                            'America/Inuvik',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem'
                          ]
                        ],
                        [
                          '915174000',
                          [
                            'America/Chihuahua',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Bahia_Banderas',
                            'America/Ojinaga',
                            'America/Yellowknife',
                            'America/Inuvik',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem'
                          ]
                        ],
                        [
                          '941360400',
                          [
                            'America/Chihuahua',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Bahia_Banderas',
                            'America/Ojinaga',
                            'America/Yellowknife',
                            'America/Inuvik',
                            'America/North_Dakota/Beulah',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem'
                          ]
                        ],
                        [
                          '986115600',
                          [
                            'America/Chihuahua',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Bahia_Banderas',
                            'America/Ojinaga',
                            'America/Yellowknife',
                            'America/Inuvik',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton',
                            'America/North_Dakota/New_Salem'
                          ]
                        ],
                        [
                          '1067158800',
                          [
                            'America/Chihuahua',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Bahia_Banderas',
                            'America/Ojinaga',
                            'America/Yellowknife',
                            'America/Inuvik',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton'
                          ]
                        ],
                        [
                          '1270371600',
                          [
                            'America/Chihuahua',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Ojinaga',
                            'America/Yellowknife',
                            'America/Inuvik',
                            'America/North_Dakota/Beulah',
                            'America/Cambridge_Bay',
                            'America/Edmonton'
                          ]
                        ],
                        [
                          '1289120400',
                          [
                            'America/Chihuahua',
                            'America/Denver',
                            'America/Mazatlan',
                            'America/Boise',
                            'America/Ojinaga',
                            'America/Yellowknife',
                            'America/Inuvik',
                            'America/Cambridge_Bay',
                            'America/Edmonton'
                          ]
                        ]
                      ]
             },
  '-0044' => {
               'N' => [
                        [
                          '0',
                          [
                            'Africa/Monrovia'
                          ]
                        ]
                      ]
             },
  '+1245' => {
               'Y' => [
                        [
                          '0',
                          [
                            'Pacific/Chatham'
                          ]
                        ]
                      ]
             },
  '+0930' => {
               'N' => [
                        [
                          '0',
                          [
                            'Australia/Adelaide',
                            'Australia/Darwin',
                            'Australia/Broken_Hill'
                          ]
                        ],
                        [
                          '31501800',
                          [
                            'Australia/Darwin'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '31501800',
                          [
                            'Australia/Adelaide',
                            'Australia/Broken_Hill'
                          ]
                        ]
                      ]
             },
  '-0330' => {
               'N' => [
                        [
                          '0',
                          [
                            'America/Paramaribo'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/St_Johns'
                          ]
                        ]
                      ]
             },
  '-0100' => {
               'N' => [
                        [
                          '0',
                          [
                            'Africa/El_Aaiun',
                            'Africa/Bissau',
                            'Etc/GMT-1'
                          ]
                        ],
                        [
                          '157770000',
                          [
                            'Africa/El_Aaiun',
                            'Etc/GMT-1'
                          ]
                        ],
                        [
                          '186120000',
                          [
                            'Atlantic/Cape_Verde',
                            'Africa/El_Aaiun',
                            'Etc/GMT-1'
                          ]
                        ],
                        [
                          '198291600',
                          [
                            'Atlantic/Cape_Verde',
                            'Etc/GMT-1'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Atlantic/Azores'
                          ]
                        ],
                        [
                          '354679200',
                          [
                            'Atlantic/Azores',
                            'America/Scoresbysund'
                          ]
                        ],
                        [
                          '717559200',
                          [
                            'America/Scoresbysund'
                          ]
                        ],
                        [
                          '733280400',
                          [
                            'Atlantic/Azores',
                            'America/Scoresbysund'
                          ]
                        ]
                      ]
             },
  '-1200' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Kwajalein',
                            'Etc/GMT-12',
                            'Pacific/Enderbury'
                          ]
                        ],
                        [
                          '307627200',
                          [
                            'Pacific/Kwajalein',
                            'Etc/GMT-12'
                          ]
                        ],
                        [
                          '745848000',
                          [
                            'Etc/GMT-12'
                          ]
                        ]
                      ]
             },
  '+0300' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Baghdad',
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '76190400',
                          [
                            'Asia/Baghdad',
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '389048400',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '631141200',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Europe/Kiev',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Europe/Minsk',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Europe/Chisinau',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Europe/Uzhgorod',
                            'Antarctica/Syowa',
                            'Etc/GMT+3',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '641941200',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Europe/Kiev',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Europe/Minsk',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Europe/Uzhgorod',
                            'Antarctica/Syowa',
                            'Etc/GMT+3',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '646786800',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Europe/Minsk',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '670370400',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Baku',
                            'Asia/Qatar',
                            'Europe/Minsk',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '670374000',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Baku',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '671144400',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Baku',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Asia/Yerevan',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '683499600',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Asia/Yerevan',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '685573200',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '686102400',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Europe/Samara',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '687916800',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '828230400',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '846374400',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '852066000',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '859683600',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '947930400',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Africa/Kampala',
                            'Africa/Khartoum',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '1301184000',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Europe/Minsk',
                            'Africa/Kampala',
                            'Africa/Khartoum',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Europe/Kaliningrad',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ],
                        [
                          '1351202400',
                          [
                            'Asia/Riyadh',
                            'Africa/Nairobi',
                            'Asia/Kuwait',
                            'Africa/Addis_Ababa',
                            'Africa/Dar_es_Salaam',
                            'Africa/Mogadishu',
                            'Asia/Qatar',
                            'Europe/Minsk',
                            'Africa/Kampala',
                            'Africa/Khartoum',
                            'Indian/Antananarivo',
                            'Asia/Bahrain',
                            'Asia/Amman',
                            'Africa/Djibouti',
                            'Asia/Aden',
                            'Africa/Asmara',
                            'Europe/Kaliningrad',
                            'Indian/Comoro',
                            'Indian/Mayotte',
                            'Antarctica/Syowa',
                            'Etc/GMT+3'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Europe/Moscow',
                            'Europe/Kiev',
                            'Europe/Minsk',
                            'Europe/Zaporozhye',
                            'Europe/Riga',
                            'Europe/Chisinau',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Europe/Uzhgorod',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '277250400',
                          [
                            'Europe/Istanbul',
                            'Europe/Moscow',
                            'Europe/Kiev',
                            'Europe/Minsk',
                            'Europe/Zaporozhye',
                            'Europe/Riga',
                            'Europe/Chisinau',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Europe/Uzhgorod',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '389048400',
                          [
                            'Europe/Istanbul',
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Kiev',
                            'Europe/Minsk',
                            'Europe/Zaporozhye',
                            'Europe/Riga',
                            'Europe/Chisinau',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Europe/Uzhgorod',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '482792400',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Kiev',
                            'Europe/Minsk',
                            'Europe/Zaporozhye',
                            'Europe/Riga',
                            'Europe/Chisinau',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Europe/Uzhgorod',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '606866400',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Kiev',
                            'Europe/Minsk',
                            'Europe/Samara',
                            'Europe/Volgograd',
                            'Europe/Zaporozhye',
                            'Europe/Riga',
                            'Europe/Chisinau',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Europe/Uzhgorod',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '606870000',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Kiev',
                            'Europe/Minsk',
                            'Europe/Samara',
                            'Europe/Volgograd',
                            'Europe/Zaporozhye',
                            'Europe/Chisinau',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Uzhgorod',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '631141200',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Samara',
                            'Europe/Volgograd',
                            'Europe/Zaporozhye',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad'
                          ]
                        ],
                        [
                          '670374000',
                          [
                            'Asia/Baghdad'
                          ]
                        ],
                        [
                          '671144400',
                          [
                            'Asia/Baghdad',
                            'Asia/Tbilisi'
                          ]
                        ],
                        [
                          '683499600',
                          [
                            'Asia/Baghdad',
                            'Asia/Baku',
                            'Asia/Tbilisi'
                          ]
                        ],
                        [
                          '685573200',
                          [
                            'Asia/Baghdad',
                            'Asia/Baku',
                            'Asia/Yerevan',
                            'Asia/Tbilisi'
                          ]
                        ],
                        [
                          '695779200',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Asia/Baku',
                            'Asia/Yerevan',
                            'Asia/Tbilisi'
                          ]
                        ],
                        [
                          '701820000',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Asia/Baku',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Europe/Volgograd'
                          ]
                        ],
                        [
                          '717537600',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Europe/Volgograd'
                          ]
                        ],
                        [
                          '767743200',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Europe/Volgograd',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '780440400',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Asia/Yerevan',
                            'Europe/Volgograd',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '811897200',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Volgograd',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '828230400',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Volgograd'
                          ]
                        ],
                        [
                          '846374400',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Volgograd',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '852066000',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Volgograd'
                          ]
                        ],
                        [
                          '1088280000',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Asia/Tbilisi',
                            'Europe/Volgograd'
                          ]
                        ],
                        [
                          '1111878000',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Volgograd'
                          ]
                        ],
                        [
                          '1269727200',
                          [
                            'Europe/Moscow',
                            'Asia/Baghdad',
                            'Europe/Samara',
                            'Europe/Volgograd'
                          ]
                        ],
                        [
                          '1301180400',
                          [
                            'Asia/Baghdad'
                          ]
                        ]
                      ]
             },
  '-0900' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Gambier',
                            'Etc/GMT-9'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/Dawson',
                            'America/Yakutat'
                          ]
                        ],
                        [
                          '120646800',
                          [
                            'America/Yakutat'
                          ]
                        ],
                        [
                          '325677600',
                          [
                            'America/Juneau',
                            'America/Yakutat'
                          ]
                        ],
                        [
                          '341406000',
                          [
                            'America/Yakutat'
                          ]
                        ],
                        [
                          '436356000',
                          [
                            'America/Juneau',
                            'America/Sitka',
                            'America/Yakutat'
                          ]
                        ],
                        [
                          '436363200',
                          [
                            'America/Anchorage',
                            'America/Juneau',
                            'America/Sitka',
                            'America/Yakutat'
                          ]
                        ],
                        [
                          '436366800',
                          [
                            'America/Anchorage',
                            'America/Juneau',
                            'America/Sitka',
                            'America/Nome',
                            'America/Yakutat'
                          ]
                        ]
                      ]
             },
  '+0400' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Dubai',
                            'Asia/Qatar',
                            'Asia/Bahrain',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '76190400',
                          [
                            'Asia/Dubai',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '662673600',
                          [
                            'Asia/Dubai',
                            'Indian/Reunion',
                            'Asia/Oral',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '670374000',
                          [
                            'Asia/Dubai',
                            'Europe/Volgograd',
                            'Indian/Reunion',
                            'Asia/Oral',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '692827200',
                          [
                            'Asia/Dubai',
                            'Europe/Volgograd',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '701820000',
                          [
                            'Asia/Dubai',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '717537600',
                          [
                            'Asia/Baku',
                            'Asia/Dubai',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '811897200',
                          [
                            'Asia/Baku',
                            'Asia/Dubai',
                            'Asia/Yerevan',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '820440000',
                          [
                            'Asia/Dubai',
                            'Asia/Yerevan',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '846360000',
                          [
                            'Asia/Dubai',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '852062400',
                          [
                            'Asia/Dubai',
                            'Asia/Tbilisi',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '859665600',
                          [
                            'Asia/Dubai',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '1111878000',
                          [
                            'Asia/Dubai',
                            'Asia/Tbilisi',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '1301180400',
                          [
                            'Europe/Moscow',
                            'Asia/Dubai',
                            'Europe/Samara',
                            'Asia/Tbilisi',
                            'Europe/Volgograd',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ],
                        [
                          '1332626400',
                          [
                            'Europe/Moscow',
                            'Asia/Dubai',
                            'Europe/Samara',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Europe/Volgograd',
                            'Indian/Reunion',
                            'Indian/Mahe',
                            'Asia/Muscat',
                            'Etc/GMT+4'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Europe/Volgograd'
                          ]
                        ],
                        [
                          '247177800',
                          [
                            'Asia/Tehran',
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Europe/Volgograd'
                          ]
                        ],
                        [
                          '283982400',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Europe/Volgograd'
                          ]
                        ],
                        [
                          '606862800',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Europe/Volgograd',
                            'Asia/Oral'
                          ]
                        ],
                        [
                          '606866400',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Asia/Oral'
                          ]
                        ],
                        [
                          '662673600',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Asia/Yerevan',
                            'Asia/Tbilisi'
                          ]
                        ],
                        [
                          '670366800',
                          [
                            'Asia/Baku',
                            'Asia/Yekaterinburg',
                            'Indian/Mauritius',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Asia/Ashgabat'
                          ]
                        ],
                        [
                          '670370400',
                          [
                            'Asia/Yekaterinburg',
                            'Indian/Mauritius',
                            'Asia/Ashgabat'
                          ]
                        ],
                        [
                          '687916800',
                          [
                            'Asia/Yekaterinburg',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Ashgabat'
                          ]
                        ],
                        [
                          '692827200',
                          [
                            'Asia/Yekaterinburg',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Ashgabat',
                            'Asia/Oral'
                          ]
                        ],
                        [
                          '695772000',
                          [
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Oral'
                          ]
                        ],
                        [
                          '780440400',
                          [
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Tbilisi',
                            'Asia/Oral'
                          ]
                        ],
                        [
                          '796165200',
                          [
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Tbilisi',
                            'Asia/Oral',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '820440000',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Tbilisi',
                            'Asia/Oral',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '846360000',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Oral',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '852062400',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Yerevan',
                            'Asia/Oral',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '859665600',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Yerevan',
                            'Asia/Tbilisi',
                            'Asia/Oral',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '1088280000',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Yerevan',
                            'Asia/Oral',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '1110830400',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Europe/Samara',
                            'Asia/Yerevan'
                          ]
                        ],
                        [
                          '1269727200',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius',
                            'Asia/Yerevan'
                          ]
                        ],
                        [
                          '1332626400',
                          [
                            'Asia/Baku',
                            'Indian/Mauritius'
                          ]
                        ]
                      ]
             },
  '-1000' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Honolulu',
                            'Pacific/Tahiti',
                            'Etc/GMT-10'
                          ]
                        ],
                        [
                          '307622400',
                          [
                            'Pacific/Honolulu',
                            'Pacific/Tahiti',
                            'Etc/GMT-10',
                            'Pacific/Kiritimati'
                          ]
                        ],
                        [
                          '788954400',
                          [
                            'Pacific/Honolulu',
                            'Pacific/Tahiti',
                            'Etc/GMT-10'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/Anchorage'
                          ]
                        ],
                        [
                          '279714600',
                          [
                            'America/Anchorage',
                            'Pacific/Rarotonga'
                          ]
                        ],
                        [
                          '436363200',
                          [
                            'Pacific/Rarotonga'
                          ]
                        ],
                        [
                          '436366800',
                          [
                            'Pacific/Rarotonga',
                            'America/Adak'
                          ]
                        ]
                      ]
             },
  '+0500' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Karachi',
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Asia/Qyzylorda',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Asia/Kashgar',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '38775600',
                          [
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Asia/Qyzylorda',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Asia/Kashgar',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '325969200',
                          [
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Asia/Qyzylorda',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '370724400',
                          [
                            'Indian/Maldives',
                            'Indian/Kerguelen',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '662670000',
                          [
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Qyzylorda',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '670363200',
                          [
                            'Asia/Bishkek',
                            'Asia/Dushanbe',
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Qyzylorda',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '683586000',
                          [
                            'Asia/Dushanbe',
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Qyzylorda',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '692823600',
                          [
                            'Asia/Dushanbe',
                            'Indian/Maldives',
                            'Asia/Qyzylorda',
                            'Indian/Kerguelen',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '694206000',
                          [
                            'Asia/Tashkent',
                            'Asia/Dushanbe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Asia/Qyzylorda',
                            'Indian/Kerguelen',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '695768400',
                          [
                            'Asia/Tashkent',
                            'Asia/Dushanbe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Indian/Kerguelen',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '695772000',
                          [
                            'Asia/Tashkent',
                            'Asia/Ashgabat',
                            'Asia/Dushanbe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Indian/Kerguelen',
                            'Etc/GMT+5',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '820436400',
                          [
                            'Asia/Tashkent',
                            'Asia/Ashgabat',
                            'Asia/Dushanbe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Indian/Kerguelen',
                            'Etc/GMT+5'
                          ]
                        ],
                        [
                          '1110826800',
                          [
                            'Asia/Tashkent',
                            'Asia/Ashgabat',
                            'Asia/Dushanbe',
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Indian/Kerguelen',
                            'Etc/GMT+5'
                          ]
                        ],
                        [
                          '1110830400',
                          [
                            'Asia/Tashkent',
                            'Asia/Ashgabat',
                            'Asia/Dushanbe',
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Etc/GMT+5'
                          ]
                        ],
                        [
                          '1255806000',
                          [
                            'Asia/Tashkent',
                            'Asia/Ashgabat',
                            'Asia/Dushanbe',
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Antarctica/Davis',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Etc/GMT+5'
                          ]
                        ],
                        [
                          '1255809600',
                          [
                            'Asia/Tashkent',
                            'Asia/Ashgabat',
                            'Asia/Dushanbe',
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Antarctica/Davis',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Antarctica/Mawson',
                            'Etc/GMT+5'
                          ]
                        ],
                        [
                          '1268251200',
                          [
                            'Asia/Tashkent',
                            'Asia/Ashgabat',
                            'Asia/Dushanbe',
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Antarctica/Mawson',
                            'Etc/GMT+5'
                          ]
                        ],
                        [
                          '1319742000',
                          [
                            'Asia/Tashkent',
                            'Asia/Ashgabat',
                            'Asia/Dushanbe',
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Antarctica/Davis',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Antarctica/Mawson',
                            'Etc/GMT+5'
                          ]
                        ],
                        [
                          '1329854400',
                          [
                            'Asia/Tashkent',
                            'Asia/Ashgabat',
                            'Asia/Dushanbe',
                            'Asia/Aqtobe',
                            'Indian/Maldives',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Asia/Aqtau',
                            'Indian/Kerguelen',
                            'Antarctica/Mawson',
                            'Etc/GMT+5'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Asia/Yekaterinburg',
                            'Asia/Ashgabat'
                          ]
                        ],
                        [
                          '38775600',
                          [
                            'Asia/Karachi',
                            'Asia/Yekaterinburg',
                            'Asia/Ashgabat'
                          ]
                        ],
                        [
                          '386445600',
                          [
                            'Asia/Karachi',
                            'Asia/Yekaterinburg',
                            'Asia/Ashgabat',
                            'Asia/Aqtobe',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Asia/Qyzylorda',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '606862800',
                          [
                            'Asia/Karachi',
                            'Asia/Yekaterinburg',
                            'Asia/Ashgabat',
                            'Asia/Aqtobe',
                            'Asia/Samarkand',
                            'Asia/Qyzylorda',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '662670000',
                          [
                            'Asia/Karachi',
                            'Asia/Yekaterinburg',
                            'Asia/Ashgabat',
                            'Asia/Samarkand'
                          ]
                        ],
                        [
                          '670363200',
                          [
                            'Asia/Karachi',
                            'Asia/Tashkent',
                            'Asia/Yekaterinburg',
                            'Asia/Omsk',
                            'Asia/Ashgabat',
                            'Asia/Samarkand'
                          ]
                        ],
                        [
                          '670366800',
                          [
                            'Asia/Karachi',
                            'Asia/Tashkent',
                            'Asia/Omsk',
                            'Asia/Samarkand'
                          ]
                        ],
                        [
                          '683586000',
                          [
                            'Asia/Karachi',
                            'Asia/Tashkent',
                            'Asia/Omsk',
                            'Asia/Bishkek',
                            'Asia/Samarkand'
                          ]
                        ],
                        [
                          '692823600',
                          [
                            'Asia/Karachi',
                            'Asia/Tashkent',
                            'Asia/Omsk',
                            'Asia/Bishkek',
                            'Asia/Aqtobe',
                            'Asia/Samarkand',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '694206000',
                          [
                            'Asia/Karachi',
                            'Asia/Omsk',
                            'Asia/Bishkek',
                            'Asia/Aqtobe',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '695768400',
                          [
                            'Asia/Karachi',
                            'Asia/Bishkek',
                            'Asia/Aqtobe',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '695772000',
                          [
                            'Asia/Karachi',
                            'Asia/Yekaterinburg',
                            'Asia/Bishkek',
                            'Asia/Aqtobe',
                            'Asia/Aqtau'
                          ]
                        ],
                        [
                          '796165200',
                          [
                            'Asia/Karachi',
                            'Asia/Yekaterinburg',
                            'Asia/Bishkek',
                            'Asia/Aqtobe'
                          ]
                        ],
                        [
                          '1110826800',
                          [
                            'Asia/Karachi',
                            'Asia/Yekaterinburg',
                            'Asia/Bishkek'
                          ]
                        ],
                        [
                          '1123786800',
                          [
                            'Asia/Karachi',
                            'Asia/Yekaterinburg'
                          ]
                        ],
                        [
                          '1301173200',
                          [
                            'Asia/Karachi'
                          ]
                        ]
                      ]
             },
  '+0600' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Dhaka',
                            'Asia/Urumqi',
                            'Asia/Hovd',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6'
                          ]
                        ],
                        [
                          '252439200',
                          [
                            'Asia/Dhaka',
                            'Asia/Urumqi',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6'
                          ]
                        ],
                        [
                          '325965600',
                          [
                            'Asia/Dhaka',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6'
                          ]
                        ],
                        [
                          '370724400',
                          [
                            'Asia/Dhaka',
                            'Asia/Aqtobe',
                            'Asia/Samarkand',
                            'Asia/Oral',
                            'Asia/Qyzylorda',
                            'Asia/Aqtau',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6'
                          ]
                        ],
                        [
                          '386445600',
                          [
                            'Asia/Dhaka',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6'
                          ]
                        ],
                        [
                          '560025000',
                          [
                            'Asia/Dhaka',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6'
                          ]
                        ],
                        [
                          '662666400',
                          [
                            'Asia/Dhaka',
                            'Asia/Almaty',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6'
                          ]
                        ],
                        [
                          '694202400',
                          [
                            'Asia/Dhaka',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6'
                          ]
                        ],
                        [
                          '820436400',
                          [
                            'Asia/Dhaka',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '846266400',
                          [
                            'Asia/Dhaka',
                            'Asia/Colombo',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '1110823200',
                          [
                            'Asia/Dhaka',
                            'Asia/Almaty',
                            'Asia/Colombo',
                            'Asia/Qyzylorda',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '1123786800',
                          [
                            'Asia/Dhaka',
                            'Asia/Almaty',
                            'Asia/Bishkek',
                            'Asia/Colombo',
                            'Asia/Qyzylorda',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '1145039400',
                          [
                            'Asia/Dhaka',
                            'Asia/Almaty',
                            'Asia/Bishkek',
                            'Asia/Qyzylorda',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '1230746400',
                          [
                            'Asia/Almaty',
                            'Asia/Bishkek',
                            'Asia/Qyzylorda',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Antarctica/Mawson',
                            'Etc/GMT+6',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '1255809600',
                          [
                            'Asia/Almaty',
                            'Asia/Bishkek',
                            'Asia/Qyzylorda',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Etc/GMT+6',
                            'Indian/Chagos'
                          ]
                        ],
                        [
                          '1301173200',
                          [
                            'Asia/Almaty',
                            'Asia/Yekaterinburg',
                            'Asia/Bishkek',
                            'Asia/Qyzylorda',
                            'Asia/Thimphu',
                            'Antarctica/Vostok',
                            'Etc/GMT+6',
                            'Indian/Chagos'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Asia/Tashkent',
                            'Asia/Almaty',
                            'Asia/Omsk',
                            'Asia/Bishkek',
                            'Asia/Dushanbe'
                          ]
                        ],
                        [
                          '662666400',
                          [
                            'Asia/Tashkent',
                            'Asia/Omsk',
                            'Asia/Bishkek',
                            'Asia/Dushanbe'
                          ]
                        ],
                        [
                          '670359600',
                          [
                            'Asia/Tashkent',
                            'Asia/Omsk',
                            'Asia/Krasnoyarsk',
                            'Asia/Bishkek',
                            'Asia/Dushanbe',
                            'Asia/Novokuznetsk',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '670363200',
                          [
                            'Asia/Krasnoyarsk',
                            'Asia/Novokuznetsk',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '694202400',
                          [
                            'Asia/Almaty',
                            'Asia/Krasnoyarsk',
                            'Asia/Novokuznetsk',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '695764800',
                          [
                            'Asia/Almaty'
                          ]
                        ],
                        [
                          '695768400',
                          [
                            'Asia/Almaty',
                            'Asia/Omsk',
                            'Asia/Qyzylorda'
                          ]
                        ],
                        [
                          '738090000',
                          [
                            'Asia/Almaty',
                            'Asia/Omsk',
                            'Asia/Qyzylorda',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '1110823200',
                          [
                            'Asia/Omsk',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '1230746400',
                          [
                            'Asia/Dhaka',
                            'Asia/Omsk',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '1269716400',
                          [
                            'Asia/Dhaka',
                            'Asia/Omsk',
                            'Asia/Novokuznetsk',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '1301169600',
                          [
                            'Asia/Dhaka'
                          ]
                        ]
                      ]
             },
  '-1130' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Niue'
                          ]
                        ]
                      ]
             },
  '-0300' => {
               'N' => [
                        [
                          '0',
                          [
                            'America/Cayenne',
                            'America/Godthab',
                            'America/Danmarkshavn',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '86760000',
                          [
                            'America/Asuncion',
                            'America/Cayenne',
                            'America/Godthab',
                            'America/Danmarkshavn',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '134017200',
                          [
                            'America/Cayenne',
                            'America/Godthab',
                            'America/Danmarkshavn',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '176010300',
                          [
                            'America/Guyana',
                            'America/Cayenne',
                            'America/Godthab',
                            'America/Danmarkshavn',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '218246400',
                          [
                            'America/Guyana',
                            'America/Cayenne',
                            'America/Godthab',
                            'America/Danmarkshavn',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '323845200',
                          [
                            'America/Guyana',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '326001600',
                          [
                            'America/Guyana',
                            'America/Cayenne',
                            'America/Miquelon',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '465449400',
                          [
                            'America/Guyana',
                            'America/Paramaribo',
                            'America/Cayenne',
                            'America/Miquelon',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '536468400',
                          [
                            'America/Guyana',
                            'America/Paramaribo',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '590036400',
                          [
                            'America/Belem',
                            'America/Guyana',
                            'America/Paramaribo',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '631162800',
                          [
                            'America/Belem',
                            'America/Guyana',
                            'America/Paramaribo',
                            'America/Argentina/San_Luis',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '637383600',
                          [
                            'America/Belem',
                            'America/Guyana',
                            'America/Paramaribo',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '653540400',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Guyana',
                            'America/Paramaribo',
                            'America/Araguaina',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '662698800',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Paramaribo',
                            'America/Araguaina',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '675748800',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Paramaribo',
                            'America/Argentina/San_Luis',
                            'America/Araguaina',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '686721600',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Jujuy',
                            'America/Paramaribo',
                            'America/Argentina/San_Luis',
                            'America/Araguaina',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '694234800',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Paramaribo',
                            'America/Argentina/San_Luis',
                            'America/Araguaina',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '811047600',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Paramaribo',
                            'America/Argentina/San_Luis',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '813553200',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Paramaribo',
                            'America/Argentina/San_Luis',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '841806000',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Paramaribo',
                            'America/Argentina/San_Luis',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '938660400',
                          [
                            'America/Belem',
                            'America/Paramaribo',
                            'America/Argentina/San_Luis',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '938919600',
                          [
                            'America/Belem',
                            'America/Paramaribo',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '952056000',
                          [
                            'America/Belem',
                            'America/Argentina/Tucuman',
                            'America/Argentina/San_Juan',
                            'America/Paramaribo',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '971578800',
                          [
                            'America/Recife',
                            'America/Belem',
                            'America/Argentina/Tucuman',
                            'America/Argentina/San_Juan',
                            'America/Paramaribo',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '972183600',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/San_Juan',
                            'America/Paramaribo',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1000350000',
                          [
                            'America/Belem',
                            'America/Argentina/Tucuman',
                            'America/Argentina/San_Juan',
                            'America/Paramaribo',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1033441200',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/San_Juan',
                            'America/Paramaribo',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1064372400',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/San_Juan',
                            'America/Paramaribo',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1085281200',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/San_Juan',
                            'America/Paramaribo',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1085886000',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/San_Juan',
                            'America/Paramaribo',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1085972400',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Paramaribo',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1086058800',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Paramaribo',
                            'America/Araguaina',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1214280000',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Paramaribo',
                            'America/Santarem',
                            'America/Araguaina',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1224298800',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Paramaribo',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1255233600',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Paramaribo',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1283666400',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Paramaribo',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Atlantic/Stanley',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1318734000',
                          [
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Paramaribo',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Atlantic/Stanley',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1350788400',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Paramaribo',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Atlantic/Stanley',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ],
                        [
                          '1378004400',
                          [
                            'America/Bahia',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Maceio',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Paramaribo',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Cayenne',
                            'Atlantic/Stanley',
                            'Antarctica/Rothera',
                            'Etc/GMT-3'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Montevideo',
                            'Antarctica/Palmer'
                          ]
                        ],
                        [
                          '323845200',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Montevideo',
                            'Antarctica/Palmer',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '389070000',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '420609600',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Montevideo',
                            'Atlantic/Stanley',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '495601200',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '536468400',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Belem',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '590036400',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '631162800',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '636519600',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '653540400',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '667796400',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/Catamarca',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '667969200',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '673588800',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/San_Juan',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '687931200',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '694234800',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '719380800',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '811047600',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '813553200',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo',
                            'America/Danmarkshavn'
                          ]
                        ],
                        [
                          '820465200',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '841806000',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '938660400',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Araguaina',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '938919600',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Maceio',
                            'America/Araguaina',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '952056000',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Salta',
                            'America/Argentina/Jujuy',
                            'America/Araguaina',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '971578800',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Salta',
                            'America/Argentina/Jujuy',
                            'America/Araguaina',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '972183600',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Salta',
                            'America/Argentina/Jujuy',
                            'America/Araguaina',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1000350000',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Fortaleza',
                            'America/Recife',
                            'America/Argentina/Cordoba',
                            'America/Maceio',
                            'America/Argentina/Salta',
                            'America/Argentina/Jujuy',
                            'America/Araguaina',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1033441200',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Salta',
                            'America/Argentina/Jujuy',
                            'America/Araguaina',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1064372400',
                          [
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Salta',
                            'America/Argentina/Jujuy',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1087099200',
                          [
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/Jujuy',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1087704000',
                          [
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1090728000',
                          [
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1096171200',
                          [
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1200884400',
                          [
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1224298800',
                          [
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1318734000',
                          [
                            'America/Bahia',
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1350788400',
                          [
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Araguaina',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ],
                        [
                          '1378004400',
                          [
                            'America/Sao_Paulo',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Argentina/Tucuman',
                            'America/Godthab',
                            'America/Miquelon',
                            'America/Montevideo'
                          ]
                        ]
                      ]
             },
  '-0200' => {
               'N' => [
                        [
                          '0',
                          [
                            'Atlantic/Cape_Verde',
                            'America/Scoresbysund',
                            'Atlantic/South_Georgia',
                            'Etc/GMT-2'
                          ]
                        ],
                        [
                          '186120000',
                          [
                            'America/Scoresbysund',
                            'Atlantic/South_Georgia',
                            'Etc/GMT-2'
                          ]
                        ],
                        [
                          '323841600',
                          [
                            'Atlantic/South_Georgia',
                            'Etc/GMT-2'
                          ]
                        ],
                        [
                          '653536800',
                          [
                            'Atlantic/South_Georgia',
                            'America/Noronha',
                            'Etc/GMT-2'
                          ]
                        ],
                        [
                          '938656800',
                          [
                            'Atlantic/South_Georgia',
                            'Etc/GMT-2'
                          ]
                        ],
                        [
                          '971575200',
                          [
                            'Atlantic/South_Georgia',
                            'America/Noronha',
                            'Etc/GMT-2'
                          ]
                        ],
                        [
                          '1000346400',
                          [
                            'Atlantic/South_Georgia',
                            'Etc/GMT-2'
                          ]
                        ],
                        [
                          '1033437600',
                          [
                            'Atlantic/South_Georgia',
                            'America/Noronha',
                            'Etc/GMT-2'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/Noronha'
                          ]
                        ],
                        [
                          '323841600',
                          [
                            'America/Scoresbysund',
                            'America/Noronha'
                          ]
                        ],
                        [
                          '354679200',
                          [
                            'America/Noronha'
                          ]
                        ],
                        [
                          '653536800',
                          []
                        ],
                        [
                          '938656800',
                          [
                            'America/Noronha'
                          ]
                        ],
                        [
                          '971575200',
                          []
                        ],
                        [
                          '1000346400',
                          [
                            'America/Noronha'
                          ]
                        ]
                      ]
             },
  '-0400' => {
               'N' => [
                        [
                          '0',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Asuncion',
                            'America/Martinique',
                            'America/Curacao',
                            'America/Antigua',
                            'Atlantic/Bermuda',
                            'America/Port_of_Spain',
                            'America/Glace_Bay',
                            'America/Miquelon',
                            'America/La_Paz',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '14400',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Asuncion',
                            'America/Martinique',
                            'America/Curacao',
                            'America/Antigua',
                            'Atlantic/Bermuda',
                            'America/Port_of_Spain',
                            'America/Glace_Bay',
                            'America/Miquelon',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '63086400',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Asuncion',
                            'America/Martinique',
                            'America/Curacao',
                            'America/Antigua',
                            'Atlantic/Bermuda',
                            'America/Port_of_Spain',
                            'America/Miquelon',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '86760000',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Martinique',
                            'America/Curacao',
                            'America/Antigua',
                            'Atlantic/Bermuda',
                            'America/Port_of_Spain',
                            'America/Miquelon',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '136360800',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Martinique',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/Miquelon',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '152082000',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Santo_Domingo',
                            'America/Martinique',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/Miquelon',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '326001600',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Santo_Domingo',
                            'America/Martinique',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '590040000',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '636519600',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Martinique',
                            'America/Argentina/Jujuy',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '637383600',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Martinique',
                            'America/Argentina/Jujuy',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/San_Luis',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '662698800',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Argentina/Jujuy',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/San_Luis',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '667796400',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Argentina/San_Juan',
                            'America/Martinique',
                            'America/Argentina/Jujuy',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '667969200',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Argentina/Cordoba',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Argentina/San_Juan',
                            'America/Martinique',
                            'America/Argentina/Jujuy',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '673588800',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Argentina/Cordoba',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Martinique',
                            'America/Argentina/Jujuy',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '675748800',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Argentina/Cordoba',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Martinique',
                            'America/Argentina/Jujuy',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '686721600',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Argentina/Cordoba',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '687931200',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '719380800',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '749188800',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '780206400',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '938664000',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '938919600',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Santarem',
                            'America/Argentina/San_Luis',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '952056000',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '971582400',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '972799200',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '975823200',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1064376000',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Cuiaba',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1085281200',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Cuiaba',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1085886000',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Cuiaba',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Argentina/Ushuaia',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1085972400',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Cuiaba',
                            'America/Argentina/San_Juan',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/San_Luis',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Argentina/Ushuaia',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1086058800',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Argentina/Tucuman',
                            'America/Cuiaba',
                            'America/Argentina/San_Juan',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1087099200',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Cuiaba',
                            'America/Argentina/San_Juan',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/Catamarca',
                            'America/Argentina/San_Luis',
                            'America/Argentina/La_Rioja',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Argentina/Rio_Gallegos',
                            'America/Argentina/Ushuaia',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1087704000',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Cuiaba',
                            'America/Argentina/San_Juan',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Argentina/San_Luis',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1090728000',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Cuiaba',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Argentina/Mendoza',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1096171200',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Cuiaba',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1096603200',
                          [
                            'America/Caracas',
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1197183600',
                          [
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1214280000',
                          [
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1214283600',
                          [
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Rio_Branco',
                            'America/Boa_Vista',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/Eirunepe',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ],
                        [
                          '1384056000',
                          [
                            'America/Puerto_Rico',
                            'America/Manaus',
                            'America/Santo_Domingo',
                            'America/Guyana',
                            'America/Martinique',
                            'America/Porto_Velho',
                            'America/Boa_Vista',
                            'America/Curacao',
                            'America/Antigua',
                            'America/Port_of_Spain',
                            'America/La_Paz',
                            'America/Blanc-Sablon',
                            'Etc/GMT-4'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/Santiago',
                            'America/Manaus',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Porto_Velho',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Moncton',
                            'America/Halifax',
                            'Atlantic/Stanley',
                            'America/Pangnirtung',
                            'America/Blanc-Sablon',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '14400',
                          [
                            'America/Santiago',
                            'America/Manaus',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Porto_Velho',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Moncton',
                            'America/Halifax',
                            'Atlantic/Stanley',
                            'America/Pangnirtung',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '63086400',
                          [
                            'America/Santiago',
                            'America/Manaus',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Porto_Velho',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Atlantic/Stanley',
                            'America/Pangnirtung',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '134017200',
                          [
                            'America/Santiago',
                            'America/Manaus',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Porto_Velho',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Atlantic/Stanley',
                            'America/Pangnirtung',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '136360800',
                          [
                            'America/Santiago',
                            'America/Manaus',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Porto_Velho',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Atlantic/Stanley',
                            'America/Pangnirtung',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '389070000',
                          [
                            'America/Santiago',
                            'America/Manaus',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Porto_Velho',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Pangnirtung',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '420609600',
                          [
                            'America/Santiago',
                            'America/Manaus',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Porto_Velho',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'America/Pangnirtung',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '495601200',
                          [
                            'America/Santiago',
                            'America/Manaus',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Porto_Velho',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'America/Santarem',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Pangnirtung',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '590040000',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Pangnirtung',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '749188800',
                          [
                            'America/Santiago',
                            'America/Manaus',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Pangnirtung',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '780206400',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Pangnirtung',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '796802400',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '938664000',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '938919600',
                          [
                            'America/Santiago',
                            'America/Argentina/Buenos_Aires',
                            'America/Argentina/Cordoba',
                            'America/Campo_Grande',
                            'America/Argentina/Tucuman',
                            'America/Argentina/Salta',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Argentina/San_Juan',
                            'America/Argentina/Jujuy',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'America/Argentina/Catamarca',
                            'America/Argentina/La_Rioja',
                            'America/Argentina/Mendoza',
                            'America/Argentina/Rio_Gallegos',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Argentina/Ushuaia',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '952056000',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'America/Boa_Vista',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '971582400',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '1064376000',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Asuncion',
                            'America/Barbados',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '1096603200',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '1200884400',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'America/Argentina/San_Luis',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '1255233600',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'Atlantic/Stanley',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ],
                        [
                          '1283666400',
                          [
                            'America/Santiago',
                            'America/Campo_Grande',
                            'America/Cuiaba',
                            'America/Asuncion',
                            'America/Barbados',
                            'Atlantic/Bermuda',
                            'America/Moncton',
                            'America/Glace_Bay',
                            'America/Halifax',
                            'Antarctica/Palmer',
                            'America/Goose_Bay',
                            'America/Thule'
                          ]
                        ]
                      ]
             },
  '+0800' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Makassar',
                            'Asia/Kuching',
                            'Asia/Pontianak',
                            'Asia/Brunei',
                            'Antarctica/Casey',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '199897200',
                          [
                            'Asia/Makassar',
                            'Asia/Kuching',
                            'Asia/Pontianak',
                            'Asia/Brunei',
                            'Asia/Dili',
                            'Antarctica/Casey',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '252435600',
                          [
                            'Asia/Makassar',
                            'Asia/Kuching',
                            'Asia/Pontianak',
                            'Asia/Brunei',
                            'Asia/Dili',
                            'Asia/Choibalsan',
                            'Antarctica/Casey',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '378664200',
                          [
                            'Asia/Singapore',
                            'Asia/Kuala_Lumpur',
                            'Asia/Makassar',
                            'Asia/Kuching',
                            'Asia/Pontianak',
                            'Asia/Brunei',
                            'Asia/Dili',
                            'Asia/Choibalsan',
                            'Antarctica/Casey',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '417974400',
                          [
                            'Asia/Singapore',
                            'Asia/Kuala_Lumpur',
                            'Asia/Makassar',
                            'Asia/Kuching',
                            'Asia/Pontianak',
                            'Asia/Brunei',
                            'Asia/Dili',
                            'Antarctica/Casey',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '567964800',
                          [
                            'Asia/Singapore',
                            'Asia/Kuala_Lumpur',
                            'Asia/Makassar',
                            'Asia/Kuching',
                            'Asia/Brunei',
                            'Asia/Dili',
                            'Antarctica/Casey',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '969120000',
                          [
                            'Asia/Singapore',
                            'Asia/Kuala_Lumpur',
                            'Asia/Makassar',
                            'Asia/Kuching',
                            'Asia/Brunei',
                            'Antarctica/Casey',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '1255802400',
                          [
                            'Asia/Singapore',
                            'Asia/Kuala_Lumpur',
                            'Asia/Makassar',
                            'Asia/Kuching',
                            'Asia/Brunei',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '1267714800',
                          [
                            'Asia/Singapore',
                            'Asia/Kuala_Lumpur',
                            'Asia/Makassar',
                            'Asia/Kuching',
                            'Asia/Brunei',
                            'Antarctica/Casey',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '1301166000',
                          [
                            'Asia/Singapore',
                            'Asia/Kuala_Lumpur',
                            'Asia/Makassar',
                            'Asia/Krasnoyarsk',
                            'Asia/Kuching',
                            'Asia/Brunei',
                            'Antarctica/Casey',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '1319738400',
                          [
                            'Asia/Singapore',
                            'Asia/Kuala_Lumpur',
                            'Asia/Makassar',
                            'Asia/Krasnoyarsk',
                            'Asia/Kuching',
                            'Asia/Brunei',
                            'Etc/GMT+8'
                          ]
                        ],
                        [
                          '1329843600',
                          [
                            'Asia/Singapore',
                            'Asia/Kuala_Lumpur',
                            'Asia/Makassar',
                            'Asia/Krasnoyarsk',
                            'Asia/Kuching',
                            'Asia/Brunei',
                            'Antarctica/Casey',
                            'Etc/GMT+8'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Asia/Shanghai',
                            'Asia/Hong_Kong',
                            'Asia/Taipei',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Macau',
                            'Asia/Irkutsk'
                          ]
                        ],
                        [
                          '252435600',
                          [
                            'Asia/Shanghai',
                            'Asia/Hong_Kong',
                            'Asia/Taipei',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Irkutsk'
                          ]
                        ],
                        [
                          '325956600',
                          [
                            'Asia/Shanghai',
                            'Asia/Harbin',
                            'Asia/Hong_Kong',
                            'Asia/Taipei',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Irkutsk'
                          ]
                        ],
                        [
                          '325962000',
                          [
                            'Asia/Shanghai',
                            'Asia/Harbin',
                            'Asia/Hong_Kong',
                            'Asia/Chongqing',
                            'Asia/Taipei',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Irkutsk'
                          ]
                        ],
                        [
                          '325965600',
                          [
                            'Asia/Shanghai',
                            'Asia/Harbin',
                            'Asia/Hong_Kong',
                            'Asia/Chongqing',
                            'Asia/Taipei',
                            'Asia/Urumqi',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Irkutsk'
                          ]
                        ],
                        [
                          '325969200',
                          [
                            'Asia/Shanghai',
                            'Asia/Harbin',
                            'Asia/Hong_Kong',
                            'Asia/Chongqing',
                            'Asia/Taipei',
                            'Asia/Urumqi',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Irkutsk',
                            'Asia/Kashgar'
                          ]
                        ],
                        [
                          '670352400',
                          [
                            'Asia/Shanghai',
                            'Asia/Harbin',
                            'Asia/Hong_Kong',
                            'Asia/Chongqing',
                            'Asia/Taipei',
                            'Asia/Urumqi',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Irkutsk',
                            'Asia/Yakutsk',
                            'Asia/Khandyga',
                            'Asia/Kashgar'
                          ]
                        ],
                        [
                          '670356000',
                          [
                            'Asia/Shanghai',
                            'Asia/Harbin',
                            'Asia/Hong_Kong',
                            'Asia/Chongqing',
                            'Asia/Taipei',
                            'Asia/Urumqi',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Yakutsk',
                            'Asia/Khandyga',
                            'Asia/Kashgar'
                          ]
                        ],
                        [
                          '695757600',
                          [
                            'Asia/Shanghai',
                            'Asia/Harbin',
                            'Asia/Hong_Kong',
                            'Asia/Chongqing',
                            'Asia/Taipei',
                            'Asia/Urumqi',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Kashgar'
                          ]
                        ],
                        [
                          '695761200',
                          [
                            'Asia/Shanghai',
                            'Asia/Harbin',
                            'Asia/Hong_Kong',
                            'Asia/Chongqing',
                            'Asia/Taipei',
                            'Asia/Urumqi',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Irkutsk',
                            'Asia/Kashgar'
                          ]
                        ],
                        [
                          '1206889200',
                          [
                            'Asia/Shanghai',
                            'Asia/Harbin',
                            'Asia/Hong_Kong',
                            'Asia/Chongqing',
                            'Asia/Taipei',
                            'Asia/Urumqi',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Irkutsk',
                            'Asia/Choibalsan',
                            'Asia/Kashgar'
                          ]
                        ],
                        [
                          '1301162400',
                          [
                            'Asia/Shanghai',
                            'Asia/Harbin',
                            'Asia/Hong_Kong',
                            'Asia/Chongqing',
                            'Asia/Taipei',
                            'Asia/Urumqi',
                            'Australia/Perth',
                            'Asia/Manila',
                            'Asia/Ulaanbaatar',
                            'Asia/Macau',
                            'Asia/Choibalsan',
                            'Asia/Kashgar'
                          ]
                        ]
                      ]
             },
  '+0700' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Jakarta',
                            'Asia/Ho_Chi_Minh',
                            'Asia/Bangkok',
                            'Asia/Chongqing',
                            'Asia/Phnom_Penh',
                            'Asia/Ulaanbaatar',
                            'Asia/Vientiane',
                            'Antarctica/Davis',
                            'Asia/Choibalsan',
                            'Etc/GMT+7',
                            'Indian/Christmas'
                          ]
                        ],
                        [
                          '252435600',
                          [
                            'Asia/Jakarta',
                            'Asia/Ho_Chi_Minh',
                            'Asia/Bangkok',
                            'Asia/Chongqing',
                            'Asia/Phnom_Penh',
                            'Asia/Vientiane',
                            'Antarctica/Davis',
                            'Etc/GMT+7',
                            'Indian/Christmas'
                          ]
                        ],
                        [
                          '325962000',
                          [
                            'Asia/Jakarta',
                            'Asia/Ho_Chi_Minh',
                            'Asia/Bangkok',
                            'Asia/Phnom_Penh',
                            'Asia/Vientiane',
                            'Antarctica/Davis',
                            'Etc/GMT+7',
                            'Indian/Christmas'
                          ]
                        ],
                        [
                          '567964800',
                          [
                            'Asia/Jakarta',
                            'Asia/Ho_Chi_Minh',
                            'Asia/Bangkok',
                            'Asia/Phnom_Penh',
                            'Asia/Pontianak',
                            'Asia/Vientiane',
                            'Antarctica/Davis',
                            'Etc/GMT+7',
                            'Indian/Christmas'
                          ]
                        ],
                        [
                          '1255806000',
                          [
                            'Asia/Jakarta',
                            'Asia/Ho_Chi_Minh',
                            'Asia/Bangkok',
                            'Asia/Phnom_Penh',
                            'Asia/Pontianak',
                            'Asia/Vientiane',
                            'Etc/GMT+7',
                            'Indian/Christmas'
                          ]
                        ],
                        [
                          '1268251200',
                          [
                            'Asia/Jakarta',
                            'Asia/Ho_Chi_Minh',
                            'Asia/Bangkok',
                            'Asia/Phnom_Penh',
                            'Asia/Pontianak',
                            'Asia/Vientiane',
                            'Antarctica/Davis',
                            'Etc/GMT+7',
                            'Indian/Christmas'
                          ]
                        ],
                        [
                          '1301169600',
                          [
                            'Asia/Jakarta',
                            'Asia/Ho_Chi_Minh',
                            'Asia/Bangkok',
                            'Asia/Phnom_Penh',
                            'Asia/Omsk',
                            'Asia/Novokuznetsk',
                            'Asia/Pontianak',
                            'Asia/Vientiane',
                            'Antarctica/Davis',
                            'Asia/Novosibirsk',
                            'Etc/GMT+7',
                            'Indian/Christmas'
                          ]
                        ],
                        [
                          '1319742000',
                          [
                            'Asia/Jakarta',
                            'Asia/Ho_Chi_Minh',
                            'Asia/Bangkok',
                            'Asia/Phnom_Penh',
                            'Asia/Omsk',
                            'Asia/Novokuznetsk',
                            'Asia/Pontianak',
                            'Asia/Vientiane',
                            'Asia/Novosibirsk',
                            'Etc/GMT+7',
                            'Indian/Christmas'
                          ]
                        ],
                        [
                          '1329854400',
                          [
                            'Asia/Jakarta',
                            'Asia/Ho_Chi_Minh',
                            'Asia/Bangkok',
                            'Asia/Phnom_Penh',
                            'Asia/Omsk',
                            'Asia/Novokuznetsk',
                            'Asia/Pontianak',
                            'Asia/Vientiane',
                            'Antarctica/Davis',
                            'Asia/Novosibirsk',
                            'Etc/GMT+7',
                            'Indian/Christmas'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Asia/Krasnoyarsk',
                            'Asia/Novokuznetsk',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '252439200',
                          [
                            'Asia/Krasnoyarsk',
                            'Asia/Novokuznetsk',
                            'Asia/Hovd',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '670356000',
                          [
                            'Asia/Krasnoyarsk',
                            'Asia/Irkutsk',
                            'Asia/Novokuznetsk',
                            'Asia/Hovd',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '670359600',
                          [
                            'Asia/Irkutsk',
                            'Asia/Hovd'
                          ]
                        ],
                        [
                          '695761200',
                          [
                            'Asia/Hovd'
                          ]
                        ],
                        [
                          '695764800',
                          [
                            'Asia/Krasnoyarsk',
                            'Asia/Novokuznetsk',
                            'Asia/Hovd',
                            'Asia/Novosibirsk'
                          ]
                        ],
                        [
                          '738090000',
                          [
                            'Asia/Krasnoyarsk',
                            'Asia/Novokuznetsk',
                            'Asia/Hovd'
                          ]
                        ],
                        [
                          '1269716400',
                          [
                            'Asia/Krasnoyarsk',
                            'Asia/Hovd'
                          ]
                        ],
                        [
                          '1301166000',
                          [
                            'Asia/Hovd'
                          ]
                        ]
                      ]
             },
  '+0845' => {
               'Y' => [
                        [
                          '0',
                          [
                            'Australia/Eucla'
                          ]
                        ]
                      ]
             },
  '+0100' => {
               'N' => [
                        [
                          '0',
                          [
                            'Europe/London',
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Europe/Berlin',
                            'Africa/Luanda',
                            'Africa/Douala',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Africa/Brazzaville',
                            'Europe/Dublin',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Africa/Ndjamena',
                            'Europe/Stockholm',
                            'Africa/Niamey',
                            'Europe/Oslo',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Lisbon',
                            'Europe/Zurich',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '57722400',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Europe/Berlin',
                            'Africa/Luanda',
                            'Africa/Douala',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Africa/Brazzaville',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Africa/Ndjamena',
                            'Europe/Stockholm',
                            'Africa/Niamey',
                            'Europe/Oslo',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Lisbon',
                            'Europe/Zurich',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '212544000',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Europe/Berlin',
                            'Africa/Luanda',
                            'Africa/Douala',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Africa/Brazzaville',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Africa/Ndjamena',
                            'Europe/Stockholm',
                            'Africa/Niamey',
                            'Europe/Oslo',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Zurich',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '220921200',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Europe/Berlin',
                            'Africa/Luanda',
                            'Africa/Douala',
                            'Europe/Belgrade',
                            'Africa/Brazzaville',
                            'Europe/Prague',
                            'Africa/Ndjamena',
                            'Europe/Stockholm',
                            'Africa/Niamey',
                            'Europe/Oslo',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Europe/Copenhagen',
                            'Europe/Zurich',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Europe/Gibraltar',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '283993200',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Europe/Berlin',
                            'Africa/Luanda',
                            'Africa/Douala',
                            'Europe/Belgrade',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Europe/Stockholm',
                            'Africa/Niamey',
                            'Europe/Oslo',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Europe/Copenhagen',
                            'Europe/Zurich',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Europe/Gibraltar',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '315529200',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Africa/Luanda',
                            'Africa/Douala',
                            'Europe/Belgrade',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Africa/Niamey',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Europe/Zurich',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Europe/Gibraltar',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '347151600',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Africa/Luanda',
                            'Africa/Douala',
                            'Europe/Belgrade',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Africa/Niamey',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Europe/Gibraltar',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '357523200',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Africa/Luanda',
                            'Africa/Algiers',
                            'Africa/Douala',
                            'Europe/Belgrade',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Africa/Niamey',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Europe/Gibraltar',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '378687600',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Africa/Luanda',
                            'Africa/Algiers',
                            'Africa/Douala',
                            'Europe/Belgrade',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Africa/Niamey',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '407199600',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Africa/Luanda',
                            'Africa/Algiers',
                            'Africa/Douala',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Africa/Niamey',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '448243200',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Africa/Casablanca',
                            'Africa/Luanda',
                            'Africa/Algiers',
                            'Africa/Douala',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Africa/Niamey',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '481078800',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Africa/Casablanca',
                            'Africa/Luanda',
                            'Africa/Algiers',
                            'Africa/Douala',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Africa/Niamey',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Africa/Ceuta',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '504918000',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Africa/Luanda',
                            'Africa/Algiers',
                            'Africa/Douala',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Africa/Niamey',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '646786800',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Africa/Luanda',
                            'Africa/Algiers',
                            'Africa/Douala',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Africa/Niamey',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Europe/Uzhgorod',
                            'Etc/GMT+1'
                          ]
                        ],
                        [
                          '670384800',
                          [
                            'Africa/Lagos',
                            'Africa/Kinshasa',
                            'Africa/Luanda',
                            'Africa/Algiers',
                            'Africa/Douala',
                            'Africa/Brazzaville',
                            'Africa/Ndjamena',
                            'Africa/Niamey',
                            'Africa/Libreville',
                            'Africa/Bangui',
                            'Africa/Porto-Novo',
                            'Africa/Malabo',
                            'Etc/GMT+1'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Monaco'
                          ]
                        ],
                        [
                          '220921200',
                          [
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Brussels',
                            'Europe/Luxembourg',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Monaco',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '246240000',
                          [
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Africa/Algiers',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Brussels',
                            'Europe/Luxembourg',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Monaco',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '283993200',
                          [
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Africa/Algiers',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Luxembourg',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Monaco',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '309740400',
                          [
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Luxembourg',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Monaco',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '315529200',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Monaco',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '347151600',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Europe/Monaco',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '378684000',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Africa/Tripoli',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Europe/Monaco',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '378687600',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Africa/Tripoli',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '407199600',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Africa/Tripoli',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '481078800',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Africa/Tripoli',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Europe/Andorra',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '504918000',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Africa/Tripoli',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '641775600',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '717555600',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Lisbon',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '765324000',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Lisbon',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Africa/Windhoek',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '828234000',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Africa/Windhoek',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '844034400',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Africa/Tripoli',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Africa/Windhoek',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '875919600',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Africa/Windhoek',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '891133200',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Vilnius',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Africa/Windhoek',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '941331600',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Africa/Windhoek',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '1352505600',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Africa/Tripoli',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Africa/Windhoek',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ],
                        [
                          '1382662800',
                          [
                            'Europe/Berlin',
                            'Europe/Madrid',
                            'Europe/Rome',
                            'Africa/Tunis',
                            'Europe/Paris',
                            'Europe/Vienna',
                            'Europe/Budapest',
                            'Europe/Warsaw',
                            'Europe/Belgrade',
                            'Europe/Prague',
                            'Europe/Brussels',
                            'Europe/Stockholm',
                            'Europe/Oslo',
                            'Europe/Luxembourg',
                            'Europe/Copenhagen',
                            'Europe/Tirane',
                            'Europe/Malta',
                            'Europe/Zurich',
                            'Africa/Windhoek',
                            'Europe/Andorra',
                            'Africa/Ceuta',
                            'Europe/Monaco',
                            'Europe/Gibraltar',
                            'Europe/Amsterdam'
                          ]
                        ]
                      ]
             },
  '+1400' => {
               'N' => [
                        [
                          '0',
                          [
                            'Etc/GMT+14'
                          ]
                        ],
                        [
                          '788954400',
                          [
                            'Etc/GMT+14',
                            'Pacific/Kiritimati'
                          ]
                        ]
                      ]
             },
  '+0430' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Kabul'
                          ]
                        ]
                      ]
             },
  '+0830' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Harbin'
                          ]
                        ]
                      ]
             },
  '+0530' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Kolkata',
                            'Asia/Kathmandu',
                            'Asia/Colombo',
                            'Asia/Thimphu'
                          ]
                        ],
                        [
                          '504901800',
                          [
                            'Asia/Kolkata',
                            'Asia/Colombo',
                            'Asia/Thimphu'
                          ]
                        ],
                        [
                          '560025000',
                          [
                            'Asia/Kolkata',
                            'Asia/Colombo'
                          ]
                        ],
                        [
                          '832962600',
                          [
                            'Asia/Kolkata'
                          ]
                        ],
                        [
                          '1145039400',
                          [
                            'Asia/Kolkata',
                            'Asia/Colombo'
                          ]
                        ]
                      ]
             },
  '-1100' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Apia',
                            'Pacific/Pago_Pago',
                            'Pacific/Midway',
                            'Etc/GMT-11',
                            'Pacific/Fakaofo'
                          ]
                        ],
                        [
                          '276089400',
                          [
                            'Pacific/Apia',
                            'Pacific/Pago_Pago',
                            'Pacific/Midway',
                            'Pacific/Niue',
                            'Etc/GMT-11',
                            'Pacific/Fakaofo'
                          ]
                        ],
                        [
                          '307627200',
                          [
                            'Pacific/Apia',
                            'Pacific/Pago_Pago',
                            'Pacific/Midway',
                            'Pacific/Niue',
                            'Etc/GMT-11',
                            'Pacific/Enderbury',
                            'Pacific/Fakaofo'
                          ]
                        ],
                        [
                          '788958000',
                          [
                            'Pacific/Apia',
                            'Pacific/Pago_Pago',
                            'Pacific/Midway',
                            'Pacific/Niue',
                            'Etc/GMT-11',
                            'Pacific/Fakaofo'
                          ]
                        ],
                        [
                          '1325242800',
                          [
                            'Pacific/Pago_Pago',
                            'Pacific/Midway',
                            'Pacific/Niue',
                            'Etc/GMT-11'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/Nome',
                            'America/Adak'
                          ]
                        ]
                      ]
             },
  '+0900' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Tokyo',
                            'Asia/Pyongyang',
                            'Asia/Dili',
                            'Asia/Jayapura',
                            'Pacific/Palau',
                            'Etc/GMT+9'
                          ]
                        ],
                        [
                          '199897200',
                          [
                            'Asia/Tokyo',
                            'Asia/Pyongyang',
                            'Asia/Jayapura',
                            'Pacific/Palau',
                            'Etc/GMT+9'
                          ]
                        ],
                        [
                          '969120000',
                          [
                            'Asia/Tokyo',
                            'Asia/Pyongyang',
                            'Asia/Dili',
                            'Asia/Jayapura',
                            'Pacific/Palau',
                            'Etc/GMT+9'
                          ]
                        ],
                        [
                          '1301162400',
                          [
                            'Asia/Tokyo',
                            'Asia/Pyongyang',
                            'Asia/Irkutsk',
                            'Asia/Dili',
                            'Asia/Jayapura',
                            'Pacific/Palau',
                            'Etc/GMT+9'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Asia/Seoul',
                            'Asia/Yakutsk',
                            'Asia/Ust-Nera',
                            'Asia/Khandyga'
                          ]
                        ],
                        [
                          '354898800',
                          [
                            'Asia/Seoul',
                            'Asia/Yakutsk',
                            'Asia/Khandyga'
                          ]
                        ],
                        [
                          '417974400',
                          [
                            'Asia/Seoul',
                            'Asia/Yakutsk',
                            'Asia/Choibalsan',
                            'Asia/Khandyga'
                          ]
                        ],
                        [
                          '670348800',
                          [
                            'Asia/Seoul',
                            'Asia/Vladivostok',
                            'Asia/Yakutsk',
                            'Asia/Choibalsan',
                            'Asia/Khandyga'
                          ]
                        ],
                        [
                          '670352400',
                          [
                            'Asia/Seoul',
                            'Asia/Vladivostok',
                            'Asia/Choibalsan'
                          ]
                        ],
                        [
                          '695754000',
                          [
                            'Asia/Seoul',
                            'Asia/Choibalsan'
                          ]
                        ],
                        [
                          '695757600',
                          [
                            'Asia/Seoul',
                            'Asia/Yakutsk',
                            'Asia/Choibalsan',
                            'Asia/Khandyga'
                          ]
                        ],
                        [
                          '1072882800',
                          [
                            'Asia/Seoul',
                            'Asia/Yakutsk',
                            'Asia/Choibalsan'
                          ]
                        ],
                        [
                          '1206889200',
                          [
                            'Asia/Seoul',
                            'Asia/Yakutsk'
                          ]
                        ],
                        [
                          '1301158800',
                          [
                            'Asia/Seoul'
                          ]
                        ]
                      ]
             },
  '+1300' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Tongatapu',
                            'Etc/GMT+13'
                          ]
                        ],
                        [
                          '788958000',
                          [
                            'Pacific/Tongatapu',
                            'Etc/GMT+13',
                            'Pacific/Enderbury'
                          ]
                        ],
                        [
                          '915102000',
                          [
                            'Etc/GMT+13',
                            'Pacific/Enderbury'
                          ]
                        ],
                        [
                          '1325242800',
                          [
                            'Pacific/Apia',
                            'Etc/GMT+13',
                            'Pacific/Enderbury',
                            'Pacific/Fakaofo'
                          ]
                        ],
                        [
                          '1333206000',
                          [
                            'Etc/GMT+13',
                            'Pacific/Enderbury',
                            'Pacific/Fakaofo'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Asia/Anadyr'
                          ]
                        ],
                        [
                          '386420400',
                          []
                        ],
                        [
                          '915102000',
                          [
                            'Pacific/Tongatapu'
                          ]
                        ],
                        [
                          '1333206000',
                          [
                            'Pacific/Tongatapu',
                            'Pacific/Apia'
                          ]
                        ]
                      ]
             },
  '-1030' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Rarotonga'
                          ]
                        ]
                      ]
             },
  '-0930' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Marquesas'
                          ]
                        ]
                      ]
             },
  '-0800' => {
               'N' => [
                        [
                          '0',
                          [
                            'America/Tijuana',
                            'America/Hermosillo',
                            'America/Mazatlan',
                            'America/Santa_Isabel',
                            'America/Bahia_Banderas',
                            'Etc/GMT-8'
                          ]
                        ],
                        [
                          '28800',
                          [
                            'America/Tijuana',
                            'America/Santa_Isabel',
                            'Etc/GMT-8'
                          ]
                        ],
                        [
                          '189331200',
                          [
                            'Etc/GMT-8'
                          ]
                        ],
                        [
                          '436356000',
                          [
                            'America/Metlakatla',
                            'Etc/GMT-8'
                          ]
                        ],
                        [
                          '893665800',
                          [
                            'America/Metlakatla',
                            'Pacific/Pitcairn',
                            'Etc/GMT-8'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/Los_Angeles',
                            'America/Vancouver',
                            'America/Juneau',
                            'America/Dawson_Creek',
                            'America/Whitehorse',
                            'America/Sitka',
                            'America/Inuvik',
                            'America/Metlakatla'
                          ]
                        ],
                        [
                          '84016800',
                          [
                            'America/Los_Angeles',
                            'America/Vancouver',
                            'America/Juneau',
                            'America/Whitehorse',
                            'America/Sitka',
                            'America/Inuvik',
                            'America/Metlakatla'
                          ]
                        ],
                        [
                          '120646800',
                          [
                            'America/Los_Angeles',
                            'America/Vancouver',
                            'America/Juneau',
                            'America/Whitehorse',
                            'America/Sitka',
                            'America/Dawson',
                            'America/Inuvik',
                            'America/Metlakatla'
                          ]
                        ],
                        [
                          '189331200',
                          [
                            'America/Los_Angeles',
                            'America/Tijuana',
                            'America/Vancouver',
                            'America/Santa_Isabel',
                            'America/Juneau',
                            'America/Whitehorse',
                            'America/Sitka',
                            'America/Dawson',
                            'America/Inuvik',
                            'America/Metlakatla'
                          ]
                        ],
                        [
                          '294228000',
                          [
                            'America/Los_Angeles',
                            'America/Tijuana',
                            'America/Vancouver',
                            'America/Santa_Isabel',
                            'America/Juneau',
                            'America/Whitehorse',
                            'America/Sitka',
                            'America/Dawson',
                            'America/Metlakatla'
                          ]
                        ],
                        [
                          '325677600',
                          [
                            'America/Los_Angeles',
                            'America/Tijuana',
                            'America/Vancouver',
                            'America/Santa_Isabel',
                            'America/Whitehorse',
                            'America/Sitka',
                            'America/Dawson',
                            'America/Metlakatla'
                          ]
                        ],
                        [
                          '341406000',
                          [
                            'America/Los_Angeles',
                            'America/Tijuana',
                            'America/Vancouver',
                            'America/Santa_Isabel',
                            'America/Juneau',
                            'America/Whitehorse',
                            'America/Sitka',
                            'America/Dawson',
                            'America/Metlakatla'
                          ]
                        ],
                        [
                          '436356000',
                          [
                            'America/Los_Angeles',
                            'America/Tijuana',
                            'America/Vancouver',
                            'America/Santa_Isabel',
                            'America/Whitehorse',
                            'America/Dawson'
                          ]
                        ]
                      ]
             },
  '+0200' => {
               'N' => [
                        [
                          '0',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '291762000',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '378684000',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '606870000',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Kigali',
                            'Europe/Riga',
                            'Africa/Blantyre',
                            'Europe/Tallinn',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '622598400',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '641775600',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '641941200',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Europe/Chisinau',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '646786800',
                          [
                            'Africa/Johannesburg',
                            'Europe/Kiev',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Europe/Chisinau',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '662680800',
                          [
                            'Africa/Johannesburg',
                            'Europe/Kiev',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '670374000',
                          [
                            'Africa/Johannesburg',
                            'Europe/Kiev',
                            'Europe/Minsk',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Europe/Vilnius',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '670384800',
                          [
                            'Africa/Johannesburg',
                            'Europe/Kiev',
                            'Europe/Minsk',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Europe/Vilnius',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Europe/Uzhgorod',
                            'Africa/Mbabane',
                            'Etc/GMT+2',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '686102400',
                          [
                            'Africa/Johannesburg',
                            'Europe/Kiev',
                            'Europe/Minsk',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Europe/Uzhgorod',
                            'Africa/Mbabane',
                            'Etc/GMT+2',
                            'Europe/Simferopol'
                          ]
                        ],
                        [
                          '694216800',
                          [
                            'Africa/Johannesburg',
                            'Europe/Minsk',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '717544800',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Windhoek',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '765324000',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '844034400',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '875919600',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '883605600',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Europe/Vilnius',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '891133200',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '941331600',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Europe/Vilnius',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '941407200',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Europe/Vilnius',
                            'Europe/Tallinn',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '951775200',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Europe/Riga',
                            'Africa/Blantyre',
                            'Europe/Vilnius',
                            'Europe/Tallinn',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '978386400',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Europe/Vilnius',
                            'Europe/Tallinn',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1014242400',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Europe/Vilnius',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1041372000',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1219960800',
                          [
                            'Africa/Johannesburg',
                            'Asia/Gaza',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1220220000',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1262296800',
                          [
                            'Africa/Johannesburg',
                            'Asia/Gaza',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1269640860',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1301187600',
                          [
                            'Europe/Istanbul',
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1301274000',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1312149600',
                          [
                            'Africa/Johannesburg',
                            'Asia/Gaza',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1325368800',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1352505600',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ],
                        [
                          '1382662800',
                          [
                            'Africa/Johannesburg',
                            'Africa/Harare',
                            'Africa/Lubumbashi',
                            'Africa/Lusaka',
                            'Africa/Maputo',
                            'Africa/Tripoli',
                            'Africa/Kigali',
                            'Africa/Blantyre',
                            'Africa/Bujumbura',
                            'Africa/Maseru',
                            'Africa/Gaborone',
                            'Africa/Mbabane',
                            'Etc/GMT+2'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Asia/Jerusalem',
                            'Europe/Athens',
                            'Europe/Helsinki',
                            'Asia/Nicosia',
                            'Asia/Hebron'
                          ]
                        ],
                        [
                          '277250400',
                          [
                            'Africa/Cairo',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Asia/Jerusalem',
                            'Europe/Athens',
                            'Europe/Helsinki',
                            'Asia/Nicosia',
                            'Asia/Hebron'
                          ]
                        ],
                        [
                          '291762000',
                          [
                            'Africa/Cairo',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Asia/Jerusalem',
                            'Europe/Athens',
                            'Europe/Helsinki',
                            'Asia/Nicosia',
                            'Asia/Hebron',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '482792400',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Asia/Jerusalem',
                            'Europe/Athens',
                            'Europe/Helsinki',
                            'Asia/Nicosia',
                            'Asia/Hebron',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '622598400',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Helsinki',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Asia/Hebron',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '662680800',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Asia/Hebron',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '670374000',
                          [
                            'Europe/Istanbul',
                            'Europe/Moscow',
                            'Africa/Cairo',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Europe/Samara',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Asia/Hebron',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '686102400',
                          [
                            'Europe/Istanbul',
                            'Europe/Moscow',
                            'Africa/Cairo',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Asia/Hebron',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '694216800',
                          [
                            'Europe/Istanbul',
                            'Europe/Moscow',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '695779200',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '717544800',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '767743200',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '859683600',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '883605600',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '941407200',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Africa/Khartoum',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Kaliningrad',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '947930400',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Kaliningrad',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '951775200',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Kaliningrad',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '978386400',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Kaliningrad',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1014242400',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1041372000',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1219960800',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1220220000',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1262296800',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1269640860',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Europe/Minsk',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Kaliningrad',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1301184000',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1301187600',
                          [
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1301274000',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1312149600',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1325368800',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Asia/Amman',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ],
                        [
                          '1351202400',
                          [
                            'Europe/Istanbul',
                            'Africa/Cairo',
                            'Europe/Kiev',
                            'Asia/Beirut',
                            'Europe/Bucharest',
                            'Asia/Gaza',
                            'Asia/Damascus',
                            'Europe/Zaporozhye',
                            'Asia/Jerusalem',
                            'Europe/Riga',
                            'Europe/Athens',
                            'Europe/Chisinau',
                            'Europe/Helsinki',
                            'Europe/Vilnius',
                            'Europe/Tallinn',
                            'Asia/Nicosia',
                            'Europe/Uzhgorod',
                            'Asia/Hebron',
                            'Europe/Simferopol',
                            'Europe/Sofia'
                          ]
                        ]
                      ]
             },
  '+1130' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Nauru',
                            'Pacific/Norfolk'
                          ]
                        ],
                        [
                          '294323400',
                          [
                            'Pacific/Norfolk'
                          ]
                        ]
                      ]
             },
  '+1100' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Guadalcanal',
                            'Etc/GMT+11',
                            'Pacific/Pohnpei'
                          ]
                        ],
                        [
                          '915105600',
                          [
                            'Pacific/Guadalcanal',
                            'Pacific/Kosrae',
                            'Etc/GMT+11',
                            'Pacific/Pohnpei'
                          ]
                        ],
                        [
                          '1255802400',
                          [
                            'Pacific/Guadalcanal',
                            'Pacific/Kosrae',
                            'Antarctica/Casey',
                            'Etc/GMT+11',
                            'Pacific/Pohnpei'
                          ]
                        ],
                        [
                          '1267714800',
                          [
                            'Pacific/Guadalcanal',
                            'Pacific/Kosrae',
                            'Etc/GMT+11',
                            'Pacific/Pohnpei'
                          ]
                        ],
                        [
                          '1270314000',
                          [
                            'Pacific/Guadalcanal',
                            'Pacific/Kosrae',
                            'Antarctica/Macquarie',
                            'Etc/GMT+11',
                            'Pacific/Pohnpei'
                          ]
                        ],
                        [
                          '1301155200',
                          [
                            'Asia/Sakhalin',
                            'Asia/Vladivostok',
                            'Pacific/Guadalcanal',
                            'Asia/Khandyga',
                            'Pacific/Kosrae',
                            'Antarctica/Macquarie',
                            'Etc/GMT+11',
                            'Pacific/Pohnpei'
                          ]
                        ],
                        [
                          '1315828800',
                          [
                            'Asia/Sakhalin',
                            'Asia/Vladivostok',
                            'Pacific/Guadalcanal',
                            'Asia/Ust-Nera',
                            'Asia/Khandyga',
                            'Pacific/Kosrae',
                            'Antarctica/Macquarie',
                            'Etc/GMT+11',
                            'Pacific/Pohnpei'
                          ]
                        ],
                        [
                          '1315832400',
                          [
                            'Asia/Sakhalin',
                            'Asia/Vladivostok',
                            'Pacific/Guadalcanal',
                            'Asia/Ust-Nera',
                            'Pacific/Kosrae',
                            'Antarctica/Macquarie',
                            'Etc/GMT+11',
                            'Pacific/Pohnpei'
                          ]
                        ],
                        [
                          '1319738400',
                          [
                            'Asia/Sakhalin',
                            'Asia/Vladivostok',
                            'Pacific/Guadalcanal',
                            'Asia/Ust-Nera',
                            'Pacific/Kosrae',
                            'Antarctica/Casey',
                            'Antarctica/Macquarie',
                            'Etc/GMT+11',
                            'Pacific/Pohnpei'
                          ]
                        ],
                        [
                          '1329843600',
                          [
                            'Asia/Sakhalin',
                            'Asia/Vladivostok',
                            'Pacific/Guadalcanal',
                            'Asia/Ust-Nera',
                            'Pacific/Kosrae',
                            'Antarctica/Macquarie',
                            'Etc/GMT+11',
                            'Pacific/Pohnpei'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Asia/Sakhalin',
                            'Asia/Magadan',
                            'Pacific/Noumea',
                            'Pacific/Efate'
                          ]
                        ],
                        [
                          '354898800',
                          [
                            'Asia/Sakhalin',
                            'Asia/Magadan',
                            'Pacific/Noumea',
                            'Asia/Ust-Nera',
                            'Pacific/Efate'
                          ]
                        ],
                        [
                          '670341600',
                          [
                            'Asia/Sakhalin',
                            'Asia/Kamchatka',
                            'Asia/Magadan',
                            'Pacific/Noumea',
                            'Asia/Ust-Nera',
                            'Pacific/Efate',
                            'Asia/Anadyr'
                          ]
                        ],
                        [
                          '670345200',
                          [
                            'Asia/Kamchatka',
                            'Pacific/Noumea',
                            'Pacific/Efate',
                            'Asia/Anadyr'
                          ]
                        ],
                        [
                          '695746800',
                          [
                            'Pacific/Noumea',
                            'Pacific/Efate'
                          ]
                        ],
                        [
                          '695750400',
                          [
                            'Asia/Sakhalin',
                            'Asia/Magadan',
                            'Pacific/Noumea',
                            'Asia/Ust-Nera',
                            'Pacific/Efate'
                          ]
                        ],
                        [
                          '859647600',
                          [
                            'Asia/Magadan',
                            'Pacific/Noumea',
                            'Asia/Ust-Nera',
                            'Pacific/Efate'
                          ]
                        ],
                        [
                          '1269698400',
                          [
                            'Asia/Kamchatka',
                            'Asia/Magadan',
                            'Pacific/Noumea',
                            'Asia/Ust-Nera',
                            'Pacific/Efate',
                            'Asia/Anadyr'
                          ]
                        ],
                        [
                          '1301151600',
                          [
                            'Pacific/Noumea',
                            'Pacific/Efate'
                          ]
                        ]
                      ]
             },
  '+1030' => {
               'Y' => [
                        [
                          '352216800',
                          [
                            'Australia/Lord_Howe'
                          ]
                        ]
                      ]
             },
  '-0345' => {
               'N' => [
                        [
                          '0',
                          [
                            'America/Guyana'
                          ]
                        ]
                      ]
             },
  '+0330' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Tehran'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '283982400',
                          [
                            'Asia/Tehran'
                          ]
                        ]
                      ]
             },
  '-1040' => {
               'N' => [
                        [
                          '0',
                          [
                            'Pacific/Kiritimati'
                          ]
                        ]
                      ]
             },
  '+0545' => {
               'N' => [
                        [
                          '504901800',
                          [
                            'Asia/Kathmandu'
                          ]
                        ]
                      ]
             },
  '-0430' => {
               'N' => [
                        [
                          '1197183600',
                          [
                            'America/Caracas'
                          ]
                        ]
                      ]
             },
  '+1000' => {
               'N' => [
                        [
                          '0',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Pacific/Port_Moresby',
                            'Pacific/Guam',
                            'Pacific/Chuuk',
                            'Australia/Lord_Howe',
                            'Australia/Currie',
                            'Antarctica/DumontDUrville',
                            'Australia/Lindeman',
                            'Etc/GMT+10',
                            'Pacific/Saipan'
                          ]
                        ],
                        [
                          '31500000',
                          [
                            'Pacific/Port_Moresby',
                            'Pacific/Guam',
                            'Pacific/Chuuk',
                            'Australia/Lord_Howe',
                            'Australia/Currie',
                            'Antarctica/DumontDUrville',
                            'Etc/GMT+10',
                            'Pacific/Saipan'
                          ]
                        ],
                        [
                          '47138400',
                          [
                            'Pacific/Port_Moresby',
                            'Pacific/Guam',
                            'Pacific/Chuuk',
                            'Australia/Lord_Howe',
                            'Antarctica/DumontDUrville',
                            'Etc/GMT+10',
                            'Pacific/Saipan'
                          ]
                        ],
                        [
                          '352216800',
                          [
                            'Pacific/Port_Moresby',
                            'Pacific/Guam',
                            'Pacific/Chuuk',
                            'Antarctica/DumontDUrville',
                            'Etc/GMT+10',
                            'Pacific/Saipan'
                          ]
                        ],
                        [
                          '1301158800',
                          [
                            'Pacific/Port_Moresby',
                            'Asia/Yakutsk',
                            'Pacific/Guam',
                            'Pacific/Chuuk',
                            'Antarctica/DumontDUrville',
                            'Etc/GMT+10',
                            'Pacific/Saipan'
                          ]
                        ],
                        [
                          '1315832400',
                          [
                            'Pacific/Port_Moresby',
                            'Asia/Yakutsk',
                            'Pacific/Guam',
                            'Pacific/Chuuk',
                            'Asia/Khandyga',
                            'Antarctica/DumontDUrville',
                            'Etc/GMT+10',
                            'Pacific/Saipan'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Asia/Vladivostok',
                            'Australia/Hobart',
                            'Antarctica/Macquarie'
                          ]
                        ],
                        [
                          '31500000',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Asia/Vladivostok',
                            'Australia/Hobart',
                            'Antarctica/Macquarie',
                            'Australia/Lindeman'
                          ]
                        ],
                        [
                          '47138400',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Asia/Vladivostok',
                            'Australia/Hobart',
                            'Australia/Currie',
                            'Antarctica/Macquarie',
                            'Australia/Lindeman'
                          ]
                        ],
                        [
                          '670345200',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Asia/Sakhalin',
                            'Asia/Vladivostok',
                            'Australia/Hobart',
                            'Asia/Magadan',
                            'Asia/Ust-Nera',
                            'Australia/Currie',
                            'Antarctica/Macquarie',
                            'Australia/Lindeman'
                          ]
                        ],
                        [
                          '670348800',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Asia/Sakhalin',
                            'Australia/Hobart',
                            'Asia/Magadan',
                            'Asia/Ust-Nera',
                            'Australia/Currie',
                            'Antarctica/Macquarie',
                            'Australia/Lindeman'
                          ]
                        ],
                        [
                          '695750400',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Australia/Hobart',
                            'Australia/Currie',
                            'Antarctica/Macquarie',
                            'Australia/Lindeman'
                          ]
                        ],
                        [
                          '695754000',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Asia/Vladivostok',
                            'Australia/Hobart',
                            'Australia/Currie',
                            'Antarctica/Macquarie',
                            'Australia/Lindeman'
                          ]
                        ],
                        [
                          '859647600',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Asia/Sakhalin',
                            'Asia/Vladivostok',
                            'Australia/Hobart',
                            'Australia/Currie',
                            'Antarctica/Macquarie',
                            'Australia/Lindeman'
                          ]
                        ],
                        [
                          '1072882800',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Asia/Sakhalin',
                            'Asia/Vladivostok',
                            'Australia/Hobart',
                            'Asia/Khandyga',
                            'Australia/Currie',
                            'Antarctica/Macquarie',
                            'Australia/Lindeman'
                          ]
                        ],
                        [
                          '1270314000',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Asia/Sakhalin',
                            'Asia/Vladivostok',
                            'Australia/Hobart',
                            'Asia/Khandyga',
                            'Australia/Currie',
                            'Australia/Lindeman'
                          ]
                        ],
                        [
                          '1301155200',
                          [
                            'Australia/Sydney',
                            'Australia/Melbourne',
                            'Australia/Brisbane',
                            'Australia/Hobart',
                            'Australia/Currie',
                            'Australia/Lindeman'
                          ]
                        ]
                      ]
             },
  '+0000' => {
               'N' => [
                        [
                          '0',
                          [
                            'Africa/Abidjan',
                            'Africa/Dakar',
                            'Africa/Accra',
                            'Africa/Bamako',
                            'Africa/Conakry',
                            'Africa/Ouagadougou',
                            'Africa/Lome',
                            'Africa/Nouakchott',
                            'Africa/Freetown',
                            'Africa/Sao_Tome',
                            'Atlantic/Reykjavik',
                            'Atlantic/Faroe',
                            'Africa/Banjul',
                            'Atlantic/St_Helena',
                            'Antarctica/Rothera',
                            'Atlantic/Canary',
                            'Etc/UTC'
                          ]
                        ],
                        [
                          '73529070',
                          [
                            'Africa/Abidjan',
                            'Africa/Dakar',
                            'Africa/Accra',
                            'Africa/Bamako',
                            'Africa/Conakry',
                            'Africa/Ouagadougou',
                            'Africa/Monrovia',
                            'Africa/Lome',
                            'Africa/Nouakchott',
                            'Africa/Freetown',
                            'Africa/Sao_Tome',
                            'Atlantic/Reykjavik',
                            'Atlantic/Faroe',
                            'Africa/Banjul',
                            'Atlantic/St_Helena',
                            'Antarctica/Rothera',
                            'Atlantic/Canary',
                            'Etc/UTC'
                          ]
                        ],
                        [
                          '157770000',
                          [
                            'Africa/Abidjan',
                            'Africa/Dakar',
                            'Africa/Accra',
                            'Africa/Bamako',
                            'Africa/Conakry',
                            'Africa/Ouagadougou',
                            'Africa/Monrovia',
                            'Africa/Lome',
                            'Africa/Nouakchott',
                            'Africa/Freetown',
                            'Africa/Sao_Tome',
                            'Atlantic/Reykjavik',
                            'Atlantic/Faroe',
                            'Africa/Banjul',
                            'Atlantic/St_Helena',
                            'Africa/Bissau',
                            'Antarctica/Rothera',
                            'Atlantic/Canary',
                            'Etc/UTC'
                          ]
                        ],
                        [
                          '218246400',
                          [
                            'Africa/Abidjan',
                            'Africa/Dakar',
                            'Africa/Accra',
                            'Africa/Bamako',
                            'Africa/Conakry',
                            'Africa/Ouagadougou',
                            'Africa/Monrovia',
                            'Africa/Lome',
                            'Africa/Nouakchott',
                            'Africa/Freetown',
                            'Africa/Sao_Tome',
                            'Atlantic/Reykjavik',
                            'Atlantic/Faroe',
                            'Africa/Banjul',
                            'Atlantic/St_Helena',
                            'Africa/Bissau',
                            'Atlantic/Canary',
                            'Etc/UTC'
                          ]
                        ],
                        [
                          '338947200',
                          [
                            'Africa/Abidjan',
                            'Africa/Dakar',
                            'Africa/Accra',
                            'Africa/Bamako',
                            'Africa/Conakry',
                            'Africa/Ouagadougou',
                            'Africa/Monrovia',
                            'Africa/Lome',
                            'Africa/Nouakchott',
                            'Africa/Freetown',
                            'Africa/Sao_Tome',
                            'Atlantic/Reykjavik',
                            'Atlantic/Faroe',
                            'Africa/Banjul',
                            'Atlantic/St_Helena',
                            'Africa/Bissau',
                            'Etc/UTC'
                          ]
                        ],
                        [
                          '347155200',
                          [
                            'Africa/Abidjan',
                            'Africa/Dakar',
                            'Africa/Accra',
                            'Africa/Bamako',
                            'Africa/Conakry',
                            'Africa/Ouagadougou',
                            'Africa/Monrovia',
                            'Africa/Lome',
                            'Africa/Nouakchott',
                            'Africa/Freetown',
                            'Africa/Sao_Tome',
                            'Atlantic/Reykjavik',
                            'Africa/Banjul',
                            'Atlantic/St_Helena',
                            'Africa/Bissau',
                            'Etc/UTC'
                          ]
                        ],
                        [
                          '820465200',
                          [
                            'Africa/Abidjan',
                            'Africa/Dakar',
                            'Africa/Accra',
                            'Africa/Bamako',
                            'Africa/Conakry',
                            'Africa/Ouagadougou',
                            'Africa/Monrovia',
                            'Africa/Lome',
                            'Africa/Nouakchott',
                            'Africa/Freetown',
                            'Africa/Sao_Tome',
                            'Atlantic/Reykjavik',
                            'Africa/Banjul',
                            'Atlantic/St_Helena',
                            'Africa/Bissau',
                            'America/Danmarkshavn',
                            'Etc/UTC'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'Africa/Casablanca',
                            'Africa/Algiers',
                            'Atlantic/Madeira',
                            'Africa/Ceuta'
                          ]
                        ],
                        [
                          '57722400',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Africa/Algiers',
                            'Europe/Dublin',
                            'Atlantic/Madeira',
                            'Africa/Ceuta'
                          ]
                        ],
                        [
                          '198291600',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Africa/Algiers',
                            'Europe/Dublin',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Africa/Ceuta'
                          ]
                        ],
                        [
                          '212544000',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Africa/Algiers',
                            'Europe/Dublin',
                            'Europe/Lisbon',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Africa/Ceuta'
                          ]
                        ],
                        [
                          '246240000',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Europe/Dublin',
                            'Europe/Lisbon',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Africa/Ceuta'
                          ]
                        ],
                        [
                          '309740400',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Africa/Algiers',
                            'Europe/Dublin',
                            'Europe/Lisbon',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Africa/Ceuta'
                          ]
                        ],
                        [
                          '338947200',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Africa/Algiers',
                            'Europe/Dublin',
                            'Europe/Lisbon',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Africa/Ceuta',
                            'Atlantic/Canary'
                          ]
                        ],
                        [
                          '347155200',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Africa/Algiers',
                            'Europe/Dublin',
                            'Europe/Lisbon',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Africa/Ceuta',
                            'Atlantic/Faroe',
                            'Atlantic/Canary'
                          ]
                        ],
                        [
                          '357523200',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Europe/Dublin',
                            'Europe/Lisbon',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Africa/Ceuta',
                            'Atlantic/Faroe',
                            'Atlantic/Canary'
                          ]
                        ],
                        [
                          '448243200',
                          [
                            'Europe/London',
                            'Europe/Dublin',
                            'Europe/Lisbon',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Atlantic/Faroe',
                            'Atlantic/Canary'
                          ]
                        ],
                        [
                          '504918000',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Europe/Dublin',
                            'Europe/Lisbon',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Atlantic/Faroe',
                            'Atlantic/Canary'
                          ]
                        ],
                        [
                          '717555600',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Europe/Dublin',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Atlantic/Faroe',
                            'Atlantic/Canary'
                          ]
                        ],
                        [
                          '717559200',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Europe/Dublin',
                            'Atlantic/Azores',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Atlantic/Faroe',
                            'Atlantic/Canary'
                          ]
                        ],
                        [
                          '733280400',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Europe/Dublin',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Atlantic/Faroe',
                            'Atlantic/Canary'
                          ]
                        ],
                        [
                          '828234000',
                          [
                            'Europe/London',
                            'Africa/Casablanca',
                            'Europe/Dublin',
                            'Europe/Lisbon',
                            'Atlantic/Madeira',
                            'Africa/El_Aaiun',
                            'Atlantic/Faroe',
                            'Atlantic/Canary'
                          ]
                        ]
                      ]
             },
  '-0500' => {
               'N' => [
                        [
                          '0',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Detroit',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Menominee',
                            'America/Atikokan',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '31554000',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Detroit',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Menominee',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '94712400',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Thunder_Bay',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Menominee',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '104914800',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Thunder_Bay',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '105084000',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Managua',
                            'America/Indiana/Indianapolis',
                            'America/Thunder_Bay',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '126248400',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Managua',
                            'America/Indiana/Indianapolis',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '136364400',
                          [
                            'America/Panama',
                            'America/Guayaquil',
                            'America/Managua',
                            'America/Indiana/Indianapolis',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '157784400',
                          [
                            'America/Panama',
                            'America/Guayaquil',
                            'America/Managua',
                            'America/Indiana/Indianapolis',
                            'America/Detroit',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '161758800',
                          [
                            'America/Panama',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Detroit',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '167814000',
                          [
                            'America/Panama',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '189320400',
                          [
                            'America/Panama',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '247046400',
                          [
                            'America/Panama',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '377935200',
                          [
                            'America/Panama',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Merida',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '407653200',
                          [
                            'America/Panama',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '441781200',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Cayman',
                            'Pacific/Galapagos',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '504939600',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Cayman',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '590043600',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '688550400',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '694260000',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Managua',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '717310800',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '725868000',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Managua',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '749192400',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Managua',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '780210000',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Managua',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '852094800',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '972806400',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Rankin_Inlet',
                            'America/Indiana/Vevay',
                            'America/Cambridge_Bay',
                            'America/Indiana/Marengo',
                            'America/Resolute',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '973400400',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Rankin_Inlet',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'America/Resolute',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '986112000',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Indiana/Indianapolis',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Indiana/Marengo',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '1136091600',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Indiana/Tell_City',
                            'America/Atikokan',
                            'America/Indiana/Knox',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '1143961200',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Atikokan',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '1162108800',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Atikokan',
                            'America/Resolute',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '1173600000',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Atikokan',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '1214283600',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Cayman',
                            'America/Atikokan',
                            'Etc/GMT-5'
                          ]
                        ],
                        [
                          '1384056000',
                          [
                            'America/Panama',
                            'America/Jamaica',
                            'America/Guayaquil',
                            'America/Rio_Branco',
                            'America/Cayman',
                            'America/Eirunepe',
                            'America/Atikokan',
                            'Etc/GMT-5'
                          ]
                        ]
                      ],
               'Y' => [
                        [
                          '0',
                          [
                            'America/New_York',
                            'America/Santo_Domingo',
                            'America/Port-au-Prince',
                            'America/Indiana/Indianapolis',
                            'America/Kentucky/Louisville',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Indiana/Vincennes',
                            'America/Bogota',
                            'America/Indiana/Tell_City',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Indiana/Marengo',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '31554000',
                          [
                            'America/New_York',
                            'America/Santo_Domingo',
                            'America/Port-au-Prince',
                            'America/Kentucky/Louisville',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Indiana/Vevay',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Indiana/Marengo',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '94712400',
                          [
                            'America/New_York',
                            'America/Santo_Domingo',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Rio_Branco',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Indiana/Marengo',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '126248400',
                          [
                            'America/New_York',
                            'America/Santo_Domingo',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Indiana/Marengo',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '126687600',
                          [
                            'America/New_York',
                            'America/Santo_Domingo',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '136364400',
                          [
                            'America/New_York',
                            'America/Jamaica',
                            'America/Santo_Domingo',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '152082000',
                          [
                            'America/New_York',
                            'America/Jamaica',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '152092800',
                          [
                            'America/New_York',
                            'America/Jamaica',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Indiana/Marengo',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '157784400',
                          [
                            'America/New_York',
                            'America/Jamaica',
                            'America/Port-au-Prince',
                            'America/Kentucky/Louisville',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Indiana/Marengo',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '167814000',
                          [
                            'America/New_York',
                            'America/Jamaica',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Indiana/Marengo',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '189320400',
                          [
                            'America/New_York',
                            'America/Jamaica',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '377935200',
                          [
                            'America/New_York',
                            'America/Jamaica',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Cancun',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '441781200',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Cancun',
                            'America/Rio_Branco',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '590043600',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Cancun',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '749192400',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Cancun',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Eirunepe',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '780210000',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Cancun',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '796802400',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Cancun',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Pangnirtung',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '902041200',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Bogota',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Pangnirtung',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '941353200',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Bogota',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '972799200',
                          [
                            'America/New_York',
                            'America/Santo_Domingo',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Bogota',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '972806400',
                          [
                            'America/New_York',
                            'America/Santo_Domingo',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Bogota',
                            'America/Kentucky/Monticello',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Pangnirtung',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '975823200',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Bogota',
                            'America/Kentucky/Monticello',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Nipigon',
                            'America/Pangnirtung',
                            'America/Nassau',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '1136091600',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Indiana/Indianapolis',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Bogota',
                            'America/Kentucky/Monticello',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Indiana/Vevay',
                            'America/Nipigon',
                            'America/Pangnirtung',
                            'America/Nassau',
                            'America/Indiana/Marengo',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '1173600000',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Indiana/Indianapolis',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Bogota',
                            'America/Kentucky/Monticello',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Indiana/Winamac',
                            'America/Indiana/Vevay',
                            'America/Nipigon',
                            'America/Pangnirtung',
                            'America/Nassau',
                            'America/Indiana/Marengo',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ],
                        [
                          '1194163200',
                          [
                            'America/New_York',
                            'America/Port-au-Prince',
                            'America/Indiana/Indianapolis',
                            'America/Detroit',
                            'America/Kentucky/Louisville',
                            'America/Thunder_Bay',
                            'America/Lima',
                            'America/Indiana/Vincennes',
                            'America/Bogota',
                            'America/Kentucky/Monticello',
                            'America/Iqaluit',
                            'America/Toronto',
                            'America/Havana',
                            'America/Indiana/Winamac',
                            'America/Indiana/Petersburg',
                            'America/Indiana/Vevay',
                            'America/Nipigon',
                            'America/Pangnirtung',
                            'America/Nassau',
                            'America/Indiana/Marengo',
                            'America/Montreal',
                            'America/Grand_Turk'
                          ]
                        ]
                      ]
             },
  '+0630' => {
               'N' => [
                        [
                          '0',
                          [
                            'Asia/Rangoon',
                            'Indian/Cocos'
                          ]
                        ],
                        [
                          '832962600',
                          [
                            'Asia/Rangoon',
                            'Asia/Colombo',
                            'Indian/Cocos'
                          ]
                        ],
                        [
                          '846266400',
                          [
                            'Asia/Rangoon',
                            'Indian/Cocos'
                          ]
                        ]
                      ]
             }
}
;

#
# This list is copied from:
#   AjaxApp/API/Mailbox.pm
#   http://wiki.zimbra.com/wiki/Time_Zones_in_ZCS
#

our %OtherLinks = (
  'AUS Central Standard Time'                                         => 'Australia/Darwin',
  'AUS Central'                                                       => 'Australia/Darwin',
  'AUS Eastern Standard Time'                                         => 'Australia/Sydney',
  'AUS Eastern'                                                       => 'Australia/Sydney',
  'Afghanistan Standard Time'                                         => 'Asia/Kabul',
  'Afghanistan'                                                       => 'Asia/Kabul',
  'Alaskan Standard Time'                                             => 'America/Anchorage',
  'Alaskan'                                                           => 'America/Anchorage',
  'Arab Standard Time'                                                => 'Asia/Riyadh',
  'Arab'                                                              => 'Asia/Riyadh',
  'Arabian Standard Time'                                             => 'Asia/Muscat',
  'Arabian'                                                           => 'Asia/Muscat',
  'Arabic Standard Time'                                              => 'Asia/Baghdad',
  'Argentina Standard Time'                                           => 'America/Argentina/Buenos_Aires',
  'Armenian Standard Time'                                            => 'Asia/Yerevan',
  'Atlantic Standard Time'                                            => 'America/Halifax',
  'Atlantic'                                                          => 'America/Halifax',
  'Azerbaijan Standard Time'                                          => 'Asia/Baku',
  'Azores Standard Time'                                              => 'Atlantic/Azores',
  'Azores'                                                            => 'Atlantic/Azores',
  'Bangkok Standard Time'                                             => 'Asia/Bangkok',
  'Bangkok'                                                           => 'Asia/Bangkok',
  'Bangladesh Standard Time'                                          => 'Asia/Dhaka',
  'Beijing'                                                           => 'Asia/Shanghai',
  'Canada Central Standard Time'                                      => 'America/Regina',
  'Canada Central'                                                    => 'America/Regina',
  'Cape Verde Standard Time'                                          => 'Atlantic/Cape_Verde',
  'Caucasus Standard Time'                                            => 'Asia/Yerevan',
  'Caucasus'                                                          => 'Asia/Yerevan',
  'Cen. Australia Standard Time'                                      => 'Australia/Adelaide',
  'Cen. Australia'                                                    => 'Australia/Adelaide',
  'Central America Standard Time'                                     => 'America/Regina',
  'Central Asia Standard Time'                                        => 'Asia/Almaty',
  'Central Asia'                                                      => 'Asia/Almaty',
  'Central Brazilian Standard Time'                                   => 'America/Cuiaba',
  'Central Europe Standard Time'                                      => 'Europe/Prague',
  'Central Europe'                                                    => 'Europe/Prague',
  'Central European Standard Time'                                    => 'Europe/Belgrade',
  'Central European'                                                  => 'Europe/Belgrade',
  'Central Pacific Standard Time'                                     => 'Pacific/Guadalcanal',
  'Central Pacific'                                                   => 'Pacific/Guadalcanal',
  'Central Standard Time (Mexico)'                                    => 'America/Mexico_City',
  'Central Standard Time'                                             => 'America/Chicago',
  'Central'                                                           => 'America/Chicago',
  'China Standard Time'                                               => 'Asia/Shanghai',
  'China'                                                             => 'Asia/Shanghai',
  'E. Africa Standard Time'                                           => 'Africa/Nairobi',
  'E. Africa'                                                         => 'Africa/Nairobi',
  'E. Australia Standard Time'                                        => 'Australia/Brisbane',
  'E. Australia'                                                      => 'Australia/Brisbane',
  'E. Europe Standard Time'                                           => 'Europe/Minsk',
  'E. Europe'                                                         => 'Europe/Minsk',
  'E. South America Standard Time'                                    => 'America/Sao_Paulo',
  'E. South America'                                                  => 'America/Sao_Paulo',
  'Eastern Standard Time'                                             => 'America/New_York',
  'Eastern'                                                           => 'America/New_York',
  'Egypt Standard Time'                                               => 'Africa/Cairo',
  'Egypt'                                                             => 'Africa/Cairo',
  'Ekaterinburg Standard Time'                                        => 'Asia/Yekaterinburg',
  'Ekaterinburg'                                                      => 'Asia/Yekaterinburg',
  'FLE Standard Time'                                                 => 'Europe/Helsinki',
  'FLE'                                                               => 'Europe/Helsinki',
  'Fiji Standard Time'                                                => 'Pacific/Fiji',
  'Fiji'                                                              => 'Pacific/Fiji',
  'GFT Standard Time'                                                 => 'Europe/Athens',
  'GFT'                                                               => 'Europe/Athens',
  'GMT Standard Time'                                                 => 'Europe/London',
  'GMT'                                                               => 'Europe/London',
  'GTB Standard Time'                                                 => 'Europe/Athens',
  'GTB'                                                               => 'Europe/Athens',
  'Georgian Standard Time'                                            => 'Asia/Tbilisi',
  'Greenland Standard Time'                                           => 'America/Godthab',
  'Hawaiian Standard Time'                                            => 'Pacific/Honolulu',
  'Hawaiian'                                                          => 'Pacific/Honolulu',
  'India Standard Time'                                               => 'Asia/Calcutta',
  'India'                                                             => 'Asia/Calcutta',
  'Iran Standard Time'                                                => 'Asia/Tehran',
  'Iran'                                                              => 'Asia/Tehran',
  'Israel Standard Time'                                              => 'Asia/Jerusalem',
  'Israel'                                                            => 'Asia/Jerusalem',
  'Jordan Standard Time'                                              => 'Asia/Amman',
  'Kamchatka Standard Time'                                           => 'Asia/Kamchatka',
  'Korea Standard Time'                                               => 'Asia/Seoul',
  'Korea'                                                             => 'Asia/Seoul',
  'Magadan Standard Time'                                             => 'Asia/Magadan',
  'Mauritius Standard Time'                                           => 'Indian/Mauritius',
  'Mexico Standard Time 2'                                            => 'America/Chihuahua',
  'Mexico Standard Time'                                              => 'America/Mexico_City',
  'Mexico'                                                            => 'America/Mexico_City',
  'Mid-Atlantic Standard Time'                                        => 'Atlantic/South_Georgia',
  'Mid-Atlantic'                                                      => 'Atlantic/South_Georgia',
  'Middle East Standard Time'                                         => 'Asia/Beirut',
  'Montevideo Standard Time'                                          => 'America/Montevideo',
  'Morocco Standard Time'                                             => 'Africa/Casablanca',
  'Mountain Standard Time (Mexico)'                                   => 'America/Chihuahua',
  'Mountain Standard Time'                                            => 'America/Denver',
  'Mountain'                                                          => 'America/Denver',
  'Myanmar Standard Time'                                             => 'Asia/Rangoon',
  'N. Central Asia Standard Time'                                     => 'Asia/Novosibirsk',
  'Namibia Standard Time'                                             => 'Africa/Windhoek',
  'Nepal Standard Time'                                               => 'Asia/Katmandu',
  'New Zealand Standard Time'                                         => 'Pacific/Auckland',
  'New Zealand'                                                       => 'Pacific/Auckland',
  'Newfoundland Standard Time'                                        => 'America/St_Johns',
  'Newfoundland'                                                      => 'America/St_Johns',
  'North Asia East Standard Time'                                     => 'Asia/Irkutsk',
  'North Asia Standard Time'                                          => 'Asia/Krasnoyarsk',
  'Pacific SA Standard Time'                                          => 'America/Santiago',
  'Pacific SA'                                                        => 'America/Santiago',
  'Pacific Standard Time (Mexico)'                                    => 'America/Tijuana',
  'Pacific Standard Time'                                             => 'America/Los_Angeles',
  'Pacific'                                                           => 'America/Los_Angeles',
  'Pakistan Standard Time'                                            => 'Asia/Karachi',
  'Paraguay Standard Time'                                            => 'America/Asuncion',
  'Prague Bratislava'                                                 => 'Europe/Prague',
  'Romance Standard Time'                                             => 'Europe/Paris',
  'Romance'                                                           => 'Europe/Paris',
  'Russian Standard Time'                                             => 'Europe/Moscow',
  'Russian'                                                           => 'Europe/Moscow',
  'SA Eastern Standard Time'                                          => 'America/Cayenne',
  'SA Eastern'                                                        => 'America/Cayenne',
  'SA Pacific Standard Time'                                          => 'America/Bogota',
  'SA Pacific'                                                        => 'America/Bogota',
  'SA Western Standard Time'                                          => 'America/Guyana',
  'SA Western'                                                        => 'America/Guyana',
  'SE Asia Standard Time'                                             => 'Asia/Bangkok',
  'SE Asia'                                                           => 'Asia/Bangkok',
  'Samoa Standard Time'                                               => 'Pacific/Apia',
  'Samoa'                                                             => 'Pacific/Apia',
  'Saudi Arabia Standard Time'                                        => 'Asia/Riyadh',
  'Saudi Arabia'                                                      => 'Asia/Riyadh',
  'Singapore Standard Time'                                           => 'Asia/Singapore',
  'Singapore'                                                         => 'Asia/Singapore',
  'South Africa Standard Time'                                        => 'Africa/Harare',
  'South Africa'                                                      => 'Africa/Harare',
  'Sri Lanka Standard Time'                                           => 'Asia/Colombo',
  'Sri Lanka'                                                         => 'Asia/Colombo',
  'Sydney Standard Time'                                              => 'Australia/Sydney',
  'Syria Standard Time'                                               => 'Asia/Damascus',
  'Taipei Standard Time'                                              => 'Asia/Taipei',
  'Taipei'                                                            => 'Asia/Taipei',
  'Tasmania Standard Time'                                            => 'Australia/Hobart',
  'Tasmania'                                                          => 'Australia/Hobart',
  'Tokyo Standard Time'                                               => 'Asia/Tokyo',
  'Tokyo'                                                             => 'Asia/Tokyo',
  'Tonga Standard Time'                                               => 'Pacific/Tongatapu',
  'US Eastern Standard Time'                                          => 'America/Indianapolis',
  'US Eastern'                                                        => 'America/Indianapolis',
  'US Mountain Standard Time'                                         => 'America/Phoenix',
  'US Mountain'                                                       => 'America/Phoenix',
  'US-Alaskan'                                                        => 'America/Anchorage',
  'US-Arizona'                                                        => 'America/Phoenix',
  'US-Central'                                                        => 'America/Chicago',
  'US-Eastern'                                                        => 'America/New_York',
  'US-Mountain'                                                       => 'America/Denver',
  'US-Pacific'                                                        => 'America/Los_Angeles',
  'US/Alaskan'                                                        => 'America/Anchorage',
  'US/Arizona'                                                        => 'America/Phoenix',
  'US/Central'                                                        => 'America/Chicago',
  'US/Eastern'                                                        => 'America/New_York',
  'US/Mountain'                                                       => 'America/Denver',
  'US/Pacific'                                                        => 'America/Los_Angeles',
  'Ulaanbaatar Standard Time'                                         => 'Asia/Ulaanbaatar',
  'Venezuela Standard Time'                                           => 'America/Caracas',
  'Vladivostok Standard Time'                                         => 'Asia/Vladivostok',
  'Vladivostok'                                                       => 'Asia/Vladivostok',
  'W. Australia Standard Time'                                        => 'Australia/Perth',
  'W. Australia'                                                      => 'Australia/Perth',
  'W. Central Africa Standard Time'                                   => 'Africa/Luanda',
  'W. Europe Standard Time'                                           => 'Europe/Berlin',
  'W. Europe'                                                         => 'Europe/Berlin',
  'Warsaw'                                                            => 'Europe/Warsaw',
  'West Asia Standard Time'                                           => 'Asia/Karachi',
  'West Asia'                                                         => 'Asia/Karachi',
  'West Pacific Standard Time'                                        => 'Pacific/Guam',
  'West Pacific'                                                      => 'Pacific/Guam',
  'Western Brazilian Standard Time'                                   => 'America/Rio_Branco',
  'Yakutsk Standard Time'                                             => 'Asia/Yakutsk',
  'Yakutsk'                                                           => 'Asia/Yakutsk',
  '(GMT-12.00) International Date Line West'                          => 'Etc/GMT-12',
  '(GMT-11.00) Midway Island / Samoa'                                 => 'Pacific/Midway',
  '(GMT-10.00) Hawaii'                                                => 'Pacific/Honolulu',
  '(GMT-09.00) Alaska'                                                => 'America/Anchorage',
  '(GMT-08.00) Pacific Time (US & Canada)'                            => 'America/Los_Angeles',
  '(GMT-08.00) Tijuana / Baja California'                             => 'America/Tijuana',
  '(GMT-07.00) Arizona'                                               => 'America/Phoenix',
  '(GMT-07.00) Chihuahua / La Paz / Mazatlan - New'                   => 'America/Chihuahua',
  '(GMT-07.00) Chihuahua / La Paz / Mazatlan - Old'                   => 'America/Chihuahua',
  '(GMT-07.00) Mountain Time (US & Canada)'                           => 'America/Denver',
  '(GMT-06.00) Central America'                                       => 'America/Chicago',
  '(GMT-06.00) Central Time (US & Canada)'                            => 'America/Chicago',
  '(GMT-06.00) Guadalajara / Mexico City / Monterrey - New'           => 'America/Mexico_City',
  '(GMT-06.00) Guadalajara / Mexico City / Monterrey - Old'           => 'America/Mexico_City',
  '(GMT-06.00) Saskatchewan'                                          => 'America/Belize',
  '(GMT-05.00) Bogota / Lima / Quito / Rio Branco'                    => 'America/Bogota',
  '(GMT-05.00) Eastern Time (US & Canada)'                            => 'America/New_York',
  '(GMT-05.00) Indiana (East)'                                        => 'America/Indiana/Indianapolis',
  '(GMT-04.00) Atlantic Time (Canada)'                                => 'America/Glace_Bay',
  '(GMT-04.00) Caracas / La Paz'                                      => 'America/Caracas',
  '(GMT-04.00) Manaus'                                                => 'America/Manaus',
  '(GMT-04.00) Santiago'                                              => 'America/Santiago',
  '(GMT-03.30) Newfoundland'                                          => 'America/St_Johns',
  '(GMT-03.00) Brasilia'                                              => 'America/Sao_Paulo',
  '(GMT-03.00) Buenos Aires / Georgetown'                             => 'America/Argentina/Buenos_Aires',
  '(GMT-03.00) Greenland'                                             => 'America/Godthab',
  '(GMT-03.00) Montevideo'                                            => 'America/Montevideo',
  '(GMT-02.00) Mid-Atlantic'                                          => 'America/Noronha',
  '(GMT-01.00) Azores'                                                => 'Atlantic/Azores',
  '(GMT-01.00) Cape Verde Is.'                                        => 'Atlantic/Cape_Verde',
  '(GMT) Casablanca / Monrovia / Reykjavik'                           => 'Africa/Casablanca',
  '(GMT) Greenwich Mean Time - Dublin / Edinburgh / Lisbon / London'  => 'Etc/UTC',
  '(GMT+01.00) Amsterdam / Berlin / Bern / Rome / Stockholm / Vienna' => 'Europe/Amsterdam',
  '(GMT+01.00) Belgrade / Bratislava / Budapest / Ljubljana / Prague' => 'Europe/Belgrade',
  '(GMT+01.00) Brussels / Copenhagen / Madrid / Paris'                => 'Europe/Brussels',
  '(GMT+01.00) Sarajevo / Skopje / Warsaw / Zagreb'                   => 'Europe/Warsaw',
  '(GMT+01.00) West Central Africa'                                   => 'Africa/Algiers',
  '(GMT+02.00) Amman'                                                 => 'Asia/Amman',
  '(GMT+02.00) Athens / Bucharest / Istanbul'                         => 'Europe/Athens',
  '(GMT+02.00) Beirut'                                                => 'Asia/Beirut',
  '(GMT+02.00) Cairo'                                                 => 'Africa/Cairo',
  '(GMT+02.00) Harare / Pretoria'                                     => 'Africa/Harare',
  '(GMT+02.00) Helsinki / Kyiv / Riga / Sofia / Tallinn / Vilnius'    => 'Europe/Helsinki',
  '(GMT+02.00) Jerusalem'                                             => 'Asia/Jerusalem',
  '(GMT+02.00) Minsk'                                                 => 'Europe/Minsk',
  '(GMT+02.00) Windhoek'                                              => 'Africa/Windhoek',
  '(GMT+03.00) Baghdad'                                               => 'Asia/Baghdad',
  '(GMT+03.00) Kuwait / Riyadh'                                       => 'Asia/Kuwait',
  '(GMT+03.00) Moscow / St. Petersburg / Volgograd'                   => 'Europe/Moscow',
  '(GMT+03.00) Nairobi'                                               => 'Africa/Nairobi',
  '(GMT+03.00) Tbilisi'                                               => 'Asia/Tbilisi',
  '(GMT+03.30) Tehran'                                                => 'Asia/Tehran',
  '(GMT+04.00) Abu Dhabi / Muscat'                                    => 'Asia/Dubai',
  '(GMT+04.00) Baku'                                                  => 'Asia/Baku',
  '(GMT+04.00) Yerevan'                                               => 'Asia/Yerevan',
  '(GMT+04.30) Kabul'                                                 => 'Asia/Kabul',
  '(GMT+05.00) Ekaterinburg'                                          => 'Asia/Yekaterinburg',
  '(GMT+05.00) Islamabad / Karachi / Tashkent'                        => 'Asia/Karachi',
  '(GMT+05.30) Chennai / Kolkata / Mumbai / New Delhi'                => 'Asia/Kolkata',
  '(GMT+05.30) Sri Jayawardenepura'                                   => 'Asia/Colombo',
  '(GMT+05.45) Kathmandu'                                             => 'Asia/Kathmandu',
  '(GMT+06.00) Almaty / Novosibirsk'                                  => 'Asia/Almaty',
  '(GMT+06.00) Astana / Dhaka'                                        => 'Asia/Dhaka',
  '(GMT+06.30) Yangon (Rangoon)'                                      => 'Asia/Rangoon',
  '(GMT+07.00) Bangkok / Hanoi / Jakarta'                             => 'Asia/Bangkok',
  '(GMT+07.00) Krasnoyarsk'                                           => 'Asia/Krasnoyarsk',
  '(GMT+08.00) Beijing / Chongqing / Hong Kong / Urumqi'              => 'Asia/Shanghai',
  '(GMT+08.00) Irkutsk / Ulaan Bataar'                                => 'Asia/Irkutsk',
  '(GMT+08.00) Kuala Lumpur / Singapore'                              => 'Asia/Kuala_Lumpur',
  '(GMT+08.00) Perth'                                                 => 'Australia/Perth',
  '(GMT+08.00) Taipei'                                                => 'Asia/Taipei',
  '(GMT+09.00) Osaka / Sapporo / Tokyo'                               => 'Asia/Tokyo',
  '(GMT+09.00) Seoul'                                                 => 'Asia/Seoul',
  '(GMT+09.00) Yakutsk'                                               => 'Asia/Yakutsk',
  '(GMT+09.30) Adelaide'                                              => 'Australia/Adelaide',
  '(GMT+09.30) Darwin'                                                => 'Australia/Darwin',
  '(GMT+10.00) Brisbane'                                              => 'Australia/Brisbane',
  '(GMT+10.00) Canberra / Melbourne / Sydney'                         => 'Australia/Sydney',
  '(GMT+10.00) Guam / Port Moresby'                                   => 'Pacific/Guam',
  '(GMT+10.00) Hobart'                                                => 'Australia/Hobart',
  '(GMT+10.00) Vladivostok'                                           => 'Asia/Vladivostok',
  '(GMT+11.00) Magadan / Solomon Is. / New Caledonia'                 => 'Asia/Magadan',
  '(GMT+12.00) Auckland / Wellington'                                 => 'Pacific/Auckland',
  '(GMT+12.00) Fiji / Kamchatka / Marshall Is.'                       => 'Pacific/Fiji',
  "(GMT+13.00) Nuku'alofa"                                            => 'Pacific/Tongatapu',
);

our %OtherLinksReversed;

foreach my $OtherLink (keys %OtherLinks) {
  push @{$OtherLinksReversed{$OtherLinks{$OtherLink}}}, $OtherLink;
}

=head1 SUBROUTINES/METHODS

=head2 $Class->GetTimeZone(%Args)

Args:

   TZID - zone name
   StandardTzOffsetTo - offset

Pick the matching timezone with the highest population size to the offset
if the zone name isn't known.

Returns a DateTime::TimeZone object

=cut

sub GetTimeZone {
  my ($Class, %Args) = @_;

  # can we short circuit {{{

  if ($Args{TZID}) {
    my $Name = $OtherLinks{$Args{TZID}}
      ? $OtherLinks{$Args{TZID}}
      : $Args{TZID};

    my $TimeZone = eval {DateTime::TimeZone->new(name => $Name)};

    if ($TimeZone and $TimeZone->is_olson()) {
      return $TimeZone->name();
    }
  }

  return '' unless exists $Args{StandardTzOffsetTo};

  # }}}

  # get set of timezones for provided standard offset {{{

  my $Now    = DateTime->now()->strftime("%Y%m%dT%H%M%S");
  my $Time   = DateTime::Format::ISO8601->parse_datetime(($Args{Time} || $Now))->epoch();
  my $HasDST = $Args{DaylightTzOffsetTo} ? 'Y' : 'N';

  return '' unless exists $ZonesByOffset->{$Args{StandardTzOffsetTo}}{$HasDST};

  my @TimeZones;

  foreach my $Range (reverse @{$ZonesByOffset->{$Args{StandardTzOffsetTo}}{$HasDST}}) {
    if ($Range->[0] <= $Time) {
      @TimeZones = @{$Range->[1]};
      last;
    }
  }

  return '' unless @TimeZones;

  # }}}

  if ($Args{TZID} and ($Args{TZID} =~ /\w/)) {
    # try to match provided TZID with Olson timezones {{{

    my %TimeZoneEndings;

    foreach my $TimeZone (@TimeZones) {
      my (@TimeZoneParts) = split /[^a-z0-9\+\-\_]+/i, $TimeZone;
      $TimeZoneEndings{$TimeZoneParts[-1]} = $TimeZone;
    }

    my (@TZIDParts) = reverse split /[^a-z0-9\+\-\_]+/i, $Args{TZID};

    my %Distances;

    foreach my $TZIDPart (@TZIDParts) {
      foreach my $TimeZoneEnding (keys %TimeZoneEndings) {
        my $Distance = distance(lc($TZIDPart), lc($TimeZoneEnding));

        if ($Distance == 0) {
          return $TimeZoneEndings{$TimeZoneEnding};
        }

        my $MaxLength = (length($TZIDPart) > length($TimeZoneEnding))
          ? length($TZIDPart)
          : length($TimeZoneEnding);

        if ($Distance < int($MaxLength/2)) {
          $Distances{$Distance}{$TimeZoneEndings{$TimeZoneEnding}} = 1;
        }
      }
    }

    # }}}

    # try to match provided TZID with links {{{

    foreach my $TimeZone (@TimeZones) {
      next unless @{$OtherLinksReversed{$TimeZone} || []};

      foreach my $OtherLink (@{$OtherLinksReversed{$TimeZone}}) {
        my $Distance = distance(lc($Args{TZID}), lc($OtherLink));

        if ($Distance == 0) {
          return $TimeZone;
        }

        my $MaxLength = (length($Args{TZID}) > length($OtherLink))
          ? length($Args{TZID})
          : length($OtherLink);

        if ($Distance < int($MaxLength/2)) {
          $Distances{$Distance}{$TimeZone} = 1;
        }
      }
    }

    # }}}

    if (%Distances) {
      my ($Shortest) = sort { $a <=> $b } keys %Distances;

      # @TimeZones is sorted by population size, so in a tie, biggest population wins
      foreach my $TimeZone (@TimeZones) {
        return $TimeZone if $Distances{$Shortest}{$TimeZone};
      }
    }
  }

  # damn, let's fallback {{{

  my ($Etc) = grep { m{^Etc/} } @TimeZones;
  return $Etc if $Etc;

  # @TimeZones is sorted by population size
  return $TimeZones[0];

  # }}}
}

=head2 $Class->GetVTimeZone($TimeZone)

Returns a Data::ICal::TimeZone object for the named zone

=cut

sub GetVTimeZone {
  my ($Class, $TimeZone) = @_;

  return '' unless $TimeZone;
  return '' unless $RulesByZone->{$TimeZone};

  my $TZ = Data::ICal::TimeZone->new( timezone => $TimeZone );

  return $TZ->definition();
}

=head1 LICENSE AND COPYRIGHT

Copyright 2015 Bron Gondwana.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


=cut

1; # End of Net::CalDAVTalk::TimeZone
