package ZCS::Admin::Types::ArchiveSpecifier;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'urn:zimbraAdmin' };

our $XML_ATTRIBUTE_CLASS = 'ZCS::Admin::Types::ArchiveSpecifier::_ArchiveSpecifier::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %name_of :ATTR(:get<name>);
my %cos_of :ATTR(:get<cos>);
my %password_of :ATTR(:get<password>);
my %a_of :ATTR(:get<a>);

__PACKAGE__->_factory(
    [ qw(        name
        cos
        password
        a

    ) ],
    {
        'name' => \%name_of,
        'cos' => \%cos_of,
        'password' => \%password_of,
        'a' => \%a_of,
    },
    {
        'name' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'cos' => 'ZCS::Admin::Types::GetCosSpecifier',
        'password' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'a' => 'ZCS::Admin::Types::ItemAttribute',
    },
    {

        'name' => 'name',
        'cos' => 'cos',
        'password' => 'password',
        'a' => 'a',
    }
);

} # end BLOCK




package ZCS::Admin::Types::ArchiveSpecifier::_ArchiveSpecifier::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %create_of :ATTR(:get<create>);

__PACKAGE__->_factory(
    [ qw(
        create
    ) ],
    {

        create => \%create_of,
    },
    {
        create => 'ZCS::Admin::Types::IntBool',
    }
);

} # end BLOCK



1;


=pod

=head1 NAME

ZCS::Admin::Types::ArchiveSpecifier

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ArchiveSpecifier from the namespace urn:zimbraAdmin.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * name


=item * cos


=item * password


=item * a




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ZCS::Admin::Types::ArchiveSpecifier
   name =>  $some_value, # string
   cos =>  { value => $some_value },
   password =>  $some_value, # string
   a =>  { value => $some_value },
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ZCS::Admin::Types::ArchiveSpecifier::_ArchiveSpecifier::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * create



This attribute is of type L<ZCS::Admin::Types::IntBool|ZCS::Admin::Types::IntBool>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

