# Generated by default/object.tt
package Paws::SSMIncidents::ChatChannel;
  use Moose;
  has ChatbotSns => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'chatbotSns', traits => ['NameInRequest']);
  has Empty => (is => 'ro', isa => 'Paws::SSMIncidents::EmptyChatChannel', request_name => 'empty', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::ChatChannel

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::ChatChannel object:

  $service_obj->Method(Att1 => { ChatbotSns => $value, ..., Empty => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::ChatChannel object:

  $result = $service_obj->Method(...);
  $result->Att1->ChatbotSns

=head1 DESCRIPTION

The AWS Chatbot chat channel used for collaboration during an incident.

=head1 ATTRIBUTES


=head2 ChatbotSns => ArrayRef[Str|Undef]

The SNS targets that AWS Chatbot uses to notify the chat channel of
updates to an incident. You can also make updates to the incident
through the chat channel by using the SNS topics.


=head2 Empty => L<Paws::SSMIncidents::EmptyChatChannel>

Used to remove the chat channel from an incident record or response
plan.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

