/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.value.Whitespace;

public class XSLAttributeSet
extends StyleElement
implements StylesheetProcedure {
    private String nameAtt;
    private String useAtt;
    private SlotManager stackFrameMap;
    private List<Declaration> attributeSetElements = null;
    private AttributeSet[] useAttributeSets = null;
    private AttributeSet procedure = new AttributeSet();
    private int referenceCount = 0;
    private boolean validated = false;

    public boolean isDeclaration() {
        return true;
    }

    public StructuredQName getAttributeSetName() {
        return this.getObjectName();
    }

    public AttributeSet getInstruction() {
        return this.procedure;
    }

    public void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public void prepareAttributes() throws XPathException {
        this.useAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use-attribute-sets")) {
                this.useAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
            return;
        }
        try {
            this.setObjectName(this.makeQName(this.nameAtt));
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
        }
        catch (XPathException err) {
            this.compileError(err.getMessage(), err.getErrorCodeQName());
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
        }
    }

    public StructuredQName getObjectName() {
        StructuredQName o = super.getObjectName();
        if (o == null) {
            try {
                this.prepareAttributes();
                o = this.getObjectName();
            }
            catch (XPathException err) {
                o = new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-attribute-set");
                this.setObjectName(o);
            }
        }
        return o;
    }

    public void validate(Declaration decl) throws XPathException {
        Object child;
        if (this.validated) {
            return;
        }
        this.checkTopLevel("XTSE0010");
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLAttribute) continue;
            this.compileError("Only xsl:attribute is allowed within xsl:attribute-set", "XTSE0010");
        }
        if (this.useAtt != null) {
            this.attributeSetElements = new ArrayList<Declaration>(5);
            this.useAttributeSets = this.getAttributeSets(this.useAtt, this.attributeSetElements);
            for (Declaration attributeSetElement : this.attributeSetElements) {
                ((XSLAttributeSet)attributeSetElement.getSourceElement()).checkCircularity(this);
            }
        }
        this.validated = true;
    }

    public void checkCircularity(XSLAttributeSet origin) throws XPathException {
        if (this == origin) {
            this.compileError("The definition of the attribute set is circular", "XTSE0720");
            this.useAttributeSets = null;
        } else {
            if (!this.validated) {
                return;
            }
            if (this.attributeSetElements != null) {
                for (Declaration attributeSetElement : this.attributeSetElements) {
                    ((XSLAttributeSet)attributeSetElement.getSourceElement()).checkCircularity(origin);
                }
            }
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public void compileDeclaration(Executable exec, Declaration decl) throws XPathException {
        if (this.referenceCount > 0) {
            Expression body = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
            if (body == null) {
                body = Literal.makeEmptySequence();
            }
            try {
                ExpressionVisitor visitor = this.makeExpressionVisitor();
                body = visitor.simplify(body);
                if (this.getConfiguration().isCompileWithTracing()) {
                    body = XSLAttributeSet.makeTraceInstruction(this, body);
                }
                this.procedure.setUseAttributeSets(this.useAttributeSets);
                this.procedure.setName(this.getObjectName());
                this.procedure.setBody(body);
                this.procedure.setSystemId(this.getSystemId());
                this.procedure.setLineNumber(this.getLineNumber());
                this.procedure.setExecutable(exec);
                Expression exp2 = body.optimize(visitor, new ExpressionVisitor.ContextItemType(AnyItemType.getInstance(), true));
                if (body != exp2) {
                    this.procedure.setBody(exp2);
                    body = exp2;
                }
                super.allocateSlots(body);
                this.procedure.setStackFrameMap(this.stackFrameMap);
            }
            catch (XPathException e) {
                this.compileError(e);
            }
        }
    }

    public void optimize(Declaration declaration) throws XPathException {
    }

    public int getConstructType() {
        return 132;
    }
}

