# NAME

AnyEvent::Discord - Provides an AnyEvent interface to the Discord bot API

# SYNOPSIS

    use AnyEvent::Discord;
    my $client = AnyEvent::Discord->new({ token => 'mydiscordbottoken' });
    $client->on('ready', sub { warn 'Connected'; });
    $client->on('message_create', sub {
      my ($client, $data) = @_;
      warn '[' . $client->channels->{$data->{channel_id}} . '] (' . $data->{author}->{username} . ') - ' . $data->{content};
     });
     $client->connect();
     AnyEvent->condvar->recv;

# DESCRIPTION

This module provides an AnyEvent interface for the Discord API over the REST
and WebSocket APIs. It is designed to be somewhat similar to the SlackRTM and
XMPP modules, with a subset of their far more mature functionality.

# CONFIGURATION ACCESSORS

- token (String) (required)

    The token generated by the Discord Application portal, under Bot.

- base\_uri (String) (optional)

    The base URI for communicating with the Discord API.

- socket\_options (HashRef) (optional)

    Used to override options to sent to AnyEvent::WebSocket::Client, if needed.

- verbose (Num) (defaults to 0)

    Verbose output, writes internal debug information on 1, writes network messages
    on 2.

# DATA ACCESSORS

- guilds

    Available/created/seen guilds

- channels

    Available/created/seen channels

- users

    Available/created/seen users

# PUBLIC METHODS

- new(\\%arguments)

    Instantiate the AnyEvent::Discord client. The hashref of arguments matches the
    configuration accessors listed above. A common invocation looks like:

        my $client = AnyEvent::Discord->new({ token => 'ABCDEF' });

- on($event\_type, \\&handler)

    Attach an event handler to a defined event type. If an invalid event type is
    specified, no error will occur -- this is mostly to be able to handle events
    that are created after this module is published. This is an append method, so
    calling on() for an event multiple times will call each callback assigned. If
    the handler already exists for an event, no error will be returned, but the
    handler will not be called twice.

    Discord event types: https://discord.com/developers/docs/topics/gateway#list-of-intents

    Opcodes: https://discord.com/developers/docs/topics/opcodes-and-status-codes#gateway-opcodes

    These events receive the parameters client, data object (d) and the opcode (op).

        sub event_responder {
          my ($client, $data, $opcode) = @_;
          return;
        }

    Internal event types:

    - disconnected

        Receives no parameters, just notifies a disconnection will occur. It will
        auto reconnect.

    - error

        Receives an error message as a parameter, allows internal handling of errors
        that are not a hard failure.

- off($event\_type, \\&handler?)

    Detach an event handler from a defined event type. If the handler does not
    exist for the event, no error will be returned. If no handler is provided, all
    handlers for the event type will be removed.

- connect()

    Start connecting to the Discord API and return immediately. In a new AnyEvent
    application, this would come before executing "AnyEvent->condvar->recv". This
    method will retrieve the available gateway endpoint, create a connection,
    identify itself, begin a heartbeat, and once complete, Discord will fire a
    'ready' event to the handler.

- send($channel\_id, $content)

    Send a message to the provided channel.

- typing($channel\_id)

    Starts the "typing..." indicator in the provided channel. This method issues the
    typing request, and starts a timer on the caller's behalf to keep the indicator
    active. Returns an instance of that timer to allow the caller to undef it when
    the typing indicator should be stopped.

        my $instance = $client->typing($channel);
        # ... perform some actions
        $instance = undef;
        # typing indicator disappears

- close()

    Close the connection to the server.

# CAVEATS

This is incredibly unfinished.

# AUTHOR

Nick Melnick <nmelnick@cpan.org>

# COPYRIGHT AND LICENSE

This software is copyright (c) 2021, Nick Melnick.

This is free software; you can redistribute it and/or modify it under the same terms as the Perl 5 programming language system itself.
