package Langertha::Spec::OpenAI;
# ABSTRACT: Pre-computed OpenAPI operations for OpenAI
our $VERSION = '0.302';

# AUTO-GENERATED by maint/generate_spec_data.pl -- do not edit manually.
# Source: share/openai.yaml (148 operations)

my $DATA;

sub data {
  $DATA //= {
    server_url => 'https://api.openai.com/v1',
    operations => {
      'activateOrganizationCertificates' => { method => 'POST', path => '/organization/certificates/activate', content_type => 'application/json' },
      'activateProjectCertificates' => { method => 'POST', path => '/organization/projects/{project_id}/certificates/activate', content_type => 'application/json' },
      'addUploadPart' => { method => 'POST', path => '/uploads/{upload_id}/parts', content_type => 'multipart/form-data' },
      'admin-api-keys-create' => { method => 'POST', path => '/organization/admin_api_keys', content_type => 'application/json' },
      'admin-api-keys-delete' => { method => 'DELETE', path => '/organization/admin_api_keys/{key_id}' },
      'admin-api-keys-get' => { method => 'GET', path => '/organization/admin_api_keys/{key_id}' },
      'admin-api-keys-list' => { method => 'GET', path => '/organization/admin_api_keys' },
      'archive-project' => { method => 'POST', path => '/organization/projects/{project_id}/archive' },
      'cancelBatch' => { method => 'POST', path => '/batches/{batch_id}/cancel' },
      'cancelEvalRun' => { method => 'POST', path => '/evals/{eval_id}/runs/{run_id}' },
      'cancelFineTuningJob' => { method => 'POST', path => '/fine_tuning/jobs/{fine_tuning_job_id}/cancel' },
      'cancelRun' => { method => 'POST', path => '/threads/{thread_id}/runs/{run_id}/cancel' },
      'cancelUpload' => { method => 'POST', path => '/uploads/{upload_id}/cancel' },
      'cancelVectorStoreFileBatch' => { method => 'POST', path => '/vector_stores/{vector_store_id}/file_batches/{batch_id}/cancel' },
      'completeUpload' => { method => 'POST', path => '/uploads/{upload_id}/complete', content_type => 'application/json' },
      'create-project' => { method => 'POST', path => '/organization/projects', content_type => 'application/json' },
      'create-project-service-account' => { method => 'POST', path => '/organization/projects/{project_id}/service_accounts', content_type => 'application/json' },
      'create-project-user' => { method => 'POST', path => '/organization/projects/{project_id}/users', content_type => 'application/json' },
      'create-realtime-session' => { method => 'POST', path => '/realtime/sessions', content_type => 'application/json' },
      'create-realtime-transcription-session' => { method => 'POST', path => '/realtime/transcription_sessions', content_type => 'application/json' },
      'createAssistant' => { method => 'POST', path => '/assistants', content_type => 'application/json' },
      'createBatch' => { method => 'POST', path => '/batches', content_type => 'application/json' },
      'createChatCompletion' => { method => 'POST', path => '/chat/completions', content_type => 'application/json' },
      'createCompletion' => { method => 'POST', path => '/completions', content_type => 'application/json' },
      'createEmbedding' => { method => 'POST', path => '/embeddings', content_type => 'application/json' },
      'createEval' => { method => 'POST', path => '/evals', content_type => 'application/json' },
      'createEvalRun' => { method => 'POST', path => '/evals/{eval_id}/runs', content_type => 'application/json' },
      'createFile' => { method => 'POST', path => '/files', content_type => 'multipart/form-data' },
      'createFineTuningCheckpointPermission' => { method => 'POST', path => '/fine_tuning/checkpoints/{fine_tuned_model_checkpoint}/permissions', content_type => 'application/json' },
      'createFineTuningJob' => { method => 'POST', path => '/fine_tuning/jobs', content_type => 'application/json' },
      'createImage' => { method => 'POST', path => '/images/generations', content_type => 'application/json' },
      'createImageEdit' => { method => 'POST', path => '/images/edits', content_type => 'multipart/form-data' },
      'createImageVariation' => { method => 'POST', path => '/images/variations', content_type => 'multipart/form-data' },
      'createMessage' => { method => 'POST', path => '/threads/{thread_id}/messages', content_type => 'application/json' },
      'createModeration' => { method => 'POST', path => '/moderations', content_type => 'application/json' },
      'createResponse' => { method => 'POST', path => '/responses', content_type => 'application/json' },
      'createRun' => { method => 'POST', path => '/threads/{thread_id}/runs', content_type => 'application/json' },
      'createSpeech' => { method => 'POST', path => '/audio/speech', content_type => 'application/json' },
      'createThread' => { method => 'POST', path => '/threads', content_type => 'application/json' },
      'createThreadAndRun' => { method => 'POST', path => '/threads/runs', content_type => 'application/json' },
      'createTranscription' => { method => 'POST', path => '/audio/transcriptions', content_type => 'multipart/form-data' },
      'createTranslation' => { method => 'POST', path => '/audio/translations', content_type => 'multipart/form-data' },
      'createUpload' => { method => 'POST', path => '/uploads', content_type => 'application/json' },
      'createVectorStore' => { method => 'POST', path => '/vector_stores', content_type => 'application/json' },
      'createVectorStoreFile' => { method => 'POST', path => '/vector_stores/{vector_store_id}/files', content_type => 'application/json' },
      'createVectorStoreFileBatch' => { method => 'POST', path => '/vector_stores/{vector_store_id}/file_batches', content_type => 'application/json' },
      'deactivateOrganizationCertificates' => { method => 'POST', path => '/organization/certificates/deactivate', content_type => 'application/json' },
      'deactivateProjectCertificates' => { method => 'POST', path => '/organization/projects/{project_id}/certificates/deactivate', content_type => 'application/json' },
      'delete-invite' => { method => 'DELETE', path => '/organization/invites/{invite_id}' },
      'delete-project-api-key' => { method => 'DELETE', path => '/organization/projects/{project_id}/api_keys/{key_id}' },
      'delete-project-service-account' => { method => 'DELETE', path => '/organization/projects/{project_id}/service_accounts/{service_account_id}' },
      'delete-project-user' => { method => 'DELETE', path => '/organization/projects/{project_id}/users/{user_id}' },
      'delete-user' => { method => 'DELETE', path => '/organization/users/{user_id}' },
      'deleteAssistant' => { method => 'DELETE', path => '/assistants/{assistant_id}' },
      'deleteCertificate' => { method => 'DELETE', path => '/organization/certificates/{certificate_id}' },
      'deleteChatCompletion' => { method => 'DELETE', path => '/chat/completions/{completion_id}' },
      'deleteEval' => { method => 'DELETE', path => '/evals/{eval_id}' },
      'deleteEvalRun' => { method => 'DELETE', path => '/evals/{eval_id}/runs/{run_id}' },
      'deleteFile' => { method => 'DELETE', path => '/files/{file_id}' },
      'deleteFineTuningCheckpointPermission' => { method => 'DELETE', path => '/fine_tuning/checkpoints/{fine_tuned_model_checkpoint}/permissions/{permission_id}' },
      'deleteMessage' => { method => 'DELETE', path => '/threads/{thread_id}/messages/{message_id}' },
      'deleteModel' => { method => 'DELETE', path => '/models/{model}' },
      'deleteResponse' => { method => 'DELETE', path => '/responses/{response_id}' },
      'deleteThread' => { method => 'DELETE', path => '/threads/{thread_id}' },
      'deleteVectorStore' => { method => 'DELETE', path => '/vector_stores/{vector_store_id}' },
      'deleteVectorStoreFile' => { method => 'DELETE', path => '/vector_stores/{vector_store_id}/files/{file_id}' },
      'downloadFile' => { method => 'GET', path => '/files/{file_id}/content' },
      'getAssistant' => { method => 'GET', path => '/assistants/{assistant_id}' },
      'getCertificate' => { method => 'GET', path => '/organization/certificates/{certificate_id}' },
      'getChatCompletion' => { method => 'GET', path => '/chat/completions/{completion_id}' },
      'getChatCompletionMessages' => { method => 'GET', path => '/chat/completions/{completion_id}/messages' },
      'getEval' => { method => 'GET', path => '/evals/{eval_id}' },
      'getEvalRun' => { method => 'GET', path => '/evals/{eval_id}/runs/{run_id}' },
      'getEvalRunOutputItem' => { method => 'GET', path => '/evals/{eval_id}/runs/{run_id}/output_items/{output_item_id}' },
      'getEvalRunOutputItems' => { method => 'GET', path => '/evals/{eval_id}/runs/{run_id}/output_items' },
      'getEvalRuns' => { method => 'GET', path => '/evals/{eval_id}/runs' },
      'getMessage' => { method => 'GET', path => '/threads/{thread_id}/messages/{message_id}' },
      'getResponse' => { method => 'GET', path => '/responses/{response_id}' },
      'getRun' => { method => 'GET', path => '/threads/{thread_id}/runs/{run_id}' },
      'getRunStep' => { method => 'GET', path => '/threads/{thread_id}/runs/{run_id}/steps/{step_id}' },
      'getThread' => { method => 'GET', path => '/threads/{thread_id}' },
      'getVectorStore' => { method => 'GET', path => '/vector_stores/{vector_store_id}' },
      'getVectorStoreFile' => { method => 'GET', path => '/vector_stores/{vector_store_id}/files/{file_id}' },
      'getVectorStoreFileBatch' => { method => 'GET', path => '/vector_stores/{vector_store_id}/file_batches/{batch_id}' },
      'inviteUser' => { method => 'POST', path => '/organization/invites', content_type => 'application/json' },
      'list-audit-logs' => { method => 'GET', path => '/organization/audit_logs' },
      'list-invites' => { method => 'GET', path => '/organization/invites' },
      'list-project-api-keys' => { method => 'GET', path => '/organization/projects/{project_id}/api_keys' },
      'list-project-rate-limits' => { method => 'GET', path => '/organization/projects/{project_id}/rate_limits' },
      'list-project-service-accounts' => { method => 'GET', path => '/organization/projects/{project_id}/service_accounts' },
      'list-project-users' => { method => 'GET', path => '/organization/projects/{project_id}/users' },
      'list-projects' => { method => 'GET', path => '/organization/projects' },
      'list-users' => { method => 'GET', path => '/organization/users' },
      'listAssistants' => { method => 'GET', path => '/assistants' },
      'listBatches' => { method => 'GET', path => '/batches' },
      'listChatCompletions' => { method => 'GET', path => '/chat/completions' },
      'listEvals' => { method => 'GET', path => '/evals' },
      'listFiles' => { method => 'GET', path => '/files' },
      'listFilesInVectorStoreBatch' => { method => 'GET', path => '/vector_stores/{vector_store_id}/file_batches/{batch_id}/files' },
      'listFineTuningCheckpointPermissions' => { method => 'GET', path => '/fine_tuning/checkpoints/{fine_tuned_model_checkpoint}/permissions' },
      'listFineTuningEvents' => { method => 'GET', path => '/fine_tuning/jobs/{fine_tuning_job_id}/events' },
      'listFineTuningJobCheckpoints' => { method => 'GET', path => '/fine_tuning/jobs/{fine_tuning_job_id}/checkpoints' },
      'listInputItems' => { method => 'GET', path => '/responses/{response_id}/input_items' },
      'listMessages' => { method => 'GET', path => '/threads/{thread_id}/messages' },
      'listModels' => { method => 'GET', path => '/models' },
      'listOrganizationCertificates' => { method => 'GET', path => '/organization/certificates' },
      'listPaginatedFineTuningJobs' => { method => 'GET', path => '/fine_tuning/jobs' },
      'listProjectCertificates' => { method => 'GET', path => '/organization/projects/{project_id}/certificates' },
      'listRunSteps' => { method => 'GET', path => '/threads/{thread_id}/runs/{run_id}/steps' },
      'listRuns' => { method => 'GET', path => '/threads/{thread_id}/runs' },
      'listVectorStoreFiles' => { method => 'GET', path => '/vector_stores/{vector_store_id}/files' },
      'listVectorStores' => { method => 'GET', path => '/vector_stores' },
      'modify-project' => { method => 'POST', path => '/organization/projects/{project_id}', content_type => 'application/json' },
      'modify-project-user' => { method => 'POST', path => '/organization/projects/{project_id}/users/{user_id}', content_type => 'application/json' },
      'modify-user' => { method => 'POST', path => '/organization/users/{user_id}', content_type => 'application/json' },
      'modifyAssistant' => { method => 'POST', path => '/assistants/{assistant_id}', content_type => 'application/json' },
      'modifyCertificate' => { method => 'POST', path => '/organization/certificates/{certificate_id}', content_type => 'application/json' },
      'modifyMessage' => { method => 'POST', path => '/threads/{thread_id}/messages/{message_id}', content_type => 'application/json' },
      'modifyRun' => { method => 'POST', path => '/threads/{thread_id}/runs/{run_id}', content_type => 'application/json' },
      'modifyThread' => { method => 'POST', path => '/threads/{thread_id}', content_type => 'application/json' },
      'modifyVectorStore' => { method => 'POST', path => '/vector_stores/{vector_store_id}', content_type => 'application/json' },
      'retrieve-invite' => { method => 'GET', path => '/organization/invites/{invite_id}' },
      'retrieve-project' => { method => 'GET', path => '/organization/projects/{project_id}' },
      'retrieve-project-api-key' => { method => 'GET', path => '/organization/projects/{project_id}/api_keys/{key_id}' },
      'retrieve-project-service-account' => { method => 'GET', path => '/organization/projects/{project_id}/service_accounts/{service_account_id}' },
      'retrieve-project-user' => { method => 'GET', path => '/organization/projects/{project_id}/users/{user_id}' },
      'retrieve-user' => { method => 'GET', path => '/organization/users/{user_id}' },
      'retrieveBatch' => { method => 'GET', path => '/batches/{batch_id}' },
      'retrieveFile' => { method => 'GET', path => '/files/{file_id}' },
      'retrieveFineTuningJob' => { method => 'GET', path => '/fine_tuning/jobs/{fine_tuning_job_id}' },
      'retrieveModel' => { method => 'GET', path => '/models/{model}' },
      'retrieveVectorStoreFileContent' => { method => 'GET', path => '/vector_stores/{vector_store_id}/files/{file_id}/content' },
      'searchVectorStore' => { method => 'POST', path => '/vector_stores/{vector_store_id}/search', content_type => 'application/json' },
      'submitToolOuputsToRun' => { method => 'POST', path => '/threads/{thread_id}/runs/{run_id}/submit_tool_outputs', content_type => 'application/json' },
      'update-project-rate-limits' => { method => 'POST', path => '/organization/projects/{project_id}/rate_limits/{rate_limit_id}', content_type => 'application/json' },
      'updateChatCompletion' => { method => 'POST', path => '/chat/completions/{completion_id}', content_type => 'application/json' },
      'updateEval' => { method => 'POST', path => '/evals/{eval_id}', content_type => 'application/json' },
      'updateVectorStoreFileAttributes' => { method => 'POST', path => '/vector_stores/{vector_store_id}/files/{file_id}', content_type => 'application/json' },
      'uploadCertificate' => { method => 'POST', path => '/organization/certificates', content_type => 'application/json' },
      'usage-audio-speeches' => { method => 'GET', path => '/organization/usage/audio_speeches' },
      'usage-audio-transcriptions' => { method => 'GET', path => '/organization/usage/audio_transcriptions' },
      'usage-code-interpreter-sessions' => { method => 'GET', path => '/organization/usage/code_interpreter_sessions' },
      'usage-completions' => { method => 'GET', path => '/organization/usage/completions' },
      'usage-costs' => { method => 'GET', path => '/organization/costs' },
      'usage-embeddings' => { method => 'GET', path => '/organization/usage/embeddings' },
      'usage-images' => { method => 'GET', path => '/organization/usage/images' },
      'usage-moderations' => { method => 'GET', path => '/organization/usage/moderations' },
      'usage-vector-stores' => { method => 'GET', path => '/organization/usage/vector_stores' },
    },
  };
  return $DATA;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Langertha::Spec::OpenAI - Pre-computed OpenAPI operations for OpenAI

=head1 VERSION

version 0.302

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/Getty/langertha/issues>.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHOR

Torsten Raudssus <torsten@raudssus.de> L<https://raudss.us/>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
