#!/usr/bin/perl

package eBay::API::XML::DataType::ExpressDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExpressDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ExpressDetailsType

=head1 DESCRIPTION

Item details that are only applicable to listings on Express (not the main eBay
site).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ExpressDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'Condition', 'xs:string', '', '', '' ]
	, [ 'ExpressLargeImage', 'xs:anyURI', '', '', '' ]
	, [ 'ExpressSmallImage', 'xs:anyURI', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCondition()

The item condition, if any. On Express US, this is often a value like "New",
"Used", or "Refurbished", but the exact value can vary based on the Item
Condition data that the seller used in the listing.<br> For example, in
some eBay categories, the condition can have a value like "New: With Tags"
instead. (At the time of this writing, GetSearchResultsExpress mapped all
conditions to "New" and "Used". However, this could change in the future.) By
default, only new items (or the equivalent) are returned from
GetSearchResultsExpress. Use Condition in the request to include used and
refurbished items (or the equivalent) as well. Only returned when ItemDetails
is set to Fine.<br>
<br>
Not applicable to calls that browse or search items on the main eBay site.

#    Argument: 'xs:string'

=cut

sub setCondition {
  my $self = shift;
  $self->{'Condition'} = shift
}

=head2 getCondition()

#    Returns: 'xs:string'

=cut

sub getCondition {
  my $self = shift;
  return $self->{'Condition'};
}


=head2 setExpressLargeImage()

Large gallery image that appears in the "Grid View" in search results on the
Express site. The longest dimension is 140 pixels. Only returned when
ItemDetails is set to Fine.<br>
<br>
Express generates the image based on pictures that the seller includes in the
listing. For details about Express listing criteria, see the eBay Web Services
Guide link below.<br>
<br>
If the item was listed in an eBay category that does not require
pictures for Express (like Tickets), a generic image may be returned instead.

#    Argument: 'xs:anyURI'

=cut

sub setExpressLargeImage {
  my $self = shift;
  $self->{'ExpressLargeImage'} = shift
}

=head2 getExpressLargeImage()

#    Returns: 'xs:anyURI'

=cut

sub getExpressLargeImage {
  my $self = shift;
  return $self->{'ExpressLargeImage'};
}


=head2 setExpressSmallImage()

Small gallery image that appears in the "List View" in search results on the
Express site. The longest dimension is 96 pixels. Only returned when ItemDetails
is set to Fine.<br>
<br>
Express generates the image based on pictures that the seller includes in the
listing. For details about Express listing criteria, see the eBay Web Services
Guide link below.<br>
<br>
If the item was listed in an eBay category that does not require pictures for
Express (like Tickets), a generic image may be returned instead.

#    Argument: 'xs:anyURI'

=cut

sub setExpressSmallImage {
  my $self = shift;
  $self->{'ExpressSmallImage'} = shift
}

=head2 getExpressSmallImage()

#    Returns: 'xs:anyURI'

=cut

sub getExpressSmallImage {
  my $self = shift;
  return $self->{'ExpressSmallImage'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
