#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   - Fixup includes.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrcP/uuid/tst_uuid.c	Mon Jan  8 03:58:16 2024
+++ ulib/uuid/tst_uuid.c	Mon Jan  8 04:39:13 2024
@@ -33,11 +33,7 @@
  */
 
 #include "config.h"
-
-#include <stdio.h>
-#include <stdlib.h>
-
-#include <uuid/uuid.h>
+#include "uuid/uuid.h"
 
 static int mytest_uuid(const char * uuid, int isValid)
 {

