#ifdef __cplusplus
extern "C" {
#endif

/*
**  It seems that perfection is attained
**  not when there is nothing more to add,
**  but when there is nothing more to remove.
**                -- Antoine de Saint Exupery
*/

#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <config.h>
#include <uuid/uuid.h>
#include <uuid/uuidP.h>

#ifdef __cplusplus
}
#endif

/* 2 hex digits per byte + 4 separators + 1 trailing null */
#define UUID_BUF_SZ 37

#ifndef MUTEX_LOCK
#  define MUTEX_LOCK(m)           NOOP
#endif

#ifndef MUTEX_UNLOCK
#  define MUTEX_UNLOCK(m)         NOOP
#endif

#ifndef MUTEX_INIT
#  define MUTEX_INIT(m)           NOOP
#endif

#ifndef MUTEX_DESTROY
#  define MUTEX_DESTROY(m)        NOOP
#endif

#ifdef USE_ITHREADS
STATIC perl_mutex UUID_LOCK;
#else
#define UUID_LOCK dNOOP;
#endif


MODULE = UUID		PACKAGE = UUID


BOOT:
    MUTEX_INIT(&UUID_LOCK);

void
generate(str)
    SV * str
    PROTOTYPE: $
    INIT:
        myuuid_t uu;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        myuuid_generate(uu);
        MUTEX_UNLOCK(&UUID_LOCK);
        sv_setpvn(str, (char*)uu, sizeof(myuuid_t));

void
generate_random(str)
    SV * str
    PROTOTYPE: $
    INIT:
        myuuid_t uu;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        myuuid_generate_random(uu);
        MUTEX_UNLOCK(&UUID_LOCK);
        sv_setpvn(str, (char*)uu, sizeof(myuuid_t));

void
generate_time(str)
    SV * str
    PROTOTYPE: $
    INIT:
        myuuid_t uu;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        myuuid_generate_time(uu);
        MUTEX_UNLOCK(&UUID_LOCK);
        sv_setpvn(str, (char*)uu, sizeof(myuuid_t));

void
unparse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
        char str[UUID_BUF_SZ];
    CODE:
        myuuid_unparse((unsigned char*)sv_grow(in, sizeof(myuuid_t)+1), str);
        sv_setpvn(out, str, UUID_BUF_SZ-1);

void
unparse_lower(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
        char str[UUID_BUF_SZ];
    CODE:
        myuuid_unparse_lower((unsigned char*)sv_grow(in, sizeof(myuuid_t)+1), str);
        sv_setpvn(out, str, UUID_BUF_SZ-1);

void
unparse_upper(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
        char str[UUID_BUF_SZ];
    CODE:
        myuuid_unparse_upper((unsigned char*)sv_grow(in, sizeof(myuuid_t)+1), str);
        sv_setpvn(out, str, UUID_BUF_SZ-1);

int
parse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
        myuuid_t uu;
    CODE:
        RETVAL = myuuid_parse(sv_grow(in, UUID_BUF_SZ+1), uu);
        if( !RETVAL )
            sv_setpvn(out, (char*)uu, sizeof(myuuid_t));
    OUTPUT:
    RETVAL

void
clear(in)
    SV * in
    PROTOTYPE: $
    INIT:
        myuuid_t uu;
    CODE:
        myuuid_clear(uu);
        sv_setpvn(in, (char*)uu, sizeof(myuuid_t));

int
is_null(in)
    SV * in
    PROTOTYPE: $
    CODE:
        if( SvCUR(in) != sizeof(myuuid_t) )
            RETVAL = 0;
        else
            RETVAL = myuuid_is_null((unsigned char*)sv_grow(in, sizeof(myuuid_t)+1));
    OUTPUT:
        RETVAL

void
copy(dst, src)
    SV * dst
    SV * src
    PROTOTYPE: $$
    INIT:
        myuuid_t uu;
    CODE:
        if( SvCUR(src) != sizeof(myuuid_t) )
            myuuid_clear(uu);
        else
            myuuid_copy(uu, (unsigned char*)sv_grow(src, sizeof(myuuid_t)+1));
        sv_setpvn(dst, (char*)uu, sizeof(myuuid_t));

int
compare(uu1, uu2)
    SV * uu1
    SV * uu2
    PROTOTYPE: $$
    INIT:
        unsigned char *p1;
        unsigned char *p2;
    CODE:
        p1 = (unsigned char*)sv_grow(uu1, sizeof(myuuid_t)+1);
        p2 = (unsigned char*)sv_grow(uu2, sizeof(myuuid_t)+1);
        RETVAL = myuuid_compare(p1, p2);
    OUTPUT:
        RETVAL

int
type(in)
    SV * in
    PROTOTYPE: $
    CODE:
        RETVAL = myuuid_type((unsigned char*)sv_grow(in, sizeof(myuuid_t)+1));
    OUTPUT:
        RETVAL

time_t
time(in)
    SV * in
    PROTOTYPE: $
    INIT:
        struct timeval tv;
    CODE:
        RETVAL = myuuid_time((unsigned char*)sv_grow(in, sizeof(myuuid_t)+1), &tv);
    OUTPUT:
        RETVAL

int
variant(in)
    SV * in
    PROTOTYPE: $
    CODE:
        RETVAL = myuuid_variant((unsigned char*)sv_grow(in, sizeof(myuuid_t)+1));
    OUTPUT:
        RETVAL

SV *
uuid()
    PROTOTYPE:
    INIT:
        myuuid_t uu;
        char str[UUID_BUF_SZ];
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        myuuid_generate(uu);
        MUTEX_UNLOCK(&UUID_LOCK);
        myuuid_unparse(uu, str);
        RETVAL = newSVpvn(str, UUID_BUF_SZ-1);
    OUTPUT:
        RETVAL

SV *
uuid1()
    PROTOTYPE:
    INIT:
        myuuid_t uu;
        char str[UUID_BUF_SZ];
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        myuuid_generate_time(uu);
        MUTEX_UNLOCK(&UUID_LOCK);
        myuuid_unparse(uu, str);
        RETVAL = newSVpvn(str, UUID_BUF_SZ-1);
    OUTPUT:
        RETVAL

SV *
uuid4()
    PROTOTYPE:
    INIT:
        myuuid_t uu;
        char str[UUID_BUF_SZ];
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        myuuid_generate_random(uu);
        MUTEX_UNLOCK(&UUID_LOCK);
        myuuid_unparse(uu, str);
        RETVAL = newSVpvn(str, UUID_BUF_SZ-1);
    OUTPUT:
        RETVAL

=pod

void
testlock1()
    PROTOTYPE:
    INIT:
        char    str[9];
    CODE:
        /*
        *  strbry:   1372256/s
        *  msys:     1493187/s
        *  native:   1711377/s
        *  slack:    3957601/s
        *  debian:  13981013/s
        *  freebsd: 21562069/s
        */
        str[0] = '\0';
        MUTEX_LOCK(&UUID_LOCK);
        MUTEX_UNLOCK(&UUID_LOCK);

SV *
testlock2()
    PROTOTYPE:
    INIT:
        char    str[9];
    CODE:
        /*
        *  strbry:   1044231/s
        *  msys:     1275107/s
        *  native:   1295050/s
        *  slack:     953250/s
        *  debian:   4822459/s
        *  freebsd:  6156634/s
        */
        str[0] = '\0';
        MUTEX_LOCK(&UUID_LOCK);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSVpvn(str, 0);
    OUTPUT:
        RETVAL

void
testlock3(inout)
    SV * inout
    PROTOTYPE: $
    INIT:
        char    str[9];
    CODE:
        /*
        *  strbry:   1309971/s
        *  msys:     1453362/s
        *  native:   1626338/s
        *  slack:    1854792/s
        *  debian:   8137507/s
        *  freebsd: 10994747/s
        */
        str[0] = '\0';
        MUTEX_LOCK(&UUID_LOCK);
        MUTEX_UNLOCK(&UUID_LOCK);
        sv_setpvn(inout, str, 0);

SV *
testlock4(in)
    SV * in
    PROTOTYPE: $
    INIT:
        char    str[9];
    CODE:
        /*
        *  strbry:   1309971/s
        *  msys:     1453362/s
        *  native:   1626338/s
        *  slack:    1854792/s
        *  debian:   8137507/s
        *  freebsd: 10994747/s
        */
        str[0] = '\0';
        MUTEX_LOCK(&UUID_LOCK);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSVpvn(str, 0);
    OUTPUT:
        RETVAL

=cut
