# Generated by default/object.tt
package Paws::CodeGuruProfiler::AnomalyInstance;
  use Moose;
  has EndTime => (is => 'ro', isa => 'Str', request_name => 'endTime', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest'], required => 1);
  has StartTime => (is => 'ro', isa => 'Str', request_name => 'startTime', traits => ['NameInRequest'], required => 1);
  has UserFeedback => (is => 'ro', isa => 'Paws::CodeGuruProfiler::UserFeedback', request_name => 'userFeedback', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruProfiler::AnomalyInstance

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruProfiler::AnomalyInstance object:

  $service_obj->Method(Att1 => { EndTime => $value, ..., UserFeedback => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruProfiler::AnomalyInstance object:

  $result = $service_obj->Method(...);
  $result->Att1->EndTime

=head1 DESCRIPTION

The specific duration in which the metric is flagged as anomalous.

=head1 ATTRIBUTES


=head2 EndTime => Str

The end time of the period during which the metric is flagged as
anomalous. This is specified using the ISO 8601 format. For example,
2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
1:15:02 PM UTC.


=head2 B<REQUIRED> Id => Str

The universally unique identifier (UUID) of an instance of an anomaly
in a metric.


=head2 B<REQUIRED> StartTime => Str

The start time of the period during which the metric is flagged as
anomalous. This is specified using the ISO 8601 format. For example,
2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
1:15:02 PM UTC.


=head2 UserFeedback => L<Paws::CodeGuruProfiler::UserFeedback>

Feedback type on a specific instance of anomaly submitted by the user.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruProfiler>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

