#!perl

use strict;
use warnings;

use Test::More 0.88;
use Date::WeekNumber qw/ iso_week_number /;

my @TESTS =
(
    # 2013 / 2014
    [ '2013-12-29', ['2013-12-29'],                           '2013-W52'],
    [ '2013-12-30', [2013, 12, 30],                           '2014-W01'],
    [ '2013-12-31', [year => 2013, month => 12, day => 31],   '2014-W01'],
    [ '2014-01-01', [{ year => 2014, month => 1, day => 1}],  '2014-W01'],
    [ '2014-01-02', ['2014-01-02'],                           '2014-W01'],
    [ '2014-01-03', ['2014-01-03'],                           '2014-W01'],
    [ '2014-01-04', ['2014-01-04'],                           '2014-W01'],
    [ '2014-01-05', [1388962435],                             '2014-W01'],

    # 2009/2010
    [ '2009-12-28', ['2009-12-28'] , '2009-W53'],
    [ '2009-12-29', ['2009-12-29'] , '2009-W53'],
    [ '2009-12-30', ['2009-12-30'] , '2009-W53'],
    [ '2009-12-31', ['2009-12-31'] , '2009-W53'],
    [ '2010-01-01', ['2010-01-01'] , '2009-W53'],
    [ '2010-01-02', ['2010-01-02'] , '2009-W53'],
    [ '2010-01-03', ['2010-01-03'] , '2009-W53'],
    [ '2010-01-04', ['2010-01-04'] , '2010-W01'],

);

foreach my $test (@TESTS) {
    my ($date, $args_ref, $expected_week_number) = @$test;
    my $week_number = iso_week_number(@$args_ref);

    is($week_number, $expected_week_number,
       "$date is in week $expected_week_number");
}

done_testing();

