### sub fold

```perl6
sub fold(
    $string,
    :$width where { ... } = 79
) returns Str
```

Fold a string to contain no lines longer than the given width.

class $string
-------------

The string to fold.

class :$width where { ... } = 79
--------------------------------

The maximum width of lines in the text.

### multi sub line-length

```perl6
multi sub line-length(
    $
) returns Int
```

Get the length of a line array. If the array does not exist yet, it is clearly empty, and this sub returns 0.

### multi sub line-length

```perl6
multi sub line-length(
    @line
) returns Int
```

Get the length of a line array. This counts the characters of all words in the array, and adds up the number of spaces required for it to be a human representable line.

class @line
-----------

The line array, containing any number of words.

NAME
====

String::Fold

AUTHOR
======

Patrick Spek <p.spek@tyil.work>

VERSION
=======

0.2.0

SYNOPSIS
========

fold(Str:D $, Int:D :$width);

DESCRIPTION
===========

Fold a `Str` to a given width. Accepts a `:$width`Defaults to `79` argument.

EXAMPLES
========

Basic usage
-----------

    use String::Fold;

    my Str $folded = fold(slurp("some-text-file"));

This will yield a folded string in `$folded`. The input file will have all its lines folded to a maximum width of 79 characters.

Folding at a custom width
-------------------------

    use String::Fold;

    my Str $folded = slurp("some-text-file").&fold(:width(40));

This will yield a string folded at 40 characters, instead of the default of 79 characters. Any number higher than `0` is accepted.

