/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

@Deprecated
public class MockSearchableSolrClient
extends SolrClient {
    public Map<String, Map<String, SolrInputDocument>> docs = new ConcurrentHashMap<String, Map<String, SolrInputDocument>>();
    private AtomicLong numUpdates = new AtomicLong();
    private AtomicLong numQueries = new AtomicLong();

    public void clear() {
        this.docs.clear();
    }

    public synchronized NamedList<Object> request(SolrRequest<?> request, String coll) throws SolrServerException, IOException {
        if (coll == null && request.getParams() != null) {
            coll = request.getParams().get("collection");
        }
        if (coll == null) {
            coll = "";
        }
        String collection = coll;
        NamedList res = new NamedList();
        if (request instanceof UpdateRequest) {
            List docList = ((UpdateRequest)request).getDocuments();
            if (docList != null) {
                docList.forEach(doc -> {
                    String id = (String)doc.getFieldValue("id");
                    Objects.requireNonNull(id, doc.toString());
                    this.docs.computeIfAbsent(collection, c -> new LinkedHashMap()).put(id, doc);
                    this.numUpdates.incrementAndGet();
                });
            }
        } else if (request instanceof QueryRequest) {
            SolrParams params = request.getParams();
            if (params == null) {
                throw new UnsupportedOperationException("invalid request, no params: " + String.valueOf(request));
            }
            String query = params.get("q");
            SolrDocumentList lst = new SolrDocumentList();
            if (query != null) {
                if (query.startsWith("{!term f=id}") || query.startsWith("id:")) {
                    SolrInputDocument doc2;
                    this.numQueries.incrementAndGet();
                    String id = query.startsWith("{!") ? query.substring(12) : query.substring(3);
                    Map<String, SolrInputDocument> collDocs = this.docs.get(collection);
                    if (collDocs != null && (doc2 = collDocs.get(id)) != null) {
                        SolrDocument d = new SolrDocument();
                        doc2.forEach((k, f) -> f.forEach(v -> d.addField(k, v)));
                        lst.add((Object)d);
                        lst.setNumFound(1L);
                    }
                } else if (query.equals("*:*")) {
                    this.numQueries.incrementAndGet();
                    Map<String, SolrInputDocument> collDocs = this.docs.get(collection);
                    if (collDocs != null) {
                        lst.setNumFound((long)collDocs.size());
                        collDocs.values().forEach(doc -> {
                            SolrDocument d = new SolrDocument();
                            doc.forEach((k, f) -> f.forEach(v -> d.addField(k, v)));
                            lst.add((Object)d);
                        });
                    }
                }
            }
            res.add("response", (Object)lst);
        } else {
            throw new UnsupportedOperationException("Unsupported request type: " + String.valueOf(request.getClass()) + ":" + String.valueOf(request));
        }
        return res;
    }

    public long getNumUpdates() {
        return this.numUpdates.get();
    }

    public long getNumQueries() {
        return this.numQueries.get();
    }

    public void close() throws IOException {
    }
}

