/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;

public class PostLogsTool
extends ToolBase {
    private static final Map<Integer, String> purposes;
    protected static final String UNKNOWN_VALUE = "Unknown";
    private static final String[] purposeUnknown;

    public PostLogsTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public String getName() {
        return "postlogs";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"url").longOpt("solr-collection-url").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --solr-url and -c / --name instead").get()).hasArg().argName("ADDRESS").desc("Address of the collection, example http://localhost:8983/solr/collection1/.").build(), Option.builder((String)"c").longOpt("name").hasArg().argName("NAME").desc("Name of the collection.").build(), Option.builder((String)"rootdir").longOpt("rootdir").hasArg().argName("DIRECTORY").required(true).desc("All files found at or below the root directory will be indexed.").build(), SolrCLI.OPTION_SOLRURL);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        Object url = null;
        if (cli.hasOption("solr-url")) {
            if (!cli.hasOption("name")) {
                throw new IllegalArgumentException("Must specify -c / --name parameter with --solr-url to post documents.");
            }
            url = SolrCLI.normalizeSolrUrl(cli) + "/solr/" + cli.getOptionValue("name");
        } else if (cli.hasOption("solr-collection-url")) {
            url = cli.getOptionValue("solr-collection-url");
        } else {
            throw new IllegalArgumentException("Must specify --solr-url.");
        }
        String rootDir = cli.getOptionValue("rootdir");
        this.runCommand((String)url, rootDir);
    }

    public void runCommand(String baseUrl, String root) throws IOException {
        Http2SolrClient.Builder builder = new Http2SolrClient.Builder(baseUrl).withKeyStoreReloadInterval(-1L, TimeUnit.SECONDS);
        try (Http2SolrClient client = builder.build();){
            List files;
            int rec = 0;
            UpdateRequest request = new UpdateRequest();
            try (Stream<Path> stream = Files.walk(Path.of(root, new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]);){
                files = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
            }
            block17: for (Path file : files) {
                try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(file, Charset.defaultCharset()));){
                    LogRecordReader recordReader = new LogRecordReader(reader);
                    String fileName = file.getFileName().toString();
                    while (true) {
                        SolrInputDocument doc;
                        try {
                            doc = recordReader.readRecord();
                        }
                        catch (Throwable t) {
                            CLIO.err("Error reading log record:" + reader.getLineNumber() + " from file:" + fileName);
                            CLIO.err(t.getMessage());
                            continue;
                        }
                        if (doc == null) continue block17;
                        ++rec;
                        UUID id = UUID.randomUUID();
                        doc.setField("id", (Object)id.toString());
                        doc.setField("file_s", (Object)fileName);
                        request.add(doc);
                        if (rec != 300) continue;
                        this.sendBatch((SolrClient)client, request, false);
                        request = new UpdateRequest();
                        rec = 0;
                    }
                }
            }
            if (rec > 0) {
                this.sendBatch((SolrClient)client, request, true);
            }
        }
    }

    private void sendBatch(SolrClient client, UpdateRequest request, boolean lastRequest) {
        String beginMessage = lastRequest ? "Sending last batch ..." : "Sending batch of 300 log records...";
        CLIO.out(beginMessage);
        try {
            request.process(client);
            CLIO.out("Batch sent");
        }
        catch (Exception e) {
            CLIO.err("Batch sending failed: " + e.getMessage());
            e.printStackTrace(CLIO.getErrStream());
        }
        if (lastRequest) {
            try {
                client.commit();
                CLIO.out("Committed");
            }
            catch (Exception e) {
                CLIO.err("Unable to commit documents: " + e.getMessage());
                e.printStackTrace(CLIO.getErrStream());
            }
        }
    }

    public static String[] getRequestPurposeNames(Integer reqPurpose) {
        if (reqPurpose != null) {
            int valid = 0;
            for (Map.Entry<Integer, String> entry : purposes.entrySet()) {
                if ((reqPurpose & entry.getKey()) == 0) continue;
                ++valid;
            }
            if (valid == 0) {
                return purposeUnknown;
            }
            String[] result = new String[valid];
            int i = 0;
            for (Map.Entry<Integer, String> entry : purposes.entrySet()) {
                if ((reqPurpose & entry.getKey()) == 0) continue;
                result[i] = entry.getValue();
                ++i;
            }
            return result;
        }
        return purposeUnknown;
    }

    static {
        purposeUnknown = new String[]{UNKNOWN_VALUE};
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(1, "PRIVATE");
        map.put(4, "GET_TOP_IDS");
        map.put(8, "REFINE_TOP_IDS");
        map.put(16, "GET_FACETS");
        map.put(32, "REFINE_FACETS");
        map.put(64, "GET_FIELDS");
        map.put(128, "GET_HIGHLIGHTS");
        map.put(256, "GET_DEBUG");
        map.put(512, "GET_STATS");
        map.put(1024, "GET_TERMS");
        map.put(2048, "GET_TOP_GROUPS");
        map.put(4096, "GET_MLT_RESULTS");
        map.put(8192, "REFINE_PIVOT_FACETS");
        map.put(16384, "SET_TERM_STATS");
        map.put(32768, "GET_TERM_STATS");
        purposes = Collections.unmodifiableMap(map);
    }

    public static class LogRecordReader {
        private BufferedReader bufferedReader;
        private String pushedBack = null;
        private boolean finished = false;
        private String cause;
        private Pattern p = Pattern.compile("^(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d[\\s|T]\\d\\d:\\d\\d\\:\\d\\d.\\d\\d\\d)");
        private Pattern minute = Pattern.compile("^(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d[\\s|T]\\d\\d:\\d\\d)");
        private Pattern tenSecond = Pattern.compile("^(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d[\\s|T]\\d\\d:\\d\\d:\\d)");

        public LogRecordReader(BufferedReader bufferedReader) throws IOException {
            this.bufferedReader = bufferedReader;
        }

        public SolrInputDocument readRecord() throws IOException {
            String line = null;
            if (this.finished) {
                return null;
            }
            if (this.pushedBack != null) {
                line = this.pushedBack;
                this.pushedBack = null;
            } else {
                line = this.bufferedReader.readLine();
            }
            if (line != null) {
                SolrInputDocument lineDoc = new SolrInputDocument();
                String date = this.parseDate(line);
                String minute = this.parseMinute(line);
                String tenSecond = this.parseTenSecond(line);
                lineDoc.setField("date_dt", (Object)date);
                lineDoc.setField("time_minute_s", (Object)minute);
                lineDoc.setField("time_ten_second_s", (Object)tenSecond);
                lineDoc.setField("line_t", (Object)line);
                lineDoc.setField("type_s", (Object)"other");
                if (line.contains("Registered new searcher")) {
                    this.parseNewSearch(lineDoc, line);
                } else if (line.contains("path=/update")) {
                    this.parseUpdate(lineDoc, line);
                } else if (line.contains(" ERROR ")) {
                    this.cause = null;
                    this.parseError(lineDoc, line, this.readTrace());
                } else if (line.contains("QTime=")) {
                    this.parseQueryRecord(lineDoc, line);
                }
                return lineDoc;
            }
            return null;
        }

        private String readTrace() throws IOException {
            String line;
            StringBuilder buf = new StringBuilder();
            buf.append("%html ");
            while (true) {
                if ((line = this.bufferedReader.readLine()) == null) {
                    this.finished = true;
                    return buf.toString();
                }
                Matcher m = this.p.matcher(line);
                if (m.find() || buf.length() >= 10000) break;
                buf.append(line.replace("\t", "    ")).append("<br/>");
                if (!line.startsWith("Caused by:")) continue;
                this.cause = line;
            }
            this.pushedBack = line;
            return buf.toString();
        }

        private String parseDate(String line) {
            Matcher m = this.p.matcher(line);
            if (m.find()) {
                String date = m.group(1);
                return date.replace(" ", "T") + "Z";
            }
            return null;
        }

        private String parseMinute(String line) {
            Matcher m = this.minute.matcher(line);
            if (m.find()) {
                String date = m.group(1);
                return date.replace(" ", "T") + ":00Z";
            }
            return null;
        }

        private String parseTenSecond(String line) {
            Matcher m = this.tenSecond.matcher(line);
            if (m.find()) {
                String date = m.group(1);
                return date.replace(" ", "T") + "0Z";
            }
            return null;
        }

        private void setFieldIfUnset(SolrInputDocument doc, String fieldName, String fieldValue) {
            if (doc.containsKey((Object)fieldName)) {
                return;
            }
            doc.setField(fieldName, (Object)fieldValue);
        }

        private void parseError(SolrInputDocument lineRecord, String line, String trace) {
            lineRecord.setField("type_s", (Object)"error");
            if (trace != null && trace.length() > 6) {
                lineRecord.setField("stack_t", (Object)trace);
            }
            if (this.cause != null) {
                lineRecord.setField("root_cause_t", (Object)this.cause.replace("Caused by:", "").trim());
            }
            lineRecord.setField("collection_s", (Object)this.parseCollection(line));
            lineRecord.setField("core_s", (Object)this.parseCore(line));
            lineRecord.setField("shard_s", (Object)this.parseShard(line));
            lineRecord.setField("replica_s", (Object)this.parseReplica(line));
        }

        private void parseQueryRecord(SolrInputDocument lineRecord, String line) {
            lineRecord.setField("qtime_i", (Object)this.parseQTime(line));
            lineRecord.setField("status_s", (Object)this.parseStatus(line));
            String path = this.parsePath(line);
            lineRecord.setField("path_s", (Object)path);
            if (line.contains("hits=")) {
                lineRecord.setField("hits_l", (Object)this.parseHits(line));
            }
            String params = this.parseParams(line);
            lineRecord.setField("params_t", (Object)params);
            this.addParams(lineRecord, params);
            lineRecord.setField("collection_s", (Object)this.parseCollection(line));
            lineRecord.setField("core_s", (Object)this.parseCore(line));
            lineRecord.setField("node_s", (Object)this.parseNode(line));
            lineRecord.setField("shard_s", (Object)this.parseShard(line));
            lineRecord.setField("replica_s", (Object)this.parseReplica(line));
            if (path != null && path.contains("/admin")) {
                lineRecord.setField("type_s", (Object)"admin");
            } else if (path != null && params.contains("/replication")) {
                lineRecord.setField("type_s", (Object)"replication");
            } else if (path != null && path.contains("/get")) {
                lineRecord.setField("type_s", (Object)"get");
            } else {
                lineRecord.setField("type_s", (Object)"query");
            }
        }

        private void parseNewSearch(SolrInputDocument lineRecord, String line) {
            lineRecord.setField("core_s", (Object)this.parseCore(line));
            lineRecord.setField("type_s", (Object)"newSearcher");
            lineRecord.setField("collection_s", (Object)this.parseCollection(line));
            lineRecord.setField("shard_s", (Object)this.parseShard(line));
            lineRecord.setField("replica_s", (Object)this.parseReplica(line));
        }

        private String parseCollection(String line) {
            char[] ca = new char[]{' ', ']', ','};
            String[] parts = line.split("c:");
            if (parts.length >= 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private void parseUpdate(SolrInputDocument lineRecord, String line) {
            if (line.contains("deleteByQuery=")) {
                lineRecord.setField("type_s", (Object)"deleteByQuery");
            } else if (line.contains("delete=")) {
                lineRecord.setField("type_s", (Object)"delete");
            } else if (line.contains("commit=true")) {
                lineRecord.setField("type_s", (Object)"commit");
            } else {
                lineRecord.setField("type_s", (Object)"update");
            }
            lineRecord.setField("collection_s", (Object)this.parseCollection(line));
            lineRecord.setField("core_s", (Object)this.parseCore(line));
            lineRecord.setField("shard_s", (Object)this.parseShard(line));
            lineRecord.setField("replica_s", (Object)this.parseReplica(line));
        }

        private String parseCore(String line) {
            char[] ca = new char[]{' ', ']', '}', ','};
            String[] parts = line.split("x:");
            if (parts.length >= 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseShard(String line) {
            char[] ca = new char[]{' ', ']', '}', ','};
            String[] parts = line.split("s:");
            if (parts.length >= 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseReplica(String line) {
            char[] ca = new char[]{' ', ']', '}', ','};
            String[] parts = line.split("r:");
            if (parts.length >= 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parsePath(String line) {
            char[] ca = new char[]{' '};
            String[] parts = line.split(" path=");
            if (parts.length == 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseQTime(String line) {
            char[] ca = new char[]{'\n', '\r'};
            String[] parts = line.split(" QTime=");
            if (parts.length == 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseNode(String line) {
            char[] ca = new char[]{' ', ']', '}', ','};
            String[] parts = line.split("node_name=n:");
            if (parts.length >= 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseStatus(String line) {
            char[] ca = new char[]{' ', '\n', '\r'};
            String[] parts = line.split(" status=");
            if (parts.length == 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseHits(String line) {
            char[] ca = new char[]{' '};
            String[] parts = line.split(" hits=");
            if (parts.length == 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseParams(String line) {
            char[] ca = new char[]{' '};
            String[] parts = line.split(" params=");
            if (parts.length == 2) {
                String p = this.readUntil(parts[1].substring(1), ca);
                return p.substring(0, p.length() - 1);
            }
            return null;
        }

        private String readUntil(String s, char[] chars) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char a = s.charAt(i);
                for (char c : chars) {
                    if (a != c) continue;
                    return builder.toString();
                }
                builder.append(a);
            }
            return builder.toString();
        }

        private void addParams(SolrInputDocument doc, String params) {
            String[] pairs;
            for (String pair : pairs = params.split("&")) {
                String dr;
                String[] parts = pair.split("=");
                if (parts.length == 2 && parts[0].equals("q")) {
                    String dq = URLDecoder.decode(parts[1], Charset.defaultCharset());
                    this.setFieldIfUnset(doc, "q_s", dq);
                    this.setFieldIfUnset(doc, "q_t", dq);
                }
                if (parts[0].equals("rows")) {
                    dr = URLDecoder.decode(parts[1], Charset.defaultCharset());
                    this.setFieldIfUnset(doc, "rows_i", dr);
                }
                if (parts[0].equals("start")) {
                    dr = URLDecoder.decode(parts[1], Charset.defaultCharset());
                    this.setFieldIfUnset(doc, "start_i", dr);
                }
                if (parts[0].equals("distrib")) {
                    dr = URLDecoder.decode(parts[1], Charset.defaultCharset());
                    this.setFieldIfUnset(doc, "distrib_s", dr);
                }
                if (parts[0].equals("shards")) {
                    this.setFieldIfUnset(doc, "shards_s", "true");
                }
                if (parts[0].equals("ids") && !this.isRTGRequest(doc)) {
                    this.setFieldIfUnset(doc, "ids_s", "true");
                }
                if (parts[0].equals("isShard")) {
                    dr = URLDecoder.decode(parts[1], Charset.defaultCharset());
                    this.setFieldIfUnset(doc, "isShard_s", dr);
                }
                if (parts[0].equals("wt")) {
                    dr = URLDecoder.decode(parts[1], Charset.defaultCharset());
                    this.setFieldIfUnset(doc, "wt_s", dr);
                }
                if (parts[0].equals("facet")) {
                    dr = URLDecoder.decode(parts[1], Charset.defaultCharset());
                    this.setFieldIfUnset(doc, "facet_s", dr);
                }
                if (!parts[0].equals("shards.purpose")) continue;
                try {
                    String[] purposes;
                    int purpose = Integer.parseInt(parts[1]);
                    for (String p : purposes = PostLogsTool.getRequestPurposeNames(purpose)) {
                        doc.addField("purpose_ss", (Object)p);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.setFieldIfUnset(doc, "distrib_s", "true");
            this.setFieldIfUnset(doc, "shards_s", "false");
            this.setFieldIfUnset(doc, "ids_s", "false");
        }

        private boolean isRTGRequest(SolrInputDocument doc) {
            SolrInputField path = doc.getField("path_s");
            if (path == null) {
                return false;
            }
            return "/get".equals(path.getValue());
        }
    }
}

