/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.ReadShareGroupStateRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ReadShareGroupStateResponse;

public class ReadShareGroupStateRequest
extends AbstractRequest {
    private final ReadShareGroupStateRequestData data;

    public ReadShareGroupStateRequest(ReadShareGroupStateRequestData data, short version) {
        super(ApiKeys.READ_SHARE_GROUP_STATE, version);
        this.data = data;
    }

    @Override
    public ReadShareGroupStateResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<ReadShareGroupStateResponseData.ReadStateResult> results = new ArrayList<ReadShareGroupStateResponseData.ReadStateResult>();
        this.data.topics().forEach(topicResult -> results.add(new ReadShareGroupStateResponseData.ReadStateResult().setTopicId(topicResult.topicId()).setPartitions(topicResult.partitions().stream().map(partitionData -> new ReadShareGroupStateResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(Errors.forException(e).code()).setErrorMessage(Errors.forException(e).message())).collect(Collectors.toList()))));
        return new ReadShareGroupStateResponse(new ReadShareGroupStateResponseData().setResults(results));
    }

    @Override
    public ReadShareGroupStateRequestData data() {
        return this.data;
    }

    public static ReadShareGroupStateRequest parse(ByteBuffer buffer, short version) {
        return new ReadShareGroupStateRequest(new ReadShareGroupStateRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ReadShareGroupStateRequest> {
        private final ReadShareGroupStateRequestData data;

        public Builder(ReadShareGroupStateRequestData data) {
            this(data, true);
        }

        public Builder(ReadShareGroupStateRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.READ_SHARE_GROUP_STATE, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public ReadShareGroupStateRequest build(short version) {
            return new ReadShareGroupStateRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

