/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.chat.AssistantMessage;
import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.chat.Content;
import dev.ai4j.openai4j.chat.ContentType;
import dev.ai4j.openai4j.chat.Function;
import dev.ai4j.openai4j.chat.FunctionCall;
import dev.ai4j.openai4j.chat.FunctionMessage;
import dev.ai4j.openai4j.chat.ImageDetail;
import dev.ai4j.openai4j.chat.ImageUrl;
import dev.ai4j.openai4j.chat.JsonBooleanSchema;
import dev.ai4j.openai4j.chat.JsonEnumSchema;
import dev.ai4j.openai4j.chat.JsonObjectSchema;
import dev.ai4j.openai4j.chat.JsonStringSchema;
import dev.ai4j.openai4j.chat.Message;
import dev.ai4j.openai4j.chat.ResponseFormatType;
import dev.ai4j.openai4j.chat.Tool;
import dev.ai4j.openai4j.chat.ToolCall;
import dev.ai4j.openai4j.chat.ToolMessage;
import dev.ai4j.openai4j.chat.ToolType;
import dev.ai4j.openai4j.chat.UserMessage;
import dev.ai4j.openai4j.shared.Usage;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InternalOpenAiHelper {
    static final String OPENAI_URL = "https://api.openai.com/v1";
    static final String OPENAI_DEMO_API_KEY = "demo";
    static final String OPENAI_DEMO_URL = "http://langchain4j.dev/demo/openai/v1";
    static final String DEFAULT_USER_AGENT = "langchain4j-openai";

    public static List<Message> toOpenAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(InternalOpenAiHelper::toOpenAiMessage).collect(Collectors.toList());
    }

    public static Message toOpenAiMessage(ChatMessage message) {
        if (message instanceof SystemMessage) {
            return dev.ai4j.openai4j.chat.SystemMessage.from((String)((SystemMessage)message).text());
        }
        if (message instanceof dev.langchain4j.data.message.UserMessage) {
            dev.langchain4j.data.message.UserMessage userMessage = (dev.langchain4j.data.message.UserMessage)message;
            if (userMessage.hasSingleText()) {
                return UserMessage.builder().content(userMessage.text()).name(userMessage.name()).build();
            }
            return UserMessage.builder().content(userMessage.contents().stream().map(InternalOpenAiHelper::toOpenAiContent).collect(Collectors.toList())).name(userMessage.name()).build();
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return AssistantMessage.from((String)aiMessage.text());
            }
            ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
            if (toolExecutionRequest.id() == null) {
                FunctionCall functionCall = FunctionCall.builder().name(toolExecutionRequest.name()).arguments(toolExecutionRequest.arguments()).build();
                return AssistantMessage.builder().functionCall(functionCall).build();
            }
            List toolCalls = aiMessage.toolExecutionRequests().stream().map(it -> ToolCall.builder().id(it.id()).type(ToolType.FUNCTION).function(FunctionCall.builder().name(it.name()).arguments(it.arguments()).build()).build()).collect(Collectors.toList());
            return AssistantMessage.builder().toolCalls(toolCalls).build();
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)message;
            if (toolExecutionResultMessage.id() == null) {
                return FunctionMessage.from((String)toolExecutionResultMessage.toolName(), (String)toolExecutionResultMessage.text());
            }
            return ToolMessage.from((String)toolExecutionResultMessage.id(), (String)toolExecutionResultMessage.text());
        }
        throw Exceptions.illegalArgument((String)("Unknown message type: " + message.type()), (Object[])new Object[0]);
    }

    private static Content toOpenAiContent(dev.langchain4j.data.message.Content content) {
        if (content instanceof TextContent) {
            return InternalOpenAiHelper.toOpenAiContent((TextContent)content);
        }
        if (content instanceof ImageContent) {
            return InternalOpenAiHelper.toOpenAiContent((ImageContent)content);
        }
        throw Exceptions.illegalArgument((String)("Unknown content type: " + content), (Object[])new Object[0]);
    }

    private static Content toOpenAiContent(TextContent content) {
        return Content.builder().type(ContentType.TEXT).text(content.text()).build();
    }

    private static Content toOpenAiContent(ImageContent content) {
        return Content.builder().type(ContentType.IMAGE_URL).imageUrl(ImageUrl.builder().url(InternalOpenAiHelper.toUrl(content.image())).detail(InternalOpenAiHelper.toDetail(content.detailLevel())).build()).build();
    }

    private static String toUrl(Image image) {
        if (image.url() != null) {
            return image.url().toString();
        }
        return String.format("data:%s;base64,%s", image.mimeType(), image.base64Data());
    }

    private static ImageDetail toDetail(ImageContent.DetailLevel detailLevel) {
        if (detailLevel == null) {
            return null;
        }
        return ImageDetail.valueOf((String)detailLevel.name());
    }

    public static List<Tool> toTools(Collection<ToolSpecification> toolSpecifications, boolean strict) {
        return toolSpecifications.stream().map(toolSpecification -> InternalOpenAiHelper.toTool(toolSpecification, strict)).collect(Collectors.toList());
    }

    private static Tool toTool(ToolSpecification toolSpecification, boolean strict) {
        Function.Builder functionBuilder = Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(InternalOpenAiHelper.toOpenAiParameters(toolSpecification.parameters(), strict));
        if (strict) {
            functionBuilder.strict(Boolean.valueOf(true));
        }
        Function function = functionBuilder.build();
        return Tool.from((Function)function);
    }

    @Deprecated
    public static List<Function> toFunctions(Collection<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(InternalOpenAiHelper::toFunction).collect(Collectors.toList());
    }

    @Deprecated
    private static Function toFunction(ToolSpecification toolSpecification) {
        return Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(InternalOpenAiHelper.toOpenAiParameters(toolSpecification.parameters(), false)).build();
    }

    private static JsonObjectSchema toOpenAiParameters(ToolParameters toolParameters, boolean strict) {
        if (toolParameters == null) {
            JsonObjectSchema.Builder builder = JsonObjectSchema.builder();
            if (strict) {
                builder.additionalProperties(Boolean.valueOf(false));
            }
            return builder.build();
        }
        JsonObjectSchema.Builder builder = JsonObjectSchema.builder().properties(InternalOpenAiHelper.toOpenAiProperties(toolParameters.properties(), strict)).required(toolParameters.required());
        if (strict) {
            builder.required(new ArrayList(toolParameters.properties().keySet())).additionalProperties(Boolean.valueOf(false));
        }
        return builder.build();
    }

    private static Map<String, dev.ai4j.openai4j.chat.JsonSchemaElement> toOpenAiProperties(Map<String, ?> properties, boolean strict) {
        LinkedHashMap<String, dev.ai4j.openai4j.chat.JsonSchemaElement> openAiProperties = new LinkedHashMap<String, dev.ai4j.openai4j.chat.JsonSchemaElement>();
        properties.forEach((key, value) -> openAiProperties.put((String)key, InternalOpenAiHelper.toOpenAiJsonSchemaElement((Map)value, strict)));
        return openAiProperties;
    }

    private static dev.ai4j.openai4j.chat.JsonSchemaElement toOpenAiJsonSchemaElement(Map<String, ?> properties, boolean strict) {
        Object type = properties.get("type");
        String description = (String)properties.get("description");
        if ("object".equals(type)) {
            List required = (List)properties.get("required");
            JsonObjectSchema.Builder builder = JsonObjectSchema.builder().description(description).properties(InternalOpenAiHelper.toOpenAiProperties((Map)properties.get("properties"), strict));
            if (required != null) {
                builder.required(required);
            }
            if (strict) {
                builder.required(new ArrayList(((Map)properties.get("properties")).keySet())).additionalProperties(Boolean.valueOf(false));
            }
            return builder.build();
        }
        if ("array".equals(type)) {
            return dev.ai4j.openai4j.chat.JsonArraySchema.builder().description(description).items(InternalOpenAiHelper.toOpenAiJsonSchemaElement((Map)properties.get("items"), strict)).build();
        }
        if (properties.get("enum") != null) {
            return JsonEnumSchema.builder().description(description).enumValues((List)properties.get("enum")).build();
        }
        if ("string".equals(type)) {
            return JsonStringSchema.builder().description(description).build();
        }
        if ("integer".equals(type)) {
            return dev.ai4j.openai4j.chat.JsonIntegerSchema.builder().description(description).build();
        }
        if ("number".equals(type)) {
            return dev.ai4j.openai4j.chat.JsonNumberSchema.builder().description(description).build();
        }
        if ("boolean".equals(type)) {
            return JsonBooleanSchema.builder().description(description).build();
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static AiMessage aiMessageFrom(ChatCompletionResponse response) {
        AssistantMessage assistantMessage = ((ChatCompletionChoice)response.choices().get(0)).message();
        String text = assistantMessage.content();
        List toolCalls = assistantMessage.toolCalls();
        if (!Utils.isNullOrEmpty((Collection)toolCalls)) {
            List toolExecutionRequests = toolCalls.stream().filter(toolCall -> toolCall.type() == ToolType.FUNCTION).map(InternalOpenAiHelper::toToolExecutionRequest).collect(Collectors.toList());
            return Utils.isNullOrBlank((String)text) ? AiMessage.from(toolExecutionRequests) : AiMessage.from((String)text, toolExecutionRequests);
        }
        FunctionCall functionCall = assistantMessage.functionCall();
        if (functionCall != null) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(functionCall.name()).arguments(functionCall.arguments()).build();
            return Utils.isNullOrBlank((String)text) ? AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest}) : AiMessage.from((String)text, Collections.singletonList(toolExecutionRequest));
        }
        return AiMessage.from((String)text);
    }

    private static ToolExecutionRequest toToolExecutionRequest(ToolCall toolCall) {
        FunctionCall functionCall = toolCall.function();
        return ToolExecutionRequest.builder().id(toolCall.id()).name(functionCall.name()).arguments(functionCall.arguments()).build();
    }

    public static TokenUsage tokenUsageFrom(Usage openAiUsage) {
        if (openAiUsage == null) {
            return null;
        }
        return new TokenUsage(openAiUsage.promptTokens(), openAiUsage.completionTokens(), openAiUsage.totalTokens());
    }

    public static FinishReason finishReasonFrom(String openAiFinishReason) {
        if (openAiFinishReason == null) {
            return null;
        }
        switch (openAiFinishReason) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
            case "tool_calls": 
            case "function_call": {
                return FinishReason.TOOL_EXECUTION;
            }
            case "content_filter": {
                return FinishReason.CONTENT_FILTER;
            }
        }
        return null;
    }

    static ChatModelRequest createModelListenerRequest(ChatCompletionRequest request, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return ChatModelRequest.builder().model(request.model()).temperature(request.temperature()).topP(request.topP()).maxTokens((Integer)Utils.getOrDefault((Object)request.maxCompletionTokens(), (Object)request.maxTokens())).messages(messages).toolSpecifications(toolSpecifications).build();
    }

    static ChatModelResponse createModelListenerResponse(String responseId, String responseModel, Response<AiMessage> response) {
        if (response == null) {
            return null;
        }
        return ChatModelResponse.builder().id(responseId).model(responseModel).tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).aiMessage((AiMessage)response.content()).build();
    }

    static dev.ai4j.openai4j.chat.ResponseFormat toOpenAiResponseFormat(ResponseFormat responseFormat, Boolean strict) {
        if (responseFormat == null || responseFormat.type() == dev.langchain4j.model.chat.request.ResponseFormatType.TEXT) {
            return null;
        }
        JsonSchema jsonSchema = responseFormat.jsonSchema();
        if (jsonSchema == null) {
            return dev.ai4j.openai4j.chat.ResponseFormat.builder().type(ResponseFormatType.JSON_OBJECT).build();
        }
        if (!(jsonSchema.rootElement() instanceof dev.langchain4j.model.chat.request.json.JsonObjectSchema)) {
            throw new IllegalArgumentException("For OpenAI, the root element of the JSON Schema must be a JsonObjectSchema, but it was: " + jsonSchema.rootElement().getClass());
        }
        dev.ai4j.openai4j.chat.JsonSchema openAiJsonSchema = dev.ai4j.openai4j.chat.JsonSchema.builder().name(jsonSchema.name()).strict(strict).schema((JsonObjectSchema)InternalOpenAiHelper.toOpenAiJsonSchemaElement(jsonSchema.rootElement())).build();
        return dev.ai4j.openai4j.chat.ResponseFormat.builder().type(ResponseFormatType.JSON_SCHEMA).jsonSchema(openAiJsonSchema).build();
    }

    private static dev.ai4j.openai4j.chat.JsonSchemaElement toOpenAiJsonSchemaElement(JsonSchemaElement jsonSchemaElement) {
        if (jsonSchemaElement instanceof dev.langchain4j.model.chat.request.json.JsonStringSchema) {
            return JsonStringSchema.builder().description(((dev.langchain4j.model.chat.request.json.JsonStringSchema)jsonSchemaElement).description()).build();
        }
        if (jsonSchemaElement instanceof JsonIntegerSchema) {
            return dev.ai4j.openai4j.chat.JsonIntegerSchema.builder().description(((JsonIntegerSchema)jsonSchemaElement).description()).build();
        }
        if (jsonSchemaElement instanceof JsonNumberSchema) {
            return dev.ai4j.openai4j.chat.JsonNumberSchema.builder().description(((JsonNumberSchema)jsonSchemaElement).description()).build();
        }
        if (jsonSchemaElement instanceof dev.langchain4j.model.chat.request.json.JsonBooleanSchema) {
            return JsonBooleanSchema.builder().description(((dev.langchain4j.model.chat.request.json.JsonBooleanSchema)jsonSchemaElement).description()).build();
        }
        if (jsonSchemaElement instanceof dev.langchain4j.model.chat.request.json.JsonEnumSchema) {
            return JsonEnumSchema.builder().description(((dev.langchain4j.model.chat.request.json.JsonEnumSchema)jsonSchemaElement).description()).enumValues(((dev.langchain4j.model.chat.request.json.JsonEnumSchema)jsonSchemaElement).enumValues()).build();
        }
        if (jsonSchemaElement instanceof JsonArraySchema) {
            return dev.ai4j.openai4j.chat.JsonArraySchema.builder().description(((JsonArraySchema)jsonSchemaElement).description()).items(InternalOpenAiHelper.toOpenAiJsonSchemaElement(((JsonArraySchema)jsonSchemaElement).items())).build();
        }
        if (jsonSchemaElement instanceof dev.langchain4j.model.chat.request.json.JsonObjectSchema) {
            Map properties = ((dev.langchain4j.model.chat.request.json.JsonObjectSchema)jsonSchemaElement).properties();
            LinkedHashMap openAiProperties = new LinkedHashMap();
            properties.forEach((key, value) -> openAiProperties.put(key, InternalOpenAiHelper.toOpenAiJsonSchemaElement(value)));
            return JsonObjectSchema.builder().description(((dev.langchain4j.model.chat.request.json.JsonObjectSchema)jsonSchemaElement).description()).properties(openAiProperties).required(((dev.langchain4j.model.chat.request.json.JsonObjectSchema)jsonSchemaElement).required()).additionalProperties(((dev.langchain4j.model.chat.request.json.JsonObjectSchema)jsonSchemaElement).additionalProperties()).build();
        }
        throw new IllegalArgumentException("Unknown type: " + jsonSchemaElement);
    }
}

