/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.tree;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLObjectTreeNode<N extends OWLObject>
extends DefaultMutableTreeNode {
    private final OWLObjectTree tree;
    private boolean isLoaded;
    private final Set<N> equivalentObjects = new HashSet<N>();
    @Nullable
    private Object relationship;

    public OWLObjectTreeNode(Object userObject, OWLObjectTree tree) {
        super(userObject);
        this.tree = tree;
        this.isLoaded = false;
    }

    public void addEquivalentObject(N object) {
        this.equivalentObjects.add(object);
    }

    public Set<N> getEquivalentObjects() {
        if (this.getUserObject() == null) {
            return Collections.emptySet();
        }
        Set<OWLObject> equivalents = this.tree.getProvider().getEquivalents((OWLObject)this.getUserObject());
        equivalents.remove(this.getUserObject());
        return Sets.union(equivalents, this.equivalentObjects);
    }

    public OWLObjectTreeNode(OWLObjectTree tree) {
        this.tree = tree;
    }

    @Override
    public boolean isRoot() {
        return this.getUserObject() == null;
    }

    @Nullable
    public N getOWLObject() {
        return (N)((OWLObject)this.getUserObject());
    }

    public void setRelationship(@Nonnull Object rel) {
        this.relationship = rel;
    }

    public Optional<Object> getRelationship() {
        return Optional.ofNullable(this.relationship);
    }

    protected boolean isLoaded() {
        return this.isLoaded;
    }

    protected void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    protected synchronized void loadChildrenIfNecessary() {
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        Object parentObject = null;
        OWLObjectTreeNode parentNode = (OWLObjectTreeNode)this.getParent();
        if (this.getParent() != null) {
            parentObject = parentNode.getOWLObject();
        }
        List nodes = this.tree.getChildNodes(this);
        for (OWLObjectTreeNode child : nodes) {
            this.add(child);
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.loadChildrenIfNecessary();
        return super.getChildAt(childIndex);
    }

    @Override
    public int getChildCount() {
        this.loadChildrenIfNecessary();
        return super.getChildCount();
    }

    @Override
    public TreeNode getParent() {
        return super.getParent();
    }

    @Override
    public int getIndex(TreeNode node) {
        this.loadChildrenIfNecessary();
        return super.getIndex(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Enumeration children() {
        this.loadChildrenIfNecessary();
        return super.children();
    }
}

