/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agui;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.agui.BaseEvent;

public class TextMessageContentEvent
extends BaseEvent {
    public static final String TYPE = "TEXT_MESSAGE_CONTENT";
    private String messageId;
    private String delta;

    public TextMessageContentEvent(String messageId, String delta) {
        super(TYPE, System.currentTimeMillis(), null);
        this.messageId = messageId;
        this.delta = delta != null ? delta : "";
    }

    public TextMessageContentEvent(StreamInput input) throws IOException {
        super(input);
        this.messageId = input.readString();
        this.delta = input.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.messageId);
        out.writeString(this.delta);
    }

    @Override
    protected void addEventSpecificFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("messageId", this.messageId);
        builder.field("delta", this.delta);
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getDelta() {
        return this.delta;
    }

    @Generated
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setDelta(String delta) {
        this.delta = delta;
    }

    @Override
    @Generated
    public String toString() {
        return "TextMessageContentEvent(messageId=" + this.getMessageId() + ", delta=" + this.getDelta() + ")";
    }

    @Generated
    public TextMessageContentEvent() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextMessageContentEvent)) {
            return false;
        }
        TextMessageContentEvent other = (TextMessageContentEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$delta = this.getDelta();
        String other$delta = other.getDelta();
        return !(this$delta == null ? other$delta != null : !this$delta.equals(other$delta));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TextMessageContentEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $delta = this.getDelta();
        result = result * 59 + ($delta == null ? 43 : $delta.hashCode());
        return result;
    }
}

