/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.spec;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.EAXBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMModeCipher;
import org.bouncycastle.crypto.modes.OCBBlockCipher;
import org.cryptacular.CryptUtil;
import org.cryptacular.spec.BlockCipherSpec;
import org.cryptacular.spec.Spec;

public class AEADBlockCipherSpec
implements Spec<AEADBlockCipher> {
    public static final Pattern FORMAT = Pattern.compile("(?<alg>[A-Za-z0-9_-]+)/(?<mode>\\w+)");
    private final String algorithm;
    private final String mode;

    public AEADBlockCipherSpec(String algName, String cipherMode) {
        this.algorithm = CryptUtil.assertNotNullArg(algName, "Algorithm name cannot be null.");
        this.mode = CryptUtil.assertNotNullArg(cipherMode, "Cipher mode cannot be null.");
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getMode() {
        return this.mode;
    }

    @Override
    public AEADBlockCipher newInstance() {
        GCMModeCipher aeadBlockCipher;
        BlockCipher blockCipher = new BlockCipherSpec(this.algorithm).newInstance();
        switch (this.mode) {
            case "GCM": {
                aeadBlockCipher = GCMBlockCipher.newInstance((BlockCipher)blockCipher);
                break;
            }
            case "CCM": {
                aeadBlockCipher = CCMBlockCipher.newInstance((BlockCipher)blockCipher);
                break;
            }
            case "OCB": {
                aeadBlockCipher = new OCBBlockCipher(blockCipher, new BlockCipherSpec(this.algorithm).newInstance());
                break;
            }
            case "EAX": {
                aeadBlockCipher = new EAXBlockCipher(blockCipher);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mode " + this.mode);
            }
        }
        return aeadBlockCipher;
    }

    public String toString() {
        return this.algorithm + '/' + this.mode;
    }

    public static AEADBlockCipherSpec parse(String specification) {
        Matcher m = FORMAT.matcher(CryptUtil.assertNotNullArg(specification, "Specification cannot be null."));
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid specification " + specification);
        }
        return new AEADBlockCipherSpec(m.group("alg"), m.group("mode"));
    }
}

