/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.contextmanager;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.contextmanager.ActivationRule;
import org.opensearch.ml.common.contextmanager.ActivationRuleFactory;
import org.opensearch.ml.common.contextmanager.ContextManager;
import org.opensearch.ml.common.contextmanager.ContextManagerContext;
import org.opensearch.ml.engine.algorithms.contextmanager.ContextManagerUtils;

public class SlidingWindowManager
implements ContextManager {
    @Generated
    private static final Logger log = LogManager.getLogger(SlidingWindowManager.class);
    public static final String TYPE = "SlidingWindowManager";
    private static final String MAX_MESSAGES_KEY = "max_messages";
    private static final int DEFAULT_MAX_MESSAGES = 20;
    private int maxMessages;
    private List<ActivationRule> activationRules;

    public String getType() {
        return TYPE;
    }

    public void initialize(Map<String, Object> config) {
        this.maxMessages = this.parseIntegerConfig(config, MAX_MESSAGES_KEY, 20);
        if (this.maxMessages <= 0) {
            log.warn("Invalid max_messages value: {}, using default {}", (Object)this.maxMessages, (Object)20);
            this.maxMessages = 20;
        }
        Map activationConfig = (Map)config.get("activation");
        this.activationRules = ActivationRuleFactory.createRules((Map)activationConfig);
        log.info("Initialized SlidingWindowManager: maxMessages={}", (Object)this.maxMessages);
    }

    public boolean shouldActivate(ContextManagerContext context) {
        if (this.activationRules == null || this.activationRules.isEmpty()) {
            return true;
        }
        for (ActivationRule rule : this.activationRules) {
            if (rule.evaluate(context)) continue;
            log.debug("Activation rule not satisfied: {}", (Object)rule.getDescription());
            return false;
        }
        log.debug("All activation rules satisfied, manager will execute");
        return true;
    }

    public void execute(ContextManagerContext context) {
        List interactions = context.getToolInteractions();
        if (interactions == null || interactions.isEmpty()) {
            log.debug("No tool interactions to process");
            return;
        }
        if (interactions.isEmpty()) {
            log.debug("No string interactions found in tool interactions");
            return;
        }
        int originalSize = interactions.size();
        if (originalSize <= this.maxMessages) {
            log.debug("Interactions size ({}) is within limit ({}), no truncation needed", (Object)originalSize, (Object)this.maxMessages);
            return;
        }
        int startIndex = ContextManagerUtils.findSafePoint(interactions, originalSize - this.maxMessages, true);
        ArrayList updatedInteractions = new ArrayList(interactions.subList(startIndex, originalSize));
        context.setToolInteractions(updatedInteractions);
        HashMap<String, CallSite> parameters = context.getParameters();
        if (parameters == null) {
            parameters = new HashMap<String, CallSite>();
            context.setParameters(parameters);
        }
        parameters.put("_interactions", (CallSite)((Object)(", " + String.join((CharSequence)", ", updatedInteractions))));
        int removedMessages = originalSize - updatedInteractions.size();
        log.info("Applied sliding window: kept {} most recent interactions, removed {} older interactions", (Object)updatedInteractions.size(), (Object)removedMessages);
    }

    private int parseIntegerConfig(Map<String, Object> config, String key, int defaultValue) {
        Object value = config.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            log.warn("Invalid type for config key '{}': {}, using default {}", (Object)key, (Object)value.getClass().getSimpleName(), (Object)defaultValue);
            return defaultValue;
        }
        catch (NumberFormatException e) {
            log.warn("Invalid integer value for config key '{}': {}, using default {}", (Object)key, value, (Object)defaultValue);
            return defaultValue;
        }
    }
}

