/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.io;

import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.provenance.io.ObjectMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ProvenanceSerializationException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public interface ProvenanceSerialization {
    public String getFileExtension();

    public List<ObjectMarshalledProvenance> deserializeFromFile(Path var1) throws ProvenanceSerializationException, IOException;

    public List<ObjectMarshalledProvenance> deserializeFromString(String var1) throws ProvenanceSerializationException;

    default public ObjectProvenance deserializeAndUnmarshal(Path path) throws ProvenanceSerializationException, IOException {
        return ProvenanceUtil.unmarshalProvenance(this.deserializeFromFile(path));
    }

    default public ObjectProvenance deserializeAndUnmarshal(String input) throws ProvenanceSerializationException {
        return ProvenanceUtil.unmarshalProvenance(this.deserializeFromString(input));
    }

    public String serializeToString(List<ObjectMarshalledProvenance> var1);

    public void serializeToFile(List<ObjectMarshalledProvenance> var1, Path var2) throws IOException;

    default public String marshalAndSerialize(ObjectProvenance provenance) {
        return this.serializeToString(ProvenanceUtil.marshalProvenance(provenance));
    }

    default public void marshalAndSerialize(ObjectProvenance provenance, Path path) throws IOException {
        this.serializeToFile(ProvenanceUtil.marshalProvenance(provenance), path);
    }
}

