/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.search.ScoreMode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RescoreQuery
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RescoreQuery> {
    @Nullable
    private final Float queryWeight;
    @Nonnull
    private final Query rescoreQuery;
    @Nullable
    private final Float rescoreQueryWeight;
    @Nullable
    private final ScoreMode scoreMode;
    public static final JsonpDeserializer<RescoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RescoreQuery::setupRescoreQueryDeserializer);

    private RescoreQuery(Builder builder) {
        this.queryWeight = builder.queryWeight;
        this.rescoreQuery = ApiTypeHelper.requireNonNull(builder.rescoreQuery, this, "rescoreQuery");
        this.rescoreQueryWeight = builder.rescoreQueryWeight;
        this.scoreMode = builder.scoreMode;
    }

    public static RescoreQuery of(Function<Builder, ObjectBuilder<RescoreQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Float queryWeight() {
        return this.queryWeight;
    }

    @Nonnull
    public final Query rescoreQuery() {
        return this.rescoreQuery;
    }

    @Nullable
    public final Float rescoreQueryWeight() {
        return this.rescoreQueryWeight;
    }

    @Nullable
    public final ScoreMode scoreMode() {
        return this.scoreMode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.queryWeight != null) {
            generator.writeKey("query_weight");
            generator.write((double)this.queryWeight.floatValue());
        }
        generator.writeKey("rescore_query");
        this.rescoreQuery.serialize(generator, mapper);
        if (this.rescoreQueryWeight != null) {
            generator.writeKey("rescore_query_weight");
            generator.write((double)this.rescoreQueryWeight.floatValue());
        }
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRescoreQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::queryWeight, JsonpDeserializer.floatDeserializer(), "query_weight");
        op.add(Builder::rescoreQuery, Query._DESERIALIZER, "rescore_query");
        op.add(Builder::rescoreQueryWeight, JsonpDeserializer.floatDeserializer(), "rescore_query_weight");
        op.add(Builder::scoreMode, ScoreMode._DESERIALIZER, "score_mode");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.queryWeight);
        result = 31 * result + this.rescoreQuery.hashCode();
        result = 31 * result + Objects.hashCode(this.rescoreQueryWeight);
        result = 31 * result + Objects.hashCode(this.scoreMode);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RescoreQuery other = (RescoreQuery)o;
        return Objects.equals(this.queryWeight, other.queryWeight) && this.rescoreQuery.equals(other.rescoreQuery) && Objects.equals(this.rescoreQueryWeight, other.rescoreQueryWeight) && Objects.equals(this.scoreMode, other.scoreMode);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RescoreQuery> {
        @Nullable
        private Float queryWeight;
        private Query rescoreQuery;
        @Nullable
        private Float rescoreQueryWeight;
        @Nullable
        private ScoreMode scoreMode;

        public Builder() {
        }

        private Builder(RescoreQuery o) {
            this.queryWeight = o.queryWeight;
            this.rescoreQuery = o.rescoreQuery;
            this.rescoreQueryWeight = o.rescoreQueryWeight;
            this.scoreMode = o.scoreMode;
        }

        private Builder(Builder o) {
            this.queryWeight = o.queryWeight;
            this.rescoreQuery = o.rescoreQuery;
            this.rescoreQueryWeight = o.rescoreQueryWeight;
            this.scoreMode = o.scoreMode;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder queryWeight(@Nullable Float value) {
            this.queryWeight = value;
            return this;
        }

        @Nonnull
        public final Builder rescoreQuery(Query value) {
            this.rescoreQuery = value;
            return this;
        }

        @Nonnull
        public final Builder rescoreQuery(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.rescoreQuery(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder rescoreQueryWeight(@Nullable Float value) {
            this.rescoreQueryWeight = value;
            return this;
        }

        @Nonnull
        public final Builder scoreMode(@Nullable ScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        @Override
        @Nonnull
        public RescoreQuery build() {
            this._checkSingleUse();
            return new RescoreQuery(this);
        }
    }
}

