/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AccessScopePathListRequestCopier;
import software.amazon.awssdk.services.ec2.model.AccessScopePathRequest;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkInsightsAccessScopeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateNetworkInsightsAccessScopeRequest> {
    private static final SdkField<List<AccessScopePathRequest>> MATCH_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchPaths").getter(CreateNetworkInsightsAccessScopeRequest.getter(CreateNetworkInsightsAccessScopeRequest::matchPaths)).setter(CreateNetworkInsightsAccessScopeRequest.setter(Builder::matchPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchPath").unmarshallLocationName("MatchPath").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessScopePathRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<AccessScopePathRequest>> EXCLUDE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludePaths").getter(CreateNetworkInsightsAccessScopeRequest.getter(CreateNetworkInsightsAccessScopeRequest::excludePaths)).setter(CreateNetworkInsightsAccessScopeRequest.setter(Builder::excludePaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludePath").unmarshallLocationName("ExcludePath").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessScopePathRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateNetworkInsightsAccessScopeRequest.getter(CreateNetworkInsightsAccessScopeRequest::clientToken)).setter(CreateNetworkInsightsAccessScopeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateNetworkInsightsAccessScopeRequest.getter(CreateNetworkInsightsAccessScopeRequest::tagSpecifications)).setter(CreateNetworkInsightsAccessScopeRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateNetworkInsightsAccessScopeRequest.getter(CreateNetworkInsightsAccessScopeRequest::dryRun)).setter(CreateNetworkInsightsAccessScopeRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_PATHS_FIELD, EXCLUDE_PATHS_FIELD, CLIENT_TOKEN_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateNetworkInsightsAccessScopeRequest.memberNameToFieldInitializer();
    private final List<AccessScopePathRequest> matchPaths;
    private final List<AccessScopePathRequest> excludePaths;
    private final String clientToken;
    private final List<TagSpecification> tagSpecifications;
    private final Boolean dryRun;

    private CreateNetworkInsightsAccessScopeRequest(BuilderImpl builder) {
        super(builder);
        this.matchPaths = builder.matchPaths;
        this.excludePaths = builder.excludePaths;
        this.clientToken = builder.clientToken;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
    }

    public final boolean hasMatchPaths() {
        return this.matchPaths != null && !(this.matchPaths instanceof SdkAutoConstructList);
    }

    public final List<AccessScopePathRequest> matchPaths() {
        return this.matchPaths;
    }

    public final boolean hasExcludePaths() {
        return this.excludePaths != null && !(this.excludePaths instanceof SdkAutoConstructList);
    }

    public final List<AccessScopePathRequest> excludePaths() {
        return this.excludePaths;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchPaths() ? this.matchPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludePaths() ? this.excludePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInsightsAccessScopeRequest)) {
            return false;
        }
        CreateNetworkInsightsAccessScopeRequest other = (CreateNetworkInsightsAccessScopeRequest)((Object)obj);
        return this.hasMatchPaths() == other.hasMatchPaths() && Objects.equals(this.matchPaths(), other.matchPaths()) && this.hasExcludePaths() == other.hasExcludePaths() && Objects.equals(this.excludePaths(), other.excludePaths()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNetworkInsightsAccessScopeRequest").add("MatchPaths", this.hasMatchPaths() ? this.matchPaths() : null).add("ExcludePaths", this.hasExcludePaths() ? this.excludePaths() : null).add("ClientToken", (Object)this.clientToken()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchPaths": {
                return Optional.ofNullable(clazz.cast(this.matchPaths()));
            }
            case "ExcludePaths": {
                return Optional.ofNullable(clazz.cast(this.excludePaths()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MatchPath", MATCH_PATHS_FIELD);
        map.put("ExcludePath", EXCLUDE_PATHS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInsightsAccessScopeRequest, T> g) {
        return obj -> g.apply((CreateNetworkInsightsAccessScopeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<AccessScopePathRequest> matchPaths = DefaultSdkAutoConstructList.getInstance();
        private List<AccessScopePathRequest> excludePaths = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInsightsAccessScopeRequest model) {
            super(model);
            this.matchPaths(model.matchPaths);
            this.excludePaths(model.excludePaths);
            this.clientToken(model.clientToken);
            this.tagSpecifications(model.tagSpecifications);
            this.dryRun(model.dryRun);
        }

        public final List<AccessScopePathRequest.Builder> getMatchPaths() {
            List<AccessScopePathRequest.Builder> result = AccessScopePathListRequestCopier.copyToBuilder(this.matchPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchPaths(Collection<AccessScopePathRequest.BuilderImpl> matchPaths) {
            this.matchPaths = AccessScopePathListRequestCopier.copyFromBuilder(matchPaths);
        }

        @Override
        public final Builder matchPaths(Collection<AccessScopePathRequest> matchPaths) {
            this.matchPaths = AccessScopePathListRequestCopier.copy(matchPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPaths(AccessScopePathRequest ... matchPaths) {
            this.matchPaths(Arrays.asList(matchPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPaths(Consumer<AccessScopePathRequest.Builder> ... matchPaths) {
            this.matchPaths(Stream.of(matchPaths).map(c -> (AccessScopePathRequest)((AccessScopePathRequest.Builder)AccessScopePathRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AccessScopePathRequest.Builder> getExcludePaths() {
            List<AccessScopePathRequest.Builder> result = AccessScopePathListRequestCopier.copyToBuilder(this.excludePaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludePaths(Collection<AccessScopePathRequest.BuilderImpl> excludePaths) {
            this.excludePaths = AccessScopePathListRequestCopier.copyFromBuilder(excludePaths);
        }

        @Override
        public final Builder excludePaths(Collection<AccessScopePathRequest> excludePaths) {
            this.excludePaths = AccessScopePathListRequestCopier.copy(excludePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludePaths(AccessScopePathRequest ... excludePaths) {
            this.excludePaths(Arrays.asList(excludePaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludePaths(Consumer<AccessScopePathRequest.Builder> ... excludePaths) {
            this.excludePaths(Stream.of(excludePaths).map(c -> (AccessScopePathRequest)((AccessScopePathRequest.Builder)AccessScopePathRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkInsightsAccessScopeRequest build() {
            return new CreateNetworkInsightsAccessScopeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkInsightsAccessScopeRequest> {
        public Builder matchPaths(Collection<AccessScopePathRequest> var1);

        public Builder matchPaths(AccessScopePathRequest ... var1);

        public Builder matchPaths(Consumer<AccessScopePathRequest.Builder> ... var1);

        public Builder excludePaths(Collection<AccessScopePathRequest> var1);

        public Builder excludePaths(AccessScopePathRequest ... var1);

        public Builder excludePaths(Consumer<AccessScopePathRequest.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

