/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core.action.node;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.alerting.core.JobSweeper;
import org.opensearch.alerting.core.JobSweeperMetrics;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.alerting.core.action.node.ScheduledJobStats;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsRequest;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsResponse;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsTransportActionKt;
import org.opensearch.alerting.core.schedule.JobScheduler;
import org.opensearch.alerting.core.schedule.JobSchedulerMetrics;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001:\u0001*BA\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J,\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00022\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001dH\u0014J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0004H\u0014J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0002H\u0002J\u001e\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsTransportAction;", "Lorg/opensearch/action/support/nodes/TransportNodesAction;", "Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsRequest;", "Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsResponse;", "Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsTransportAction$ScheduledJobStatusRequest;", "Lorg/opensearch/alerting/core/action/node/ScheduledJobStats;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "jobSweeper", "Lorg/opensearch/alerting/core/JobSweeper;", "jobScheduler", "Lorg/opensearch/alerting/core/schedule/JobScheduler;", "scheduledJobIndices", "Lorg/opensearch/alerting/core/ScheduledJobIndices;", "<init>", "(Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/alerting/core/JobSweeper;Lorg/opensearch/alerting/core/schedule/JobScheduler;Lorg/opensearch/alerting/core/ScheduledJobIndices;)V", "newNodeRequest", "request", "newNodeResponse", "si", "Lorg/opensearch/core/common/io/stream/StreamInput;", "newResponse", "responses", "", "failures", "Lorg/opensearch/action/FailedNodeException;", "nodeOperation", "createScheduledJobStatus", "scheduledJobsStatusRequest", "evaluateStatus", "Lorg/opensearch/alerting/core/action/node/ScheduledJobStats$ScheduleStatus;", "jobsInfo", "", "Lorg/opensearch/alerting/core/schedule/JobSchedulerMetrics;", "jobSweeperMetrics", "Lorg/opensearch/alerting/core/JobSweeperMetrics;", "ScheduledJobStatusRequest", "alerting-core"})
@SourceDebugExtension(value={"SMAP\nScheduledJobsStatsTransportAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScheduledJobsStatsTransportAction.kt\norg/opensearch/alerting/core/action/node/ScheduledJobsStatsTransportAction\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n37#2:142\n36#2,3:143\n1740#3,3:146\n*S KotlinDebug\n*F\n+ 1 ScheduledJobsStatsTransportAction.kt\norg/opensearch/alerting/core/action/node/ScheduledJobsStatsTransportAction\n*L\n104#1:142\n104#1:143,3\n112#1:146,3\n*E\n"})
public final class ScheduledJobsStatsTransportAction
extends TransportNodesAction<ScheduledJobsStatsRequest, ScheduledJobsStatsResponse, ScheduledJobStatusRequest, ScheduledJobStats> {
    @NotNull
    private final JobSweeper jobSweeper;
    @NotNull
    private final JobScheduler jobScheduler;
    @NotNull
    private final ScheduledJobIndices scheduledJobIndices;

    @Inject
    public ScheduledJobsStatsTransportAction(@NotNull ThreadPool threadPool, @NotNull ClusterService clusterService, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull JobSweeper jobSweeper, @NotNull JobScheduler jobScheduler, @NotNull ScheduledJobIndices scheduledJobIndices) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)((Object)jobSweeper), (String)"jobSweeper");
        Intrinsics.checkNotNullParameter((Object)jobScheduler, (String)"jobScheduler");
        Intrinsics.checkNotNullParameter((Object)scheduledJobIndices, (String)"scheduledJobIndices");
        super("cluster:admin/opendistro/_scheduled_jobs/stats", threadPool, clusterService, transportService, actionFilters, ScheduledJobsStatsTransportAction::_init_$lambda$0, ScheduledJobsStatsTransportAction::_init_$lambda$1, "management", ScheduledJobStats.class);
        this.jobSweeper = jobSweeper;
        this.jobScheduler = jobScheduler;
        this.scheduledJobIndices = scheduledJobIndices;
    }

    @NotNull
    protected ScheduledJobStatusRequest newNodeRequest(@NotNull ScheduledJobsStatsRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return new ScheduledJobStatusRequest(request);
    }

    @NotNull
    protected ScheduledJobStats newNodeResponse(@NotNull StreamInput si) {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        return new ScheduledJobStats(si);
    }

    @NotNull
    protected ScheduledJobsStatsResponse newResponse(@NotNull ScheduledJobsStatsRequest request, @NotNull List<ScheduledJobStats> responses, @NotNull List<FailedNodeException> failures) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(responses, (String)"responses");
        Intrinsics.checkNotNullParameter(failures, (String)"failures");
        boolean scheduledJobEnabled = this.jobSweeper.isSweepingEnabled();
        boolean scheduledJobIndexExist = this.scheduledJobIndices.scheduledJobIndexExists();
        ClusterIndexHealth indexHealth = scheduledJobIndexExist ? this.scheduledJobIndices.scheduledJobIndexHealth() : null;
        ClusterName clusterName = this.clusterService.getClusterName();
        Intrinsics.checkNotNullExpressionValue((Object)clusterName, (String)"getClusterName(...)");
        return new ScheduledJobsStatsResponse(clusterName, responses, failures, scheduledJobEnabled, scheduledJobIndexExist, indexHealth);
    }

    @NotNull
    protected ScheduledJobStats nodeOperation(@NotNull ScheduledJobStatusRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.createScheduledJobStatus(request.getRequest());
    }

    private final ScheduledJobStats createScheduledJobStatus(ScheduledJobsStatsRequest scheduledJobsStatusRequest) {
        JobSchedulerMetrics[] jobSchedulerMetricsArray;
        JobSweeperMetrics jobSweeperMetrics = this.jobSweeper.getJobSweeperMetrics();
        List<JobSchedulerMetrics> jobSchedulerMetrics = this.jobScheduler.getJobSchedulerMetric(scheduledJobsStatusRequest.getShowAlertingV2ScheduledJobs());
        ScheduledJobStats.ScheduleStatus status = this.evaluateStatus(jobSchedulerMetrics, jobSweeperMetrics);
        DiscoveryNode discoveryNode = this.transportService.getLocalNode();
        Intrinsics.checkNotNullExpressionValue((Object)discoveryNode, (String)"getLocalNode(...)");
        JobSweeperMetrics jobSweeperMetrics2 = scheduledJobsStatusRequest.getJobSchedulingMetrics() ? jobSweeperMetrics : null;
        if (scheduledJobsStatusRequest.getJobsInfo()) {
            Collection $this$toTypedArray$iv = jobSchedulerMetrics;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            jobSchedulerMetricsArray = thisCollection$iv.toArray(new JobSchedulerMetrics[0]);
        } else {
            jobSchedulerMetricsArray = null;
        }
        return new ScheduledJobStats(discoveryNode, status, jobSweeperMetrics2, jobSchedulerMetricsArray);
    }

    private final ScheduledJobStats.ScheduleStatus evaluateStatus(List<JobSchedulerMetrics> jobsInfo, JobSweeperMetrics jobSweeperMetrics) {
        boolean allJobsRunningOnTime;
        block4: {
            Iterable $this$all$iv = jobsInfo;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    JobSchedulerMetrics it = (JobSchedulerMetrics)element$iv;
                    boolean bl = false;
                    if (it.getRunningOnTime()) continue;
                    v0 = false;
                    break block4;
                }
                v0 = allJobsRunningOnTime = true;
            }
        }
        if (allJobsRunningOnTime && jobSweeperMetrics.getFullSweepOnTime()) {
            return ScheduledJobStats.ScheduleStatus.GREEN;
        }
        ScheduledJobsStatsTransportActionKt.access$getLog$p().info("Jobs Running on time: " + allJobsRunningOnTime + ", Sweeper on time: " + jobSweeperMetrics.getFullSweepOnTime());
        return ScheduledJobStats.ScheduleStatus.RED;
    }

    private static final ScheduledJobsStatsRequest _init_$lambda$0(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new ScheduledJobsStatsRequest(it);
    }

    private static final ScheduledJobStatusRequest _init_$lambda$1(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new ScheduledJobStatusRequest(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsTransportAction$ScheduledJobStatusRequest;", "Lorg/opensearch/transport/TransportRequest;", "<init>", "()V", "si", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "request", "Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsRequest;", "(Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsRequest;)V", "getRequest", "()Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsRequest;", "setRequest", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "alerting-core"})
    public static final class ScheduledJobStatusRequest
    extends TransportRequest {
        public ScheduledJobsStatsRequest request;

        @NotNull
        public final ScheduledJobsStatsRequest getRequest() {
            ScheduledJobsStatsRequest scheduledJobsStatsRequest = this.request;
            if (scheduledJobsStatsRequest != null) {
                return scheduledJobsStatsRequest;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            return null;
        }

        public final void setRequest(@NotNull ScheduledJobsStatsRequest scheduledJobsStatsRequest) {
            Intrinsics.checkNotNullParameter((Object)((Object)scheduledJobsStatsRequest), (String)"<set-?>");
            this.request = scheduledJobsStatsRequest;
        }

        public ScheduledJobStatusRequest() {
        }

        public ScheduledJobStatusRequest(@NotNull StreamInput si) {
            Intrinsics.checkNotNullParameter((Object)si, (String)"si");
            super(si);
            this.setRequest(new ScheduledJobsStatsRequest(si));
        }

        public ScheduledJobStatusRequest(@NotNull ScheduledJobsStatsRequest request) {
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.setRequest(request);
        }

        public void writeTo(@NotNull StreamOutput out) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super.writeTo(out);
            this.getRequest().writeTo(out);
        }
    }
}

