/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.streams.kstream.internals.graph.BaseRepartitionNode;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;

public class NodesWithRelaxedNullKeyJoinDownstream {
    private final HashSet<GraphNode> visited;
    private final HashSet<GraphNode> nonOptimizable;
    private final GraphNode start;

    public NodesWithRelaxedNullKeyJoinDownstream(GraphNode root) {
        this.start = root;
        this.visited = new HashSet();
        this.nonOptimizable = new HashSet();
    }

    public Set<BaseRepartitionNode<?, ?>> find() {
        this.traverseGraph(this.start);
        return this.visited.stream().filter(node -> node instanceof BaseRepartitionNode && !this.nonOptimizable.contains(node)).map(node -> (BaseRepartitionNode)node).collect(Collectors.toSet());
    }

    private void traverseGraph(GraphNode node) {
        if (!this.visited.contains(node)) {
            for (GraphNode child : node.children()) {
                this.traverseGraph(child);
                if (!child.labels().contains((Object)GraphNode.Label.NULL_KEY_RELAXED_JOIN) && !this.nonOptimizable.contains(child)) continue;
                this.nonOptimizable.add(node);
            }
            this.visited.add(node);
        }
    }
}

