/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.List;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.AbstractProjectSpec;
import org.gradle.initialization.ProjectDescriptorInternal;
import org.gradle.initialization.ProjectDescriptorRegistry;

public class CurrentDirectoryProjectSpec
extends AbstractProjectSpec {
    private final boolean useRootWhenNoMatch;
    private final File currentDir;

    public CurrentDirectoryProjectSpec(File currentDir, SettingsInternal settings) {
        this.currentDir = currentDir;
        this.useRootWhenNoMatch = currentDir.equals(settings.getSettingsDir());
    }

    @Override
    protected void select(ProjectDescriptorRegistry candidates, List<ProjectDescriptorInternal> matches) {
        for (ProjectDescriptorInternal candidate : candidates.getAllProjects()) {
            if (!candidate.getProjectDir().equals(this.currentDir)) continue;
            matches.add(candidate);
        }
        if (this.useRootWhenNoMatch && matches.isEmpty()) {
            matches.add(candidates.getRootProject());
        }
    }

    @Override
    protected String formatNoMatchesMessage(String settings) {
        return String.format("Project directory '%s' is not part of the build defined by %s.", this.currentDir, settings);
    }

    @Override
    protected String formatMultipleMatchesMessage(Iterable<ProjectDescriptorInternal> matches) {
        return String.format("Multiple projects in this build have project directory '%s': %s", this.currentDir, matches);
    }
}

