/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.DisambiguationRuleChain;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.attributes.AttributeMatchException;
import org.gradle.api.internal.attributes.AttributeMatchingRules;
import org.gradle.internal.action.ConfigurableRule;
import org.gradle.internal.action.DefaultConfigurableRule;
import org.gradle.internal.action.DefaultConfigurableRules;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.type.ModelType;

public class DefaultDisambiguationRuleChain<T>
implements DisambiguationRuleChain<T> {
    private final List<Action<? super MultipleCandidatesDetails<T>>> rules = new ArrayList<Action<? super MultipleCandidatesDetails<T>>>();
    private final Instantiator instantiator;
    private final IsolatableFactory isolatableFactory;

    public DefaultDisambiguationRuleChain(Instantiator instantiator, IsolatableFactory isolatableFactory) {
        this.instantiator = instantiator;
        this.isolatableFactory = isolatableFactory;
    }

    public void add(Class<? extends AttributeDisambiguationRule<T>> ruleClass, Action<? super ActionConfiguration> configureAction) {
        ConfigurableRule rule = DefaultConfigurableRule.of(ruleClass, configureAction, (IsolatableFactory)this.isolatableFactory);
        this.rules.add(DefaultDisambiguationRuleChain.createAction(rule, this.instantiator));
    }

    public void add(Class<? extends AttributeDisambiguationRule<T>> ruleClass) {
        ConfigurableRule rule = DefaultConfigurableRule.of(ruleClass);
        this.rules.add(DefaultDisambiguationRuleChain.createAction(rule, this.instantiator));
    }

    public void pickFirst(Comparator<? super T> comparator) {
        Action<MultipleCandidatesDetails<? super T>> rule = AttributeMatchingRules.orderedDisambiguation(comparator, true);
        this.rules.add(rule);
    }

    public void pickLast(Comparator<? super T> comparator) {
        Action<MultipleCandidatesDetails<? super T>> rule = AttributeMatchingRules.orderedDisambiguation(comparator, false);
        this.rules.add(rule);
    }

    public List<Action<? super MultipleCandidatesDetails<T>>> getRules() {
        return this.rules;
    }

    public static <T> Action<MultipleCandidatesDetails<T>> createAction(ConfigurableRule<MultipleCandidatesDetails<T>> rule, Instantiator instantiator) {
        return new InstantiatingAction(DefaultConfigurableRules.of(rule), instantiator, new ExceptionHandler(rule.getRuleClass()));
    }

    private static class ExceptionHandler<T>
    implements InstantiatingAction.ExceptionHandler<MultipleCandidatesDetails<T>> {
        private final Class<?> rule;

        private ExceptionHandler(Class<?> rule) {
            this.rule = rule;
        }

        public void handleException(MultipleCandidatesDetails<T> details, Throwable throwable) {
            TreeSet orderedValues = Sets.newTreeSet((Comparator)Ordering.usingToString());
            orderedValues.addAll(details.getCandidateValues());
            throw new AttributeMatchException(String.format("Could not select value from candidates %s using %s.", orderedValues, ModelType.of(this.rule).getDisplayName()), throwable);
        }
    }
}

