/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.net.URLConnection;
import org.gradle.api.JavaVersion;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.reflect.JavaMethod;
import org.jspecify.annotations.Nullable;

public abstract class ClassLoaderUtils {
    private static final ClassDefiner CLASS_DEFINER = JavaVersion.current().isJava9Compatible() ? new LookupClassDefiner() : new ReflectionClassDefiner();
    private static final ClassLoaderPackagesFetcher CLASS_LOADER_PACKAGES_FETCHER = JavaVersion.current().isJava9Compatible() ? new Java9PackagesFetcher() : new ReflectionPackagesFetcher();

    public static ClassLoader getPlatformClassLoader() {
        return ClassLoader.getSystemClassLoader().getParent();
    }

    public static void tryClose(@Nullable ClassLoader classLoader) {
        CompositeStoppable.stoppable((Object[])new Object[]{classLoader}).stop();
    }

    public static void disableUrlConnectionCaching() {
        try {
            URL url = new URL("jar:file://valid_jar_url_syntax.jar!/");
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    static Package[] getPackages(ClassLoader classLoader) {
        return CLASS_LOADER_PACKAGES_FETCHER.getPackages(classLoader);
    }

    static @Nullable Package getPackage(ClassLoader classLoader, String name) {
        return CLASS_LOADER_PACKAGES_FETCHER.getPackage(classLoader, name);
    }

    public static <T> Class<T> define(ClassLoader targetClassLoader, String className, byte[] clazzBytes) {
        return CLASS_DEFINER.defineClass(targetClassLoader, className, clazzBytes);
    }

    public static <T> Class<T> defineDecorator(Class<?> decoratedClass, ClassLoader targetClassLoader, String className, byte[] clazzBytes) {
        return CLASS_DEFINER.defineDecoratorClass(decoratedClass, targetClassLoader, className, clazzBytes);
    }

    public static Class<?> classFromContextLoader(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> @Nullable T executeInClassloader(ClassLoader classLoader, Factory<T> factory) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Object object = factory.create();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static interface ClassLoaderPackagesFetcher {
        public Package[] getPackages(ClassLoader var1);

        public @Nullable Package getPackage(ClassLoader var1, String var2);
    }

    private static interface ClassDefiner {
        public <T> Class<T> defineClass(ClassLoader var1, String var2, byte[] var3);

        public <T> Class<T> defineDecoratorClass(Class<?> var1, ClassLoader var2, String var3, byte[] var4);
    }

    private static class LookupClassDefiner
    extends AbstractClassLoaderLookuper
    implements ClassDefiner {
        private MethodType defineClassMethodType = MethodType.methodType(Class.class, new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});

        private LookupClassDefiner() {
        }

        @Override
        public <T> Class<T> defineDecoratorClass(Class<?> decoratedClass, ClassLoader classLoader, String className, byte[] classBytes) {
            try {
                if (decoratedClass.getClassLoader() == classLoader) {
                    MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(decoratedClass, this.baseLookup);
                    return lookup.defineClass(classBytes);
                }
                return this.defineClass(classLoader, className, classBytes);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public <T> Class<T> defineClass(ClassLoader classLoader, String className, byte[] classBytes) {
            return (Class)this.invoke(classLoader, "defineClass", this.defineClassMethodType, className, classBytes, 0, classBytes.length);
        }
    }

    private static class ReflectionClassDefiner
    implements ClassDefiner {
        private final JavaMethod<ClassLoader, Class> defineClassMethod = JavaMethod.of(ClassLoader.class, Class.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});

        private ReflectionClassDefiner() {
        }

        @Override
        public <T> Class<T> defineClass(ClassLoader classLoader, String className, byte[] classBytes) {
            return (Class)this.defineClassMethod.invoke((Object)classLoader, new Object[]{className, classBytes, 0, classBytes.length});
        }

        @Override
        public <T> Class<T> defineDecoratorClass(Class<?> decoratedClass, ClassLoader classLoader, String className, byte[] classBytes) {
            return this.defineClass(classLoader, className, classBytes);
        }
    }

    private static class Java9PackagesFetcher
    implements ClassLoaderPackagesFetcher {
        private Java9PackagesFetcher() {
        }

        @Override
        public Package[] getPackages(ClassLoader classLoader) {
            return new ClassLoader(classLoader){

                @Override
                protected Package[] getPackages() {
                    return super.getPackages();
                }
            }.getPackages();
        }

        @Override
        public @Nullable Package getPackage(ClassLoader classLoader, String name) {
            return new ClassLoader(classLoader){

                @Override
                protected Package getPackage(String name) {
                    return super.getPackage(name);
                }
            }.getPackage(name);
        }
    }

    private static class ReflectionPackagesFetcher
    implements ClassLoaderPackagesFetcher {
        private static final JavaMethod<ClassLoader, Package[]> GET_PACKAGES_METHOD = JavaMethod.of(ClassLoader.class, Package[].class, (String)"getPackages", (Class[])new Class[0]);
        private static final JavaMethod<ClassLoader, Package> GET_PACKAGE_METHOD = JavaMethod.of(ClassLoader.class, Package.class, (String)"getPackage", (Class[])new Class[]{String.class});

        private ReflectionPackagesFetcher() {
        }

        @Override
        public Package[] getPackages(ClassLoader classLoader) {
            return (Package[])GET_PACKAGES_METHOD.invoke((Object)classLoader, new Object[0]);
        }

        @Override
        public @Nullable Package getPackage(ClassLoader classLoader, String name) {
            return (Package)GET_PACKAGE_METHOD.invoke((Object)classLoader, new Object[]{name});
        }
    }

    private static class AbstractClassLoaderLookuper {
        protected MethodHandles.Lookup baseLookup;

        protected AbstractClassLoaderLookuper() {
            try {
                this.baseLookup = MethodHandles.lookup();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        protected <T> T invoke(ClassLoader classLoader, String methodName, MethodType methodType, Object ... arguments) {
            try {
                MethodHandles.Lookup lookup = this.getLookupForClassLoader(classLoader);
                MethodHandle methodHandle = lookup.findVirtual(ClassLoader.class, methodName, methodType);
                return (T)methodHandle.bindTo(classLoader).invokeWithArguments(arguments);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        private MethodHandles.Lookup getLookupForClassLoader(ClassLoader classLoader) throws IllegalAccessException {
            try {
                return MethodHandles.privateLookupIn(classLoader.getClass(), this.baseLookup);
            }
            catch (IllegalAccessException e) {
                return MethodHandles.privateLookupIn(ClassLoader.class, this.baseLookup);
            }
        }
    }
}

