# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/location/version"

require "google/cloud/location/locations/credentials"
require "google/cloud/location/locations/client"
require "google/cloud/location/locations/rest"

module Google
  module Cloud
    module Location
      ##
      # An abstract interface that provides location-related information for
      # a service. Service-specific metadata is provided through the
      # {::Google::Cloud::Location::Location#metadata Location.metadata} field.
      #
      # @example Load this service and instantiate a gRPC client
      #
      #     require "google/cloud/location/locations"
      #     client = ::Google::Cloud::Location::Locations::Client.new
      #
      # @example Load this service and instantiate a REST client
      #
      #     require "google/cloud/location/locations/rest"
      #     client = ::Google::Cloud::Location::Locations::Rest::Client.new
      #
      module Locations
      end
    end
  end
end

helper_path = ::File.join __dir__, "locations", "helpers.rb"
require "google/cloud/location/locations/helpers" if ::File.file? helper_path
