---
stage: Runtime
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: プロジェクトの表示レベル、検索、バッジ、レイアウト
title: プロジェクトで作業を整理する
---

GitLabでは、プロジェクトは開発作業のあらゆる側面を包含する広範なコンテナです。プロジェクトには、コードリポジトリ、コラボレーションツール、プロジェクト管理機能、CI/CD機能が含まれています。開発プロジェクトのすべてのデータを整理するには、プロジェクトを使用します:

- イシューの追跡
- 作業の計画
- コードの共同作業
- CI/CDツールを使用して、アプリケーションを継続的にビルド、テスト、デプロイする

プロジェクトは、[公開、内部、またはプライベート](../public_access.md)で利用できます。GitLabでは、作成できるプライベートプロジェクトの数に制限はありません。

{{< cards >}}

- [はじめに](../get_started/get_started_projects.md)
- [プロジェクトを作成する](_index.md)
- [プロジェクトを管理する](working_with_projects.md)
- [プロジェクトの表示レベル](../public_access.md)
- [プロジェクトの設定](working_with_projects.md)
- [説明テンプレート](description_templates.md)
- [デプロイキー](deploy_keys/_index.md)
- [デプロイトークン](deploy_tokens/_index.md)
- [予約済みのプロジェクト名とグループ名](../reserved_names.md)
- [検索](../search/_index.md)
- [バッジ](badges.md)
- [プロジェクトのトピック](project_topics.md)
- [コードインテリジェンス](code_intelligence.md)
- [インポートと移行](import/_index.md)
- [システムノート](system_notes.md)
- [プロジェクトを管理する](working_with_projects.md)
- [プロジェクトをGo言語パッケージとして使用する](use_project_as_go_package.md)
- [チュートリアル: プロジェクト用の保護されたワークフローを構築する](../../tutorials/protected_workflow/_index.md)
- [トラブルシューティング](troubleshooting.md)

{{< /cards >}}
