---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンLinear APIトークンの公開'
---

## 説明 {#description}

レスポンス本文に、Linear APIトークンのパターンに一致するコンテンツが含まれていることが確認されました。個人用APIトークンを使用すると、LinearのGraphQL APIにアクセスできます。このトークンにアクセスできる悪意のある攻撃者は、イシュー、プロジェクト、チームをLinear、およびアカウントが統合されているシステムに対して読み書きできます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできる可能性があります。

## 修正 {#remediation}

漏洩したキーに関するセキュリティインシデントの取り扱いに関する一般的なガイダンスについては、GitLabドキュメントの[認証情報のインターネットへの公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。

Linear APIトークンを失効するには:

- <https://linear.app/>でアカウントにサインインします
- 左上隅で組織を選択し、「Preferences」を選択します
- 左側のメニューで、「My Account」の「API」を選択します
- ページの「Personal API Keys」セクションで、特定されたAPIキーを見つけます
- 識別されたキーの横にある「Revoke」を選択します
- プロンプトが表示されたら、「Revoke access?」ダイアログで「Revoke」を選択します

詳細については、[個人用APIキーの使用に関するLinearのドキュメント](https://developers.linear.app/docs/graphql/working-with-the-graphql-api#personal-api-keys)を参照してください。

## 詳細 {#details}

| ID | 集計 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.66 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
