---
stage: Solutions Architecture
group: Solutions Architecture
info: This page is owned by the Solutions Architecture team.
description: Duoワークフローを含む、GitLab AIソリューションコンポーネントとユースケースの概要。
title: GitLab AIソリューションコンポーネント
---

このドキュメントセクションでは、GitLabによって開発および提供されるさまざまなソリューションコンポーネントについて説明します。これらのソリューションコンポーネントをダウンロードして実行するには、アカウントチームに招待リクエストしてください。

ソリューションコンポーネントの使用は、[GitLabサブスクリプション契約](https://handbook.gitlab.com/handbook/legal/subscription-agreement/)（以下「本契約」）に従うものとし、本契約で定義されるFree Softwareを構成するものとします。

## GitLab Duoワークフロー {#gitlab-duo-workflow}

GitLab Duoワークフローは、開発タスクの完了に役立ちます。GitLabコードベース、イシュー、マージリクエスト、パイプラインは、エージェント型ワークフローをプロンプトから実行できるコンテキストとなり得ます。Visual Studio Code統合開発環境（IDE）を使用します。

GitLab Duoワークフローの詳細については、[こちらのドキュメント](../../../user/duo_agent_platform/_index.md)をご覧ください。

## Duoワークフローソリューション {#duo-workflow-solution}

Duoワークフローソリューションは、さまざまなソフトウェア開発のユースケースに対するプロンプトとコンテキストライブラリを提供します。各ソリューションのユースケースは、プロンプトとコンテキストライブラリにより、コーディングの変更、問題の修正、定義されたワークフロー計画に基づくコードレビューなど、開発タスクの自動化を目的とした、必要な自律型ワークフローをサポートします。

[エージェント型ワークフロー: コードスタイルガイドの適用](duo_workflow_codestyle.md)
