﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/xray/XRayRequest.h>
#include <aws/xray/XRay_EXPORTS.h>

#include <utility>

namespace Aws {
namespace XRay {
namespace Model {

/**
 */
class DeleteGroupRequest : public XRayRequest {
 public:
  AWS_XRAY_API DeleteGroupRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteGroup"; }

  AWS_XRAY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The case-sensitive name of the group.</p>
   */
  inline const Aws::String& GetGroupName() const { return m_groupName; }
  inline bool GroupNameHasBeenSet() const { return m_groupNameHasBeenSet; }
  template <typename GroupNameT = Aws::String>
  void SetGroupName(GroupNameT&& value) {
    m_groupNameHasBeenSet = true;
    m_groupName = std::forward<GroupNameT>(value);
  }
  template <typename GroupNameT = Aws::String>
  DeleteGroupRequest& WithGroupName(GroupNameT&& value) {
    SetGroupName(std::forward<GroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the group that was generated on creation.</p>
   */
  inline const Aws::String& GetGroupARN() const { return m_groupARN; }
  inline bool GroupARNHasBeenSet() const { return m_groupARNHasBeenSet; }
  template <typename GroupARNT = Aws::String>
  void SetGroupARN(GroupARNT&& value) {
    m_groupARNHasBeenSet = true;
    m_groupARN = std::forward<GroupARNT>(value);
  }
  template <typename GroupARNT = Aws::String>
  DeleteGroupRequest& WithGroupARN(GroupARNT&& value) {
    SetGroupARN(std::forward<GroupARNT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_groupName;

  Aws::String m_groupARN;
  bool m_groupNameHasBeenSet = false;
  bool m_groupARNHasBeenSet = false;
};

}  // namespace Model
}  // namespace XRay
}  // namespace Aws
