"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateFileReferences = decorateFileReferences;
const utils_1 = require("../utils");
function decorateFileReferences(ls, snapshotManager) {
    const getFileReferences = ls.getFileReferences;
    ls.getFileReferences = (fileName) => {
        const references = getFileReferences(fileName);
        return references
            .map((ref) => {
            if (!(0, utils_1.isSvelteFilePath)(ref.fileName)) {
                return ref;
            }
            let textSpan = snapshotManager.get(ref.fileName)?.getOriginalTextSpan(ref.textSpan);
            if (!textSpan) {
                return;
            }
            return {
                ...ref,
                textSpan
            };
        })
            .filter(utils_1.isNotNullOrUndefined);
    };
}
//# sourceMappingURL=file-references.js.map