'''OpenGL extension QCOM.render_shared_exponent

This module customises the behaviour of the 
OpenGL.raw.GLES2.QCOM.render_shared_exponent to provide a more 
Python-friendly API

Overview (from the spec)
	
	OpenGL ES 3.2 supports a packed, shared exponent floating format RGB9_E5
	which is not color-renderable.
	
	This extension enables the packed, shared exponent floating type format RGB9_E5
	to be color-renderable using framebuffer objects.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/QCOM/render_shared_exponent.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.QCOM.render_shared_exponent import *
from OpenGL.raw.GLES2.QCOM.render_shared_exponent import _EXTENSION_NAME

def glInitRenderSharedExponentQCOM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION